/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.resultados;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.evento.DigitacaoEvento;
import jalis.laboratorio.digitacao.evento.DigitacaoListener;
import jalis.laboratorio.interfaceamento.resultados.DialogoResultadosRequisicoes;
import jalis.laboratorio.interfaceamento.resultados.HistoricoDadosBrutos;
import jalis.laboratorio.interfaceamento.resultados.RenderDadosBrutos;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditarDadosBrutos
extends AbstractDialogoOKCancelar
implements DigitacaoListener {
    private String filialSelecionada;
    private String requisicaoSelecionada;
    private String exameSelecionado;
    private String materialSelecionado;
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JTabbedPane tabbedExames = new JTabbedPane();
    private DefaultListModel modeloDatas = new DefaultListModel();
    private JList tabelaDatas = new JList(this.modeloDatas);
    private JPanel panelDatas = ComponenteFactory.novoJPanelBorderLayout("Datas", new JScrollPane(this.tabelaDatas));
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            EditarDadosBrutos.this.novo();
        }
    });
    private JButton buttonExames = ComponenteFactory.novoJButton("Resultados", 'd', new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            EditarDadosBrutos.this.mostrarResultados();
        }
    });

    public EditarDadosBrutos(Dialog pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public EditarDadosBrutos(Frame pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public static EditarDadosBrutos novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new EditarDadosBrutos((Frame)owner, "Dados brutos");
        }
        return new EditarDadosBrutos((Dialog)owner, "Dados brutos");
    }

    private void mostrarResultados() {
        DialogoResultadosRequisicoes diag = DialogoResultadosRequisicoes.novaInstancia(this);
        if (diag != null) {
            diag.setRequisicao(this.getOwner(), this.filialSelecionada, this.requisicaoSelecionada);
            diag.setVisible(true);
        }
    }

    public void setOcultarNovo() {
        this.buttonNovo.setVisible(false);
        this.buttonNovo.getParent().setVisible(false);
    }

    public void setOcultarResultados() {
        this.buttonExames.setVisible(false);
    }

    private void novo() {
        StringBuilder buf = new StringBuilder("select a.req_codigo, a.exa_codigo, b.exa_descricao, a.mco_codigo, c.mco_descricao, c.mco_abreviatura, a.exr_situacao, ");
        buf.append("'").append(Variaveis.login).append("' as usr_codigo, '' as eda_dadosbrutos, e.req_idade, e.req_anomes, f.lay_codigo, a.met_codigo ");
        buf.append("from examerequisicao a ");
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            buf.append(" left join requisicaorequisicao reqreq on reqreq.fil_codigo = a.fil_codigo and (reqreq.req_kodigo = a.req_codigo or reqreq.req_codigo = a.req_codigo) ");
        }
        buf.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        buf.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        buf.append(" left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
        buf.append(" left join requisicao e on a.fil_codigo =  e.fil_codigo and a.req_codigo = e.req_codigo ");
        buf.append(" left join convenios f on e.fil_codigo = f.fil_codigo and e.con_codigo = f.con_codigo ");
        buf.append("where ");
        buf.append("  a.fil_codigo = ").append(this.filialSelecionada);
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            buf.append("  and ").append(this.requisicaoSelecionada).append("in (reqreq.req_codigo, reqreq.req_kodigo, a.req_codigo)");
        } else {
            buf.append(" and a.req_codigo = ").append(this.requisicaoSelecionada);
        }
        buf.append(" and a.exa_codigo = ").append(StringUtil.textoDBEscape(this.exameSelecionado));
        buf.append(" and a.mco_codigo = ").append(this.materialSelecionado);
        buf.append(" and a.exr_excluido = false ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                this.tabbedExames.removeAll();
                this.requisicaoSelecionada = rs.getString("req_codigo");
                Registro reg = new Registro(rs);
                String layout = ExameUtil.pegaLayoutIdade(this.filialSelecionada, rs.getInt("req_idade"), rs.getString("req_anomes"), rs.getString("lay_codigo"), this.exameSelecionado, Integer.parseInt(this.materialSelecionado), rs.getInt("met_codigo"), "elm_dadosbrutos");
                Digitacao dig = new Digitacao();
                dig.addDigitacaoListener(this);
                dig.carregarCampos(layout);
                dig.exibirBotaoFechar(false);
                dig.exibirBotaoImprimir(false);
                dig.exibirBotaoSalvar(true);
                dig.exibirBotaoSalvarParcial(false);
                dig.exibirCheckBoxImprimir(false);
                dig.setCodigoExame(this.exameSelecionado);
                dig.setCodigoMaterialColeta(Integer.parseInt(this.materialSelecionado));
                dig.setSituacao(reg.getString("exr_situacao"));
                this.tabbedExames.add((Component)dig, this.getTituloAba(reg));
                dig.setFocoPrimeiroCampo();
                this.panelExames.removeAll();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditarDadosBrutos.this.panelExames.add((Component)EditarDadosBrutos.this.tabbedExames, "Center");
                        EditarDadosBrutos.this.panelExames.revalidate();
                        EditarDadosBrutos.this.panelExames.repaint();
                    }
                });
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EditarDadosBrutos: 106");
        }
    }

    private void iniciar() {
        this.setSize(new Dimension(720, 550));
        this.setLocationRelativeTo(this.getParent());
        this.tabelaDatas.setCellRenderer(new RenderDadosBrutos());
        this.tabbedExames.setTabLayoutPolicy(1);
        this.getBotaoCancelar().setVisible(false);
        this.getBotaoOK().setText("Fechar");
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new BorderLayout());
        this.panelDatas.setPreferredSize(new Dimension(205, 105));
        this.panelDatas.setMinimumSize(this.panelDatas.getPreferredSize());
        panelCentro.add((Component)this.panelDatas, "West");
        JPanel p = new JPanel(new FlowLayout(2));
        p.add(this.buttonNovo);
        this.panelDatas.add((Component)p, "South");
        this.getPanelBotoesEsquerda().add(this.buttonExames);
        panelCentro.add((Component)this.panelExames, "Center");
        this.tabelaDatas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EditarDadosBrutos.this.buscaExames(EditarDadosBrutos.this.tabelaDatas.getSelectedIndex());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaExames(int linha) {
        if (this.modeloDatas.getSize() > linha) {
            Statement st = Conexao.getStatement();
            try {
                HistoricoDadosBrutos h = (HistoricoDadosBrutos)this.modeloDatas.getElementAt(linha);
                StringBuilder buf = new StringBuilder("select a.exa_codigo, b.exa_descricao, a.mco_codigo, c.mco_descricao, c.mco_abreviatura, a.exr_situacao, e.usr_codigo, e.eda_dadosbrutos ");
                buf.append("from examerequisicaodadosbrutos e ");
                buf.append(" left join examerequisicao a on e.fil_codigo = a.fil_codigo and e.req_codigo = a.req_codigo and e.exa_codigo = a.exa_codigo and e.mco_codigo = a.mco_codigo ");
                buf.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
                buf.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
                buf.append(" left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
                buf.append("where ");
                buf.append("  e.fil_codigo = ").append(h.getFilial());
                buf.append(" and e.req_codigo = ").append(h.getRequisicao());
                buf.append(" and e.exa_codigo = ").append(StringUtil.textoDBEscape(h.getExame()));
                buf.append(" and e.mco_codigo = ").append(h.getMaterial());
                buf.append(" and e.eda_codigo = ").append(h.getCodigo());
                buf.append(" and a.exr_excluido = false ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                this.tabbedExames.removeAll();
                while (rs.next()) {
                    Registro reg = new Registro(rs);
                    Digitacao dig = new Digitacao();
                    dig.carregarCampos(reg.getString("eda_dadosbrutos"));
                    dig.exibirBotaoFechar(false);
                    dig.exibirBotaoImprimir(false);
                    dig.exibirBotaoSalvar(false);
                    dig.exibirBotaoSalvarParcial(false);
                    dig.exibirCheckBoxImprimir(false);
                    dig.setCodigoExame(reg.getString("exa_codigo"));
                    dig.setCodigoMaterialColeta(reg.getInt("mco_codigo"));
                    dig.setSituacao(reg.getString("exr_situacao"));
                    this.tabbedExames.add((Component)dig, this.getTituloAba(reg));
                }
                this.panelExames.removeAll();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditarDadosBrutos.this.panelExames.add((Component)EditarDadosBrutos.this.tabbedExames, "Center");
                        EditarDadosBrutos.this.panelExames.revalidate();
                        EditarDadosBrutos.this.panelExames.repaint();
                    }
                });
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EditarDadosBrutos: 155");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequisicao(String filial, String requisicao, String exame, String material) {
        this.modeloDatas.clear();
        if (!(Funcoes.textoVazio(filial) || Funcoes.textoVazio(requisicao) || Funcoes.textoVazio(exame) || Funcoes.textoVazio(material))) {
            ResultSet rs;
            this.filialSelecionada = filial;
            this.requisicaoSelecionada = requisicao;
            this.exameSelecionado = exame;
            this.materialSelecionado = material;
            ArrayList<String> listaRequisicoes = new ArrayList<String>();
            StringBuilder sql = new StringBuilder("select a.req_codigo ");
            sql.append("from examerequisicao a ");
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                sql.append(" left join requisicaorequisicao reqreq on reqreq.fil_codigo = a.fil_codigo and (reqreq.req_kodigo = a.req_codigo or reqreq.req_codigo = a.req_codigo) ");
            }
            sql.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            sql.append(" left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
            sql.append(" left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
            sql.append(" left join requisicao e on a.fil_codigo =  e.fil_codigo and a.req_codigo = e.req_codigo ");
            sql.append(" left join convenios f on e.fil_codigo = f.fil_codigo and e.con_codigo = f.con_codigo ");
            sql.append("where a.fil_codigo = ").append(this.filialSelecionada);
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                sql.append("  and ").append(this.requisicaoSelecionada).append("in (reqreq.req_codigo, reqreq.req_kodigo, a.req_codigo)");
            } else {
                sql.append("  and a.req_codigo = ").append(this.requisicaoSelecionada);
            }
            sql.append("  and a.exa_codigo = ").append(StringUtil.textoDBEscape(this.exameSelecionado));
            sql.append("  and a.mco_codigo = ").append(this.materialSelecionado);
            sql.append("  and a.exr_excluido = false ");
            Statement st = Conexao.getStatement();
            try {
                rs = Conexao.executeQuery(st, sql);
                while (rs.next()) {
                    if (listaRequisicoes.contains(rs.getString("req_codigo"))) continue;
                    listaRequisicoes.add(rs.getString("req_codigo"));
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            StringBuilder buf = new StringBuilder();
            buf.append("select req_codigo, eda_dadosbrutos, eda_datahora, usr_codigo, eda_codigo from examerequisicaodadosbrutos ");
            buf.append(" where fil_codigo = ").append(filial);
            buf.append("   and req_codigo in (").append((String)listaRequisicoes.get(0)).append(") ");
            buf.append("   and exa_codigo = ").append(StringUtil.textoDBEscape(exame));
            buf.append("   and mco_codigo = ").append(material);
            buf.append(" order by eda_datahora ");
            st = Conexao.getStatement();
            try {
                rs = Conexao.executeQuery(st, buf);
                while (rs.next()) {
                    if (Funcoes.textoVazio(rs.getString("eda_dadosbrutos"))) continue;
                    this.modeloDatas.addElement(new HistoricoDadosBrutos(rs.getString("usr_codigo"), rs.getTimestamp("eda_datahora"), filial, rs.getString("req_codigo"), exame, material, rs.getString("eda_codigo")));
                }
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EditarDadosBrutos: 190");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        if (this.modeloDatas.getSize() > 0) {
            this.tabelaDatas.setSelectedIndex(0);
        }
    }

    private String getTituloAba(Registro reg) {
        StringBuilder str = new StringBuilder();
        if (reg != null) {
            str.append("<html><font size=2>");
            str.append(reg.getValor("exa_codigo"));
            str.append(" (<font color=#FF0000>");
            str.append(reg.getValor("mco_abreviatura"));
            str.append("</font>)<br>");
            String tmp = reg.getString("exr_descricaomaterial").trim().length() == 0 ? reg.getString("mco_descricao") : reg.getString("exr_descricaomaterial");
            str.append(tmp.length() > 14 ? tmp.substring(0, 14) : tmp);
            str.append("<br>");
            tmp = Tipos.tipoSituacaoExame(reg.getString("exr_situacao"));
            str.append(tmp.length() > 14 ? tmp.substring(0, 14) : tmp);
            str.append("</font></html>");
        }
        return str.toString();
    }

    @Override
    public void acaoSalvar(DigitacaoEvento e) {
        if (this.tabbedExames.getSelectedComponent() instanceof Digitacao) {
            Digitacao digi = (Digitacao)this.tabbedExames.getSelectedComponent();
            if (!digi.verificarCondicao()) {
                Funcoes.showAlertaOK(this, digi.getMensagemErro());
                digi.setFocoPrimeiroCampo();
                return;
            }
            String resultado = digi.getResultado();
            this.insereDadosBrutos(resultado, this.requisicaoSelecionada, true);
            Integer[] guias = null;
            try {
                guias = RecepcaoUtil.verificaMultiGuias(this.filialSelecionada, this.requisicaoSelecionada);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            if (guias != null && guias.length > 0) {
                for (Integer codigoRequisicao : guias) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("select e.exa_codigo from requisicao r ");
                    buf.append(" join examerequisicao e ");
                    buf.append(" on r.fil_Codigo = e.fil_Codigo ");
                    buf.append(" and r.req_codigo = e.req_Codigo  ");
                    buf.append(" where r.req_codigo = ? ");
                    PreparedStatement stmt = Conexao.getPreparedStatement(buf.toString());
                    try {
                        stmt.setInt(1, codigoRequisicao);
                        ResultSet rsExames = Conexao.executeQuery(stmt);
                        while (rsExames.next()) {
                            String exame = rsExames.getString("exa_codigo");
                            if (!this.exameSelecionado.equals(exame)) continue;
                            this.insereDadosBrutos(resultado, Integer.toString(codigoRequisicao), false);
                        }
                    }
                    catch (NumberFormatException e2) {
                        e2.printStackTrace();
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insereDadosBrutos(String resultado, String codigoRequisicao, boolean isPai) {
        Statement st;
        block7: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("insert into examerequisicaodadosbrutos(fil_codigo, req_codigo, exa_codigo, mco_codigo, eda_datahora, usr_codigo, eda_dadosbrutos, eda_codigo) values (");
            buf.append(this.filialSelecionada).append(", ");
            buf.append(codigoRequisicao).append(", ");
            buf.append(StringUtil.textoDBEscape(this.exameSelecionado)).append(", ");
            buf.append(this.materialSelecionado).append(", ");
            buf.append(" '").append(Funcoes.formataData("yyyy/MM/dd HH:mm:ss", Funcoes.getDataHoraServidor())).append("', ");
            buf.append(StringUtil.textoDBEscape(Variaveis.login)).append(", ");
            buf.append(StringUtil.textoDBEscape(resultado)).append(", ");
            int codigo = -1;
            try {
                ResultSet rs = Conexao.executeQuery(st, "select nextval('examerequisicaodadosbrutos_eda_codigo_seq')");
                if (rs.next()) {
                    codigo = rs.getInt(1);
                }
                buf.append(codigo).append(")");
                Conexao.execute(this.filialSelecionada, st, buf.toString());
                Conexao.arquivaSQL();
                if (!isPai) break block7;
                HistoricoDadosBrutos b = new HistoricoDadosBrutos(Variaveis.login, Funcoes.getDataHoraServidor(), this.filialSelecionada, this.requisicaoSelecionada, this.exameSelecionado, this.materialSelecionado, String.valueOf(codigo));
                this.modeloDatas.addElement(b);
                int pos = this.modeloDatas.getSize() - 1;
                this.tabelaDatas.setSelectedIndex(pos);
                this.tabelaDatas.scrollRectToVisible(this.tabelaDatas.getCellBounds(pos, pos));
            }
            catch (Exception e2) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, e2.getMessage(), e2.getStackTrace(), "EditarDadosBrutos: 328");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    @Override
    public void acaoSalvarParcial(DigitacaoEvento e) {
    }

    @Override
    public void acaoFechar(DigitacaoEvento e) {
    }

    @Override
    public void acaoImprimir(DigitacaoEvento e) {
    }

    @Override
    public void acaoRemover(DigitacaoEvento e) {
    }
}

