/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.resultados;

import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.interfaceamento.resultados.RenderDialogoResultadosRequisicoes;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class DialogoResultadosRequisicoes
extends AbstractDialogoOKCancelar {
    private JPanel panelExames = new JPanel(new BorderLayout());
    private JTabbedPane tabbedExames = new JTabbedPane(){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            for (int i = 0; i < this.getTabCount(); ++i) {
                Digitacao digi = (Digitacao)DialogoResultadosRequisicoes.this.tabbedExames.getComponentAt(i);
                Rectangle rec = this.getBoundsAt(i);
                if (digi == null || rec == null) continue;
                g.setColor(Tipos.getCorSituacaoExame(digi.getSituacao())[0]);
                g.fillRect(rec.x + 3, rec.y + 8, 5, rec.height - 11);
                g.setColor(Color.black);
                g.drawRect(rec.x + 3, rec.y + 8, 5, rec.height - 11);
            }
        }
    };
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Data", "Requisi\u00e7\u00e3o"});
    private JTable tabelaRequisicoes = new JTable(this.modeloRequisicoes);
    private JPanel panelRequisicoes = ComponenteFactory.novoJPanelBorderLayout("Requisi\u00e7\u00f5es", new JScrollPane(this.tabelaRequisicoes));
    static final int COLUNA_DATA = 0;
    static final int COLUNA_CODIGO = 1;
    static final int COLUNA_FILIAL = 2;

    public DialogoResultadosRequisicoes(Dialog pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public DialogoResultadosRequisicoes(Frame pai, String titulo) {
        super(pai, titulo);
        this.iniciar();
    }

    public static DialogoResultadosRequisicoes novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new DialogoResultadosRequisicoes((Frame)owner, "Resultados");
        }
        return new DialogoResultadosRequisicoes((Dialog)owner, "Resultados");
    }

    private void iniciar() {
        this.setSize(new Dimension(720, 550));
        this.setLocationRelativeTo(this.getParent());
        this.modeloRequisicoes.setColumnSize(new int[]{80, 0}, this.tabelaRequisicoes);
        this.tabelaRequisicoes.setDefaultRenderer(Object.class, new RenderDialogoResultadosRequisicoes());
        this.tabbedExames.setTabLayoutPolicy(1);
        this.getBotaoCancelar().setVisible(false);
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new BorderLayout());
        this.panelRequisicoes.setPreferredSize(new Dimension(200, 100));
        this.panelRequisicoes.setMinimumSize(this.panelRequisicoes.getPreferredSize());
        panelCentro.add((Component)this.panelRequisicoes, "West");
        panelCentro.add((Component)this.panelExames, "Center");
        this.tabelaRequisicoes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DialogoResultadosRequisicoes.this.buscaExames(DialogoResultadosRequisicoes.this.tabelaRequisicoes.getSelectedRow());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaExames(int linha) {
        if (this.tabelaRequisicoes.getRowCount() > linha) {
            Statement st = Conexao.getStatement();
            try {
                String filial = this.modeloRequisicoes.getValueAt(linha, 2).toString();
                String requisicao = this.modeloRequisicoes.getValueAt(linha, 1).toString();
                StringBuilder buf = new StringBuilder("select a.exa_codigo, b.exa_descricao, a.mco_codigo, c.mco_descricao, c.mco_abreviatura, pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, a.exr_situacao ");
                buf.append("from examerequisicao a ");
                buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
                buf.append("left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
                buf.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
                buf.append("where ");
                buf.append("  a.fil_codigo = ").append(filial);
                buf.append(" and a.req_codigo = ").append(requisicao);
                buf.append(" and a.exr_excluido = false ");
                buf.append(" order by ");
                buf.append("d.emc_pagina, d.emc_ordem, a.exa_codigo, a.mco_codigo ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                this.tabbedExames.removeAll();
                while (rs.next()) {
                    Registro reg = new Registro(rs);
                    Digitacao dig = new Digitacao();
                    dig.carregarCampos(reg.getString("exr_resultado"));
                    dig.exibirBotaoFechar(false);
                    dig.exibirBotaoImprimir(false);
                    dig.exibirBotaoSalvar(false);
                    dig.exibirBotaoSalvarParcial(false);
                    dig.exibirCheckBoxImprimir(false);
                    dig.setCodigoExame(reg.getString("exa_codigo"));
                    dig.setCodigoMaterialColeta(reg.getInt("mco_codigo"));
                    dig.setSituacao(reg.getString("exr_situacao"));
                    this.tabbedExames.add((Component)dig, this.getTituloAba(reg));
                }
                this.panelExames.removeAll();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DialogoResultadosRequisicoes.this.panelExames.add((Component)DialogoResultadosRequisicoes.this.tabbedExames, "Center");
                        DialogoResultadosRequisicoes.this.panelExames.revalidate();
                        DialogoResultadosRequisicoes.this.panelExames.repaint();
                    }
                });
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoResultadosRequisicoes: 155");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setRequisicao(Window owner, String filial, String requisicao) {
        boolean bl;
        Statement st;
        block10: {
            this.modeloRequisicoes.clear();
            st = Conexao.getStatement();
            Integer[] guias = RecepcaoUtil.verificaMultiGuias(filial, requisicao, true);
            StringBuilder buf = new StringBuilder("select req_codigo, req_data, fil_codigo ");
            buf.append("from requisicao ");
            buf.append(" where fil_codigo = ").append(filial);
            if (guias.length == 1) {
                buf.append(" and req_codigo = ").append(requisicao);
            } else {
                buf.append(" and req_codigo in (");
                for (int i = 0; i < guias.length; ++i) {
                    if (i > 0) {
                        buf.append(" , ");
                    }
                    buf.append(String.valueOf(guias[i]));
                }
                buf.append(") ");
            }
            buf.append(" order by req_data desc, req_hora desc, req_codigo ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                this.modeloRequisicoes.addLine(new String[]{Funcoes.formataData(rs.getDate("req_data")), rs.getString("req_codigo"), rs.getString("fil_codigo")});
            }
            if (this.modeloRequisicoes.getRowCount() <= 0) break block10;
            this.tabelaRequisicoes.setRowSelectionInterval(0, 0);
            ScreenUtil.requisitarFoco(this.tabelaRequisicoes);
            boolean bl2 = true;
            Conexao.fecharStatement(st);
            return bl2;
        }
        try {
            Funcoes.mensagem(owner, "Requisi\u00e7\u00e3o n\u00e3o localizada", 2);
            bl = false;
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoResultadosRequisicoes: 85");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return false;
        }
        Conexao.fecharStatement(st);
        return bl;
    }

    private String getTituloAba(Registro reg) {
        StringBuilder str = new StringBuilder();
        if (reg != null) {
            str.append("<html><font size=2>");
            str.append(reg.getValor("exa_codigo"));
            str.append(" (<font color=#FF0000>");
            str.append(reg.getValor("mco_abreviatura"));
            str.append("</font>)<br>");
            String tmp = reg.getString("exr_descricaomaterial").trim().length() == 0 ? reg.getString("mco_descricao") : reg.getString("exr_descricaomaterial");
            str.append(tmp.length() > 14 ? tmp.substring(0, 14) : tmp);
            str.append("<br>");
            tmp = Tipos.tipoSituacaoExame(reg.getString("exr_situacao"));
            str.append(tmp.length() > 14 ? tmp.substring(0, 14) : tmp);
            str.append("</font></html>");
        }
        return str.toString();
    }
}

