/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.wama;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.wama.InterfaceWAMAListener;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import java.sql.Statement;
import java.util.HashMap;

public class WAMARecordParser {
    protected final String ETIQUETA = "ID";
    protected final String PACIENTE = "NOME:";
    protected final String ALTERNATIVO = "EXAME:";
    protected final String TEMPO = "TEMPO:";
    protected final String RELACAO = "RELACAO:";
    protected final String PERCENTUAL = "%:";
    protected final String INR = "INR:";
    protected final String CONTROLE = "CONTROLE 100%:";
    protected final String FALHA = "FALHOU!";
    protected InterfaceWAMAListener equip;

    public WAMARecordParser() {
    }

    public WAMARecordParser(InterfaceWAMAListener equip) {
        this.equip = equip;
    }

    public void setInterfaceWAMAListener(InterfaceWAMAListener equip) {
        this.equip = equip;
    }

    public void trataRecord(String record) throws Exception {
        String codigoTubo;
        String codigoRequisicao;
        String dataResultado = null;
        String codigoEtiqueta = null;
        String nomePaciente = null;
        String codigoAlternativo = null;
        String tempo = null;
        String relacao = null;
        String percentual = null;
        String inr = null;
        String controle = null;
        for (String linha : record.split(String.valueOf('\n'))) {
            if ((linha = linha.replace(String.valueOf('\n'), "").replace(String.valueOf('\r'), "")).contains("/") && linha.contains(":")) {
                linha = linha.trim();
                while (linha.contains("  ")) {
                    linha = linha.replace("  ", " ");
                }
                dataResultado = Funcoes.formataData("yyyy-MM-dd HH:mm:ss", linha);
            }
            if (linha.length() > "ID".length() && linha.substring(0, "ID".length() + 1).contains("ID")) {
                codigoEtiqueta = linha.replace("ID", "").replace("(", "").replace(")", "");
            }
            if (linha.length() > "NOME:".length() && linha.substring(0, "NOME:".length() + 1).contains("NOME:")) {
                nomePaciente = linha.replace("NOME:", "").trim();
            }
            if (linha.length() > "EXAME:".length() && linha.substring(0, "EXAME:".length() + 1).contains("EXAME:")) {
                codigoAlternativo = linha.replace("EXAME:", "").trim();
            }
            if (linha.length() > "TEMPO:".length() && linha.substring(0, "TEMPO:".length() + 1).contains("TEMPO:") && !(tempo = linha.replace("TEMPO:", "").trim()).contains("FALHOU!")) {
                tempo = tempo.substring(0, tempo.length() - 1);
            }
            if (linha.length() > "RELACAO:".length() && linha.substring(0, "RELACAO:".length() + 1).contains("RELACAO:")) {
                relacao = linha.replace("RELACAO:", "").trim();
            }
            if (linha.length() > "%:".length() && linha.substring(0, "%:".length() + 1).contains("%:")) {
                percentual = linha.replace("%:", "").trim();
                percentual = percentual.substring(0, percentual.length() - 1);
            }
            if (linha.length() > "INR:".length() && linha.substring(0, "INR:".length() + 1).contains("INR:")) {
                inr = linha.replace("INR:", "").trim();
            }
            if (linha.length() <= "CONTROLE 100%:".length() || !linha.substring(0, "CONTROLE 100%:".length() + 1).contains("CONTROLE 100%:")) continue;
            controle = linha.replace("CONTROLE 100%:", "").trim();
            controle = controle.substring(0, controle.length() - 1);
        }
        StringBuilder mensagem = new StringBuilder();
        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(codigoEtiqueta);
        if (Funcoes.objectIsNull(etiqueta)) {
            mensagem.setLength(0);
            mensagem.append("C\u00f3digo da requisi\u00e7\u00e3o '");
            mensagem.append(codigoEtiqueta);
            mensagem.append("' invalida.");
            this.equip.fireExcecaoEncontrada(mensagem.toString());
            return;
        }
        String codigoFilial = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
        String codigoInterface = this.equip.getIntCodigo(codigoFilial, codigoRequisicao = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()), codigoTubo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo()), codigoAlternativo);
        if (Funcoes.objectIsNull(codigoInterface)) {
            mensagem.setLength(0);
            mensagem.append("C\u00f3digo LIS do exame '");
            mensagem.append(codigoAlternativo);
            mensagem.append("' n\u00e3o encontrado na interface para requisi\u00e7\u00e3o '");
            mensagem.append(codigoFilial);
            mensagem.append(" ");
            mensagem.append(codigoRequisicao);
            mensagem.append(" ");
            mensagem.append(codigoTubo);
            mensagem.append("'");
            this.equip.fireExcecaoEncontrada(mensagem.toString());
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(codigoFilial, codigoInterface, codigoRequisicao, codigoTubo, codigoAlternativo);
        if (Funcoes.objectIsNull(exame)) {
            mensagem.setLength(0);
            mensagem.append("C\u00f3digo LIS do exame '");
            mensagem.append(codigoAlternativo);
            mensagem.append("' n\u00e3o encontrado para requisi\u00e7\u00e3o '");
            mensagem.append(codigoFilial);
            mensagem.append(" ");
            mensagem.append(codigoRequisicao);
            mensagem.append(" ");
            mensagem.append(codigoTubo);
            mensagem.append("'");
            this.equip.fireExcecaoEncontrada(mensagem.toString());
            return;
        }
        if (tempo.contains("FALHOU!")) {
            mensagem.setLength(0);
            mensagem.append("Resultado com falha no exame ");
            mensagem.append(codigoAlternativo);
            mensagem.append(" para a requisi\u00e7\u00e3o ");
            mensagem.append(codigoFilial);
            mensagem.append(" ");
            mensagem.append(codigoRequisicao);
            mensagem.append(" ");
            mensagem.append(codigoTubo);
            this.equip.fireExcecaoEncontrada(mensagem.toString());
            return;
        }
        HashMap<String, Object> dados = new HashMap<String, Object>();
        Statement st = Conexao.getStatement();
        dados.put("time", this.formataNumero(tempo));
        if (!Funcoes.objectIsNull(relacao)) {
            dados.put("ratio", this.formataNumero(relacao));
        }
        if (!Funcoes.objectIsNull(percentual)) {
            dados.put("concentration", this.formataNumero(percentual));
        }
        if (!Funcoes.objectIsNull(inr)) {
            dados.put("inr", this.formataNumero(inr));
        }
        if (!Funcoes.objectIsNull(controle)) {
            dados.put("acl_activity", this.formataNumero(controle));
        }
        this.equip.atualizarDadosExame(st, codigoFilial, codigoRequisicao, codigoTubo, exame.getNomeExame(), exame.getCodigoMaterial(), codigoInterface, dados);
    }

    private String formataNumero(String resultado) {
        if (resultado.contains(".")) {
            resultado = resultado.replaceAll("\\.", ",");
        }
        return resultado;
    }
}

