/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.wama;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.padroes.wama.WAMARecordParser;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.EventObject;

public abstract class InterfaceWAMAListener
extends AbstractInterfaceamentoListener {
    protected static String DELIMITADOR_BLOCO = "******************************";
    protected static String DELIMITADOR_BLOCO_INICIO = DELIMITADOR_BLOCO + '\n' + '\r';
    protected static String DELIMITADOR_BLOCO_FIM = DELIMITADOR_BLOCO + '\n' + LINE + LINE + '\r';
    protected int TIME_RX_ABORTADO = 3000;
    protected int TIME_RX = 15000;
    protected int TIME_TO_REFRESH = 2000;
    protected StringBuilder rx_buffer = new StringBuilder();
    protected StringBuilder rx_buffer_executado = new StringBuilder();
    protected WAMARecordParser recordParser;

    public void setWAMARecordParser(WAMARecordParser recordParser) {
        this.recordParser = recordParser;
    }

    protected void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(this.TIME_RX_ABORTADO);
        this.fireMensagemEnviada("Tempo esgotado ao receber dados do equipamento", 1, 10000);
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(this.TIME_RX);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    protected void limpaDadosRequisicao() {
        this.rx_buffer.setLength(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isRX()) {
                if (this.rx_buffer.toString().isEmpty()) {
                    this.setIdle();
                    return;
                } else {
                    this.abortarRecepcao();
                }
                return;
            }
            if (!this.isIdle()) return;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: timeout no controle de fluxo");
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (!message.isEmpty()) {
                this.parse(message);
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractWAMAInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return DELIMITADOR_BLOCO_FIM;
    }

    @Override
    public String getMsgStart() {
        return DELIMITADOR_BLOCO_INICIO;
    }

    @Override
    public String parse(String message) {
        try {
            this.rx_buffer.append(message);
            if (!this.rx_buffer.toString().contains(this.getMsgEnd())) {
                return "";
            }
            do {
                String mensagem = this.rx_buffer.toString();
                StringBuilder rx_aux = new StringBuilder();
                if (this.rx_buffer.indexOf(this.getMsgEnd()) + this.getMsgEnd().length() < this.rx_buffer.length()) {
                    rx_aux.append(this.rx_buffer.substring(this.rx_buffer.indexOf(this.getMsgEnd()) + this.getMsgEnd().length(), this.rx_buffer.length()));
                }
                this.rx_buffer = new StringBuilder(this.rx_buffer.substring(this.rx_buffer.indexOf(this.getMsgStart()), this.rx_buffer.indexOf(this.getMsgEnd()) + this.getMsgEnd().length()));
                this.rx_buffer_executado.setLength(0);
                this.rx_buffer_executado.append(mensagem.substring(0, mensagem.lastIndexOf(this.rx_buffer.toString()) + this.rx_buffer.length()));
                this.rx_buffer = new StringBuilder(this.rx_buffer.substring(this.rx_buffer.indexOf(this.getMsgStart()) + this.getMsgStart().length(), this.rx_buffer.indexOf(this.getMsgEnd())));
                this.recordParser.trataRecord(this.rx_buffer.toString());
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                this.rx_buffer.setLength(0);
                this.rx_buffer.append((CharSequence)rx_aux);
            } while (this.rx_buffer.indexOf(this.getMsgEnd()) > 0);
            return "";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractWAMAInterfaceamento: parse");
            this.rx_buffer.setLength(0);
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractWAMAInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return null;
    }
}

