/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.olympus;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultNaoEnviados;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.olympus.InterfaceOlympusConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.List;

public class InterfaceOlympusListener
extends AbstractInterfaceamentoListener {
    public static final String MSG_TYPE_START_TRANSFER_RESULT = "DB";
    public static final String MSG_TYPE_NORMAL_SAMPLE_RESULT = "D ";
    public static final String MSG_TYPE_RERUN_SAMPLE_RESULT = "DH";
    public static final String MSG_TYPE_REAGENT_BLANK_SAMPLE_RESULT = "DR";
    public static final String MSG_TYPE_CALIBRATION_RESULT = "DA";
    public static final String MSG_TYPE_STAT_FAST_RESULT = "d ";
    public static final String MSG_TYPE_STAT_FAST_RERUN__RESULT = "dH";
    public static final String MSG_TYPE_QC_SAMPLE_RESULT = "DQ";
    public static final String MSG_TYPE_END_TRANSFER_RESULT = "DE";
    public static final String MSG_TYPE_TRI_NORMAL_SAMPLE = "S ";
    public static final String MSG_TYPE_TRI_RERUN_SAMPLE = "SH";
    public static final String MSG_TYPE_TRI_STOP = "SE";
    public static final String MSG_TYPE_TRI_INQUIRY_NORMAL_SAMPLE = "R ";
    public static final String MSG_TYPE_TRI_INQUIRY_RERUN_SAMPLE = "RH";
    public static final String UNIT_NO = "01";
    public static final String CUP_POSITION = "00";
    public String ultimoEnvio = "";
    public String proximaPosicao = "";
    protected InfoExameRequisicao ultimo_enviado = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    public InterfaceOlympusConfiguracao configuracao = new InterfaceOlympusConfiguracao();
    protected boolean hostQuery = false;
    protected boolean exr_codigoapoiado = false;

    public InterfaceOlympusListener() {
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceOlympusConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        String dia = Funcoes.formataData("dd", Calendar.getInstance().getTime());
        this.limpaLogArquivos(dia);
    }

    private void limpaLogArquivos(final String dia) {
        File file = new File(System.getProperty("user.home"));
        File[] afile = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.startsWith("AU400") && name.endsWith(".log")) {
                    int d = Integer.parseInt(dia);
                    for (int i = 0; i < 5; ++i) {
                        if (d == 0) {
                            d = 31;
                        }
                        if (name.endsWith(String.format("%s.log", Funcoes.preencheZero(d, 2)))) {
                            return false;
                        }
                        --d;
                    }
                    return true;
                }
                return false;
            }
        });
        if (afile != null) {
            for (File arquivos : afile) {
                arquivos.delete();
            }
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            String recebido = "";
            if (!message.equals("") && message.length() == message.indexOf(this.getMsgEnd()) + 1) {
                message = this.getPortaCOM().removeInputString(this.getMsgEnd());
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                recebido = String.format("%s (dataChanged)>> %s \n", Funcoes.formataData("yyyyMMdd HH:mm:ss:SSS", Calendar.getInstance().getTime()), message);
            } else {
                String string = String.format("%s (dataChanged)parcial>> %s \n", Funcoes.formataData("yyyyMMdd HH:mm:ss:SSS", Calendar.getInstance().getTime()), message);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    protected void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, "");
    }

    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, String codigoApoiado) {
        try {
            Statement st = Conexao.getStatement();
            this.getPortaCOM().clearInputString();
            String rec_tuboPai = "";
            boolean curva = false;
            StringBuilder examesFilho = new StringBuilder();
            ArrayList<BDExame> exameMesmoMat = new ArrayList<BDExame>();
            if (Funcoes.textoVazio(rackposition) || Funcoes.textoVazio(prioridade)) {
                this.fireExcecaoEncontrada(String.format("Envio manual ou sem informar a rack e prioridade n\u00e3o permitido %s %s %s ", fil_codigo, req_codigo, rec_codigo));
                return "Envio manual ou sem informar a rack e prioridade n\u00e3o permitido";
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            if (!Funcoes.textoVazio(codigoApoiado)) {
                codigo.setLength(0);
                codigo.append(codigoApoiado);
            }
            if (pac_nome.length() > 20) {
                pac_nome = pac_nome.substring(0, 20);
            }
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            if ((exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva)) != null) {
                for (ExameMaterial exameMaterial : exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista)) {
                    examesFilho.append(exameMaterial.getNomeExame()).append(" ");
                }
            } else {
                exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" "), mco_codigo);
                if (this.hostQuery) {
                    rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_lista[0].getNomeExame(), mco_codigo);
                }
                curva = rec_tuboPai != null && !rec_tuboPai.equalsIgnoreCase(rec_codigo) && BDUtil.isExameCurva(fil_codigo, int_codigo, exa_lista[0].getNomeExame(), mco_codigo);
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                for (ExameMaterial exameMaterial : exa_lista = this.removeExameNaoSolicitados(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exa_lista)) {
                    examesFilho.append(exameMaterial.getNomeExame()).append(" ");
                }
            }
            exa_lista = this.getOutrosExames(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exameMesmoMat, exa_lista);
            ExameMaterial[] alternativos = this.validaExames(st, exa_lista, fil_codigo, int_codigo, req_codigo, rec_codigo, mco_codigo, exames, exameMesmoMat);
            ArrayList<ExameMaterial> alternados = new ArrayList<ExameMaterial>();
            String sample_type = " ";
            String tmp = ExamesUtil.getMaterialAlternativo(st, fil_codigo, int_codigo, exa_lista);
            if (tmp != null && tmp.trim().length() > 0) {
                sample_type = tmp;
            }
            for (ExameMaterial e : alternativos) {
                if (Funcoes.textoVazio(e.getNomeExame()) || alternados.contains(e)) continue;
                alternados.add(e);
            }
            if (alternados.isEmpty()) {
                this.fireExcecaoEncontrada(String.format("A requisi\u00e7\u00e3o %s %s %s possui exames que n\u00e3o tem o alternativo configurado %s ou a configura\u00e7\u00e3o est\u00e1 incorreta", fil_codigo, req_codigo, rec_codigo, exames));
                return "";
            }
            String[] idade = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            int mes = !Funcoes.textoVazio(idade[2]) ? Integer.parseInt(Funcoes.formataData("MM", Funcoes.getData("dd/MM/yyyy", idade[2]))) - 1 : Integer.parseInt(Funcoes.formataData("MM", Funcoes.getData("dd/MM/yyyy", TempoUtil.getCurrentDateBr()))) - 1;
            if (Funcoes.textoVazio(idade[1])) {
                idade[1] = "a";
            }
            if (Funcoes.textoVazio(idade[0])) {
                idade[0] = "";
            }
            StringBuilder message = new StringBuilder();
            message.append(this.getMsgStart());
            message.append(prioridade);
            message.append(rackposition);
            message.append(sample_type);
            message.append(this.proximaPosicao);
            message.append(StringUtil.preencheString(codigo.toString(), 20, ' ', 1));
            message.append("    ");
            message.append("E");
            message.append(pac_sexo);
            message.append(StringUtil.preencheString(idade[1].equalsIgnoreCase("a") ? idade[0] : "0", 3, '0', 1));
            message.append(StringUtil.preencheString(Integer.toString(mes), 2, '0', 1));
            message.append(StringUtil.preencheString(pac_nome, 20, ' ', 0));
            message.append(StringUtil.preencheString("", 20, ' ', 0));
            message.append(StringUtil.preencheString("", 20, ' ', 0));
            message.append(StringUtil.preencheString("", 20, ' ', 0));
            message.append(StringUtil.preencheString("", 20, ' ', 0));
            message.append(StringUtil.preencheString("", 20, ' ', 0));
            for (ExameMaterial e : alternados) {
                message.append(Funcoes.preencheZero(e.getNomeExame(), 2));
            }
            message.append(this.getMsgEnd());
            this.ultimoEnvio = message.toString();
            this.ultimo_enviado = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, exames);
            this.ultimo_enviado.setInterface(int_codigo);
            this.ultimo_enviado.setCurva(curva);
            this.ultimo_enviado.setTuboPai(rec_tuboPai);
            this.ultimo_enviado.setExamesFilho(examesFilho.toString().trim());
            if (exameMesmoMat.size() > 0) {
                this.ultimo_enviado.setOutrosExames(exameMesmoMat);
            }
            this.getPortaCOM().write(message.toString());
            return "Enviando " + pac_nome + " para o equipamento";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    protected ExameMaterial[] validaExames(Statement st, ExameMaterial[] exa_lista, String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, String mco_codigo, String exames, List<BDExame> exameMesmoMat) throws SQLException {
        ArrayList<ExameMaterial> novalista = new ArrayList<ExameMaterial>();
        boolean novo = false;
        for (ExameMaterial exameMaterial : exa_lista) {
            BDExame[] lise;
            if (BDUtil.getExmCodigoAlternativo(fil_codigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), int_codigo) != null || (lise = BDUtil.getReqExames(fil_codigo, int_codigo, req_codigo, rec_codigo)).length <= 0) continue;
            exameMaterial.setCodigo(Integer.parseInt(lise[0].getMaterial()));
            exameMesmoMat.add(new BDExame(req_codigo, exameMaterial.getNomeExame(), lise[0].getMaterial(), rec_codigo));
            novo = true;
        }
        if (novo) {
            for (String ex : exames.split(" ")) {
                BDExame[] lis = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, ex, mco_codigo, rec_codigo);
                for (int i = 0; i < lis.length; ++i) {
                    boolean existe = false;
                    for (ExameMaterial exm : exa_lista) {
                        if (!exm.getNomeExame().equalsIgnoreCase(ex)) continue;
                        existe = true;
                        break;
                    }
                    if (existe) continue;
                    ExameMaterial novoExame = new ExameMaterial(lis[i].getExame(), Integer.parseInt(lis[i].getMaterial()));
                    novalista.add(novoExame);
                    exameMesmoMat.add(lis[i]);
                }
            }
            exa_lista = ArraysUtil.concatenar(exa_lista, novalista.toArray(new ExameMaterial[novalista.size()]));
        }
        return ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
    }

    protected ExameMaterial[] removeExameNaoSolicitados(String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, ExameMaterial[] exa_lista) throws SQLException {
        ArrayList<ExameMaterial> exa_temp = new ArrayList<ExameMaterial>();
        for (ExameMaterial exameMaterial : exa_lista) {
            if (!BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial())) continue;
            exa_temp.add(exameMaterial);
        }
        return exa_temp.toArray(new ExameMaterial[exa_temp.size()]);
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public void handShakeCharReceived(char c) {
        String recebido = String.format("%s (handShakeCharReceived)>> %s %s \n", Funcoes.formataData("yyyyMMdd HH:mm:ss:SSS", Calendar.getInstance().getTime()), Character.valueOf(c), String.valueOf((int)c));
        switch (c) {
            case '\u0015': {
                this.retransmitir();
            }
            case '\u0006': {
                this.confirmaTransmissao();
            }
        }
    }

    @Override
    public String parse(String message) {
        try {
            if (!message.endsWith(this.getMsgEnd()) || !message.startsWith(this.getMsgStart())) {
                this.getPortaCOM().write(String.valueOf('\u0015'));
                return "Erro no bloco enviado pelo equipamento";
            }
            this.getPortaCOM().write(String.valueOf('\u0006'));
            String tipo = message.substring(1, 3);
            if (tipo.equals(MSG_TYPE_NORMAL_SAMPLE_RESULT)) {
                return this.parseNormalSampleResult(message);
            }
            if (tipo.equals(MSG_TYPE_RERUN_SAMPLE_RESULT)) {
                return this.parseRerunSampleResult(message);
            }
            if (tipo.equals(MSG_TYPE_STAT_FAST_RESULT)) {
                return this.parseStatFastResult(message);
            }
            if (tipo.equals(MSG_TYPE_TRI_INQUIRY_NORMAL_SAMPLE)) {
                return this.parseInquirySample(message, true);
            }
            if (tipo.equals(MSG_TYPE_TRI_INQUIRY_RERUN_SAMPLE)) {
                return this.parseInquirySample(message, false);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "InterfaceOlympusListener: 62");
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "InterfaceOlympusListener: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
        return "";
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    public boolean checkCRC(String message, String checksum) {
        message = message.substring(1);
        int sum25 = 0;
        int sum2a5 = (byte)message.charAt(0) + (byte)message.charAt(message.length() - 1);
        for (int i = 0; i < message.length(); ++i) {
            sum2a5 += (byte)message.charAt(i);
        }
        String crc = Integer.toHexString(sum25 ^ sum2a5);
        return crc.equalsIgnoreCase(checksum);
    }

    public String parseNormalSampleResult(String message) throws Exception {
        String req_codigo = message.substring(17, 37).trim();
        if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada: " + req_codigo);
            return "Erro: N\u00e3o foi encontrada nenhuma requisi\u00e7\u00e3o com esse c\u00f3digo";
        }
        String fil_codigo = "";
        String rec_codigo = "";
        DescritorCodigoEtiqueta codigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigo);
        if (codigoEtiqueta != null) {
            fil_codigo = Funcoes.preencheZero(codigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = Funcoes.preencheZero(codigoEtiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            req_codigo = Funcoes.preencheZero(codigoEtiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
        } else {
            fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        }
        if (!Funcoes.isNumeric(fil_codigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 uma filial v\u00e1lida ou uma mensagem de controle foi recebida e deve ser ignorada. Filial da mensagem = \"" + fil_codigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        if (!Funcoes.isNumeric(req_codigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 uma requisi\u00e7\u00e3o v\u00e1lida ou uma mensagem de controle foi recebida e deve ser ignorada. Requisi\u00e7\u00e3o da mensagem = \"" + req_codigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        if (!Funcoes.isNumeric(rec_codigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 um recipiente v\u00e1lido ou uma mensagem de controle foi recebida e deve ser ignorada. Recipiente da mensagem = \"" + rec_codigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        return this.parseResultados(fil_codigo, req_codigo, rec_codigo, message.substring(168, message.length() - 1), false);
    }

    public String parseRerunSampleResult(String message) throws Exception {
        String req_codigo = message.substring(17, 37).trim();
        if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada: " + req_codigo);
            return "Erro: N\u00e3o foi encontrada nenhuma requisi\u00e7\u00e3o com esse c\u00f3digo";
        }
        String fil_codigo = "";
        String rec_codigo = "";
        DescritorCodigoEtiqueta codigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigo);
        if (codigoEtiqueta != null) {
            fil_codigo = Funcoes.preencheZero(codigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = Funcoes.preencheZero(codigoEtiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            req_codigo = Funcoes.preencheZero(codigoEtiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
        } else {
            fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        }
        if (!Funcoes.isNumeric(fil_codigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 uma filial v\u00e1lida ou uma mensagem de controle foi recebida e deve ser ignorada. Filial da mensagem = \"" + fil_codigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        if (!Funcoes.isNumeric(req_codigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 uma requisi\u00e7\u00e3o v\u00e1lida ou uma mensagem de controle foi recebida e deve ser ignorada. Requisi\u00e7\u00e3o da mensagem = \"" + req_codigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        if (!Funcoes.isNumeric(rec_codigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 um recipiente v\u00e1lido ou uma mensagem de controle foi recebida e deve ser ignorada. Recipiente da mensagem = \"" + rec_codigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        return this.parseResultados(fil_codigo, req_codigo, rec_codigo, message.substring(42, message.length() - 1), true);
    }

    public String parseStatFastResult(String message) throws Exception {
        boolean encontrou = false;
        Statement st = Conexao.getStatement();
        String req_codigo = message.substring(17, 37).trim();
        String paciente = "";
        if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada: " + req_codigo);
            return "Erro: N\u00e3o foi encontrada nenhuma requisi\u00e7\u00e3o com esse c\u00f3digo";
        }
        String fil_codigo = "";
        String rec_codigo = "";
        DescritorCodigoEtiqueta codigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigo);
        if (codigoEtiqueta != null) {
            fil_codigo = Funcoes.preencheZero(codigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = Funcoes.preencheZero(codigoEtiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            req_codigo = Funcoes.preencheZero(codigoEtiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
        } else {
            fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        }
        if (!Funcoes.isNumeric(fil_codigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 uma filial v\u00e1lida ou uma mensagem de controle foi recebida e deve ser ignorada. Filial da mensagem = \"" + fil_codigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        if (!Funcoes.isNumeric(req_codigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 uma requisi\u00e7\u00e3o v\u00e1lida ou uma mensagem de controle foi recebida e deve ser ignorada. Requisi\u00e7\u00e3o da mensagem = \"" + req_codigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        if (!Funcoes.isNumeric(rec_codigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 um recipiente v\u00e1lido ou uma mensagem de controle foi recebida e deve ser ignorada. Recipiente da mensagem = \"" + rec_codigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        ArrayList exames = ((AbaDefaultNaoEnviados)this.equipamento.getTab(0)).getExames();
        PanelAbaAbstrata aba = this.equipamento.getTab(0);
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            String tubo = (String)req[aba.getColIndice("Tubo")];
            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
            if (!fil_codigo.equalsIgnoreCase(filial) || !req_codigo.equalsIgnoreCase(requisicao) || !rec_codigo.equalsIgnoreCase(tubo)) continue;
            String[] examesRequisicao = ((String)req[aba.getColIndice("Exame")]).split(" ");
            String mco_codigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
            String[] stringArray = examesRequisicao;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String exame;
                String int_codigo;
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exame = stringArray[j], mco_codigo), req_codigo, exame, mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            encontrou = true;
            this.firePacienteEnviado((String)req[aba.getColIndice("C\u00f3digo")], (String)req[aba.getColIndice("Paciente")], (String)req[aba.getColIndice("S")], (String)req[aba.getColIndice("Ide")], TempoUtil.getCurrentDateBr(), TempoUtil.getCurrentTime(), (String)req[aba.getColIndice("Exame")]);
            paciente = (String)req[aba.getColIndice("Paciente")];
            break;
        }
        if (encontrou) {
            return "Enviando " + paciente + " para o equipamento";
        }
        this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada: " + fil_codigo + req_codigo + rec_codigo);
        return "Erro: N\u00e3o foi encontrada nenhuma requisi\u00e7\u00e3o com esse c\u00f3digo";
    }

    public String parseInquirySample(String message, boolean normal) throws SQLException {
        this.hostQuery = true;
        String rackPosition = message.substring(5, 12);
        this.proximaPosicao = message.substring(13, 17);
        String req_codigo = message.substring(17, 37).trim();
        StringBuilder pac_exames = new StringBuilder("");
        String fil_codigo = "";
        String rec_codigo = "";
        String req_codigoOriginal = "";
        if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada: " + fil_codigo + req_codigo + rec_codigo);
            return "Erro: N\u00e3o foi encontrada nenhuma requisi\u00e7\u00e3o com esse c\u00f3digo";
        }
        if (!Funcoes.textoVazio(req_codigo)) {
            req_codigoOriginal = req_codigo;
            fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        }
        if (!Funcoes.isNumeric(fil_codigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 uma filial v\u00e1lida ou uma mensagem de controle foi recebida e deve ser ignorada. Filial da mensagem = \"" + fil_codigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        if (!Funcoes.isNumeric(req_codigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 uma requisi\u00e7\u00e3o v\u00e1lida ou uma mensagem de controle foi recebida e deve ser ignorada. Requisi\u00e7\u00e3o da mensagem = \"" + req_codigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        if (!Funcoes.isNumeric(rec_codigo)) {
            String msg = "A mensagem recebida do equipamento n\u00e3o refere-se \u00e0 um recipiente v\u00e1lido ou uma mensagem de controle foi recebida e deve ser ignorada. Recipiente da mensagem = \"" + rec_codigo + "\". Mensagem recebida = \"" + message + "\".";
            this.fireExcecaoEncontrada(msg);
            return msg;
        }
        DescritorCodigoEtiqueta codigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigoOriginal);
        if (codigoEtiqueta != null) {
            fil_codigo = Funcoes.preencheZero(codigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = Funcoes.preencheZero(codigoEtiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            req_codigo = Funcoes.preencheZero(codigoEtiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            String req_mae = BDUtil.getReqMultiGuiaMae(fil_codigo, req_codigo);
            if (!codigoEtiqueta.getRequisicao().equals(req_mae)) {
                req_codigo = Funcoes.preencheZero(req_mae, ParametrosGerais.getDigitosTuboRequisicao());
            }
        }
        Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
        PanelAbaAbstrata aba = this.equipamento.getTab(0);
        if (req != null) {
            pac_exames.append((String)req[aba.getColIndice("Exame")]);
        }
        if (req == null) {
            req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
            aba = this.equipamento.getTab(1);
            if (req != null) {
                List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                for (Object[] r : reqs) {
                    pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                }
            }
        }
        String situacao = null;
        if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
            aba = this.equipamento.getTab(2);
            if (req != null) {
                List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                for (Object[] r : reqs) {
                    if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                    situacao = (String)r[aba.getColIndice("Sit")];
                    pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                }
            }
        }
        String int_codigo = null;
        String mco_codigo = null;
        if (req == null) {
            this.equipamento.getTab(0).reloadExames();
            req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            if (req == null) {
                this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada: " + fil_codigo + req_codigo + rec_codigo);
                return "Erro: N\u00e3o foi encontrada nenhuma requisi\u00e7\u00e3o com esse c\u00f3digo";
            }
            int_codigo = (String)req[aba.getColIndice("Interface")];
            mco_codigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
            String lisExa = (String)req[aba.getColIndice("Exame")];
            for (String ex : lisExa.split(" ")) {
                if (BDUtil.isExameCurva(fil_codigo, int_codigo, ex, mco_codigo)) continue;
                pac_exames.append(ex);
            }
            if (req != null && Funcoes.textoVazio(pac_exames.toString())) {
                pac_exames.append((String)req[aba.getColIndice("Exame")]);
            }
        }
        if (req != null) {
            String rack = (String)req[aba.getColIndice("Rack")];
            if (rack == null) {
                rack = "";
            }
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            int_codigo = (String)req[aba.getColIndice("Interface")];
            mco_codigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            String tubo = (String)req[aba.getColIndice("Tubo")];
            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
            ArrayList tubosFilho = null;
            if (req[aba.getColIndice("Tubos Filhos")] != null) {
                tubosFilho = (ArrayList)req[aba.getColIndice("Tubos Filhos")];
                if (!rec_codigo.equalsIgnoreCase(tubo) && tubosFilho.contains(String.valueOf(Integer.parseInt(rec_codigo)))) {
                    StringBuilder examesNovos = new StringBuilder();
                    for (String exame : pac_exames.toString().split(" ")) {
                        BDExame[] exames = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tubo, rec_codigo);
                        if (exames == null || exames.length <= 0) continue;
                        examesNovos.append(exame).append(" ");
                    }
                    if (!Funcoes.textoVazio(examesNovos.toString())) {
                        pac_exames.setLength(0);
                        pac_exames.append(examesNovos.toString().trim());
                    }
                }
            }
            String codigoApoiado = "";
            if (this.exr_codigoapoiado && !fil_codigo.equalsIgnoreCase(filial)) {
                String[] exames;
                for (String exame : exames = pac_exames.toString().trim().split(" ")) {
                    String[] codigoJalis = BDUtil.getCodigoJalis(fil_codigo, req_codigo, rec_codigo, int_codigo, exame, mco_codigo);
                    if (codigoJalis == null || Funcoes.textoVazio(codigoJalis[0])) continue;
                    codigoApoiado = String.format("%s%s%s", fil_codigo, req_codigo, rec_codigo);
                    fil_codigo = filial;
                    req_codigo = StringUtil.preencheString(codigoJalis[1], ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
                    rec_codigo = StringUtil.preencheString(codigoJalis[2], ParametrosGerais.getDigitosTuboTubo(), '0', 1);
                    break;
                }
            }
            if (rack.equalsIgnoreCase(rackPosition) || fil_codigo.equalsIgnoreCase(filial) && req_codigo.equalsIgnoreCase(requisicao) && (rec_codigo.equalsIgnoreCase(tubo) || tubosFilho != null && tubosFilho.contains(String.valueOf(Integer.parseInt(rec_codigo))))) {
                return this.enviarRequisicao((String)req[aba.getColIndice("Paciente")], (String)req[aba.getColIndice("S")], (String)req[aba.getColIndice("Ide")], TempoUtil.getCurrentDateBr(), TempoUtil.getCurrentTime(), rackPosition, normal ? MSG_TYPE_TRI_NORMAL_SAMPLE : MSG_TYPE_TRI_RERUN_SAMPLE, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), "N", codigoApoiado);
            }
        }
        this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada: " + fil_codigo + req_codigo + rec_codigo);
        return "Erro: N\u00e3o foi encontrada nenhuma requisi\u00e7\u00e3o com esse c\u00f3digo";
    }

    protected void retransmitir() {
        try {
            this.getPortaCOM().write(this.ultimoEnvio);
        }
        catch (IOException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "InterfaceOlympusListener: 428");
        }
    }

    protected void confirmaTransmissao() {
        try {
            if (this.ultimo_enviado == null || this.ultimo_enviado.getExames() == null) {
                this.equipamento.mensagemEnviada("Erro ao receber resposta do equipamento", 1, 5000);
                return;
            }
            Statement st = Conexao.getStatement();
            String[] exames = this.ultimo_enviado.getExames().split(" ", 0);
            for (int i = 0; i < exames.length; ++i) {
                int situacao;
                String fil_codigo = this.ultimo_enviado.getFilial();
                String req_codigo = this.ultimo_enviado.getCodigo();
                String mco_codigo = this.ultimo_enviado.getMaterial();
                String rec_codigo = this.ultimo_enviado.getRecipiente();
                String recTuboPai = this.ultimo_enviado.getTuboPai();
                String int_codigo = this.ultimo_enviado.getInterface();
                String mco_kodigo = this.ultimo_enviado.getMaterial();
                String outrosExames = "";
                if (recTuboPai != null && this.ultimo_enviado.isCurva().booleanValue()) {
                    recTuboPai = Funcoes.preencheZero(recTuboPai, ParametrosGerais.getDigitosTuboTubo());
                    situacao = -1;
                    for (String exameFilho : this.ultimo_enviado.getExamesFilho().split(" ")) {
                        String tuboFilho;
                        situacao = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, recTuboPai, exameFilho, mco_kodigo);
                        if (situacao == -1) {
                            BDExame[] bdExames;
                            for (BDExame bdExame : bdExames = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, recTuboPai, rec_codigo)) {
                                if (!exameFilho.equals(bdExame.getExame())) continue;
                                situacao = bdExame.getSituacao();
                                mco_kodigo = bdExame.getMaterial();
                            }
                        }
                        if (Funcoes.textoVazio(tuboFilho = BDUtil.getExameDesmembradoTubo(fil_codigo, req_codigo, recTuboPai, int_codigo, exameFilho, mco_kodigo))) {
                            Integer[] multiguias;
                            for (Integer multi : multiguias = RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo)) {
                                tuboFilho = BDUtil.getExameDesmembradoTubo(fil_codigo, multi.toString(), recTuboPai, int_codigo, exameFilho, mco_kodigo);
                            }
                        }
                        if (!Funcoes.textoVazio(tuboFilho)) {
                            tuboFilho = Funcoes.preencheZero(Integer.valueOf(tuboFilho), ParametrosGerais.getDigitosTuboTubo());
                        }
                        if (Funcoes.textoVazio(rec_codigo) || Funcoes.textoVazio(tuboFilho) || !tuboFilho.equalsIgnoreCase(rec_codigo)) continue;
                        BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, exameFilho, mco_kodigo, recTuboPai, situacao < 2 ? 1 : 3);
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, recTuboPai);
                    if (BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, recTuboPai)) {
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, recTuboPai, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    }
                    outrosExames = this.atualizaOutrosExames(st, fil_codigo, req_codigo, recTuboPai, int_codigo, this.ultimo_enviado.getExames());
                } else {
                    if (int_codigo == null) {
                        int_codigo = String.valueOf(this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo));
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3, this.ultimo_enviado.isCurva());
                    if (!Funcoes.textoVazio(this.ultimo_enviado.getExamesFilho())) {
                        BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo, situacao < 2 ? 1 : 3);
                    }
                    outrosExames = this.atualizaOutrosExames(st, fil_codigo, req_codigo, rec_codigo, int_codigo, this.ultimo_enviado.getExames());
                }
                if (!req_codigo.equals(this.ultimo_enviado.getCodigo())) continue;
                this.firePacienteEnviado(this.ultimo_enviado.getCodigo(), this.ultimo_enviado.getNome(), this.ultimo_enviado.getSexo(), this.ultimo_enviado.getIdade(), this.ultimo_enviado.getData(), this.ultimo_enviado.getHora(), String.format("%s %s", this.ultimo_enviado.getExames(), outrosExames));
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            this.equipamento.mensagemEnviada("Exame enviado com sucesso para " + this.ultimo_enviado.getNome(), 1, 5000);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private String atualizaOutrosExames(Statement st, String fil_codigo, String req_codigo, String recTuboPai, String int_codigo, String exames) throws SQLException {
        StringBuilder outrosExames = new StringBuilder();
        for (BDExame bdExame : this.ultimo_enviado.getOutrosExames()) {
            if (!exames.contains(bdExame.getExame())) {
                outrosExames.append(bdExame.getExame()).append(" ");
            }
            int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, bdExame.getExame(), bdExame.getMaterial(), recTuboPai);
            this.atualizarSituacaoExame(st, fil_codigo, req_codigo, bdExame.getRecipiente(), bdExame.getExame(), bdExame.getMaterial(), int_codigo, null, situacao < 2 ? 1 : 3);
        }
        return outrosExames.toString();
    }

    private String parseResultados(String fil_codigo, String req_codigo, String rec_codigo, String message, boolean repeticao) throws Exception {
        int index;
        Statement st = Conexao.getStatement();
        int n = index = message.length() % 29 == 0 ? 29 : 13;
        while (message.length() > 0) {
            String int_codigo;
            String emi_alternativo;
            String resultado;
            block11: {
                resultado = message.substring(0, index);
                message = message.substring(index);
                emi_alternativo = resultado.substring(0, 2);
                int_codigo = "";
                try {
                    int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (int_codigo == null && ParametrosGerais.getTipoExportacaoInterface().equals("T")) {
                        this.getAba(1).reloadExames();
                        int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                    }
                    if (int_codigo == null) {
                        this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    }
                    break block11;
                }
                catch (Exception e) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                }
                continue;
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
            if (exame == null) {
                this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                continue;
            }
            String res = resultado.substring(resultado.length() - 11, resultado.length() - 2);
            boolean validarLiberado = true;
            if (res.trim().length() != 0) {
                double result = Double.parseDouble(res);
                res = Double.toString(result).replaceAll("\\.", ",");
            } else {
                res = "EXCE\u00c7\u00c3O";
                validarLiberado = false;
            }
            int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
            if (repeticao && this.configuracao.isReceberResultadosRepetidosPeloEquipamento() && (sit == 3 || sit == 2)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, null, 3);
            }
            if (!repeticao && !this.configuracao.isReceberResultadosRepetidosPeloEquipamento() && sit == 2 || sit == 7 || sit == 4) {
                this.fireExcecaoEncontrada(String.format("Interfaceamento do exame %s para requisi\u00e7\u00e3o %s %s %s com situa\u00e7\u00e3o %s ", exame.getNomeExame(), fil_codigo, req_codigo, rec_codigo, sit == 2 ? "pronto " : (sit == 4 ? " j\u00e1 repetido " : "validado ")));
                continue;
            }
            this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, res, validarLiberado);
            this.parseFlags(fil_codigo, req_codigo, rec_codigo, resultado.substring(index - 2));
        }
        Conexao.arquivaSQL();
        if (!this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
            this.fireAtualizarTabela(2);
        }
        return "Dados recebidos com sucesso";
    }

    public void parseFlags(String fil_codigo, String req_codigo, String rec_codigo, String flags) {
        char[] flgs = flags.toCharArray();
        String requisicao = fil_codigo + "-" + req_codigo + "-" + rec_codigo + ": ";
        block44: for (char c : flgs) {
            switch (c) {
                case '(': {
                    this.fireExcecaoEncontrada(requisicao + "Failed to evade the contamination since the detergent for evading the contamination is not enough.");
                    continue block44;
                }
                case '%': {
                    this.fireExcecaoEncontrada(requisicao + "The sample probe is clogged with sample.");
                    continue block44;
                }
                case '?': {
                    this.fireExcecaoEncontrada(requisicao + "Calculation unable due to abnormal photometric data");
                    continue block44;
                }
                case '#': {
                    this.fireExcecaoEncontrada(requisicao + "Sample level detection error");
                    continue block44;
                }
                case 'R': {
                    this.fireExcecaoEncontrada(requisicao + "Reagent level detection error");
                    continue block44;
                }
                case '!': {
                    this.fireExcecaoEncontrada(requisicao + "Calculation unable due to abnormal data");
                    continue block44;
                }
                case 'U': {
                    this.fireExcecaoEncontrada(requisicao + "Reagent absorbance value at P-END (last photometric point) of Reagent Blank run, is smaller than the lower limit defined in the Specific Test Parameter Menu.");
                    continue block44;
                }
                case 'u': {
                    this.fireExcecaoEncontrada(requisicao + "Reagent absorbance value at P-START (first photometric point) of Reagent Blank run, is smaller than the lower limit defined in the Specific Test Parameter Menu.");
                    continue block44;
                }
                case 'Y': {
                    this.fireExcecaoEncontrada(requisicao + "Reagent absorbance value at P-END (last photometric point) of Reagent Blank run, is greater than the upper limit defined in the Specific Test Parameter Menu.");
                    continue block44;
                }
                case 'y': {
                    this.fireExcecaoEncontrada(requisicao + "Reagent absorbance value at P-START (first photometric point) of Reagent Blank run, is greater than the upper limit defined in the Specific Test Parameter Menu.");
                    continue block44;
                }
                case '@': {
                    this.fireExcecaoEncontrada(requisicao + "Abnormally high result; absorbance of every wavelength is more than 2.5.");
                    continue block44;
                }
                case '$': {
                    this.fireExcecaoEncontrada(requisicao + "No linearity validation conducted because less than 3 data obtained in the kinetics.");
                    continue block44;
                }
                case 'D': {
                    this.fireExcecaoEncontrada(requisicao + "Too quick reaction slope in increasing kinetics, absorbance at P-START is higher than MAX. OD in increasing FIXED assay, or too slow reaction slope in decreasing kinetics (= no reaction observed)");
                    continue block44;
                }
                case 'B': {
                    this.fireExcecaoEncontrada(requisicao + "Too quick reaction slope in increasing kinetics, or absorbance at P-END is lower than MIN. OD in increasing FIXED assay. Linearity error in kinetics.");
                    continue block44;
                }
                case '*': {
                    this.fireExcecaoEncontrada(requisicao + "Linearity error in kinetics.");
                    continue block44;
                }
                case '&': {
                    this.fireExcecaoEncontrada(requisicao + "Prozone data error (prozone check point data error)");
                    continue block44;
                }
                case 'Z': {
                    this.fireExcecaoEncontrada(requisicao + "Prozone error");
                    continue block44;
                }
                case ')': {
                    this.fireExcecaoEncontrada(requisicao + "The reagent lot No. used at the time of sample analysis differs from the reagent lot No. used at the time of calibration analysis.");
                    continue block44;
                }
                case 'F': {
                    this.fireExcecaoEncontrada(requisicao + "Result higher than the dynamic range specified in the Parameters");
                    continue block44;
                }
                case 'G': {
                    this.fireExcecaoEncontrada(requisicao + "Result lower than the dynamic range specified in the Parameters");
                    continue block44;
                }
                case 'x': {
                    this.fireExcecaoEncontrada(requisicao + "Other QC data error");
                    continue block44;
                }
                case '1': {
                    this.fireExcecaoEncontrada(requisicao + "QC result beyond the QC value range specified in the Parameters");
                    continue block44;
                }
                case '2': {
                    this.fireExcecaoEncontrada(requisicao + "multi-rule QC data error");
                    continue block44;
                }
                case '3': {
                    this.fireExcecaoEncontrada(requisicao + "multi-rule QC data error");
                    continue block44;
                }
                case '4': {
                    this.fireExcecaoEncontrada(requisicao + "multi-rule QC data error");
                    continue block44;
                }
                case '5': {
                    this.fireExcecaoEncontrada(requisicao + "multi-rule QC data error");
                    continue block44;
                }
                case '6': {
                    this.fireExcecaoEncontrada(requisicao + "multi-rule QC data error");
                    continue block44;
                }
                case '7': {
                    this.fireExcecaoEncontrada(requisicao + "multi-rule QC data error");
                    continue block44;
                }
                case 'p': {
                    this.fireExcecaoEncontrada(requisicao + "Result beyond the panic value specified in the Parameters");
                    continue block44;
                }
                case 'T': {
                    this.fireExcecaoEncontrada(requisicao + "Abnormality found in the Inter-Item Check");
                    continue block44;
                }
                case 'P': {
                    this.fireExcecaoEncontrada(requisicao + "Result higher than DECIDE RANGE designated in parameters.");
                    continue block44;
                }
                case 'N': {
                    this.fireExcecaoEncontrada(requisicao + "Result lower than DECIDE RANGE designated in parameters.");
                    continue block44;
                }
                case 'H': {
                    this.fireExcecaoEncontrada(requisicao + "higher than the result value range specified in the Parameters");
                    continue block44;
                }
                case 'L': {
                    this.fireExcecaoEncontrada(requisicao + "lower than the result value range specified in the Parameters");
                    continue block44;
                }
                case 'J': {
                    this.fireExcecaoEncontrada(requisicao + "Result higher than the repeat run range specified in the Parameters");
                    continue block44;
                }
                case 'K': {
                    this.fireExcecaoEncontrada(requisicao + "Result lower than the repeat run range specified in the Parameters");
                    continue block44;
                }
                case 'S': {
                    this.fireExcecaoEncontrada(requisicao + "Result extracted for repeat run");
                    continue block44;
                }
                case '/': {
                    this.fireExcecaoEncontrada(requisicao + "Test not performed: test has been requisitioned but not performed due to any reason.");
                    continue block44;
                }
                case 'r': {
                    this.fireExcecaoEncontrada(requisicao + "transferred data to host");
                    continue block44;
                }
                case 'e': {
                    this.fireExcecaoEncontrada(requisicao + "edited data");
                    continue block44;
                }
                case 'c': {
                    this.fireExcecaoEncontrada(requisicao + "correct data by manual correction");
                    continue block44;
                }
                case 'd': {
                    this.fireExcecaoEncontrada(requisicao + "Data not the object of statistical calculations with [QC monitor]-[Data Edit]");
                }
            }
        }
    }

    @Override
    public void teste() {
        this.parse(TestesInterface.arruma("[STX]RB01[ETX]"));
        this.parse(TestesInterface.arruma("[STX]DB01[ETX]"));
        this.parse(TestesInterface.arruma("[STX]R[SP]01001001[SP]0001[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]010005477004[ETX]"));
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceOlympusListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceOlympusListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

