/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.kermit;

import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.util.Funcoes;

public class KermitStandard {
    public static final char PACKET_DATA = 'D';
    public static final char PACKET_ACK_POSITIVE = 'Y';
    public static final char PACKET_ACK_NEGATIVE = 'N';
    public static final char PACKET_START = 'S';
    public static final char PACKET_BREAK = 'B';
    public static final char PACKET_FILE = 'F';
    public static final char PACKET_END = 'Z';
    public static final char PACKET_ERROR = 'E';
    public static final String URINA = "URINA";
    public static final String SANGUE = "SANGUE";
    public static final String LIQUOR = "LIQUOR";

    public static String getDefaultConfigPacket(int sequence) {
        return KermitStandard.getDefaultConfigPacket((char)sequence);
    }

    public static String getDefaultConfigPacket(char sequence) {
        StringBuilder msg = new StringBuilder();
        msg.append(sequence);
        msg.append('S');
        msg.append("~R @-#N1");
        msg.insert(0, (char)(msg.length() + 33));
        msg.append(KermitStandard.getCheckSum(msg.toString()));
        msg.append(String.valueOf('\r'));
        msg.insert(0, String.valueOf('\u0001'));
        return msg.toString();
    }

    public static String getDefaultFilePacket(int sequence) {
        return KermitStandard.getDefaultFilePacket((char)sequence);
    }

    public static String getDefaultFilePacket(char sequence) {
        StringBuilder msg = new StringBuilder();
        msg.append(sequence);
        msg.append('F');
        msg.append("S").append(Funcoes.preencheZero(sequence, 7));
        msg.insert(0, (char)(msg.length() + 33));
        msg.append(KermitStandard.getCheckSum(msg.toString()));
        msg.append(String.valueOf('\r'));
        msg.insert(0, String.valueOf('\u0001'));
        return msg.toString();
    }

    public static String getDefaultDataPacket(int sequence, String sampleId, String pac_nome, String material, ExameMaterial[] alternativos) {
        return KermitStandard.getDefaultDataPacket((char)sequence, sampleId, pac_nome, material, alternativos);
    }

    public static String getDefaultDataPacket(char sequence, String sampleId, String pac_nome, String material, ExameMaterial[] alternativos) {
        material = material.equalsIgnoreCase(URINA) ? "3" : (material.equalsIgnoreCase(LIQUOR) ? "2" : "1");
        StringBuilder msg = new StringBuilder();
        msg.append(sequence);
        msg.append('D');
        msg.append(Funcoes.preencheVazio(sampleId.toString(), 15, 2));
        msg.append(material);
        msg.append("0");
        msg.append(" ");
        msg.append("1.000");
        for (ExameMaterial exa : alternativos) {
            msg.append(KermitStandard.trocaExameAlternativo(exa.getNomeExame()));
        }
        msg.append("|");
        msg.append(pac_nome);
        msg.append("]");
        StringBuilder temp = new StringBuilder();
        temp.append(msg.toString());
        temp.insert(0, (char)(temp.length() + 33));
        temp.append(KermitStandard.getCheckSum(temp.toString()));
        temp.append(String.valueOf('\r'));
        temp.insert(0, String.valueOf('\u0001'));
        return temp.toString();
    }

    public static String getDefaultEndFilePacket(int sequence) {
        return KermitStandard.getDefaultEndFilePacket((char)sequence);
    }

    public static String getDefaultEndFilePacket(char sequence) {
        StringBuilder msg = new StringBuilder();
        msg.append(sequence);
        msg.append('Z');
        msg.insert(0, (char)(msg.length() + 33));
        msg.append(KermitStandard.getCheckSum(msg.toString()));
        msg.append(String.valueOf('\r'));
        msg.insert(0, String.valueOf('\u0001'));
        return msg.toString();
    }

    public static String getDefaultAckPacket(int sequence) {
        return KermitStandard.getDefaultAckPacket((char)sequence);
    }

    public static String getDefaultAckPacket(char sequence) {
        StringBuilder msg = new StringBuilder();
        msg.append(sequence);
        msg.append('Y');
        msg.insert(0, (char)(msg.length() + 33));
        msg.append(KermitStandard.getCheckSum(msg.toString()));
        msg.append(String.valueOf('\r'));
        msg.insert(0, String.valueOf('\u0001'));
        return msg.toString();
    }

    public static String getDefaultBreakPacket(int sequence) {
        return KermitStandard.getDefaultBreakPacket((char)sequence);
    }

    public static String getDefaultBreakPacket(char sequence) {
        StringBuilder msg = new StringBuilder();
        msg.append(sequence);
        msg.append('B');
        msg.insert(0, (char)(msg.length() + 33));
        msg.append(KermitStandard.getCheckSum(msg.toString()));
        msg.append(String.valueOf('\r'));
        msg.insert(0, String.valueOf('\u0001'));
        return msg.toString();
    }

    public static char getRecordTypeIdentifier(String record) {
        if (record != null && !record.equals("")) {
            char record_type = record.charAt(1);
            switch (record_type) {
                case 'd': {
                    return 'D';
                }
                case 'D': {
                    return 'D';
                }
                case 'y': {
                    return 'Y';
                }
                case 'Y': {
                    return 'Y';
                }
                case 'n': {
                    return 'N';
                }
                case 'N': {
                    return 'N';
                }
                case 's': {
                    return 'S';
                }
                case 'S': {
                    return 'S';
                }
                case 'b': {
                    return 'B';
                }
                case 'B': {
                    return 'B';
                }
                case 'f': {
                    return 'F';
                }
                case 'F': {
                    return 'F';
                }
                case 'z': {
                    return 'Z';
                }
                case 'Z': {
                    return 'Z';
                }
                case 'e': {
                    return 'E';
                }
                case 'E': {
                    return 'E';
                }
            }
            return ' ';
        }
        return ' ';
    }

    public static char getCheckSum(String message) {
        int sum = 0;
        for (int i = 0; i < message.length(); ++i) {
            sum += (byte)message.charAt(i);
        }
        sum = (sum + (sum & 0xC0) / 64 & 0x3F) + 32;
        return (char)sum;
    }

    private static String trocaExameAlternativo(String exame) {
        if (exame.equalsIgnoreCase("GLU")) {
            return " ";
        }
        if (exame.equalsIgnoreCase("TP")) {
            return "!";
        }
        if (exame.equalsIgnoreCase("URIC")) {
            return "\"";
        }
        if (exame.equalsIgnoreCase("ALB")) {
            return "##";
        }
        if (exame.equalsIgnoreCase("TRIG")) {
            return "$";
        }
        if (exame.equalsIgnoreCase("CHOL")) {
            return "%";
        }
        if (exame.equalsIgnoreCase("AMYL")) {
            return "&";
        }
        if (exame.equalsIgnoreCase("Cl")) {
            return "'";
        }
        if (exame.equalsIgnoreCase("K+")) {
            return "(";
        }
        if (exame.equalsIgnoreCase("Na+")) {
            return ")";
        }
        if (exame.equalsIgnoreCase("ECO2")) {
            return "*";
        }
        if (exame.equalsIgnoreCase("PHOS")) {
            return "+";
        }
        if (exame.equalsIgnoreCase("LAC")) {
            return ",";
        }
        if (exame.equalsIgnoreCase("NH3")) {
            return "-";
        }
        if (exame.equalsIgnoreCase("ALT2")) {
            return "-";
        }
        if (exame.equalsIgnoreCase("CREA")) {
            return ".";
        }
        if (exame.equalsIgnoreCase("BUN")) {
            return "/";
        }
        if (exame.equalsIgnoreCase("HDLC")) {
            return "0";
        }
        if (exame.equalsIgnoreCase("Bu")) {
            return "1";
        }
        if (exame.equalsIgnoreCase("Ca")) {
            return "2";
        }
        if (exame.equalsIgnoreCase("TBIL")) {
            return "3";
        }
        if (exame.equalsIgnoreCase("AST")) {
            return "4";
        }
        if (exame.equalsIgnoreCase("ALKP")) {
            return "5";
        }
        if (exame.equalsIgnoreCase("ALT")) {
            return "6";
        }
        if (exame.equalsIgnoreCase("LDH")) {
            return "7";
        }
        if (exame.equalsIgnoreCase("CK")) {
            return "8";
        }
        if (exame.equalsIgnoreCase("LIPA")) {
            return "9";
        }
        if (exame.equalsIgnoreCase("GGT")) {
            return ":";
        }
        if (exame.equalsIgnoreCase("Bc")) {
            return ";";
        }
        if (exame.equalsIgnoreCase("THEO")) {
            return "<";
        }
        if (exame.equalsIgnoreCase("CKMB")) {
            return "=";
        }
        if (exame.equalsIgnoreCase("Mg")) {
            return ">";
        }
        if (exame.equalsIgnoreCase("Fe")) {
            return "?";
        }
        if (exame.equalsIgnoreCase("TIBC")) {
            return "@";
        }
        if (exame.equalsIgnoreCase("PROT")) {
            return "A";
        }
        if (exame.equalsIgnoreCase("SALI")) {
            return "B";
        }
        if (exame.equalsIgnoreCase("ALC")) {
            return "C";
        }
        if (exame.equalsIgnoreCase("AMON")) {
            return "D";
        }
        if (exame.equalsIgnoreCase("CHE")) {
            return "E";
        }
        if (exame.equalsIgnoreCase("ACP")) {
            return "F";
        }
        if (exame.equalsIgnoreCase("ACPB")) {
            return "G";
        }
        if (exame.equalsIgnoreCase("Li")) {
            return "H";
        }
        if (exame.equalsIgnoreCase("DGXN")) {
            return "I";
        }
        if (exame.equalsIgnoreCase("PHBR")) {
            return "J";
        }
        if (exame.equalsIgnoreCase("PHYT")) {
            return "K";
        }
        if (exame.equalsIgnoreCase("CRP")) {
            return "L";
        }
        if (exame.equalsIgnoreCase("CRBM")) {
            return "M";
        }
        if (exame.equalsIgnoreCase("ACET")) {
            return "O";
        }
        if (exame.equalsIgnoreCase("UPRO")) {
            return "P";
        }
        if (exame.equalsIgnoreCase("dHDL")) {
            return "Y";
        }
        if (exame.equalsIgnoreCase("CRPJ")) {
            return "V";
        }
        if (exame.equalsIgnoreCase("ALTJ")) {
            return "W";
        }
        if (exame.equalsIgnoreCase("ASTJ")) {
            return "X";
        }
        if (exame.equalsIgnoreCase("ALTV")) {
            return "Z";
        }
        return exame;
    }

    public static String trocaAlternativoExame(char c) {
        switch (c) {
            case ' ': {
                return "GLU";
            }
            case '!': {
                return "TP";
            }
            case '\"': {
                return "URIC";
            }
            case '#': {
                return "ALB";
            }
            case '$': {
                return "TRIG";
            }
            case '%': {
                return "CHOL";
            }
            case '&': {
                return "AMYL";
            }
            case '\'': {
                return "Cl";
            }
            case '(': {
                return "K+";
            }
            case ')': {
                return "Na+";
            }
            case '*': {
                return "ECO2";
            }
            case '+': {
                return "PHOS";
            }
            case ',': {
                return "LAC";
            }
            case '-': {
                return "NH3";
            }
            case '.': {
                return "CREA";
            }
            case '/': {
                return "BUN";
            }
            case '0': {
                return "HDLC";
            }
            case '1': {
                return "Bu";
            }
            case '2': {
                return "Ca";
            }
            case '3': {
                return "TBIL";
            }
            case '4': {
                return "AST";
            }
            case '5': {
                return "ALKP";
            }
            case '6': {
                return "ALT";
            }
            case '7': {
                return "LDH";
            }
            case '8': {
                return "CK";
            }
            case '9': {
                return "LIPA";
            }
            case ':': {
                return "GGT";
            }
            case ';': {
                return "Bc";
            }
            case '<': {
                return "THEO";
            }
            case '=': {
                return "CKMB";
            }
            case '>': {
                return "Mg";
            }
            case '?': {
                return "Fe";
            }
            case '@': {
                return "TIBC";
            }
            case 'A': {
                return "PROT";
            }
            case 'B': {
                return "SALI";
            }
            case 'C': {
                return "ALC";
            }
            case 'D': {
                return "AMON";
            }
            case 'E': {
                return "CHE";
            }
            case 'F': {
                return "ACP";
            }
            case 'G': {
                return "ACPB";
            }
            case 'H': {
                return "Li";
            }
            case 'I': {
                return "DGXN";
            }
            case 'J': {
                return "PHBR";
            }
            case 'K': {
                return "PHYT";
            }
            case 'L': {
                return "CRP";
            }
            case 'M': {
                return "CRBM";
            }
            case 'O': {
                return "ACET";
            }
            case 'P': {
                return "UPRO";
            }
            case 'Y': {
                return "dHDL";
            }
        }
        return String.valueOf(c);
    }
}

