/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.kermit;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.kermit.InterfaceKermitListener;
import jalis.laboratorio.interfaceamento.padroes.kermit.KermitStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class KermitRecordParser {
    protected static String FIL_CODIGO = "fil_codigo";
    protected static String INT_CODIGO = "int_codigo";
    protected static String REQ_CODIGO = "req_codigo";
    protected static String REC_CODIGO = "rec_codigo";
    protected static String EXA_CODIGO = "exa_codigo";
    protected static String MCO_CODIGO = "mco_codigo";
    protected InterfaceKermitListener equip;

    public KermitRecordParser(InterfaceKermitListener equip) {
        this.equip = equip;
    }

    public void setInterfaceASTMListener(InterfaceKermitListener equip) {
        this.equip = equip;
    }

    public void recordFound(String record) throws Exception {
        record = record.substring(1, record.length() - 1);
        char record_type = KermitStandard.getRecordTypeIdentifier(record);
        switch (record_type) {
            case 'S': {
                this.trataPacketStart(record);
                return;
            }
            case 'F': {
                this.trataPacketFile(record);
                return;
            }
            case 'D': {
                this.trataPacketData(record);
                return;
            }
            case 'Z': {
                this.trataPacketEnd(record);
                return;
            }
        }
    }

    protected void trataPacketEnd(String record) throws Exception {
    }

    protected void trataPacketStart(String record) throws Exception {
    }

    protected void trataPacketFile(String record) throws Exception {
    }

    protected void trataPacketData(String message) throws SQLException {
        try {
            String[] msgExames;
            message = message.substring(2);
            if (message.length() < 50 || !message.substring(49).contains("|")) {
                return;
            }
            String req_codigo = message.substring(25, 40).trim();
            Statement st = Conexao.getStatement();
            if (Funcoes.textoVazio(req_codigo) || req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.equip.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + req_codigo);
                return;
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            req_codigo = req_codigo.substring(0, req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            String resultados = "";
            String mode = message.substring(43, 44);
            resultados = mode.equalsIgnoreCase("0") || mode.equalsIgnoreCase("1") || mode.equalsIgnoreCase("4") || mode.equalsIgnoreCase("5") ? message.substring(49, message.indexOf("|")) : message.substring(50, message.indexOf("|"));
            for (String s : msgExames = resultados.split("}")) {
                if (Funcoes.textoVazio(s)) continue;
                String emi_alternativo = s.substring(0, 1);
                s = s.substring(1);
                if (emi_alternativo.equalsIgnoreCase("#") && s.startsWith("#")) {
                    s = s.substring(1);
                }
                if (s.length() > 9) {
                    s = s.substring(0, 9);
                }
                emi_alternativo = this.trocaAlternativo(emi_alternativo.charAt(0));
                String resultado = "";
                if (s.indexOf("NO RESULT") >= 0) {
                    resultado = "NO RESULT";
                } else if (!s.startsWith(" ")) {
                    resultado = s.substring(s.indexOf(" "));
                    if (Funcoes.textoVazio(resultado)) {
                        resultado = s.substring(0, 9).trim();
                    }
                } else {
                    resultado = s.substring(0, 9);
                }
                String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (int_codigo == null) {
                    String exame;
                    ArrayList<String> exames = BDUtil.getIntDesmExamesPai(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                    Iterator<String> iterator = exames.iterator();
                    while (iterator.hasNext() && (int_codigo = BDUtil.getInterfaceExameTuboRequisicao(fil_codigo, req_codigo, rec_codigo, exame = iterator.next())) == null) {
                    }
                    if (int_codigo == null && !exames.isEmpty()) {
                        int_codigo = BDUtil.getInterfaceExameAlternativo(fil_codigo, req_codigo, rec_codigo, "");
                    }
                }
                if (int_codigo == null) {
                    this.equip.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                int sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
                String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                dados.put(campo, this.arrumaValor(resultado, fil_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo));
                String msg = String.format("Atualizando fil_codigo %s, req_codigo %s, rec_codigo %s, exame.getNomeExame() %s, exame.getCodigoMaterial() %s, situacao  %s ", fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), sit);
                this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
            }
            if (this.equip.getAbaSelecionada() != 2) {
                this.equip.fireAtualizarTabela();
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.equip.fireExcecaoEncontrada("Erro ao realizar parse de dados recebidos do equipamento");
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.equip.fireExcecaoEncontrada("Erro ao realizar parse de dados recebidos do equipamento");
        }
    }

    public String trocaAlternativo(char emi_alternativo) {
        return KermitStandard.trocaAlternativoExame(emi_alternativo);
    }

    protected String arrumaValor(String valor, String fil_codigo, String exa_codigo, String mco_codigo, String int_codigo) {
        if (valor.endsWith(".")) {
            valor = valor + "0";
        }
        if (valor.startsWith(".")) {
            valor = "0" + valor;
        }
        int idxVirgula = valor.indexOf(".");
        String mask = "0";
        if (idxVirgula >= 0 && idxVirgula < 8) {
            mask = "0." + StringUtil.preencheString("", 8 - idxVirgula, '0', 1);
        }
        if (Funcoes.isNumeric(valor)) {
            Double d = Double.valueOf(valor);
            valor = Funcoes.formataDecimal(mask, d);
            valor = valor.replaceAll(",", "\\.");
            valor = this.equip.arrendondaValor(valor, fil_codigo, exa_codigo, mco_codigo, int_codigo);
            valor = valor.replaceAll("\\.", ",");
        }
        return valor;
    }
}

