/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.kermit;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.padroes.kermit.KermitRecordParser;
import jalis.laboratorio.interfaceamento.padroes.kermit.KermitStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.List;
import java.util.Map;

public abstract class InterfaceKermitListener
extends AbstractInterfaceamentoListener {
    protected int MAX_PATIENT_NAME_CHARS = 25;
    protected int TIME_RX_ABORTADO = 3000;
    protected int TIME_TX_ABORTADO = 5000;
    protected int TIME_TX = 15000;
    protected int TIME_RX = 15000;
    protected int TIME_ENQUIRY = 30000;
    protected int TIME_ENQ_ABORTADO = 20000;
    protected int TIME_TO_REFRESH = 2000;
    protected int MAX_TENTATIVAS = 6;
    protected String[] exames;
    protected String ultima_acao = "N";
    protected String int_codigo = "";
    protected String fil_codigo;
    protected String req_codigo;
    protected String mco_codigo;
    protected String rec_codigo;
    protected String pac_nome;
    protected String pac_exames;
    protected String pac_sexo;
    protected String req_idade;
    protected String req_data;
    protected String req_hora;
    protected int tx_counter = 0;
    boolean request_received = false;
    protected MemoryList<String> tx_list = new MemoryList();
    protected MemoryList<String> rx_list = new MemoryList();
    protected static String FIL_CODIGO = "fil_codigo";
    protected static String INT_CODIGO = "int_codigo";
    protected static String REQ_CODIGO = "req_codigo";
    protected static String REC_CODIGO = "rec_codigo";
    protected static String EXA_CODIGO = "exa_codigo";
    protected static String MCO_CODIGO = "mco_codigo";
    protected static String ACTION_CODE = "action_code";
    protected static String REPORT_TYPE = "report_type";
    protected Map<String, Object> exame_atual = null;
    protected KermitRecordParser recordParser;
    protected boolean middleFrame = false;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceKermitListener() {
        KermitRecordParser recordParser;
        this.recordParser = recordParser = new KermitRecordParser(this);
        String dia = Funcoes.formataData("dd", Calendar.getInstance().getTime());
        this.limpaLogArquivos(dia);
    }

    private void limpaLogArquivos(final String dia) {
        File file = new File(System.getProperty("user.home"));
        File[] afile = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.startsWith("VITROS250") && name.endsWith(".log")) {
                    int d = Integer.parseInt(dia);
                    for (int i = 0; i < 5; ++i) {
                        if (d == 0) {
                            d = 31;
                        }
                        if (name.endsWith(String.format("%s.log", Funcoes.preencheZero(d, 2)))) {
                            return false;
                        }
                        --d;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public InterfaceKermitListener(KermitRecordParser recordParser) {
        this.recordParser = recordParser;
    }

    public void setASTMRecordParser(KermitRecordParser recordParser) {
        this.recordParser = recordParser;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            if (this.threadRecebimento.isRecebendoResultado()) {
                return "";
            }
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.blocoChamada(String.format(" Enviando Requisicao fil_codigo %s, int_codigo %s, req_codigo %s, mco_codigo %s, rec_codigo %s, pac_exames %s ", fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames));
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String nome = StringUtil.removerAcentos(pac_nome);
            nome = nome.length() > this.MAX_PATIENT_NAME_CHARS ? nome.substring(0, this.MAX_PATIENT_NAME_CHARS) : Funcoes.preencheVazio(nome, this.MAX_PATIENT_NAME_CHARS, 2);
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo).append(rec_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] desmembrados = (ExameMaterial[])exa_lista.clone();
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            ArrayList<ExameMaterial> temporario = new ArrayList<ExameMaterial>();
            for (ExameMaterial e : alternativos) {
                if (temporario.contains(e)) continue;
                temporario.add(e);
            }
            alternativos = new ExameMaterial[temporario.size()];
            for (int i = 0; i < temporario.size(); ++i) {
                alternativos[i] = (ExameMaterial)temporario.get(i);
            }
            String material = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getNomeExame(), mco_codigo, int_codigo);
            if (material == null) {
                for (ExameMaterial exameMaterial : desmembrados) {
                    List<BDExame> exame;
                    if (!BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exameMaterial.getNomeExame(), String.valueOf(exameMaterial.getCodigo())) || (exame = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exameMaterial.getCodigoMaterial(), rec_codigo)).isEmpty()) continue;
                    material = BDUtil.getExmEquipamentoMaterial(fil_codigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), int_codigo);
                    ExameMaterial[] filhos = new ExameMaterial[exame.size()];
                    int pos = 0;
                    for (BDExame bdExame : exame) {
                        filhos[pos] = new ExameMaterial(bdExame.getExame(), Integer.parseInt(bdExame.getMaterial()));
                        ++pos;
                    }
                    alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, filhos);
                    break;
                }
            }
            int sequencia = 32;
            this.tx_list.add(KermitStandard.getDefaultConfigPacket(sequencia++));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o packet de configura\u00e7\u00e3o de envio");
            }
            this.tx_list.add(KermitStandard.getDefaultFilePacket(sequencia++));
            if (this.tx_list.size() < 1) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o packet do arquivo");
            }
            this.tx_list.add(KermitStandard.getDefaultDataPacket(sequencia++, codigo.toString(), nome, material, alternativos));
            if (this.tx_list.size() < 2) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o packet dos exames");
            }
            this.tx_list.add(KermitStandard.getDefaultEndFilePacket(sequencia++));
            if (this.tx_list.size() < 3) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o packet de final de envio");
            }
            this.tx_list.add(KermitStandard.getDefaultBreakPacket(sequencia++));
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.enviarProximoFrame();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractKermitInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractKermitInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private void blocoChamada(String msg) {
        StackTraceElement[] stack = new Exception().getStackTrace();
        StringBuilder pilha = new StringBuilder(" BLOCO DA CHAMADA \n");
        for (int i = 0; i < stack.length; ++i) {
            pilha.append(String.format("%s(%s)", stack[i].getClassName(), String.valueOf(stack[i].getLineNumber()))).append("\n");
        }
        pilha.append(msg).append("\n");
    }

    protected String obtemExameJaEnviados(String fil_codigo, String req_codigo, String rec_codigo, String pac_exames) {
        System.out.println(String.format("Exames enviando: %s", pac_exames));
        StringBuilder listaExames = new StringBuilder(pac_exames);
        List<Object[]> requisicoes = this.getTodasRequisicaoAba(fil_codigo, req_codigo, Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo()), 1);
        PanelAbaAbstrata aba = this.getAba(1);
        if (!requisicoes.isEmpty()) {
            for (Object[] obj : requisicoes) {
                String exame = (String)obj[aba.getColIndice("Exame")];
                if (listaExames.toString().contains(String.format("%s ", exame))) continue;
                listaExames.append(" ").append(exame);
            }
            System.out.println(String.format("Exames obtidos: %s", listaExames.toString()));
        } else {
            System.out.println(String.format("Nenhum exame localizado em pendentes para a requisi\u00e7\u00e3o %s", req_codigo));
        }
        return listaExames.toString();
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0001');
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\r');
    }

    protected void limpaDadosRequisicao() {
        this.rx_list.clear();
        this.tx_list.clear();
        this.fil_codigo = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
        this.request_received = false;
    }

    protected void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(this.TIME_RX_ABORTADO);
        this.fireMensagemEnviada("Tempo esgotado ao receber dados do equipamento", 1, 10000);
    }

    protected void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(this.TIME_TX_ABORTADO);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    public void encerrarTransmissao() throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            Statement st = Conexao.getStatement();
            for (int i = 0; i < this.exames.length; ++i) {
                int atual = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                int novaSituacao = atual < 2 ? 1 : 3;
                this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, novaSituacao);
                if (BDUtil.isExameDesmembrado(this.fil_codigo, this.int_codigo, this.exames[i], this.mco_codigo)) {
                    BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, novaSituacao);
                }
                this.blocoChamada(String.format("Alterando situa\u00e7\u00e3o do exame %s, Req: %s , sit_atual %s, nova_situacao %s", this.req_codigo, this.exames[i], atual, novaSituacao));
            }
            Conexao.arquivaSQL();
            String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
            this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
        }
        this.interromperTimer();
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.fireAtualizarTabela(0);
        this.limpaDadosRequisicao();
        this.setIdle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fcTimedOut(EventObject e) {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
                return;
            }
            if (this.isRX()) {
                if (this.rx_list.isEmpty()) {
                    this.setIdle();
                    return;
                } else {
                    this.abortarRecepcao();
                }
                return;
            }
            if (!this.isIdle()) return;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: timeout no controle de fluxo");
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    protected void retransmitirRecusado() throws Exception {
        if (this.tx_counter >= this.MAX_TENTATIVAS) {
            this.encerrarTransmissao();
            return;
        }
        int next = this.tx_list.getUltimoLido();
        if (next < this.tx_list.size()) {
            this.setTX(this.TIME_TX);
            this.getPortaCOM().write(this.tx_list.get(next));
        }
        ++this.tx_counter;
    }

    protected void prepararParaReceber() throws Exception {
        this.rx_list.clear();
        this.getPortaCOM().clearInputString();
        this.setRX(this.TIME_ENQUIRY);
        this.fireMensagemEnviada("Aguardando envio de dados pelo equipamento", 0, 10000);
    }

    protected void encerrarRecepcao() {
        this.limpaDadosRequisicao();
        this.getPortaCOM().clearInputString();
        this.setIdle();
    }

    protected void enviarProximoFrame() throws Exception {
        int next;
        this.rx_list.clear();
        int n = next = this.tx_list.getUltimoLido() < 0 ? 0 : this.tx_list.getUltimoLido() + 1;
        if (this.tx_list.size() > 0) {
            String frame = this.tx_list.get(next);
            this.setTX(this.TIME_TX);
            ++this.tx_counter;
            this.getPortaCOM().write(frame);
        } else {
            this.encerrarTransmissao();
        }
    }

    protected void abortarParaReceber() throws Exception {
        this.setRX(this.TIME_ENQ_ABORTADO);
        this.fireMensagemEnviada("Abortando transmiss\u00e3o de dados ao equipamento.", 1, 5000);
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(this.TIME_RX);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 1);
            checksum = message.substring(message.length() - 1);
            termination = message.substring(message.length() - 2, message.length() - 1);
            message = message.substring(0, message.length() - 1);
            if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size() - 1) {
                message = message.substring(3);
                message = this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                this.rx_list.remove(this.rx_list.getUltimoInserido());
                this.middleFrame = false;
            }
            this.rx_list.add(message);
            if (!termination.equalsIgnoreCase("]")) {
                this.middleFrame = true;
                return "";
            }
            this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
            while (!this.rx_list.isEmpty()) {
                String s = this.rx_list.remove(0);
                this.recordParser.recordFound(s);
            }
            Conexao.arquivaSQL();
            RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
            return "";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("")) {
                String msg = null;
                char type = message.charAt(3);
                switch (type) {
                    case 'B': 
                    case 'F': 
                    case 'S': 
                    case 'Z': {
                        msg = KermitStandard.getDefaultAckPacket(message.charAt(2));
                        this.getPortaCOM().write(msg);
                        break;
                    }
                    case 'D': {
                        msg = KermitStandard.getDefaultAckPacket(message.charAt(2));
                        this.getPortaCOM().write(msg);
                        this.addListaRecebimento(message);
                        this.restartThreadRecebimento();
                        break;
                    }
                    case 'Y': {
                        this.tratarAcknowledge();
                        break;
                    }
                    case 'N': {
                        this.tratarNegativeAck();
                    }
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public String reenviarExames(String req_codigo, String rec_codigo, String pac_sexo, String pac_idade, String pac_nome, String hora, String data, String fil_codigo, String int_codigo, ArrayList<ExameMaterial> exames, String acao, String rackposition, String prioridade) {
        System.out.println(String.format("Reenviou exames Req.: %s Exames:%s", req_codigo, exames.get(0).getCodigo().toString()));
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, exames.get(0).getCodigoMaterial(), rec_codigo, exames.get(0).getCodigo().toString(), acao);
    }

    protected void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
            } else {
                this.enviarProximoFrame();
            }
        }
    }

    protected void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            this.verificarNegacao();
        }
    }

    protected void verificarNegacao() throws Exception {
        if (this.isTX()) {
            if (this.tx_list.getUltimoLido() >= 0) {
                this.retransmitirRecusado();
            } else {
                this.abortarTransmissao();
            }
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (!this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        this.threadRecebimento.start();
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();
        private boolean recebendoResultado = false;

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                this.recebendoResultado = true;
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceKermitListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceKermitListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                this.recebendoResultado = false;
                if (InterfaceKermitListener.this.getAbaSelecionada() == 2) {
                    InterfaceKermitListener.this.fireAtualizarTabela();
                }
            }
            catch (InterruptedException e) {
                this.recebendoResultado = false;
                e.printStackTrace();
            }
        }

        public boolean isRecebendoResultado() {
            return this.recebendoResultado;
        }
    }
}

