/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.hl7Socket;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageParser;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageType;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageDsrQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrmO01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrrO02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQckQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQryQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentDsp;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentQak;
import jalis.laboratorio.interfaceamento.padroes.socket.InterfaceSocketListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class InterfaceHl7SocketListener
extends InterfaceSocketListener {
    protected MessageParser messageParser;
    protected Message ultimaMensagemEnviada;
    protected int tentativasEnvio = 0;
    protected Map<String, InfoExameRequisicao> examesEnviadosPorSid;
    protected Map<String, InfoExameRequisicao> examesEnviadosPorMid;
    protected char fieldSeparator = (char)124;
    protected String modelo = "BS380";
    protected String receivingApplication = "Mindray";

    public InterfaceHl7SocketListener(String modelo) {
        this.modelo = modelo;
        this.messageParser = new MessageParser();
        this.examesEnviadosPorSid = new HashMap<String, InfoExameRequisicao>();
        this.examesEnviadosPorMid = new HashMap<String, InfoExameRequisicao>();
    }

    public InterfaceHl7SocketListener(String modelo, String receivingApplication) {
        this.modelo = modelo;
        this.receivingApplication = receivingApplication;
        this.messageParser = new MessageParser();
        this.examesEnviadosPorSid = new HashMap<String, InfoExameRequisicao>();
        this.examesEnviadosPorMid = new HashMap<String, InfoExameRequisicao>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        if (acao.equals("A")) {
            Statement st = Conexao.getStatement();
            try {
                String[] stringArray = exames.split(" ");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String exame;
                    int situacao = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame = stringArray[i], mcoCodigo, recCodigo);
                    this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    protected void alteraSituacaoParaPendentes(InfoExameRequisicao exameRequisicao) {
        try {
            Statement st = Conexao.getStatement();
            if (exameRequisicao != null && exameRequisicao.getExames() != null) {
                for (String exame : exameRequisicao.getExames().split(" ")) {
                    int situacao;
                    String fil_codigo = exameRequisicao.getFilial();
                    String req_codigo = exameRequisicao.getCodigo();
                    String mco_codigo = exameRequisicao.getMaterial();
                    String rec_codigo = exameRequisicao.getRecipiente();
                    String recTuboPai = exameRequisicao.getTuboPai();
                    String int_codigo = exameRequisicao.getInterface();
                    if (recTuboPai != null && exameRequisicao.isCurva().booleanValue()) {
                        recTuboPai = Funcoes.preencheZero(recTuboPai, ParametrosGerais.getDigitosTuboTubo());
                        int_codigo = this.getIntCodigo(fil_codigo, req_codigo, recTuboPai, exame, mco_codigo);
                        situacao = -1;
                        String[] stringArray = exameRequisicao.getExamesFilho().split(" ");
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String exameFilho;
                            situacao = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, recTuboPai, exameFilho = stringArray[i], mco_codigo);
                            BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, exameFilho, mco_codigo, recTuboPai, situacao < 2 ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, recTuboPai);
                        if (BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, recTuboPai)) {
                            this.atualizarSituacaoExame(st, fil_codigo, req_codigo, recTuboPai, exame, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                        }
                    } else {
                        if (int_codigo == null) {
                            int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exame, mco_codigo);
                        }
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, (situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_codigo)) < 2 ? 1 : 3);
                    }
                    this.firePacienteEnviado(exameRequisicao.getCodigo(), exameRequisicao.getNome(), exameRequisicao.getSexo(), exameRequisicao.getIdade(), exameRequisicao.getData(), exameRequisicao.getHora(), exameRequisicao.getExames());
                }
            } else if (exameRequisicao != null) {
                this.fireExcecaoEncontrada("Nenhuma amostra encontrada com o ID " + exameRequisicao.getTuboPai());
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u001c') + String.valueOf('\r');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u000b');
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public String parse(String text) {
        try {
            Message message = this.messageParser.textToMessage(text);
            this.mensagemRecebida(message);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    public synchronized void dataChanged() {
        String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (!Funcoes.textoVazio(message) && this.messageParser.checkMessage(message)) {
            this.parse(message);
            if (this.getPortaCOM().getInputString().length() > 0) {
                this.dataChanged();
            }
        }
    }

    protected void mensagemRecebida(Message message) {
        switch (message.getType()) {
            case ORU_R01: {
                this.messageOruR01Recebida((MessageOruR01)message);
                break;
            }
            case QRY_Q02: {
                this.messageQryQ02Recebida((MessageQryQ02)message);
                break;
            }
            case ACK_Q03: {
                this.messageAckQ03Recebida((MessageAckQ03)message);
                break;
            }
            case ORM_O01: {
                this.messageOrmO01Recebida((MessageOrmO01)message);
                break;
            }
            default: {
                this.fireExcecaoEncontrada("Mensagem de tipo desconhecido recebida");
            }
        }
    }

    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setReceivingApplication(this.receivingApplication);
            mensagem.getMsh().setReceivingFacility(this.modelo);
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setCharacterSet("ASCII");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            this.getPortaCOM().write(this.messageParser.messageToText(mensagem, this.fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    protected void enviaMensagens(List<Message> mensagens) {
        int id = 1;
        for (Message mensagem : mensagens) {
            this.enviaMensagem(String.valueOf(id), mensagem);
            ++id;
        }
    }

    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getObr().getPlacerOrderNumber();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                for (MessageSegmentObx obx : oruR01.getObxList()) {
                    ExameMaterial exame;
                    String emiAlternativo = String.valueOf(obx.getObservationId());
                    String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                    if (intCodigo == null) {
                        this.fireExcecaoEncontrada("Exame n\u00e3o localizado para a interface " + tuboId + " alternativo " + emiAlternativo);
                    }
                    if ((exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo)) != null) {
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        ArrayList<String> flags = new ArrayList<String>();
                        if (obx.getAbnormalFlag() != null) {
                            flags.add(obx.getAbnormalFlag().toString());
                        }
                        int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                        String campo = "resultado_quantitativo";
                        String resultado = "";
                        switch (obx.getValueType()) {
                            case NUMERIC: {
                                campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                                resultado = obx.getObservationValue();
                                resultado = this.arrendondaValor(resultado, filCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, reqCodigo);
                                resultado = resultado.replace('.', ',');
                                break;
                            }
                            case STRING: {
                                campo = sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo";
                                resultado = obx.getObservationValue();
                            }
                        }
                        dados.put(campo, resultado);
                        this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados, flags);
                        continue;
                    }
                    this.fireExcecaoEncontrada("Exame n\u00e3o localizado para a interface " + tuboId + " interface c\u00f3digo" + intCodigo);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            } else {
                this.fireExcecaoEncontrada("Id da amostra inv\u00e1lido." + tuboId);
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
            ackR01.getMsa().setTextMessage("Erro ao receber a mensagem");
            ackR01.getMsa().setErrorCondition(ErrorCondition.APPLICATION_INTERNAL_ERROR);
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    public void messageQryQ02Recebida(MessageQryQ02 qryQ02) {
        block25: {
            String messageId = qryQ02.getMsh().getMessageControlId();
            MessageQckQ02 qckQ02 = new MessageQckQ02();
            qckQ02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
            qckQ02.getMsa().setTextMessage("Mensagem aceita");
            qckQ02.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
            qckQ02.getErr().setErrorCode(0);
            qckQ02.getQak().setQueryTag("SR");
            try {
                String tuboId = qryQ02.getQrd().getWhoSubjectFilter();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    String exames = "";
                    StringBuilder examesFilho = new StringBuilder();
                    if (req != null) {
                        exames = (String)req[aba.getColIndice("Exame")];
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1), aba = this.equipamento.getTab(1), exames, 1)) && req != null) {
                        if (!Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                            exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 1);
                        }
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2), aba = this.equipamento.getTab(2), exames, 2)) && req != null) {
                        if (!Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                            exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 2);
                        }
                    }
                    if (req == null) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        return;
                    }
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String recTuboPai = (String)req[aba.getColIndice("Tubo")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.trim().split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        boolean curva = BDUtil.isExameCurva(filCodigo, intCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            int sitFilho;
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (!(n != 0 && n != 1 || curva)) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            if (curva) {
                                for (ExameMaterial exameFilho : examesFilhos) {
                                    sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recTuboPai, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    String tuboFilho = BDUtil.getExameDesmembradoTubo(filCodigo, reqCodigo, recTuboPai, intCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    if (sitFilho != 0 && sitFilho != 1 && sitFilho != 3 || !Funcoes.preencheZero(tuboFilho, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo)) continue;
                                    examesFilho.append(exameFilho.getNomeExame()).append(" ");
                                    examesParaEnviar.add(exameFilho);
                                }
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<Integer> tests = new HashSet<Integer>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test != null && !test.trim().isEmpty()) {
                            if (!Funcoes.isNumeric(test)) {
                                this.fireExcecaoEncontrada(String.format("Amostra com exame configurado errado %s %s %s Alternativo %s corrija o Alternativo", filCodigo, reqCodigo, recCodigo, test));
                                continue;
                            }
                            tests.add(Integer.valueOf(test));
                            continue;
                        }
                        System.out.println("Exames para enviar sem alternativo: " + exameMaterial.getNomeExame());
                    }
                    if (tests.isEmpty()) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        infoExameRequisicao.setInterface(intCodigo);
                        if (!Funcoes.preencheZero(recTuboPai, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo) && !Funcoes.textoVazio(examesFilho.toString().trim())) {
                            infoExameRequisicao.setTuboPai(recTuboPai);
                            infoExameRequisicao.setExamesFilho(examesFilho.toString().trim());
                            infoExameRequisicao.setCurva(true);
                        }
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        String string = this.getPacienteDataNascimento(filCodigo, reqCodigo);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        MessageDsrQ03 dsrQ03 = new MessageDsrQ03();
                        dsrQ03.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        dsrQ03.getMsa().setTextMessage("Mensagem aceita");
                        dsrQ03.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
                        dsrQ03.getErr().setErrorCode(0);
                        dsrQ03.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        dsrQ03.getQak().setQueryTag("SR");
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp(pacNome));
                        dsrQ03.addDsp(new MessageSegmentDsp(string));
                        dsrQ03.addDsp(new MessageSegmentDsp(pacSexo));
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp(tuboId));
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        String tmp = "";
                        for (Integer test : tests) {
                            tmp = tmp + test + "^^^";
                            dsrQ03.addDsp(new MessageSegmentDsp(test + "^^^"));
                        }
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.enviaMensagem(messageId, dsrQ03);
                    }
                    break block25;
                }
                qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.APPLICATION_REJECT);
                this.enviaMensagem(messageId, qckQ02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    protected String getPacienteDataNascimento(String filial, String requisicao) {
        return "";
    }

    protected String getExames(String filCodigo, String reqCodigo, String recCodigo, Object[] req, PanelAbaAbstrata aba, String exames, int abaSelecionada) {
        if (req != null) {
            exames = exames + " ";
            List<Object[]> reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, abaSelecionada);
            for (Object[] r : reqs) {
                exames = exames + (String)r[aba.getColIndice("Exame")] + " ";
            }
            exames = exames.trim();
        }
        return exames;
    }

    private void messageOrmO01Recebida(MessageOrmO01 ormO01) {
        block17: {
            String messageId = ormO01.getMsh().getMessageControlId();
            MessageOrrO02 orrO02 = new MessageOrrO02();
            try {
                String tuboId = ormO01.getOrc().getFilterOrderNumber();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                        aba = this.equipamento.getTab(1);
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                        aba = this.equipamento.getTab(2);
                    }
                    if (req == null) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        return;
                    }
                    String exames = (String)req[aba.getColIndice("Exame")];
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (n == 0 || n == 1) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test == null || test.trim().isEmpty()) continue;
                        tests.add(test);
                    }
                    if (tests.isEmpty()) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(filCodigo).append(reqCodigo).append("^^^^");
                        Date dataHoraRequisicao = new Date();
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        orrO02.getPid().setId(1);
                        orrO02.getPid().setPatientName("^" + pacNome);
                        orrO02.getPid().setSex(pacSexo);
                        orrO02.getPid().setPatientIdentifierList(stringBuilder.toString());
                        orrO02.getOrc().setOrderControl("AF");
                        orrO02.getOrc().setPlaceOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setPlacerOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setRequestDateTime(dataHoraRequisicao);
                        orrO02.getObr().setCollectorIdentifier("MA");
                        orrO02.getObr().setSpecimenReceiveDateTime(dataHoraRequisicao);
                        orrO02.getObr().setDiagnosticServSect("HM");
                        MessageSegmentObx obx = new MessageSegmentObx();
                        obx.setId(1);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("08001^Take Mode^99MRC");
                        obx.setObservationValue("A");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        obx = new MessageSegmentObx();
                        obx.setId(2);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("08002^Blood Mode^99MRC");
                        obx.setObservationValue("W");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        for (String alternativo : tests) {
                            obx = new MessageSegmentObx();
                            obx.setId(3);
                            obx.setValueType(MessageSegmentObx.ValueType.IS);
                            obx.setObservationId("08003^Test Mode^99MRC");
                            obx.setObservationValue(alternativo);
                            obx.setObserveResultStatus("F");
                            orrO02.addObx(obx);
                        }
                        obx = new MessageSegmentObx();
                        obx.setId(4);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("01002^Ref Group^99MRC");
                        obx.setObservationValue("Geral");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        this.enviaMensagem(messageId, orrO02);
                        this.alteraSituacaoParaPendentes(this.examesEnviadosPorSid.get(tuboId));
                        this.examesEnviadosPorSid.remove(tuboId);
                    }
                    break block17;
                }
                orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                this.enviaMensagem(messageId, orrO02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    protected void messageAckQ03Recebida(MessageAckQ03 ackQ03) {
        if (this.ultimaMensagemEnviada != null && this.ultimaMensagemEnviada.getType() == MessageType.DSR_Q03) {
            MessageDsrQ03 dsrQ03 = (MessageDsrQ03)this.ultimaMensagemEnviada;
            String tuboId = dsrQ03.getDspList().get(20).getDataLine();
            switch (ackQ03.getMsa().getAckCode()) {
                case ACCEPTED: {
                    this.alteraSituacaoParaPendentes(this.examesEnviadosPorSid.get(tuboId));
                    this.examesEnviadosPorSid.remove(tuboId);
                    break;
                }
                case ERROR: 
                case REJECTED: {
                    this.fireExcecaoEncontrada("Erro ao enviar " + dsrQ03.getDspList().get(20));
                }
            }
        }
    }
}

