/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.hl7.remover;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.comunicacao.TimeOutException;
import jalis.laboratorio.interfaceamento.comunicacao.TimedHandshaker;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.padroes.hl7.remover.HL7RecordParser;
import jalis.laboratorio.interfaceamento.padroes.hl7.remover.HL7Standard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public abstract class InterfaceHL7Listener
extends AbstractInterfaceamentoListener {
    protected int MAX_PATIENT_NAME_CHARS = 20;
    protected int TIME_RX_ABORTADO = 3000;
    protected int TIME_TX_ABORTADO = 5000;
    protected int TIME_TX = 15000;
    protected int TIME_RX = 15000;
    protected int TIME_ENQUIRY = 30000;
    protected int TIME_ENQ_ABORTADO = 20000;
    protected int TIME_TO_REFRESH = 2000;
    public static String DELIMITERS = "^&~\\";
    public static String INSTRUMENT_MANUFACTURER = "Mindray";
    public static String INSTRUMENT_MODEL = "BS-200";
    public static String INSTRUMENT_VERSION = "2.3.1";
    protected String PASSWORD = null;
    protected int MAX_TENTATIVAS = 6;
    public final String PRIORIDADE_STAT = "S";
    public final String PRIORIDADE_IN_A_HURRY = "A";
    public final String PRIORIDADE_ROUTINE = "R";
    public final String PRIORIDADE_CALL_BACK = "C";
    public final String PRIORIDADE_PRE_OPERATION = "P";
    public final String ACAO_PENDENTE = "P";
    public final String ACAO_RESERVA_COMPLETA = "L";
    public final String ACAO_EM_ANDAMENTO = "X";
    public final String ACAO_CONTROLE_QUALIDADE = "Q";
    public final String REPORT_TIPO_PEDIDO = "O";
    public final String REPORT_TIPO_CORRECAO = "C";
    public final String REPORT_TIPO_RESULTADO_PRELIMINAR = "P";
    public final String REPORT_TIPO_RESULTADO_FINAL = "F";
    public final String REPORT_TIPO_RESULTADO_IMENSURAVEL = "X";
    public final String REPORT_TIPO_PENDENTE = "I";
    public final String REPORT_TIPO_TESTE_SEM_PEDIDO = "Y";
    public final String REPORT_TIPO_PACIENTE_SEM_RECORD = "Z";
    public final String REPORT_TIPO_RESPOSTA = "Q";
    public final String REQUISICAO_CORRECAO_RESULTADO_ANTERIOR = "C";
    public final String REQUISICAO_RESULTADOS_PRELIMINARES = "P";
    public final String REQUISICAO_RESULTADOS_FINAIS = "F";
    public final String REQUISICAO_RESULTADO_IMENSURAVEL = "X";
    public final String REQUISICAO_PENDENTE = "I";
    public final String REQUISICAO_RESULTADOS_PARCIAIS = "S";
    public final String REQUISICAO_RESULTADO_NIVEL_MIC = "M";
    public final String REQUISICAO_RESULTADO_RETRANSMITIDO = "R";
    public final String REQUISICAO_ABORTAR_ULTIMA_REQUISICAO = "A";
    public final String REQUISICAO_NOVOS_E_EDITADOS = "N";
    public final String REQUISICAO_PEDIDOS_E_DEMOGRAFICOS = "O";
    public final String REQUISICAO_DEMOGRAFICOS_SOMENTE = "D";
    public final String TERMINO_NORMAL = "N";
    public final String TERMINO_TRANSMISSOR_ABORTOU = "T";
    public final String TERMINO_RECEPTOR_REQUISITOU_ABORTO = "R";
    public final String TERMINO_ERRO_DESCONHECIDO = "E";
    public final String TERMINO_ERRO_NO_ULTIMO_PEDIDO = "Q";
    public final String TERMINO_INFORMACAO_INDISPONIVEL = "I";
    public final String TERMINO_FIM_PROCESSAMENTO = "F";
    public final String RESULT_STATUS_CORRECAO = "C";
    public final String RESULT_STATUS_PRELIMINAR = "P";
    public final String RESULT_STATUS_FINAL = "F";
    public final String RESULT_STATUS_IMENSURAVEL = "X";
    public final String RESULT_STATUS_PENDENTE = "I";
    public final String RESULT_STATUS_PARCIAL = "S";
    public final String RESULT_STATUS_NIVEL_MIC = "M";
    public final String RESULT_STATUS_RETRANSMISSAO = "R";
    public final String RESULT_STATUS_NOVO = "N";
    public final String RESULT_STATUS_RESPOSTA_PEDIDO = "Q";
    public final String RESULT_STATUS_VALIDADO_PELO_OPERADOR = "V";
    public final Integer PATIENT_NAME_LAST = new Integer(1);
    public final Integer PATIENT_NAME_FIRST = new Integer(2);
    public final Integer PATIENT_NAME_MIDDLE = new Integer(3);
    public final Integer PATIENT_NAME_SUFFIX = new Integer(4);
    public final Integer PATIENT_NAME_TITLE = new Integer(5);
    public final Integer TEST_ID = new Integer(1);
    public final Integer TEST_NAME = new Integer(2);
    public final Integer TEST_TYPE = new Integer(3);
    public final Integer TEST_ITEM_NUMBER = new Integer(4);
    public final Integer TEST_ITEM_NAME = new Integer(5);
    public final Integer TEST_DILUTION = new Integer(6);
    public final Integer ORDER_SYS_SAMPLE_ID = new Integer(1);
    public final Integer ORDER_SYS_SAMPLE_RACK_POS = new Integer(3);
    public final Integer ORDER_SYS_SAMPLE_RACK_ID = new Integer(2);
    public final int CAMPO_NOME_PRIMEIRO_NOME = 0;
    public final int CAMPO_NOME_SOBRENOME = 1;
    public final int CAMPO_NOME_DO_MEIO = 2;
    public final int CAMPO_NOME_DEFAULT = 0;
    public final int CAMPO_PACIENTE_PATIENT_ID = 0;
    public final int CAMPO_PACIENTE_LABORATORY_PID = 1;
    public final int CAMPO_PACIENTE_SYSTEM_PID = 2;
    public final int CAMPO_PACIENTE_DEFAULT = 1;
    public static final char SB = '\u000b';
    public static final char EB = '\u001c';
    public static final String MSGSTART = String.valueOf('\u000b');
    public static final String MSGEND = String.valueOf('\u001c') + String.valueOf('\r');
    protected String[] exames;
    protected String ultima_acao = "N";
    protected String int_codigo = "";
    protected String fil_codigo;
    protected String req_codigo;
    protected String mco_codigo;
    protected String rec_codigo;
    protected String pac_nome;
    protected String pac_exames;
    protected String pac_sexo;
    protected String req_idade;
    protected String req_data;
    protected String req_hora;
    protected int tx_counter = 0;
    protected int frame_num = 0;
    boolean request_received = false;
    protected MemoryList<String> tx_list = new MemoryList();
    protected MemoryList<String> rx_list = new MemoryList();
    protected static String FIL_CODIGO = "fil_codigo";
    protected static String INT_CODIGO = "int_codigo";
    protected static String REQ_CODIGO = "req_codigo";
    protected static String REC_CODIGO = "rec_codigo";
    protected static String EXA_CODIGO = "exa_codigo";
    protected static String MCO_CODIGO = "mco_codigo";
    protected static String ACTION_CODE = "action_code";
    protected static String REPORT_TYPE = "report_type";
    protected Map<String, Object> exame_atual = null;
    protected HL7RecordParser recordParser;

    public InterfaceHL7Listener() {
    }

    public InterfaceHL7Listener(HL7RecordParser recordParser) {
        this();
        this.recordParser = recordParser;
    }

    public void setHL7RecordParser(HL7RecordParser recordParser) {
        this.recordParser = recordParser;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            String nome = short_name;
            String sobrenome = null;
            this.tx_list.add(HL7Standard.getDefaultHeaderRecord(DELIMITERS, INSTRUMENT_MANUFACTURER, INSTRUMENT_MODEL, "ORU^R01", "1", INSTRUMENT_VERSION, ""));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = req_codigo;
            String laboratory_pid = null;
            this.tx_list.add(HL7Standard.getDefaultPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(HL7Standard.getDefaultOrderRecord(1, codigo.toString(), alternativos, exa_lista, null, "R", acao, tipo_amostra, "O"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(HL7Standard.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractHL7Interfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractHL7Interfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public abstract String getErroTraduzido(String var1);

    public void responderRequest(String starting_range, String ending_range, String test_id) {
    }

    public Map<Integer, String> parsePatientNameField(String name_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(name_field), 4, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.PATIENT_NAME_LAST, tokens[0]);
            components.put(this.PATIENT_NAME_FIRST, tokens[1]);
            components.put(this.PATIENT_NAME_MIDDLE, tokens[2]);
            components.put(this.PATIENT_NAME_SUFFIX, tokens[3]);
            components.put(this.PATIENT_NAME_TITLE, tokens[4]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractHL7Interfaceamento: parse de Patient Name Field (Patient Frame)");
            return null;
        }
    }

    public Map<Integer, String> parseOrderSystemSID(String instrumentSID_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(instrumentSID_field), 2, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.ORDER_SYS_SAMPLE_ID, tokens[0]);
            components.put(this.ORDER_SYS_SAMPLE_RACK_ID, tokens[1]);
            components.put(this.ORDER_SYS_SAMPLE_RACK_POS, tokens[2]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractHL7Interfaceamento: parse de Instrument Specimen ID (Order Frame)");
            return null;
        }
    }

    public Map<Integer, String> parseOrderTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 5, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ID, tokens[0]);
            components.put(this.TEST_NAME, tokens[1]);
            components.put(this.TEST_TYPE, tokens[2]);
            components.put(this.TEST_ITEM_NUMBER, tokens[3]);
            components.put(this.TEST_ITEM_NAME, tokens[4]);
            components.put(this.TEST_DILUTION, tokens[5]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractHL7Interfaceamento: parse de Test ID Field (Order Frame)");
            return null;
        }
    }

    public Map<Integer, String> parseResultTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 5, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ID, tokens[0]);
            components.put(this.TEST_NAME, tokens[1]);
            components.put(this.TEST_TYPE, tokens[2]);
            components.put(this.TEST_ITEM_NUMBER, tokens[3]);
            components.put(this.TEST_ITEM_NAME, tokens[4]);
            components.put(this.TEST_DILUTION, tokens[5]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractHL7Interfaceamento: parse de Test ID Field (Result Frame)");
            return null;
        }
    }

    public String getMiddleFrameEnd() {
        return String.valueOf('\u0017');
    }

    public String getFinalFrameEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return MSGSTART;
    }

    @Override
    public String getMsgEnd() {
        return MSGEND;
    }

    protected int nextFrameNum() {
        return ++this.frame_num % 8;
    }

    public MemoryList<String> makeFrames(MemoryList<String> raw_list) throws Exception {
        try {
            MemoryList<String> new_list = new MemoryList<String>();
            this.frame_num = 0;
            if (raw_list != null) {
                while (!raw_list.isEmpty() && raw_list.size() > 0) {
                    String[] slices = StringUtil.dividir(raw_list.remove(0), 240);
                    for (int j = 0; j < slices.length; ++j) {
                        StringBuilder temp = new StringBuilder(String.valueOf(this.nextFrameNum()));
                        temp.append(slices[j]);
                        temp.append(j < slices.length - 1 ? String.valueOf('\u0017') : String.valueOf('\u0003'));
                        temp.append(Checksum.getChecksumMod256(temp.toString()));
                        temp = new StringBuilder(this.getMsgStart()).append((CharSequence)temp);
                        temp.append(this.getMsgEnd());
                        new_list.add(temp.toString());
                    }
                }
                return new_list;
            }
            return null;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Erro ao recuperar lista de frames (size:" + raw_list.size() + ")");
            return null;
        }
    }

    public boolean checkCRC(String message, String checksum) {
        return true;
    }

    protected void limpaDadosRequisicao() {
        this.rx_list.clear();
        this.tx_list.clear();
        this.fil_codigo = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
        this.request_received = false;
    }

    protected void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(this.TIME_RX_ABORTADO);
        this.fireMensagemEnviada("Tempo esgotado ao receber dados do equipamento", 1, 10000);
    }

    protected void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(this.TIME_TX_ABORTADO);
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    protected void encerrarTransmissao() throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            Statement st = Conexao.getStatement();
            for (int i = 0; i < this.exames.length; ++i) {
                int atual = 1;
                if (atual < 2 || !BDUtil.isExameDesmembrado(this.fil_codigo, this.int_codigo, this.exames[i], this.mco_codigo)) continue;
                BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, 3);
            }
            Conexao.arquivaSQL();
            String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
            this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
        }
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.getPortaCOM().clearInputString();
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.fireAtualizarTabela(0);
        this.limpaDadosRequisicao();
        this.setIdle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fcTimedOut(EventObject e) {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
                return;
            }
            if (this.isRX()) {
                if (this.rx_list.isEmpty()) {
                    this.setIdle();
                    return;
                } else {
                    this.abortarRecepcao();
                }
                return;
            }
            if (!this.isIdle()) return;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractHL7Interfaceamento: timeout no controle de fluxo");
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    protected void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            this.verificarNegacao();
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    protected void retransmitirRecusado() throws Exception {
        if (this.tx_counter >= this.MAX_TENTATIVAS) {
            this.encerrarTransmissao();
            return;
        }
        int next = this.tx_list.getUltimoLido();
        if (next < this.tx_list.size()) {
            this.setTX(this.TIME_TX);
            this.getPortaCOM().write(this.tx_list.get(next));
        }
        ++this.tx_counter;
    }

    protected void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
            } else {
                this.enviarProximoFrame();
            }
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    protected void tratarEnquiry() throws Exception {
        if (this.isTX()) {
            this.abortarParaReceber();
        } else if (!this.isRX()) {
            this.prepararParaReceber();
        } else {
            this.prepararParaReceber();
        }
    }

    protected void prepararParaReceber() throws Exception {
        this.rx_list.clear();
        this.getPortaCOM().clearInputString();
        this.setRX(this.TIME_ENQUIRY);
        this.fireMensagemEnviada("Aguardando envio de dados pelo equipamento", 0, 10000);
        this.getPortaCOM().write(String.valueOf('\u0006'));
    }

    protected void tratarEndOfTX() throws Exception {
        if (this.isTX()) {
            if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
            } else {
                this.enviarProximoFrame();
            }
        } else {
            this.encerrarRecepcao();
        }
    }

    protected void encerrarRecepcao() {
        this.limpaDadosRequisicao();
        this.getPortaCOM().clearInputString();
        this.setIdle();
    }

    protected void enviarProximoFrame() throws Exception {
        int next;
        this.rx_list.clear();
        int n = next = this.tx_list.getUltimoLido() < 0 ? 0 : this.tx_list.getUltimoLido() + 1;
        if (this.tx_list.size() > 0) {
            String frame = this.tx_list.get(next);
            this.setTX(this.TIME_TX);
            ++this.tx_counter;
            System.out.print("Write:");
            System.out.println(frame);
            this.getPortaCOM().write(frame);
        } else {
            this.encerrarTransmissao();
        }
    }

    protected void verificarNegacao() throws Exception {
        if (this.isTX()) {
            if (this.tx_list.getUltimoLido() >= 0) {
                this.retransmitirRecusado();
            } else {
                this.abortarTransmissao();
            }
        } else if (this.isRX()) {
            this.caracterNaoEsperado();
        }
    }

    protected void abortarParaReceber() throws Exception {
        this.setRX(this.TIME_ENQ_ABORTADO);
        this.fireMensagemEnviada("Abortando transmiss\u00e3o de dados ao equipamento.", 1, 5000);
    }

    protected void caracterNaoEsperado() throws Exception {
    }

    @Override
    public void handShakeCharReceived(final char c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    switch (c) {
                        case '\u0005': {
                            if (InterfaceHL7Listener.this.isTX() || InterfaceHL7Listener.this.tx_list.size() > 0) {
                                InterfaceHL7Listener.this.getPortaCOM().write(String.valueOf('\u0015'));
                                break;
                            }
                            InterfaceHL7Listener.this.tratarEnquiry();
                            break;
                        }
                        case '\u0006': {
                            InterfaceHL7Listener.this.tratarAcknowledge();
                            break;
                        }
                        case '\u0015': {
                            InterfaceHL7Listener.this.tratarNegativeAck();
                            break;
                        }
                        case '\u0004': {
                            InterfaceHL7Listener.this.tratarEndOfTX();
                            break;
                        }
                        default: {
                            InterfaceHL7Listener.this.caracterNaoEsperado();
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractHL7Interfaceamento: evento de caracter de handshake recebido");
                    InterfaceHL7Listener.this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
                    InterfaceHL7Listener.this.setIdle();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(this.TIME_RX);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    public void sendRequestAllResultsRecord() throws Exception {
        TimedHandshaker h = new TimedHandshaker();
        this.getClass();
        String record = HL7Standard.getDefaultEnquiryRecord("ALL", null, "ALL", null, null, "F");
        this.setTX(this.TIME_TX);
        try {
            char c = h.sendAndWaitResponse(String.valueOf('\u0005'), this.TIME_TX);
            if (c != '\u0006') {
                this.interromperTimer();
                this.fireMensagemEnviada("Requisi\u00e7\u00e3o de resultados negada pelo equipamento", 1, 5000);
                return;
            }
            c = h.sendAndWaitResponse(record, this.TIME_TX);
            if (c != '\u0006') {
                this.interromperTimer();
                this.fireMensagemEnviada("Requisi\u00e7\u00e3o de resultados negada pelo equipamento", 1, 5000);
                return;
            }
            this.getPortaCOM().write(String.valueOf('\u0004'));
        }
        catch (TimeOutException ex) {
            this.fireMensagemEnviada("Tempo esgotado ao requisitar resultados ao equipamento", 1, 5000);
        }
        this.interromperTimer();
        this.setIdle();
    }

    @Override
    public String parse(String message) {
        try {
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            String[] msg = message.split(String.valueOf('\r'));
            String retorno = "";
            String msgType = HL7Standard.getMessageType(msg[0]);
            if (msgType.equalsIgnoreCase("QRY^Q02")) {
                retorno = this.recordParser.getResponseRequest(msg[0]);
                ((PortaSocketServer)this.getPortaCOM()).write(retorno);
            }
            for (String s : msg) {
                this.recordParser.recordFound(s);
            }
            retorno = this.recordParser.getMessageReturn();
            Conexao.arquivaSQL();
            RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
            return retorno;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractHL7Interfaceamento: parse");
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractHL7Interfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = InterfaceHL7Listener.this.getPortaCOM().removeInputString(InterfaceHL7Listener.this.getMsgEnd());
                    if (!message.equals("")) {
                        String retorno = InterfaceHL7Listener.this.parse(message);
                        ((PortaSocketServer)InterfaceHL7Listener.this.getPortaCOM()).write(retorno);
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractHL7Interfaceamento: evento de dados recebidos");
                    InterfaceHL7Listener.this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public String reenviarExames(String req_codigo, String rec_codigo, String pac_sexo, String pac_idade, String pac_nome, String hora, String data, String fil_codigo, String int_codigo, ArrayList<ExameMaterial> exames, String acao, String rackposition, String prioridade) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, exames.get(0).getCodigoMaterial(), rec_codigo, exames.get(0).getCodigo().toString(), acao);
    }
}

