/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.hl7.remover;

import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;

public class HL7Standard {
    public static int HEADER_RECORD_FIELDS_NUMBER = 14;
    public static int PATIENT_RECORD_FIELDS_NUMBER = 35;
    public static int ORDER_RECORD_FIELDS_NUMBER = 31;
    public static int RESULT_RECORD_FIELDS_NUMBER = 14;
    public static int COMMENT_RECORD_FIELDS_NUMBER = 5;
    public static int REQUEST_RECORD_FIELDS_NUMBER = 13;
    public static int TERMINATION_RECORD_FIELDS_NUMBER = 3;
    public static int MANUFACTURER_RECORD_FIELDS_NUMBER = 3;
    public static Integer RECORD_TYPE = new Integer(1);
    public static Integer SEQUENCE_NUMBER = new Integer(2);
    public static Integer HEADER_FIELD_RECORD_ID = new Integer(1);
    public static Integer HEADER_FIELD_MESSAGE_TYPE = new Integer(9);
    public static Integer HEADER_FIELD_MESSAGE_CONTROL_ID = new Integer(10);
    public static Integer PATIENT_FIELD_RECORD_ID = new Integer(1);
    public static Integer PATIENT_FIELD_SEQUENCE = new Integer(2);
    public static Integer PATIENT_FIELD_PATIENT_ID = new Integer(3);
    public static Integer PATIENT_FIELD_LABORATORY_PID = new Integer(4);
    public static Integer PATIENT_FIELD_SYSTEM_PID = new Integer(5);
    public static Integer PATIENT_FIELD_NAME = new Integer(6);
    public static Integer PATIENT_FIELD_MAIDEN_NAME = new Integer(7);
    public static Integer PATIENT_FIELD_BIRTHDATE = new Integer(8);
    public static Integer PATIENT_FIELD_SEX = new Integer(9);
    public static Integer PATIENT_FIELD_RACE = new Integer(10);
    public static Integer PATIENT_FIELD_ADDRESS = new Integer(11);
    public static Integer PATIENT_FIELD_RESERVED = new Integer(12);
    public static Integer PATIENT_FIELD_PHONE = new Integer(13);
    public static Integer PATIENT_FIELD_DOCTOR = new Integer(14);
    public static Integer PATIENT_FIELD_SPECIAL1 = new Integer(15);
    public static Integer PATIENT_FIELD_SPECIAL2 = new Integer(16);
    public static Integer PATIENT_FIELD_HEIGHT = new Integer(17);
    public static Integer PATIENT_FIELD_WEIGHT = new Integer(18);
    public static Integer PATIENT_FIELD_DIAGNOSIS = new Integer(19);
    public static Integer PATIENT_FIELD_MEDICATIONS = new Integer(20);
    public static Integer PATIENT_FIELD_DIET = new Integer(21);
    public static Integer PATIENT_FIELD_PRACTICE1 = new Integer(22);
    public static Integer PATIENT_FIELD_PRACTICE2 = new Integer(23);
    public static Integer PATIENT_FIELD_DATE_IN_HOSPITAL = new Integer(24);
    public static Integer PATIENT_FIELD_ADMISSION_STATUS = new Integer(25);
    public static Integer PATIENT_FIELD_LOCATION = new Integer(26);
    public static Integer PATIENT_FIELD_ALTERNATIVE_DIAGNOSTIC_CODES = new Integer(27);
    public static Integer PATIENT_FIELD_DIAGNOSTIC_CODES = new Integer(28);
    public static Integer PATIENT_FIELD_RELIGION = new Integer(29);
    public static Integer PATIENT_FIELD_MARITAL_STATUS = new Integer(30);
    public static Integer PATIENT_FIELD_ISOLATION_STATUS = new Integer(31);
    public static Integer PATIENT_FIELD_LANGUAGE = new Integer(32);
    public static Integer PATIENT_FIELD_HOSPITAL_SERVICE = new Integer(33);
    public static Integer PATIENT_FIELD_HOSPITAL_INSTITUTION = new Integer(34);
    public static Integer PATIENT_FIELD_DOSAGE_CATEGORY = new Integer(35);
    public static Integer ORDER_FIELD_RECORD_ID = new Integer(1);
    public static Integer ORDER_FIELD_SAMPLE_ID = new Integer(3);
    public static Integer RESULT_FIELD_RECORD_ID = new Integer(0);
    public static Integer RESULT_FIELD_SEQUENCE_ID = new Integer(1);
    public static Integer RESULT_FIELD_VALUE_TYPE = new Integer(2);
    public static Integer RESULT_FIELD_TEST_ID = new Integer(3);
    public static Integer RESULT_FIELD_TEST_SUB_ID = new Integer(4);
    public static Integer RESULT_FIELD_OBSERVATION_VALUE = new Integer(5);
    public static Integer RESULT_FIELD_UNITS = new Integer(6);
    public static Integer RESULT_FIELD_REFERENCE_RANGES = new Integer(7);
    public static Integer RESULT_FIELD_ABNORMAL_FLAGS = new Integer(8);
    public static Integer RESULT_FIELD_PROBABILITY = new Integer(9);
    public static Integer RESULT_FIELD_NATURE_ABNORMAL_FLAGS = new Integer(10);
    public static Integer RESULT_FIELD_OBSERVE_RESULT_STATUS = new Integer(11);
    public static Integer RESULT_FIELD_DATA_LAST_OBSERVE_NORMAL_VALUES = new Integer(12);
    public static Integer RESULT_FIELD_USER_DEFINED_ACCESS_CHECKS = new Integer(13);
    public static Integer RESULT_FIELD_DATE_TIME_OBSERVATION = new Integer(14);
    public static Integer RESULT_FIELD_PRODUCERS_ID = new Integer(15);
    public static Integer RESULT_FIELD_RESPONSIBLE_OBSERVER = new Integer(16);
    public static Integer RESULT_FIELD_OBSERVATION_METHOD = new Integer(17);
    public static Integer COMMENT_FIELD_RECORD_ID = new Integer(1);
    public static Integer COMMENT_FIELD_SEQUENCE = new Integer(2);
    public static Integer COMMENT_FIELD_SOURCE = new Integer(3);
    public static Integer COMMENT_FIELD_TEXT = new Integer(4);
    public static Integer COMMENT_FIELD_TYPE = new Integer(5);
    public static Integer REQUEST_FIELD_RECORD_ID = new Integer(0);
    public static Integer REQUEST_FIELD_SAMPLE_ID = new Integer(9);
    public static Integer TERMINATION_FIELD_RECORD_ID = new Integer(1);
    public static Integer TERMINATION_FIELD_SEQUENCE = new Integer(2);
    public static Integer TERMINATION_FIELD_CODE = new Integer(3);
    public static String RECORD_TYPE_HEADER = "MSH";
    public static String RECORD_TYPE_PATIENT = "PID";
    public static String RECORD_TYPE_ORDER = "OBR";
    public static String RECORD_TYPE_REQUEST = "QRD";
    public static String RECORD_TYPE_RESULT = "OBX";
    public static String RECORD_TYPE_COMMENT = "C";
    public static String RECORD_TYPE_MANUFACTURER = "C";
    public static String RECORD_TYPE_TERMINATION = "L";
    public static String CR = String.valueOf('\r');

    public static String getDefaultHeaderRecord(String encodingCharacters, String sendingApplication, String sendingFamily, String messageType, String messageControlId, String versionApplication, String type) {
        StringBuilder record = new StringBuilder("MSH|");
        record.append(encodingCharacters);
        record.append("|");
        record.append(sendingApplication);
        record.append("|");
        record.append(sendingFamily);
        record.append("|||");
        record.append(HL7Standard.getCurrentMoment());
        record.append("||");
        record.append(messageType);
        record.append("|");
        record.append(messageControlId);
        record.append("|P|");
        record.append(versionApplication);
        record.append("||||");
        record.append(type);
        record.append("||ASCII|||");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String pac_nome, String pac_sobrenome, String pac_sexo) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|");
        record.append(laboratory_pid == null ? "" : laboratory_pid);
        record.append("||");
        record.append(pac_sobrenome == null ? "" : pac_sobrenome);
        record.append(pac_nome == null ? "" : "^" + pac_nome);
        record.append("|||");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultOrderRecord(int order_sequence, String sample_id, String test_item_number, String test_item_name, String dilution, String priority, String action_code, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("||");
        if (test_item_number != null) {
            record.append("^^^");
            record.append(test_item_number);
            record.append(test_item_name == null ? "" : "^" + test_item_name);
            record.append(dilution == null ? "" : "^" + dilution);
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("||||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultOrderRecord(int order_sequence, String sample_id, ExameMaterial[] test_item_numbers, ExameMaterial[] test_item_names, String dilution, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("||");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^");
            record.append(test_item_numbers[0].getNomeExame());
            record.append(test_item_names == null || test_item_names[0] == null ? "" : "^" + test_item_names[0].getNomeExame());
            record.append(dilution == null ? "" : "^" + dilution);
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                record.append("\\^^^");
                record.append(test_item_numbers[i].getNomeExame());
                record.append(test_item_names == null || test_item_names[i] == null ? "" : "^" + test_item_names[i].getNomeExame());
                record.append(dilution == null ? "" : "^" + dilution);
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("||||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||");
        record.append(sample_type == null ? "" : sample_type);
        record.append("||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultOrderRecord(int order_sequence, String sample_id, String sample_id_type, ExameMaterial[] test_item_numbers, ExameMaterial[] test_item_names, String dilution, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("|");
        record.append(sample_id_type == null ? "" : sample_id_type);
        record.append("|");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^");
            record.append(test_item_numbers[0].getNomeExame());
            record.append(test_item_names == null || test_item_names[0] == null ? "" : "^" + test_item_names[0].getNomeExame());
            record.append(dilution == null ? "" : "^" + dilution);
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                record.append("\\^^^");
                record.append(test_item_numbers[i].getNomeExame());
                record.append(test_item_names == null || test_item_names[i] == null ? "" : "^" + test_item_names[i].getNomeExame());
                record.append(dilution == null ? "" : "^" + dilution);
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("||||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||");
        record.append(sample_type == null ? "" : sample_type);
        record.append("||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultEnquiryRecord(String patient_id, String sample_id, String test_item_id, String test_item_name, String request_time_range, String request_code) {
        StringBuilder record = new StringBuilder("Q|1|");
        record.append(patient_id == null ? "" : patient_id);
        record.append(sample_id == null ? "" : "^" + sample_id);
        record.append("||");
        record.append(test_item_id == null ? "" : (test_item_id.toUpperCase().equals("ALL") ? test_item_id : "^^^" + test_item_id));
        record.append(test_item_name == null ? "" : "^" + test_item_name);
        record.append("|");
        record.append(request_time_range == null ? "" : request_time_range);
        record.append("|||||||");
        record.append(request_code == null ? "" : request_code);
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultTerminationRecord(String termination_code) {
        StringBuilder record = new StringBuilder("L|1|");
        record.append(termination_code == null ? "" : termination_code);
        record.append("|");
        record.append(CR);
        return record.toString();
    }

    public static String getDefaultCommentRecord(String crc) {
        StringBuilder record = new StringBuilder("C|1|I|");
        record.append("CRC:&X" + crc + "&");
        record.append("|G");
        record.append(CR);
        return record.toString();
    }

    public static String removeCR(String record) {
        if (record.endsWith(CR)) {
            record = record.substring(0, record.length() - 1);
        }
        return record;
    }

    public static String fillRecordFields(String record, int fields_number) {
        StringBuilder temp = new StringBuilder(record);
        for (int n = StringUtil.contaOcorrencias(new StringBuilder(record), '|'); n < fields_number - 1; ++n) {
            temp.append("|");
        }
        return temp.toString();
    }

    public static String[] tokenizeRecordFields(String record, int fields_number) {
        String[] temp = record.split("[|]");
        String[] tokens = new String[fields_number];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = i < temp.length ? temp[i] : "";
        }
        return tokens;
    }

    public static LinkedList splitMessage(String message) {
        LinkedList<String> message_records = new LinkedList<String>();
        String[] records = message.split(String.valueOf(CR));
        for (int i = 0; i < records.length; ++i) {
            message_records.addLast(records[i]);
        }
        return message_records;
    }

    public static Hashtable parseDefaultHeaderRecord(String record) {
        try {
            record = HL7Standard.removeCR(record);
            String[] tokens = record.split("\\|");
            Hashtable<Integer, String> header_fields = new Hashtable<Integer, String>();
            header_fields.put(RECORD_TYPE, tokens[0]);
            header_fields.put(HEADER_FIELD_MESSAGE_TYPE, tokens[8]);
            header_fields.put(HEADER_FIELD_MESSAGE_CONTROL_ID, tokens[9]);
            return header_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static Hashtable parseDefaultPatientRecord(String record) {
        try {
            record = HL7Standard.removeCR(record);
            record = HL7Standard.fillRecordFields(record, PATIENT_RECORD_FIELDS_NUMBER);
            String[] tokens = HL7Standard.tokenizeRecordFields(record, PATIENT_RECORD_FIELDS_NUMBER);
            Hashtable<Integer, String> patient_fields = new Hashtable<Integer, String>();
            patient_fields.put(RECORD_TYPE, tokens[0]);
            patient_fields.put(SEQUENCE_NUMBER, tokens[1]);
            patient_fields.put(PATIENT_FIELD_PATIENT_ID, tokens[2]);
            patient_fields.put(PATIENT_FIELD_LABORATORY_PID, tokens[3]);
            patient_fields.put(PATIENT_FIELD_SYSTEM_PID, tokens[4]);
            patient_fields.put(PATIENT_FIELD_NAME, tokens[5]);
            patient_fields.put(PATIENT_FIELD_MAIDEN_NAME, tokens[6]);
            patient_fields.put(PATIENT_FIELD_BIRTHDATE, tokens[7]);
            patient_fields.put(PATIENT_FIELD_SEX, tokens[8]);
            patient_fields.put(PATIENT_FIELD_RACE, tokens[9]);
            patient_fields.put(PATIENT_FIELD_ADDRESS, tokens[10]);
            patient_fields.put(PATIENT_FIELD_RESERVED, tokens[11]);
            patient_fields.put(PATIENT_FIELD_PHONE, tokens[12]);
            patient_fields.put(PATIENT_FIELD_DOCTOR, tokens[13]);
            patient_fields.put(PATIENT_FIELD_SPECIAL1, tokens[14]);
            patient_fields.put(PATIENT_FIELD_SPECIAL2, tokens[15]);
            patient_fields.put(PATIENT_FIELD_HEIGHT, tokens[16]);
            patient_fields.put(PATIENT_FIELD_WEIGHT, tokens[17]);
            patient_fields.put(PATIENT_FIELD_DIAGNOSIS, tokens[18]);
            patient_fields.put(PATIENT_FIELD_MEDICATIONS, tokens[19]);
            patient_fields.put(PATIENT_FIELD_DIET, tokens[20]);
            patient_fields.put(PATIENT_FIELD_PRACTICE1, tokens[21]);
            patient_fields.put(PATIENT_FIELD_PRACTICE2, tokens[22]);
            patient_fields.put(PATIENT_FIELD_DATE_IN_HOSPITAL, tokens[23]);
            patient_fields.put(PATIENT_FIELD_ADMISSION_STATUS, tokens[24]);
            patient_fields.put(PATIENT_FIELD_LOCATION, tokens[25]);
            patient_fields.put(PATIENT_FIELD_ALTERNATIVE_DIAGNOSTIC_CODES, tokens[26]);
            patient_fields.put(PATIENT_FIELD_DIAGNOSTIC_CODES, tokens[27]);
            patient_fields.put(PATIENT_FIELD_RELIGION, tokens[28]);
            patient_fields.put(PATIENT_FIELD_MARITAL_STATUS, tokens[29]);
            patient_fields.put(PATIENT_FIELD_ISOLATION_STATUS, tokens[30]);
            patient_fields.put(PATIENT_FIELD_LANGUAGE, tokens[31]);
            patient_fields.put(PATIENT_FIELD_HOSPITAL_SERVICE, tokens[32]);
            patient_fields.put(PATIENT_FIELD_HOSPITAL_INSTITUTION, tokens[33]);
            patient_fields.put(PATIENT_FIELD_DOSAGE_CATEGORY, tokens[34]);
            return patient_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static Hashtable<Integer, String> parseDefaultOrderRecord(String record) {
        try {
            record = HL7Standard.removeCR(record);
            String[] tokens = record.split("\\|");
            Hashtable<Integer, String> order_fields = new Hashtable<Integer, String>();
            order_fields.put(ORDER_FIELD_RECORD_ID, tokens[0]);
            order_fields.put(ORDER_FIELD_SAMPLE_ID, tokens[2]);
            return order_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static Hashtable parseDefaultResultRecord(String record) {
        try {
            record = HL7Standard.removeCR(record);
            String[] tokens = record.split("\\|");
            Hashtable<Integer, String> result_fields = new Hashtable<Integer, String>();
            result_fields.put(RESULT_FIELD_RECORD_ID, tokens[0]);
            result_fields.put(RESULT_FIELD_SEQUENCE_ID, tokens[1]);
            result_fields.put(RESULT_FIELD_VALUE_TYPE, tokens[2]);
            result_fields.put(RESULT_FIELD_TEST_ID, tokens[3]);
            result_fields.put(RESULT_FIELD_TEST_SUB_ID, tokens[4]);
            result_fields.put(RESULT_FIELD_OBSERVATION_VALUE, tokens[5]);
            result_fields.put(RESULT_FIELD_UNITS, tokens[6]);
            result_fields.put(RESULT_FIELD_REFERENCE_RANGES, tokens[7]);
            result_fields.put(RESULT_FIELD_ABNORMAL_FLAGS, tokens[8]);
            result_fields.put(RESULT_FIELD_PROBABILITY, tokens[9]);
            result_fields.put(RESULT_FIELD_NATURE_ABNORMAL_FLAGS, tokens[10]);
            result_fields.put(RESULT_FIELD_OBSERVE_RESULT_STATUS, tokens[11]);
            result_fields.put(RESULT_FIELD_DATA_LAST_OBSERVE_NORMAL_VALUES, tokens[12]);
            result_fields.put(RESULT_FIELD_USER_DEFINED_ACCESS_CHECKS, tokens[13]);
            result_fields.put(RESULT_FIELD_DATE_TIME_OBSERVATION, tokens[14]);
            result_fields.put(RESULT_FIELD_PRODUCERS_ID, tokens[15]);
            result_fields.put(RESULT_FIELD_RESPONSIBLE_OBSERVER, tokens[16]);
            return result_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static Hashtable parseDefaultCommentRecord(String record) {
        try {
            record = HL7Standard.removeCR(record);
            record = HL7Standard.fillRecordFields(record, COMMENT_RECORD_FIELDS_NUMBER);
            String[] tokens = HL7Standard.tokenizeRecordFields(record, COMMENT_RECORD_FIELDS_NUMBER);
            Hashtable<Integer, String> comment_fields = new Hashtable<Integer, String>();
            comment_fields.put(RECORD_TYPE, tokens[0]);
            comment_fields.put(SEQUENCE_NUMBER, tokens[1]);
            comment_fields.put(COMMENT_FIELD_SOURCE, tokens[2]);
            comment_fields.put(COMMENT_FIELD_TEXT, tokens[3]);
            comment_fields.put(COMMENT_FIELD_TYPE, tokens[4]);
            return comment_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static Hashtable parseDefaultRequestRecord(String record) {
        try {
            String[] tokens = record.split("\\|");
            Hashtable<Integer, String> request_fields = new Hashtable<Integer, String>();
            request_fields.put(REQUEST_FIELD_RECORD_ID, tokens[0]);
            request_fields.put(REQUEST_FIELD_SAMPLE_ID, tokens[9]);
            return request_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static Hashtable parseDefaultTerminationRecord(String record) {
        try {
            record = HL7Standard.removeCR(record);
            record = HL7Standard.fillRecordFields(record, TERMINATION_RECORD_FIELDS_NUMBER);
            String[] tokens = HL7Standard.tokenizeRecordFields(record, TERMINATION_RECORD_FIELDS_NUMBER);
            Hashtable<Integer, String> termination_fields = new Hashtable<Integer, String>();
            termination_fields.put(RECORD_TYPE, tokens[0]);
            termination_fields.put(SEQUENCE_NUMBER, tokens[1]);
            termination_fields.put(TERMINATION_FIELD_CODE, tokens[2]);
            return termination_fields;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    public static String readFirstRecordInMessage(String message) {
        if (message != null && !message.equals("")) {
            int record_end = message.indexOf(CR);
            if (record_end > 0) {
                return message.substring(0, record_end + 1);
            }
            return null;
        }
        return null;
    }

    public static String[] removeFirstRecordInMessage(String message) {
        if (message != null && !message.equals("")) {
            int record_end = message.indexOf(CR);
            if (record_end > 0) {
                String[] record_and_message = new String[]{message.substring(0, record_end + 1), record_end + 1 < message.length() ? message.substring(record_end + 1) : null};
                return record_and_message;
            }
            return new String[]{null, null};
        }
        return new String[]{null, null};
    }

    public static String getRecordTypeIdentifier(String record) {
        if (record != null && !record.equals("")) {
            String[] pars = record.split("\\|");
            return pars[0];
        }
        return null;
    }

    public static String getMessageType(String record) {
        if (record != null && !record.equals("")) {
            String[] pars = record.split("\\|");
            return pars[8];
        }
        return null;
    }

    public static String getCurrentMoment() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis()));
    }
}

