/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.hl7.remover;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ResolvedorResultado;
import jalis.laboratorio.interfaceamento.padroes.hl7.remover.HL7Standard;
import jalis.laboratorio.interfaceamento.padroes.hl7.remover.InterfaceHL7Listener;
import jalis.util.Funcoes;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class HL7RecordParser {
    protected static String FIL_CODIGO = "fil_codigo";
    protected static String INT_CODIGO = "int_codigo";
    protected static String REQ_CODIGO = "req_codigo";
    protected static String REC_CODIGO = "rec_codigo";
    protected static String EXA_CODIGO = "exa_codigo";
    protected static String MCO_CODIGO = "mco_codigo";
    protected static String ACTION_CODE = "action_code";
    protected static String REPORT_TYPE = "report_type";
    protected static String MESSAGE_TYPE = "message_type";
    protected static String MESSAGE_CONTROL_ID = "message_control_id";
    protected Map<String, Object> exame_atual = null;
    protected InterfaceHL7Listener equip;

    public HL7RecordParser(InterfaceHL7Listener equip) {
        this.equip = equip;
    }

    public HL7RecordParser() {
    }

    public String getMessageReturn() {
        StringBuilder m = new StringBuilder();
        m.append(this.equip.getMsgStart());
        m.append(HL7Standard.getDefaultHeaderRecord(InterfaceHL7Listener.DELIMITERS, InterfaceHL7Listener.INSTRUMENT_MANUFACTURER, InterfaceHL7Listener.INSTRUMENT_MODEL, "ACK^R01", this.exame_atual.get(MESSAGE_CONTROL_ID) != null ? String.valueOf(this.exame_atual.get(MESSAGE_CONTROL_ID)) : "", InterfaceHL7Listener.INSTRUMENT_VERSION, "0"));
        m.append("MSA|AA|").append(String.valueOf(this.exame_atual.get(MESSAGE_CONTROL_ID))).append("|Message accepted|||0|");
        m.append(this.equip.getMsgEnd());
        return m.toString();
    }

    public void setInterfaceHL7Listener(InterfaceHL7Listener equip) {
        this.equip = equip;
    }

    public void recordFound(String record) throws Exception {
        String record_type = HL7Standard.getRecordTypeIdentifier(record);
        if (record_type != null) {
            if (record_type.equals(HL7Standard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(HL7Standard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(HL7Standard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(HL7Standard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(HL7Standard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(HL7Standard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(HL7Standard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    protected void trataTerminationRecord() throws Exception {
        if (this.exame_atual == null) {
            return;
        }
        this.salvaExame(this.exame_atual);
        this.exame_atual = null;
    }

    protected void trataCommentRecord(String record) {
        String erro_traduzido;
        if (this.exame_atual == null) {
            return;
        }
        Hashtable comment_fields = HL7Standard.parseDefaultCommentRecord(record);
        String type = (String)comment_fields.get(HL7Standard.COMMENT_FIELD_TYPE);
        String exception = (String)comment_fields.get(HL7Standard.COMMENT_FIELD_TEXT);
        if (type != null && type.equals("I") && (erro_traduzido = this.equip.getErroTraduzido(exception)) != null) {
            String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
            String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
            String exame = exa_codigo != null ? " (" + exa_codigo + ") " : "";
            this.equip.fireExcecaoEncontrada(req_codigo + exame + " - " + erro_traduzido);
        }
    }

    protected void trataResultRecord(String record) throws Exception {
        int sit;
        if (this.exame_atual == null) {
            return;
        }
        Hashtable result_fields = HL7Standard.parseDefaultResultRecord(record);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
        String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String resultado = (String)result_fields.get(HL7Standard.RESULT_FIELD_OBSERVATION_VALUE);
        String emi_alternativo = (String)result_fields.get(HL7Standard.RESULT_FIELD_TEST_ID);
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        resultado = resultado.replaceAll("\\.", ",");
        if (resultado.startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        String campo = (sit = 1) < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
        this.exame_atual.put(campo, resultado);
        String flags = (String)result_fields.get(HL7Standard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("")) {
            this.exame_atual.put("flag_alerta", flags);
        }
        this.salvaExame(this.exame_atual);
    }

    protected void trataRequestRecord(String record) throws Exception {
        Hashtable comps = HL7Standard.parseDefaultRequestRecord(record);
        String sampleId = (String)comps.get(HL7Standard.REQUEST_FIELD_SAMPLE_ID);
        this.equip.responderRequest(sampleId, sampleId, "ALL");
    }

    protected void trataOrderRecord(String record) throws Exception {
        Hashtable<Integer, String> order_fields = HL7Standard.parseDefaultOrderRecord(record);
        String req_codigo = (String)order_fields.get(HL7Standard.ORDER_FIELD_SAMPLE_ID);
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
    }

    protected void trataPatientRecord(String record) throws Exception {
    }

    protected void trataHeaderRecord(String record) {
        this.exame_atual = new HashMap<String, Object>();
        Hashtable hash = HL7Standard.parseDefaultHeaderRecord(record);
        this.exame_atual.put(MESSAGE_TYPE, hash.get(HL7Standard.HEADER_FIELD_MESSAGE_TYPE));
        this.exame_atual.put(MESSAGE_CONTROL_ID, hash.get(HL7Standard.HEADER_FIELD_MESSAGE_CONTROL_ID));
    }

    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        ResolvedorResultado.salvaDados(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, null, null, dados, true, null);
    }

    public String getResponseRequest(String record) {
        Hashtable hash = HL7Standard.parseDefaultHeaderRecord(record);
        StringBuilder m = new StringBuilder();
        m.append(this.equip.getMsgStart());
        m.append(HL7Standard.getDefaultHeaderRecord(InterfaceHL7Listener.DELIMITERS, InterfaceHL7Listener.INSTRUMENT_MANUFACTURER, InterfaceHL7Listener.INSTRUMENT_MODEL, "QCK^Q02", hash.get(HL7Standard.HEADER_FIELD_MESSAGE_CONTROL_ID) != null ? String.valueOf(hash.get(HL7Standard.HEADER_FIELD_MESSAGE_CONTROL_ID)) : "", InterfaceHL7Listener.INSTRUMENT_VERSION, "0"));
        m.append("MSA|AA|").append(String.valueOf(hash.get(MESSAGE_CONTROL_ID))).append("|Message accepted|||0|");
        m.append("ERR|0|").append(String.valueOf('\r'));
        m.append("QAK|SR|OK|").append(String.valueOf('\r'));
        m.append(this.equip.getMsgEnd());
        return m.toString();
    }
}

