/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.hl7.message.segments;

import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegment;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegmentType;
import jalis.util.Funcoes;
import java.util.Date;

public class MessageSegmentObx
implements MessageSegment {
    private Integer id;
    private ValueType valueType;
    private String observationId;
    private String observationSubId;
    private String observationValue;
    private String units;
    private String referenceRange;
    private AbnormalFlag abnormalFlag;
    private Integer probability;
    private String natureAbnormalTest;
    private String observeResultStatus;
    private Date dateLastObserveNormalValues;
    private Float userDefinedAccessChecks;
    private Date dateObservation;
    private String producerId;
    private String responsibleObserver;
    private String observationMethod;

    public void setId(Integer id) {
        this.id = id;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public Integer getId() {
        return this.id;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public String getObservationId() {
        return this.observationId;
    }

    public void setObservationId(String observationId) {
        this.observationId = observationId;
    }

    public String getObservationSubId() {
        return this.observationSubId;
    }

    public void setObservationSubId(String observationSubId) {
        this.observationSubId = observationSubId;
    }

    public String getObservationValue() {
        return this.observationValue;
    }

    public void setObservationValue(String observationValue) {
        this.observationValue = observationValue;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getReferenceRange() {
        return this.referenceRange;
    }

    public void setReferenceRange(String referenceRange) {
        this.referenceRange = referenceRange;
    }

    public AbnormalFlag getAbnormalFlag() {
        return this.abnormalFlag;
    }

    public void setAbnormalFlag(AbnormalFlag abnormalFlag) {
        this.abnormalFlag = abnormalFlag;
    }

    public Integer getProbability() {
        return this.probability;
    }

    public void setProbability(Integer probability) {
        this.probability = probability;
    }

    public String getNatureAbnormalTest() {
        return this.natureAbnormalTest;
    }

    public void setNatureAbnormalTest(String natureAbnormalTest) {
        this.natureAbnormalTest = natureAbnormalTest;
    }

    public String getObserveResultStatus() {
        return this.observeResultStatus;
    }

    public void setObserveResultStatus(String observeResultStatus) {
        this.observeResultStatus = observeResultStatus;
    }

    public Date getDateLastObserveNormalValues() {
        return this.dateLastObserveNormalValues;
    }

    public void setDateLastObserveNormalValues(Date dateLastObserveNormalValues) {
        this.dateLastObserveNormalValues = dateLastObserveNormalValues;
    }

    public Float getUserDefinedAccessChecks() {
        return this.userDefinedAccessChecks;
    }

    public void setUserDefinedAccessChecks(Float userDefinedAccessChecks) {
        this.userDefinedAccessChecks = userDefinedAccessChecks;
    }

    public Date getDateObservation() {
        return this.dateObservation;
    }

    public void setDateObservation(Date dateObservation) {
        this.dateObservation = dateObservation;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public void setProducerId(String producerId) {
        this.producerId = producerId;
    }

    public String getResponsibleObserver() {
        return this.responsibleObserver;
    }

    public void setResponsibleObserver(String responsibleObserver) {
        this.responsibleObserver = responsibleObserver;
    }

    public String getObservationMethod() {
        return this.observationMethod;
    }

    public void setObservationMethod(String observationMethod) {
        this.observationMethod = observationMethod;
    }

    @Override
    public MessageSegmentType getType() {
        return MessageSegmentType.OBX;
    }

    @Override
    public String[] getFields() {
        String[] fields = new String[]{String.valueOf(this.getId()), this.getValueType().getId(), this.getObservationId(), this.getObservationSubId(), this.getObservationValue(), this.getUnits(), this.getReferenceRange(), this.getAbnormalFlag() != null ? this.getAbnormalFlag().getId() : null, this.getProbability() != null ? String.valueOf(this.getProbability()) : null, this.getNatureAbnormalTest(), this.getObserveResultStatus(), this.getDateLastObserveNormalValues() != null ? Funcoes.formataData("yyyyMMddHHmmss", this.getDateLastObserveNormalValues()) : null, this.getUserDefinedAccessChecks() != null ? String.valueOf(this.getUserDefinedAccessChecks()) : null, this.getDateObservation() != null ? Funcoes.formataData("yyyyMMddHHmmss", this.getDateObservation()) : null, this.getProducerId(), this.getResponsibleObserver(), this.getObservationMethod()};
        return fields;
    }

    @Override
    public void setFields(String[] fields) {
        this.setId(fields.length > 1 ? Integer.valueOf(fields[1]) : null);
        this.setValueType(fields.length > 2 ? ValueType.getValueById(fields[2]) : null);
        this.setObservationId(fields.length > 3 ? fields[3] : null);
        this.setObservationSubId(fields.length > 4 ? fields[4] : null);
        this.setObservationValue(fields.length > 5 ? fields[5] : null);
        this.setUnits(fields.length > 6 ? fields[6] : null);
        this.setReferenceRange(fields.length > 7 ? fields[7] : null);
        this.setAbnormalFlag(fields.length > 8 && !fields[8].isEmpty() ? AbnormalFlag.getValueById(fields[8]) : null);
        if (Funcoes.isNumeric(fields[9])) {
            this.setProbability(fields.length > 9 && !fields[9].isEmpty() ? Integer.valueOf(fields[9]) : null);
        }
        this.setNatureAbnormalTest(fields.length > 10 ? fields[10] : null);
        this.setObserveResultStatus(fields.length > 11 ? fields[11] : null);
        if (fields.length > 12) {
            this.setDateLastObserveNormalValues(fields[12].isEmpty() || !Funcoes.verificaDataHora(fields[12]) ? null : Funcoes.getData("yyyyMMddHHmmss", fields[12]));
            if (fields.length > 13) {
                if (Funcoes.isNumeric(fields[13])) {
                    if (!fields[13].isEmpty() && fields[13].contains(",")) {
                        fields[13] = fields[13].replaceAll(",", ".");
                    }
                    this.setUserDefinedAccessChecks(fields[13].isEmpty() ? null : Float.valueOf(fields[13]));
                }
                if (fields.length > 14) {
                    this.setDateObservation(fields[14].isEmpty() || !Funcoes.verificaDataHora(fields[14]) ? null : Funcoes.getData("yyyyMMddHHmmss", fields[14]));
                    if (fields.length > 15) {
                        this.setProducerId(fields[15]);
                        if (fields.length > 16) {
                            this.setResponsibleObserver(fields[16]);
                            if (fields.length > 17) {
                                this.setObservationMethod(fields[17]);
                            }
                        }
                    }
                }
            }
        }
    }

    public static enum AbnormalFlag {
        LOW("L"),
        HIGH("H"),
        NORMAL("N"),
        ABNORMAL("A");

        private String id;

        private AbnormalFlag(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static AbnormalFlag getValueById(String id) {
            for (AbnormalFlag messageType : AbnormalFlag.values()) {
                if (!messageType.getId().equals(id)) continue;
                return messageType;
            }
            return null;
        }
    }

    public static enum ValueType {
        NUMERIC("NM"),
        STRING("ST"),
        IS("IS"),
        BASE64("ED");

        private String id;

        private ValueType(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static ValueType getValueById(String id) {
            for (ValueType messageType : ValueType.values()) {
                if (!messageType.getId().equals(id)) continue;
                return messageType;
            }
            return null;
        }
    }
}

