/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.hl7.message.segments;

import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegment;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegmentType;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageType;
import jalis.util.Funcoes;
import java.util.Date;

public class MessageSegmentMsh
implements MessageSegment {
    private EncodingCharacters encodingCharacters;
    private String sendingApplication;
    private String sendingFacility;
    private String receivingApplication;
    private String receivingFacility;
    private Date dateTime;
    private String security;
    private MessageType messageType;
    private String messageControlId;
    private String processingId;
    private String versionId;
    private String sequenceNumber;
    private String continuationPointer;
    private String acceptAckType;
    private ApplicationAckType applicationAckType;
    private String countryCode;
    private String characterSet;
    private String principalLanguage;
    private String alternateCharacterSet;
    private boolean bs300 = false;

    public void setBs300(boolean bs300) {
        this.bs300 = bs300;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public EncodingCharacters getEncodingCharacters() {
        return this.encodingCharacters;
    }

    public void setEncodingCharacters(EncodingCharacters encodingCharacters) {
        this.encodingCharacters = encodingCharacters;
    }

    public String getSendingApplication() {
        return this.sendingApplication;
    }

    public void setSendingApplication(String sendingApplication) {
        this.sendingApplication = sendingApplication;
    }

    public String getSendingFacility() {
        return this.sendingFacility;
    }

    public void setSendingFacility(String sendingFacility) {
        this.sendingFacility = sendingFacility;
    }

    public String getReceivingApplication() {
        return this.receivingApplication;
    }

    public void setReceivingApplication(String receivingApplication) {
        this.receivingApplication = receivingApplication;
    }

    public String getReceivingFacility() {
        return this.receivingFacility;
    }

    public void setReceivingFacility(String receivingFacility) {
        this.receivingFacility = receivingFacility;
    }

    public Date getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
    }

    public String getSecurity() {
        return this.security;
    }

    public void setSecurity(String security) {
        this.security = security;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String getMessageControlId() {
        return this.messageControlId;
    }

    public void setMessageControlId(String messageControlId) {
        this.messageControlId = messageControlId;
    }

    public String getProcessingId() {
        return this.processingId;
    }

    public void setProcessingId(String processingId) {
        this.processingId = processingId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getContinuationPointer() {
        return this.continuationPointer;
    }

    public void setContinuationPointer(String continuationPointer) {
        this.continuationPointer = continuationPointer;
    }

    public String getAcceptAckType() {
        return this.acceptAckType;
    }

    public void setAcceptAckType(String acceptAckType) {
        this.acceptAckType = acceptAckType;
    }

    public ApplicationAckType getApplicationAckType() {
        return this.applicationAckType;
    }

    public void setApplicationAckType(ApplicationAckType applicationAckType) {
        this.applicationAckType = applicationAckType;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public String getPrincipalLanguage() {
        return this.principalLanguage;
    }

    public void setPrincipalLanguage(String principalLanguage) {
        this.principalLanguage = principalLanguage;
    }

    public String getAlternateCharacterSet() {
        return this.alternateCharacterSet;
    }

    public void setAlternateCharacterSet(String alternateCharacterSet) {
        this.alternateCharacterSet = alternateCharacterSet;
    }

    @Override
    public MessageSegmentType getType() {
        return MessageSegmentType.MSH;
    }

    @Override
    public String[] getFields() {
        String[] fields = this.bs300 ? new String[]{this.getEncodingCharacters() != null ? String.valueOf(this.getEncodingCharacters().getComponent()) + String.valueOf(this.getEncodingCharacters().getRepetition()) + String.valueOf(this.getEncodingCharacters().getEscape()) + String.valueOf(this.getEncodingCharacters().getSubcomponent()) : null, this.getSendingApplication(), this.getSendingFacility(), this.getReceivingApplication(), this.getReceivingFacility(), this.getDateTime() != null ? Funcoes.formataData("yyyyMMddHHmmss", this.getDateTime()) : null, this.getSecurity(), this.getMessageType() != null ? this.getMessageType().getId() : null, this.getMessageControlId() != null ? String.valueOf(this.getMessageControlId()) : null, this.getProcessingId(), this.getVersionId()} : new String[]{this.getEncodingCharacters() != null ? String.valueOf(this.getEncodingCharacters().getComponent()) + String.valueOf(this.getEncodingCharacters().getRepetition()) + String.valueOf(this.getEncodingCharacters().getEscape()) + String.valueOf(this.getEncodingCharacters().getSubcomponent()) : null, this.getSendingApplication(), this.getSendingFacility(), this.getReceivingApplication(), this.getReceivingFacility(), this.getDateTime() != null ? Funcoes.formataData("yyyyMMddHHmmss", this.getDateTime()) : null, this.getSecurity(), this.getMessageType() != null ? this.getMessageType().getId() : null, this.getMessageControlId() != null ? String.valueOf(this.getMessageControlId()) : null, this.getProcessingId(), this.getVersionId(), this.getSequenceNumber(), this.getContinuationPointer(), this.getAcceptAckType(), this.getApplicationAckType() != null ? String.valueOf(this.getApplicationAckType().getId()) : null, this.getCountryCode(), this.getCharacterSet(), this.getPrincipalLanguage(), this.getAlternateCharacterSet()};
        return fields;
    }

    @Override
    public void setFields(String[] fields) {
        this.setMessageType(MessageType.getValueById(fields[8]));
        if (fields[1].length() == 4) {
            this.setEncodingCharacters(new EncodingCharacters(fields[1].charAt(0), fields[1].charAt(1), fields[1].charAt(2), fields[1].charAt(3)));
        }
        this.setSendingApplication(fields[2]);
        this.setSendingFacility(fields[3]);
        this.setReceivingApplication(fields[4]);
        this.setReceivingFacility(fields[5]);
        if (fields[6].length() >= 14) {
            this.setDateTime(Funcoes.getData("yyyyMMddHHmmss", fields[6]));
        }
        this.setSecurity(fields[7]);
        if (fields[9].length() > 0) {
            this.setMessageControlId(fields[9]);
        }
        this.setProcessingId(fields[10]);
        this.setVersionId(fields[11]);
        if (fields.length <= 13) {
            this.setSequenceNumber("1");
            this.setContinuationPointer("");
            this.setAcceptAckType("");
            this.setApplicationAckType(null);
            this.setCountryCode("");
            this.setCharacterSet("ASCII");
        } else {
            this.setSequenceNumber(fields[12]);
            this.setContinuationPointer(fields[13]);
            this.setAcceptAckType(fields[14]);
            if (fields[15].length() > 0 && Funcoes.isNumeric(fields[15])) {
                this.setApplicationAckType(ApplicationAckType.getValueById(Integer.valueOf(fields[15])));
            }
            this.setCountryCode(fields[16]);
            this.setCharacterSet(fields[17]);
            if (fields.length > 18) {
                this.setPrincipalLanguage(fields[18]);
                this.setAlternateCharacterSet(fields[19]);
            }
        }
    }

    public static enum ApplicationAckType {
        SAMPLE_RESULT(0),
        CALIBRATION_RESULT(1),
        QC_RESULT(2);

        private int id;

        private ApplicationAckType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static ApplicationAckType getValueById(int id) {
            for (ApplicationAckType appAckType : ApplicationAckType.values()) {
                if (appAckType.getId() != id) continue;
                return appAckType;
            }
            return null;
        }
    }
}

