/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.hl7.message.segments;

import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegment;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegmentType;
import jalis.util.Funcoes;

public class MessageSegmentMsa
implements MessageSegment {
    private AckCode ackCode;
    private String messageControlId;
    private String textMessage;
    private Integer expectedSequenceNumber;
    private String delayedAckType;
    private ErrorCondition errorCondition;

    public void setAckCode(AckCode ackCode) {
        this.ackCode = ackCode;
    }

    @Override
    public MessageSegmentType getType() {
        return MessageSegmentType.MSA;
    }

    public String getMessageControlId() {
        return this.messageControlId;
    }

    public void setMessageControlId(String messageControlId) {
        this.messageControlId = messageControlId;
    }

    public String getTextMessage() {
        return this.textMessage;
    }

    public void setTextMessage(String textMessage) {
        this.textMessage = textMessage;
    }

    public Integer getExpectedSequenceNumber() {
        return this.expectedSequenceNumber;
    }

    public void setExpectedSequenceNumber(Integer expectedSequenceNumber) {
        this.expectedSequenceNumber = expectedSequenceNumber;
    }

    public String getDelayedAckType() {
        return this.delayedAckType;
    }

    public void setDelayedAckType(String delayedAckType) {
        this.delayedAckType = delayedAckType;
    }

    public ErrorCondition getErrorCondition() {
        return this.errorCondition;
    }

    public void setErrorCondition(ErrorCondition errorCondition) {
        this.errorCondition = errorCondition;
    }

    public AckCode getAckCode() {
        return this.ackCode;
    }

    @Override
    public String[] getFields() {
        String[] fields = new String[]{this.getAckCode().getId(), this.getMessageControlId() != null ? String.valueOf(this.getMessageControlId()) : null, this.getTextMessage(), this.getExpectedSequenceNumber() != null ? String.valueOf(this.getExpectedSequenceNumber()) : null, this.getDelayedAckType(), this.getErrorCondition() != null ? String.valueOf(this.getErrorCondition().getCode()) : null};
        return fields;
    }

    @Override
    public void setFields(String[] fields) {
        this.setAckCode(AckCode.getValueById(fields[1]));
        if (fields.length >= 0) {
            this.setMessageControlId(fields[2]);
        }
        if (fields.length >= 4) {
            this.setTextMessage(fields[3]);
        }
        if (fields.length >= 5 && !Funcoes.textoVazio(fields[4])) {
            this.setExpectedSequenceNumber(Integer.parseInt(fields[4]));
        }
        if (fields.length >= 6) {
            this.setDelayedAckType(fields[5]);
        }
        if (fields.length >= 7 && !Funcoes.textoVazio(fields[6])) {
            this.setErrorCondition(ErrorCondition.getValueByCode(Integer.parseInt(fields[6])));
        }
    }

    public static enum AckCode {
        ACCEPTED("AA"),
        ERROR("AE"),
        REJECTED("AR");

        private String id;

        private AckCode(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static AckCode getValueById(String id) {
            for (AckCode messageType : AckCode.values()) {
                if (!messageType.getId().equals(id)) continue;
                return messageType;
            }
            return null;
        }
    }
}

