/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.hl7.message;

import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Factory;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegment;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegmentParser;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegmentType;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageType;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsh;
import java.text.ParseException;
import java.util.ArrayList;

public class MessageParser {
    public Factory messageFactory = new Factory();
    public MessageSegmentParser messageSegmentParser = new MessageSegmentParser();

    public boolean checkMessage(String text) {
        return text.charAt(0) == '\u000b' && text.charAt(text.length() - 2) == '\u001c' && text.charAt(text.length() - 1) == '\r';
    }

    public boolean checkMessageUritBh70p(String text) {
        return text.charAt(0) == '\u000b' && text.charAt(text.length() - 1) == '\u001c';
    }

    public boolean checkMessageLabmax450I(String text) {
        return text.charAt(0) == '\u000b' && text.charAt(text.length() - 2) == '\u001c' && text.charAt(text.length() - 1) == '\r';
    }

    public Message textToMessage(String text) throws ParseException {
        if (!this.checkMessage(text)) {
            throw new ParseException("Mensagem fora do padr\u00e3o. O texto deve iniciar com <SB> e terminar com <EB><CR>", 0);
        }
        text = text.substring(1, text.length() - 2);
        ArrayList<MessageSegment> segments = new ArrayList<MessageSegment>();
        MessageType messageType = null;
        for (String textSegment : text.split(String.valueOf('\r'))) {
            MessageSegment messageSegment = this.messageSegmentParser.textToMessageSegment(textSegment);
            if (messageSegment == null) continue;
            segments.add(messageSegment);
            if (messageSegment.getType() != MessageSegmentType.MSH) continue;
            messageType = ((MessageSegmentMsh)messageSegment).getMessageType();
        }
        if (messageType != null) {
            Message message = this.messageFactory.createMessage(messageType);
            message.setMessageSegments(segments);
            return message;
        }
        return null;
    }

    public Message textToMessageUritBh70p(String text) throws ParseException {
        if (!this.checkMessageUritBh70p(text)) {
            throw new ParseException("Mensagem fora do padr\u00e3o. O texto deve iniciar com <SB> e terminar com <EB>", 0);
        }
        text = text.substring(1, text.length() - 2);
        ArrayList<MessageSegment> segments = new ArrayList<MessageSegment>();
        MessageType messageType = null;
        for (String textSegment : text.split(String.valueOf(AbstractInterfaceamento.LINE))) {
            MessageSegment messageSegment = this.messageSegmentParser.textToMessageSegment(textSegment);
            if (messageSegment == null) continue;
            segments.add(messageSegment);
            if (messageSegment.getType() != MessageSegmentType.MSH) continue;
            messageType = ((MessageSegmentMsh)messageSegment).getMessageType();
        }
        if (messageType != null) {
            Message message = this.messageFactory.createMessage(messageType);
            message.setMessageSegments(segments);
            return message;
        }
        return null;
    }

    public Message textToMessageLabmax450I(String text) throws ParseException {
        if (!this.checkMessageLabmax450I(text)) {
            throw new ParseException("Mensagem fora do padr\u00e3o. O texto deve iniciar com <SB> e terminar com <EB><CR>", 0);
        }
        text = text.substring(1, text.length() - 2);
        ArrayList<MessageSegment> segments = new ArrayList<MessageSegment>();
        MessageType messageType = null;
        for (String textSegment : text.split(String.valueOf('\r'))) {
            MessageSegment messageSegment = this.messageSegmentParser.textToMessageSegment(textSegment);
            if (messageSegment == null) continue;
            segments.add(messageSegment);
            if (messageSegment.getType() != MessageSegmentType.MSH) continue;
            messageType = ((MessageSegmentMsh)messageSegment).getMessageType();
        }
        if (messageType != null) {
            Message message = this.messageFactory.createMessage(messageType);
            message.setMessageSegments(segments);
            return message;
        }
        return null;
    }

    public Message textToMessageVidaCount510(String text) throws ParseException {
        if (!this.checkMessage(text)) {
            throw new ParseException("Mensagem fora do padr\u00e3o. O texto deve iniciar com <SB> e terminar com <EB><CR>", 0);
        }
        text = text.substring(1, text.length() - 2);
        ArrayList<MessageSegment> segments = new ArrayList<MessageSegment>();
        MessageType messageType = null;
        for (String textSegment : text.split(String.valueOf('\r'))) {
            System.out.println("1: " + textSegment);
            MessageSegment messageSegment = this.messageSegmentParser.textToMessageSegment(textSegment);
            if (messageSegment == null) continue;
            segments.add(messageSegment);
            if (messageSegment.getType() != MessageSegmentType.MSH) continue;
            String type = ((MessageSegmentMsh)messageSegment).getProcessingId();
            ((MessageSegmentMsh)messageSegment).getMessageType();
            messageType = MessageType.getValueById(type);
        }
        Message message = this.messageFactory.createMessage(messageType);
        message.setMessageSegments(segments);
        return message;
    }

    public Message textToMessageVidaCount3d(String text) throws ParseException {
        if (!this.checkMessage(text)) {
            throw new ParseException("Mensagem fora do padr\u00e3o. O texto deve iniciar com <SB> e terminar com <EB><CR>", 0);
        }
        text = text.substring(1, text.length() - 2);
        ArrayList<MessageSegment> segments = new ArrayList<MessageSegment>();
        MessageType messageType = null;
        for (String textSegment : text.split(String.valueOf('\r'))) {
            MessageSegment messageSegment = this.messageSegmentParser.textToMessageSegment(textSegment);
            if (messageSegment == null) continue;
            segments.add(messageSegment);
            if (messageSegment.getType() != MessageSegmentType.MSH) continue;
            String type = ((MessageSegmentMsh)messageSegment).getMessageType().getId();
            messageType = MessageType.getValueById(type);
        }
        Message message = this.messageFactory.createMessage(messageType);
        message.setMessageSegments(segments);
        return message;
    }

    public Message textToMessageVidas1200(String text) throws ParseException {
        if (!this.checkMessage(text)) {
            throw new ParseException("Mensagem fora do padr\u00e3o. O texto deve iniciar com <SB> e terminar com <EB><CR>", 0);
        }
        text = text.substring(1, text.length() - 2);
        ArrayList<MessageSegment> segments = new ArrayList<MessageSegment>();
        MessageType messageType = null;
        for (String textSegment : text.split(String.valueOf('\r'))) {
            MessageSegment messageSegment = this.messageSegmentParser.textToMessageSegment(textSegment);
            if (messageSegment == null) continue;
            segments.add(messageSegment);
            if (messageSegment.getType() != MessageSegmentType.MSH) continue;
            String type = ((MessageSegmentMsh)messageSegment).getMessageType().getId();
            ((MessageSegmentMsh)messageSegment).getMessageType();
            messageType = MessageType.getValueById(type);
        }
        Message message = this.messageFactory.createMessage(messageType);
        message.setMessageSegments(segments);
        return message;
    }

    public Message textToMessageVidas3800(String text) throws ParseException {
        if (!this.checkMessage(text)) {
            throw new ParseException("Mensagem fora do padr?o. O texto deve iniciar com <SB> e terminar com <EB><CR>", 0);
        }
        text = text.substring(1, text.length() - 2);
        ArrayList<MessageSegment> segments = new ArrayList<MessageSegment>();
        MessageType messageType = null;
        for (String textSegment : text.split(String.valueOf('\r'))) {
            MessageSegment messageSegment = this.messageSegmentParser.textToMessageSegment(textSegment);
            if (messageSegment == null) continue;
            segments.add(messageSegment);
            if (messageSegment.getType() != MessageSegmentType.MSH) continue;
            String type = ((MessageSegmentMsh)messageSegment).getMessageType().getId();
            ((MessageSegmentMsh)messageSegment).getMessageType();
            messageType = MessageType.getValueById(type);
        }
        Message message = this.messageFactory.createMessage(messageType);
        message.setMessageSegments(segments);
        return message;
    }

    public Message textToMessageGts1600(String text) throws ParseException {
        if (!this.checkMessage(text)) {
            throw new ParseException("Mensagem fora do padr\u00e3o. O texto deve iniciar com <SB> e terminar com <EB><CR>", 0);
        }
        text = text.substring(1, text.length() - 2);
        ArrayList<MessageSegment> segments = new ArrayList<MessageSegment>();
        MessageType messageType = null;
        for (String textSegment : text.split(String.valueOf('\r'))) {
            MessageSegment messageSegment = this.messageSegmentParser.textToMessageSegment(textSegment);
            if (messageSegment == null) continue;
            segments.add(messageSegment);
            if (messageSegment.getType() != MessageSegmentType.MSH) continue;
            String type = ((MessageSegmentMsh)messageSegment).getMessageType().getId();
            ((MessageSegmentMsh)messageSegment).getMessageType();
            messageType = MessageType.getValueById(type);
        }
        Message message = this.messageFactory.createMessage(messageType);
        message.setMessageSegments(segments);
        return message;
    }

    public final void messageToText(Message message, char fieldSeparator, StringBuilder builder) {
        builder.append('\u000b');
        for (MessageSegment messageSegment : message.getMessageSegments()) {
            this.messageSegmentParser.messageSegmentToText(messageSegment, fieldSeparator, builder);
            builder.append('\r');
        }
        builder.append('\u001c').append('\r');
    }

    public final String messageToText(Message message, char fieldSeparator) {
        StringBuilder builder = new StringBuilder();
        this.messageToText(message, fieldSeparator, builder);
        return builder.toString();
    }

    public final String messageToTextLabmax450i(Message message, char fieldSeparator) {
        StringBuilder builder = new StringBuilder();
        this.messageToTextLabmax450i(message, fieldSeparator, builder);
        return builder.toString();
    }

    public final void messageToTextLabmax450i(Message message, char fieldSeparator, StringBuilder builder) {
        builder.append('\u000b');
        for (MessageSegment messageSegment : message.getMessageSegments()) {
            this.messageSegmentParser.messageSegmentToText(messageSegment, fieldSeparator, builder);
            builder.append('\r');
        }
        builder.append('\u001c').append('\r');
    }

    public Message textToMessageVidacount860al(String text) throws ParseException {
        if (!this.checkMessage(text)) {
            throw new ParseException("Mensagem fora do padr\u00e3o. O texto deve iniciar com <SB> e terminar com <EB><CR>", 0);
        }
        text = text.substring(1, text.length() - 2);
        ArrayList<MessageSegment> segments = new ArrayList<MessageSegment>();
        MessageType messageType = null;
        for (String textSegment : text.split(String.valueOf('\r'))) {
            MessageSegment messageSegment = this.messageSegmentParser.textToMessageSegment(textSegment);
            if (messageSegment == null) continue;
            segments.add(messageSegment);
            if (messageSegment.getType() != MessageSegmentType.MSH) continue;
            String type = ((MessageSegmentMsh)messageSegment).getProcessingId();
            ((MessageSegmentMsh)messageSegment).getMessageType();
            messageType = MessageType.getValueById(type);
        }
        Message message = this.messageFactory.createMessage(messageType);
        message.setMessageSegments(segments);
        return message;
    }

    public Message textToMessageHemabioIIIVet(String text) throws ParseException {
        if (!this.checkMessage(text)) {
            throw new ParseException("Mensagem fora do padr\u00e3o. O texto deve iniciar com <SB> e terminar com <EB><CR>", 0);
        }
        text = text.substring(1, text.length() - 2);
        ArrayList<MessageSegment> segments = new ArrayList<MessageSegment>();
        MessageType messageType = null;
        for (String textSegment : text.split(String.valueOf('\r'))) {
            MessageSegment messageSegment = this.messageSegmentParser.textToMessageSegmentHemabioIIIVet(textSegment);
            if (messageSegment == null) continue;
            segments.add(messageSegment);
            if (messageSegment.getType() != MessageSegmentType.MSH) continue;
            String type = ((MessageSegmentMsh)messageSegment).getProcessingId();
            messageType = MessageType.getValueById(type);
        }
        Message message = this.messageFactory.createMessage(messageType);
        message.setMessageSegments(segments);
        return message;
    }
}

