/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.bdmodem;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.TimeOutException;
import jalis.laboratorio.interfaceamento.comunicacao.TimedHandshaker;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.padroes.bdmodem.BdModemRecordParser;
import jalis.laboratorio.interfaceamento.padroes.bdmodem.BdModemStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public abstract class InterfaceBdModemListener
extends InterfaceASTMListener {
    private static final int TAMANHO_MENSAGEM = 135;
    protected BdModemRecordParser recordParser;
    private int bsn1 = 33;
    private static final int BSN2 = 32;
    private int cbsn1 = 46;
    private static final int CBSN2 = 47;
    private ThreadRecebimento threadRecebimento;
    private boolean received = true;
    private List<String> bufferMensagens = new ArrayList<String>();

    public InterfaceBdModemListener() {
        this.threadRecebimento = new ThreadRecebimento(this, 100);
    }

    public InterfaceBdModemListener(BdModemRecordParser recordParser) {
        this();
        this.recordParser = recordParser;
    }

    public void setBdModemRecordParser(BdModemRecordParser recordParser) {
        this.recordParser = recordParser;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            String nome = null;
            String ultimoNome = short_name = this.removeEspacoDuplo(short_name.trim());
            if (short_name.indexOf(" ") > 0) {
                String[] names = short_name.split(" ");
                nome = names[0];
                if (names[0].length() > this.MAX_PATIENT_NAME_CHARS) {
                    short_name = names[0].substring(0, this.MAX_PATIENT_NAME_CHARS);
                }
                ultimoNome = names.length <= 2 ? names[1] : names[names.length - 1];
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            if (mapaParametros != null && !Funcoes.textoVazio(mapaParametros.get("codigoApoiado"))) {
                codigo.setLength(0);
                codigo.append(mapaParametros.get("codigoApoiado"));
            }
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            StringBuilder msg = new StringBuilder();
            msg.append(BdModemStandard.getDefaultHeaderRecord(this.DELIMITERS));
            Object patient_id = null;
            String laboratory_pid = req_codigo;
            msg.append(BdModemStandard.getDefaultPatientRecord(1, laboratory_pid, nome, ultimoNome));
            msg.append(BdModemStandard.getDefaultOrderRecord(1, codigo.toString()));
            msg.append(BdModemStandard.getDefaultTerminationRecord());
            this.tx_list.add(msg.toString());
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.resetCountFrame();
            this.getPortaCOM().write(String.valueOf('\u0016'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractBDMODEMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractBDMODEMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private String removeEspacoDuplo(String short_name) {
        StringBuilder newNome = new StringBuilder();
        for (int i = 0; i < short_name.length(); ++i) {
            if (short_name.charAt(i) == ' ' && i < short_name.length() && short_name.charAt(i + 1) == ' ') continue;
            newNome.append(short_name.charAt(i));
        }
        return newNome.toString();
    }

    @Override
    public abstract String getErroTraduzido(String var1);

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
    }

    @Override
    public Map<Integer, String> parsePatientNameField(String name_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(name_field), 4, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.PATIENT_NAME_LAST, tokens[0]);
            components.put(this.PATIENT_NAME_FIRST, tokens[1]);
            components.put(this.PATIENT_NAME_MIDDLE, tokens[2]);
            components.put(this.PATIENT_NAME_SUFFIX, tokens[3]);
            components.put(this.PATIENT_NAME_TITLE, tokens[4]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractBDMODEMInterfaceamento: parse de Patient Name Field (Patient Frame)");
            return null;
        }
    }

    @Override
    public Map<Integer, String> parseOrderSystemSID(String instrumentSID_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(instrumentSID_field), 2, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.ORDER_SYS_SAMPLE_ID, tokens[0]);
            components.put(this.ORDER_SYS_SAMPLE_RACK_ID, tokens[1]);
            components.put(this.ORDER_SYS_SAMPLE_RACK_POS, tokens[2]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractBDMODEMInterfaceamento: parse de Instrument Specimen ID (Order Frame)");
            return null;
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this, 100);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        this.threadRecebimento.start();
    }

    @Override
    public Map<Integer, String> parseOrderTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 5, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ID, tokens[0]);
            components.put(this.TEST_NAME, tokens[1]);
            components.put(this.TEST_TYPE, tokens[2]);
            components.put(this.TEST_ITEM_NUMBER, tokens[3]);
            components.put(this.TEST_ITEM_NAME, tokens[4]);
            components.put(this.TEST_DILUTION, tokens[5]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractBDMODEMInterfaceamento: parse de Test ID Field (Order Frame)");
            return null;
        }
    }

    @Override
    public Map<Integer, String> parseResultTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 5, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ID, tokens[0]);
            components.put(this.TEST_NAME, tokens[1]);
            components.put(this.TEST_TYPE, tokens[2]);
            components.put(this.TEST_ITEM_NUMBER, tokens[3]);
            components.put(this.TEST_ITEM_NAME, tokens[4]);
            components.put(this.TEST_DILUTION, tokens[5]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractBDMODEMInterfaceamento: parse de Test ID Field (Result Frame)");
            return null;
        }
    }

    @Override
    public String getMiddleFrameEnd() {
        return "";
    }

    @Override
    public String getFinalFrameEnd() {
        return "";
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0001');
    }

    @Override
    public String getMsgEnd() {
        return "";
    }

    private String encodeValue(String value) {
        int count = 0;
        for (int i = 0; i < value.length(); ++i) {
            count += value.codePointAt(i);
        }
        char c = (char)count;
        StringBuilder ret = new StringBuilder();
        char[] tx = new char[2];
        tx[1] = (char)(((c & 0xF0) >> 4) + 32);
        tx[0] = (char)((c & 0xF) + 32);
        ret.append(tx[0]);
        ret.append(tx[1]);
        return ret.toString();
    }

    @Override
    public MemoryList<String> makeFrames(MemoryList<String> raw_list) throws Exception {
        try {
            MemoryList<String> new_list = new MemoryList<String>();
            if (raw_list != null) {
                while (!raw_list.isEmpty() && raw_list.size() > 0) {
                    String[] slices = StringUtil.dividir(raw_list.remove(0), 128);
                    for (int j = 0; j < slices.length; ++j) {
                        StringBuilder temp = new StringBuilder(this.nextFrame());
                        temp.append(slices[j]);
                        if (slices[j].length() < 128) {
                            int size = 128 - slices[j].length();
                            temp.append(StringUtil.repeteCaractere('\u0000', size));
                        }
                        temp.append(this.encodeValue(slices[j]));
                        temp = new StringBuilder(this.getMsgStart()).append((CharSequence)temp);
                        new_list.add(temp.toString());
                    }
                }
                return new_list;
            }
            return null;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Erro ao recuperar lista de frames (size:" + raw_list.size() + ")");
            return null;
        }
    }

    protected void resetCountFrame() {
        this.bsn1 = 33;
        this.cbsn1 = 46;
    }

    private String nextFrame() {
        StringBuilder bsns = new StringBuilder();
        bsns.append((char)this.bsn1);
        bsns.append(' ');
        bsns.append((char)this.cbsn1);
        bsns.append('/');
        ++this.bsn1;
        ++this.cbsn1;
        if (this.bsn1 > 255) {
            this.bsn1 = 0;
        }
        if (this.cbsn1 > 255) {
            this.cbsn1 = 0;
        }
        return bsns.toString();
    }

    @Override
    protected void limpaDadosRequisicao() {
        this.rx_list.clear();
        this.tx_list.clear();
        this.fil_codigo = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
        this.request_received = false;
    }

    @Override
    protected void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(this.TIME_RX_ABORTADO);
        this.fireMensagemEnviada("Tempo esgotado ao receber dados do equipamento", 1, 10000);
    }

    @Override
    protected void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(this.TIME_TX_ABORTADO);
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            Statement st = Conexao.getStatement();
            if (this.exames != null && !Funcoes.textoVazio(this.mco_codigo)) {
                for (int i = 0; i < this.exames.length; ++i) {
                    int situacao;
                    if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                        for (String exame : this.examesFilho) {
                            int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                            BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    if (!this.examesFilho.isEmpty()) {
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                    this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
            }
        }
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.getPortaCOM().clearInputString();
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fcTimedOut(EventObject e) {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
                return;
            }
            if (this.isRX()) {
                if (this.rx_list.isEmpty()) {
                    this.setIdle();
                    return;
                } else {
                    this.abortarRecepcao();
                }
                return;
            }
            if (!this.isIdle()) return;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractBDMODEMInterfaceamento: timeout no controle de fluxo");
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    @Override
    protected void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            this.verificarNegacao();
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    protected void retransmitirRecusado() throws Exception {
        if (this.tx_counter >= this.MAX_TENTATIVAS) {
            this.encerrarTransmissao();
            return;
        }
        int next = this.tx_list.getUltimoLido();
        if (next < this.tx_list.size()) {
            this.setTX(this.TIME_TX);
            this.getPortaCOM().write((String)this.tx_list.get(next));
        }
        ++this.tx_counter;
    }

    @Override
    protected void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
            } else {
                this.enviarProximoFrame();
            }
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    protected void tratarEnquiry() throws Exception {
        if (this.isTX()) {
            this.abortarParaReceber();
        } else if (!this.isRX()) {
            this.prepararParaReceber();
        } else {
            this.prepararParaReceber();
        }
    }

    @Override
    protected void prepararParaReceber() throws Exception {
        this.rx_list.clear();
        this.getPortaCOM().clearInputString();
        this.setRX(this.TIME_ENQUIRY);
        this.fireMensagemEnviada("Aguardando envio de dados pelo equipamento", 0, 10000);
        this.getPortaCOM().write(String.valueOf('\u0006'));
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        if (this.isTX()) {
            if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
                this.encerrarTransmissao();
            } else {
                this.getPortaCOM().write(String.valueOf('\u0006'));
                this.encerrarRecepcao();
            }
        } else {
            this.getPortaCOM().write(String.valueOf('\u0006'));
            this.encerrarRecepcao();
        }
    }

    @Override
    protected void encerrarRecepcao() {
        this.limpaDadosRequisicao();
        this.setIdle();
    }

    @Override
    protected void enviarProximoFrame() throws Exception {
        int next;
        this.rx_list.clear();
        int n = next = this.tx_list.getUltimoLido() < 0 ? 0 : this.tx_list.getUltimoLido() + 1;
        if (this.tx_list.size() > 0) {
            String frame = (String)this.tx_list.get(next);
            this.setTX(this.TIME_TX);
            ++this.tx_counter;
            this.getPortaCOM().write(frame);
        } else {
            this.encerrarTransmissao();
        }
    }

    @Override
    protected void verificarNegacao() throws Exception {
        if (this.isTX()) {
            if (this.tx_list.getUltimoLido() >= 0) {
                this.retransmitirRecusado();
            } else {
                this.abortarTransmissao();
            }
        } else if (this.isRX()) {
            this.caracterNaoEsperado();
        }
    }

    @Override
    protected void abortarParaReceber() throws Exception {
        this.setRX(this.TIME_ENQ_ABORTADO);
        this.fireMensagemEnviada("Abortando transmiss\u00e3o de dados ao equipamento.", 1, 5000);
    }

    @Override
    protected void caracterNaoEsperado() throws Exception {
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0016': {
                    if (this.isTX() || this.tx_list.size() > 0 && this.rx_counter < this.MAX_TENTATIVAS_RX) {
                        this.getPortaCOM().write(String.valueOf('\u0015'));
                        ++this.rx_counter;
                        break;
                    }
                    this.rx_counter = 0;
                    this.tratarEnquiry();
                    this.received = false;
                    this.bufferMensagens.clear();
                    break;
                }
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    this.tratarEndOfTX();
                    this.received = true;
                    this.dataChanged();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractBDMODEMInterfaceamento: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            if (this.tx_list.size() > 0) {
                this.limpaDadosRequisicao();
            }
            this.setIdle();
        }
    }

    @Override
    protected void aguardarProximoFrame() throws Exception {
        this.setRX(this.TIME_RX);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    @Override
    public void sendRequestAllResultsRecord() throws Exception {
        TimedHandshaker h = new TimedHandshaker();
        this.getClass();
        String record = BdModemStandard.getDefaultEnquiryRecord("ALL", null, "ALL", null, null, "F");
        this.setTX(this.TIME_TX);
        try {
            char c = h.sendAndWaitResponse(String.valueOf('\u0016'), this.TIME_TX);
            if (c != '\u0006') {
                this.interromperTimer();
                this.fireMensagemEnviada("Requisi\u00e7\u00e3o de resultados negada pelo equipamento", 1, 5000);
                return;
            }
            c = h.sendAndWaitResponse(record, this.TIME_TX);
            if (c != '\u0006') {
                this.interromperTimer();
                this.fireMensagemEnviada("Requisi\u00e7\u00e3o de resultados negada pelo equipamento", 1, 5000);
                return;
            }
            this.getPortaCOM().write(String.valueOf('\u0004'));
        }
        catch (TimeOutException ex) {
            this.fireMensagemEnviada("Tempo esgotado ao requisitar resultados ao equipamento", 1, 5000);
        }
        this.interromperTimer();
        this.setIdle();
    }

    @Override
    public String parse(String message) {
        try {
            String[] records;
            for (String record : records = message.split(LINE)) {
                this.recordParser.recordFound(record);
            }
            Conexao.arquivaSQL();
            RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
            return "";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractBDMODEMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractBDMODEMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.startsWith(String.valueOf('\u0001')) && message.length() >= 135) {
                String check = message.substring(133, 135);
                message = this.getPortaCOM().removeInputString(check);
                String dataBlock = message.substring(5, 133);
                if (!this.validaCheckSum(dataBlock, check)) {
                    this.getPortaCOM().write(String.valueOf('\u0015'));
                } else if (!this.received) {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    this.bufferMensagens.add(dataBlock);
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    this.receiveDataBlock(dataBlock);
                    if (this.isRX()) {
                        this.aguardarProximoFrame();
                    }
                }
            } else if (this.received && this.bufferMensagens.size() > 0) {
                this.receiveDataBlock("");
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractBDMODEMInterfaceamento: evento de dados recebidos");
                    InterfaceBdModemListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
                }
            });
        }
    }

    private void receiveDataBlock(String dataBlock) {
        if (!Funcoes.textoVazio(dataBlock)) {
            this.bufferMensagens.add(dataBlock);
        }
        StringBuilder mensagem = new StringBuilder();
        for (String msg : this.bufferMensagens) {
            mensagem.append(msg);
        }
        this.bufferMensagens.clear();
        this.addListaRecebimento(mensagem.toString());
        this.restartThreadRecebimento();
    }

    private boolean validaCheckSum(String dataBlock, String check) {
        String checkCalculado = this.encodeValue(dataBlock.replaceAll(String.valueOf('\u0000'), ""));
        boolean ret = check.equals(checkCalculado);
        if (!ret) {
            this.fireExcecaoEncontrada(String.format("CheckSum da mensagem inv\u00e1lido erro de comunica\u00e7\u00e3o checkSum calculado (%s) checkSum recebido (%s)!", checkCalculado, check));
        }
        return ret;
    }

    @Override
    public String reenviarExames(String req_codigo, String rec_codigo, String pac_sexo, String pac_idade, String pac_nome, String hora, String data, String fil_codigo, String int_codigo, ArrayList<ExameMaterial> exames, String acao, String rackposition, String prioridade) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, exames.get(0).getCodigoMaterial(), rec_codigo, exames.get(0).getCodigo().toString(), acao);
    }
}

