/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.astm2.records;

import jalis.laboratorio.interfaceamento.padroes.astm2.Field;
import jalis.laboratorio.interfaceamento.padroes.astm2.FieldList;
import jalis.laboratorio.interfaceamento.padroes.astm2.InstrumentSpecificId;
import jalis.laboratorio.interfaceamento.padroes.astm2.Record;
import jalis.laboratorio.interfaceamento.padroes.astm2.RecordType;
import jalis.laboratorio.interfaceamento.padroes.astm2.UniversalTestId;
import jalis.util.Funcoes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TestOrder
implements Record {
    private String specimenId;
    private InstrumentSpecificId instrumentSpecificId = new InstrumentSpecificId();
    private List<UniversalTestId> universalTestIds = new ArrayList<UniversalTestId>();
    private Priority priority = Priority.ROUTINE;
    private Action action = Action.REQUEST_FOR_NEW_SAMPLE;
    private ReportType reportType = ReportType.ORDER_RECORD;
    private Date specimenDate;

    public Date getSpecimenDate() {
        return this.specimenDate;
    }

    public void setSpecimenDate(Date specimenDate) {
        this.specimenDate = specimenDate;
    }

    public String getSpecimenId() {
        return this.specimenId;
    }

    public void setSpecimenId(String specimenId) {
        this.specimenId = specimenId;
    }

    public InstrumentSpecificId getInstrumentSpecificId() {
        return this.instrumentSpecificId;
    }

    public void setInstrumentSpecificId(InstrumentSpecificId instrumentSpecificId) {
        this.instrumentSpecificId = instrumentSpecificId;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportType reportType) {
        this.reportType = reportType;
    }

    public void addUniversalTestId(UniversalTestId testId) {
        this.universalTestIds.add(testId);
    }

    public List<UniversalTestId> getUniversalTestIds() {
        return this.universalTestIds;
    }

    @Override
    public RecordType getType() {
        return RecordType.TEST_ORDER;
    }

    @Override
    public FieldList getFields(int sequenceNumber) {
        Field instrumentSpecificIdField = new Field(new String[0]);
        for (UniversalTestId test : this.universalTestIds) {
            instrumentSpecificIdField.addToRepetition(test.getField());
        }
        Field specimenDateField = this.specimenDate != null ? new Field(Funcoes.formataData("yyyyMMddHHmmss", this.specimenDate)) : null;
        FieldList fields = new FieldList(new Field(this.getType().getId()), Field.valueOf(sequenceNumber), new Field(this.specimenId), this.instrumentSpecificId.getField(), instrumentSpecificIdField, new Field(this.priority.getId()), null, null, specimenDateField, null, null, new Field(this.action.getId()), null, null, null, null, null, null, null, null, null, null, null, null, null, new Field(this.reportType.getId()), null, null, null, null, null);
        return fields;
    }

    @Override
    public void setFields(FieldList fields) {
        if (fields.exists(2)) {
            this.specimenId = fields.get(2).getFirstComponent();
        }
        if (fields.exists(3)) {
            this.instrumentSpecificId.setField(fields.get(3));
        }
        this.universalTestIds.clear();
        if (fields.exists(4)) {
            if (fields.get(4).isRepetition()) {
                for (Field fieldTest : fields.get(4).getComponentsRepetition()) {
                    UniversalTestId test = new UniversalTestId();
                    test.setFiled(fieldTest);
                    this.universalTestIds.add(test);
                }
            } else if (fields.get(4).getFirstComponent() != null) {
                UniversalTestId test = new UniversalTestId();
                test.setFiled(fields.get(4));
                this.universalTestIds.add(test);
            }
        }
        Priority priority = this.priority = fields.exists(5) && !Funcoes.textoVazio(fields.get(5).getFirstComponent()) ? Priority.getValueById(fields.get(5).getFirstComponent()) : Priority.ROUTINE;
        if (fields.exists(8) && !Funcoes.textoVazio(fields.get(8).getFirstComponent())) {
            String format = fields.get(8).getFirstComponent().length() == 12 ? "yyMMddHHmmss" : "yyyyMMddHHmmss";
            this.specimenDate = Funcoes.getData(format, fields.get(8).getFirstComponent());
        }
        this.action = fields.exists(11) && !Funcoes.textoVazio(fields.get(11).getFirstComponent()) ? Action.getValueById(fields.get(11).getFirstComponent()) : null;
        this.reportType = fields.exists(25) && !Funcoes.textoVazio(fields.get(25).getFirstComponent()) ? ReportType.getValueById(fields.get(25).getFirstComponent()) : null;
    }

    public static enum ReportType {
        FINAL_RESULTS("F"),
        ORDER_RECORD("O"),
        PENDING_IN_INSTRUMENT("I"),
        NO_RECORD("Z"),
        RESPONSE_TO_QUERY("Q");

        private String id;

        private ReportType(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static ReportType getValueById(String id) {
            for (ReportType reportType : ReportType.values()) {
                if (!reportType.getId().equals(id)) continue;
                return reportType;
            }
            return null;
        }
    }

    public static enum Action {
        ADD_TO_EXISTING_SAMPLE("A"),
        CANCEL_TESTS_LISTED("C"),
        REQUEST_FOR_NEW_SAMPLE("N"),
        PENDING_SAMPLE("P"),
        SAMPLE_IN_PRECESS("X"),
        IGNORED("L");

        private String id;

        private Action(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static Action getValueById(String id) {
            for (Action action : Action.values()) {
                if (!action.getId().equals(id)) continue;
                return action;
            }
            return null;
        }
    }

    public static enum Priority {
        ROUTINE("R"),
        STAT("S"),
        AS_SOON_AS_POSSIBLE("A"),
        CALL_BACK("C"),
        PREOPERATIVE("P");

        private String id;

        private Priority(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static Priority getValueById(String id) {
            for (Priority priority : Priority.values()) {
                if (!priority.getId().equals(id)) continue;
                return priority;
            }
            return null;
        }
    }

    public static enum ProcessingId {
        PRODUCTION("P"),
        DEBUGGIN("D");

        private String id;

        private ProcessingId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static ProcessingId getValueById(String id) {
            for (ProcessingId processingId : ProcessingId.values()) {
                if (!processingId.getId().equals(id)) continue;
                return processingId;
            }
            return null;
        }
    }
}

