/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.astm2.records;

import jalis.laboratorio.interfaceamento.padroes.astm2.Field;
import jalis.laboratorio.interfaceamento.padroes.astm2.FieldList;
import jalis.laboratorio.interfaceamento.padroes.astm2.Record;
import jalis.laboratorio.interfaceamento.padroes.astm2.RecordType;
import jalis.laboratorio.interfaceamento.padroes.astm2.UniversalTestId;
import java.util.HashMap;
import java.util.Map;

public class Result
implements Record {
    private UniversalTestId universalTestId;
    private String measurementValue;
    private String secondMeasurementValue;
    private String units;
    private ResultStatus status;
    private ResultFlags flags;
    private Map<String, String> descricaoFlags = new HashMap<String, String>();

    public Result() {
        this.universalTestId = new UniversalTestId();
        this.status = ResultStatus.FINAL_RESULTS;
        this.descricaoFlags.put(ResultFlags.ANORMAL.getId(), "Anormal");
        this.descricaoFlags.put(ResultFlags.MAIOR_FAIXA_MEDICAO.getId(), "Maior que a faixa de medi\u00e7\u00e3o");
        this.descricaoFlags.put(ResultFlags.MAIOR_FAIXA_MEDICAO2.getId(), "Maior que a faixa de medi\u00e7\u00e3o");
        this.descricaoFlags.put(ResultFlags.MENOR_FAIXA_MEDICAO.getId(), "Menor que a faixa de medi\u00e7\u00e3o");
        this.descricaoFlags.put(ResultFlags.MENOR_FAIXA_MEDICAO2.getId(), "Menor que a faixa de medi\u00e7\u00e3o");
        this.descricaoFlags.put(ResultFlags.MENOR_FAIXA_NORMAL.getId(), "Menor que a faixa normal");
        this.descricaoFlags.put(ResultFlags.MAIOR_FAIXA_NORMAL.getId(), "Maior que a faixa normal");
    }

    public UniversalTestId getUniversalTestId() {
        return this.universalTestId;
    }

    public void setUniversalTestId(UniversalTestId universalTestId) {
        this.universalTestId = universalTestId;
    }

    public String getMeasurementValue() {
        return this.measurementValue;
    }

    public void setMeasurementValue(String measurementValue) {
        this.measurementValue = measurementValue;
    }

    public String getSecondMeasurementValue() {
        return this.secondMeasurementValue;
    }

    public void setSecondMeasurementValue(String secondMeasurementValue) {
        this.secondMeasurementValue = secondMeasurementValue;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public ResultStatus getStatus() {
        return this.status;
    }

    public String getFlag() {
        if (this.flags != null) {
            return this.descricaoFlags.get(this.flags.getId());
        }
        return "";
    }

    public void setStatus(ResultStatus status) {
        this.status = status;
    }

    @Override
    public RecordType getType() {
        return RecordType.RESULT;
    }

    @Override
    public FieldList getFields(int sequenceNumber) {
        FieldList fields = new FieldList(new Field(this.getType().getId()), Field.valueOf(sequenceNumber), this.universalTestId.getField(), new Field(this.measurementValue), new Field(this.units), null, null, new Field(this.flags.getId()), new Field(this.status.getId()), null, null, null, null, null);
        return fields;
    }

    @Override
    public void setFields(FieldList fields) {
        if (fields.exists(2)) {
            this.universalTestId.setFiled(fields.get(2));
        }
        if (fields.exists(3) && fields.get(3).getFirstComponent() != null) {
            this.measurementValue = fields.get(3).getFirstComponent();
        }
        this.secondMeasurementValue = fields.exists(3) && fields.get(3).getComponent(1) != null ? fields.get(3).getComponent(1) : "";
        if (fields.exists(4) && fields.get(4).getFirstComponent() != null) {
            this.units = fields.get(4).getFirstComponent();
        }
        if (fields.exists(6) && fields.get(6).getFirstComponent() != null) {
            this.flags = ResultFlags.getValueById(fields.get(6).getFirstComponent());
        }
        if (fields.exists(8) && fields.get(8).getFirstComponent() != null) {
            this.status = ResultStatus.getValueById(fields.get(8).getFirstComponent());
        }
    }

    public static enum ResultStatus {
        FINAL_RESULTS("F"),
        RESULTS_CANNOT_BE_DONE("X"),
        RESULTS_PENDING("I"),
        RESULTS_PREVIOUSLY_SENT("R"),
        RESPONSE_TO_QUERY("Q"),
        OPERATOR_VERIFIED("V"),
        SYSTEM_BLOCKED("Y"),
        USER_BLOCKED("+");

        private String id;

        private ResultStatus(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static ResultStatus getValueById(String id) {
            for (ResultStatus status : ResultStatus.values()) {
                if (!status.getId().equals(id)) continue;
                return status;
            }
            return null;
        }
    }

    public static enum ResultFlags {
        MENOR_FAIXA_NORMAL("L"),
        MAIOR_FAIXA_NORMAL("H"),
        MENOR_FAIXA_MEDICAO("LL"),
        MAIOR_FAIXA_MEDICAO("HH"),
        MENOR_FAIXA_MEDICAO2("<"),
        MAIOR_FAIXA_MEDICAO2(">"),
        NORMAL("N"),
        ANORMAL("A");

        private String id;

        private ResultFlags(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static ResultFlags getValueById(String id) {
            for (ResultFlags flag : ResultFlags.values()) {
                if (!flag.getId().equals(id)) continue;
                return flag;
            }
            return null;
        }
    }
}

