/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.astm2.records;

import jalis.laboratorio.interfaceamento.padroes.astm2.Field;
import jalis.laboratorio.interfaceamento.padroes.astm2.FieldList;
import jalis.laboratorio.interfaceamento.padroes.astm2.RangeId;
import jalis.laboratorio.interfaceamento.padroes.astm2.Record;
import jalis.laboratorio.interfaceamento.padroes.astm2.RecordType;
import jalis.util.Funcoes;
import java.util.Date;

public class RequestInformation
implements Record {
    private RangeId startingRange;
    private RangeId endingRange;
    private RequestInfoStatus requestInfoStatus;
    private Date beginningRequestResults;
    private Date endingRequestResults;

    public RangeId getStartingRange() {
        return this.startingRange;
    }

    public void setStartingRange(RangeId startingRange) {
        this.startingRange = startingRange;
    }

    public RangeId getEndingRange() {
        return this.endingRange;
    }

    public void setEndingRange(RangeId endingRange) {
        this.endingRange = endingRange;
    }

    public RequestInfoStatus getRequestInfoStatus() {
        return this.requestInfoStatus;
    }

    public void setRequestInfoStatus(RequestInfoStatus requestInfoStatus) {
        this.requestInfoStatus = requestInfoStatus;
    }

    public Date getBeginningRequestResults() {
        return this.beginningRequestResults;
    }

    public void setBeginningRequestResults(Date beginningRequestResults) {
        this.beginningRequestResults = beginningRequestResults;
    }

    public Date getEndingRequestResults() {
        return this.endingRequestResults;
    }

    public void setEndingRequestResults(Date endingRequestResults) {
        this.endingRequestResults = endingRequestResults;
    }

    @Override
    public RecordType getType() {
        return RecordType.REQUEST_INFORMATION;
    }

    @Override
    public FieldList getFields(int sequenceNumber) {
        Field startingRangeField = this.startingRange != null ? this.startingRange.getField() : new Field("ALL");
        Field endingRangeField = this.endingRange != null ? this.endingRange.getField() : null;
        Field beginningRequestResultsField = this.beginningRequestResults != null ? new Field(Funcoes.formataData("yyyyMMddHHmmss", this.beginningRequestResults)) : null;
        Field endingRequestResultsField = this.endingRequestResults != null ? new Field(Funcoes.formataData("yyyyMMddHHmmss", this.endingRequestResults)) : null;
        Field requestInfoStatusField = this.requestInfoStatus != null ? new Field(this.requestInfoStatus.getId()) : null;
        FieldList fields = new FieldList(new Field(this.getType().getId()), Field.valueOf(sequenceNumber), startingRangeField, endingRangeField, new Field("ALL"), null, beginningRequestResultsField, endingRequestResultsField, null, null, null, null, requestInfoStatusField);
        return fields;
    }

    @Override
    public void setFields(FieldList fields) {
        String format;
        if (fields.exists(2) && fields.get(2).getFirstComponent() != null) {
            this.startingRange = new RangeId();
            this.startingRange.setField(fields.get(2));
        }
        if (fields.exists(3) && fields.get(3).getFirstComponent() != null) {
            this.endingRange = new RangeId();
            this.endingRange.setField(fields.get(3));
        }
        if (fields.exists(6) && fields.get(6).getFirstComponent() != null) {
            format = "";
            if (fields.get(6).getFirstComponent().length() == 12) {
                format = "yyMMddHHmmss";
            } else if (fields.get(6).getFirstComponent().length() == 14) {
                format = "yyyyMMddHHmmss";
            }
            Date date = this.beginningRequestResults = Funcoes.textoVazio(fields.get(6).getFirstComponent()) || Funcoes.textoVazio(format) ? new Date() : Funcoes.getData(format, fields.get(6).getFirstComponent());
        }
        if (fields.exists(7) && fields.get(7).getFirstComponent() != null) {
            format = fields.get(7).getFirstComponent().length() == 12 ? "yyMMddHHmmss" : "yyyyMMddHHmmss";
            Date date = this.endingRequestResults = Funcoes.textoVazio(fields.get(7).getFirstComponent()) ? new Date() : Funcoes.getData(format, fields.get(7).getFirstComponent());
        }
        if (fields.exists(12) && fields.get(12).getFirstComponent() != null) {
            this.requestInfoStatus = RequestInfoStatus.getValueById(fields.get(12).getFirstComponent());
        }
    }

    public static enum RequestInfoStatus {
        REQUEST_TESTS_FROM_HOST("O"),
        REQUEST_FINAL_RESULTS("F"),
        REQUEST_RESULTS_PENDING("I"),
        REQUEST_RESULTS_SENT_BEFORE("R"),
        REQUEST_NEW_OR_EDITED_RESULT("N"),
        CANCEL_SPECIFIC_REQUEST("X"),
        CANCEL_LAST_REQUEST("A");

        private String id;

        private RequestInfoStatus(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static RequestInfoStatus getValueById(String id) {
            for (RequestInfoStatus requestInfoStatus : RequestInfoStatus.values()) {
                if (!requestInfoStatus.getId().equals(id)) continue;
                return requestInfoStatus;
            }
            return null;
        }
    }
}

