/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.astm2;

import jalis.laboratorio.interfaceamento.padroes.astm2.Field;
import jalis.laboratorio.interfaceamento.padroes.astm2.FieldList;
import jalis.laboratorio.interfaceamento.padroes.astm2.Record;
import jalis.laboratorio.interfaceamento.padroes.astm2.RecordFactory;
import jalis.laboratorio.interfaceamento.padroes.astm2.RecordType;

public class RecordParser {
    private char fieldDelimiter;
    private char componentDelimiter;
    private char repeatDelimiter;
    private RecordFactory factory;

    public RecordParser(char fieldDelimiter, char componentDelimiter, char repeatDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
        this.componentDelimiter = componentDelimiter;
        this.repeatDelimiter = repeatDelimiter;
        this.factory = new RecordFactory();
    }

    public Record dataToRecord(String data) {
        RecordType type = RecordType.getValueById((data = data.substring(0, data.length() - 1)).substring(0, 1));
        if (type != null) {
            Record record;
            if (type == RecordType.MESSAGE_HEADER) {
                data = data.substring(0, 2) + data.substring(5);
            }
            if ((record = this.factory.create(type)) != null) {
                FieldList fields = new FieldList(new Field[0]);
                String[] dataFields = data.split("\\" + this.fieldDelimiter, -1);
                for (int i = 0; i < dataFields.length; ++i) {
                    Field field = null;
                    if (dataFields[i] != null) {
                        field = this.dataToField(dataFields[i]);
                    }
                    fields.add(field);
                }
                record.setFields(fields);
                return record;
            }
        }
        return null;
    }

    public String recordToData(Record record, int sequenceNumber) {
        StringBuilder data = new StringBuilder();
        boolean first = true;
        for (Field field : record.getFields(sequenceNumber)) {
            if (first) {
                first = false;
            } else {
                data.append(this.fieldDelimiter);
            }
            if (field == null) continue;
            if (field.isRepetition()) {
                this.appendRepetition(field, data);
                continue;
            }
            this.appendComponents(field, data);
        }
        data.append('\r');
        return data.toString();
    }

    private void appendComponents(Field field, StringBuilder data) {
        boolean first = true;
        for (String component : field.getComponents()) {
            if (first) {
                first = false;
            } else {
                data.append(this.componentDelimiter);
            }
            if (component == null) continue;
            data.append(component);
        }
    }

    private void appendRepetition(Field field, StringBuilder data) {
        boolean first = true;
        for (Field subField : field.getComponentsRepetition()) {
            if (first) {
                first = false;
            } else {
                data.append(this.repeatDelimiter);
            }
            if (subField == null) continue;
            this.appendComponents(subField, data);
        }
    }

    private Field dataToField(String data) {
        Field field;
        if (data.contains(String.valueOf(this.repeatDelimiter))) {
            field = new Field(new String[0]);
            for (String subFieldData : data.split("\\" + this.repeatDelimiter, -1)) {
                field.addToRepetition(this.dataToField(subFieldData));
            }
        } else {
            field = new Field(data.split("\\" + this.componentDelimiter, -1));
        }
        return field;
    }
}

