/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.astm2;

import jalis.laboratorio.interfaceamento.util.Checksum;
import java.text.ParseException;

public class PacketParser {
    public String dataToText(int frameNumber, String data, boolean endPacket) {
        StringBuilder message = new StringBuilder();
        message.append(frameNumber);
        message.append(data);
        message.append(endPacket ? (char)'\u0003' : '\u0017');
        String checksum = Checksum.getChecksumMod256(message.toString());
        StringBuilder packet = new StringBuilder();
        packet.append('\u0002');
        packet.append((CharSequence)message);
        packet.append(checksum);
        packet.append('\r').append('\n');
        return packet.toString();
    }

    public PacketParseResult textToData(String text) throws ParseException {
        String checksum;
        if (!this.checkFormat(text)) {
            return new PacketParseResult(ParseResult.FORMAT_ERROR);
        }
        String message = text.substring(1, text.length() - 4);
        if (!this.testChecksum(message, checksum = text.substring(text.length() - 4, text.length() - 2))) {
            return new PacketParseResult(ParseResult.CHECKSUM_ERROR);
        }
        int frameNumber = Integer.parseInt(text.substring(1, 2));
        String data = text.substring(2, text.length() - 5);
        char dataEnd = text.charAt(text.length() - 5);
        boolean endFrame = dataEnd == '\u0003';
        return new PacketParseResult(ParseResult.SUCCESS, frameNumber, data, endFrame);
    }

    public boolean checkFormat(String text) {
        if (text == null || text.length() <= 7) {
            return false;
        }
        char dataEnd = text.charAt(text.length() - 5);
        return text.charAt(0) == '\u0002' && (dataEnd == '\u0003' || dataEnd == '\u0017') && text.charAt(text.length() - 2) == '\r' && text.charAt(text.length() - 1) == '\n';
    }

    private boolean testChecksum(String message, String checksum) {
        return checksum.equals(Checksum.getChecksumMod256(message));
    }

    public class PacketParseResult {
        private ParseResult parseResult;
        private int frameNumber;
        private String data;
        private boolean endPacket;

        public PacketParseResult(ParseResult parseResult, int frameNumber, String data, boolean endPacket) {
            this.parseResult = parseResult;
            this.frameNumber = frameNumber;
            this.data = data;
            this.endPacket = endPacket;
        }

        public PacketParseResult(ParseResult parseResult) {
            this(parseResult, 0, null, false);
        }

        public ParseResult getParseResult() {
            return this.parseResult;
        }

        public int getFrameNumber() {
            return this.frameNumber;
        }

        public String getData() {
            return this.data;
        }

        public boolean isEndPacket() {
            return this.endPacket;
        }
    }

    public static enum ParseResult {
        SUCCESS,
        FORMAT_ERROR,
        CHECKSUM_ERROR;

    }
}

