/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.astm2;

import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.padroes.astm2.Message;
import jalis.laboratorio.interfaceamento.padroes.astm2.MessageReceivedListener;
import jalis.laboratorio.interfaceamento.padroes.astm2.MessageSentCallback;
import jalis.laboratorio.interfaceamento.padroes.astm2.PacketParser;
import jalis.laboratorio.interfaceamento.padroes.astm2.PhaseListener;
import jalis.laboratorio.interfaceamento.padroes.astm2.Record;
import jalis.laboratorio.interfaceamento.padroes.astm2.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm2.RecordType;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public abstract class InterfaceASTMListener
extends AbstractInterfaceamentoListener {
    private Phase phase = Phase.IDLE;
    private RecordParser recordParser = new RecordParser('|', '^', '\\');
    protected PacketParser packetParser = new PacketParser();
    private List<PhaseListener> phaseListeners = new ArrayList<PhaseListener>();
    private List<MessageReceivedListener> messageReceivedListeners = new ArrayList<MessageReceivedListener>();
    private PhaseListener internalPhaseListener;
    private Message messageToReceive;
    private int tentativasEnvio;
    private MessageManager messageManager = new MessageManager(this.packetParser, this.recordParser);

    public InterfaceASTMListener() {
        this.internalPhaseListener = new PhaseListener(){

            @Override
            public void phaseChanged(Phase oldPhase, Phase newPhase) {
                if (oldPhase == Phase.HOST_TRANSFER) {
                    InterfaceASTMListener.this.tentativasEnvio = 0;
                }
                if (oldPhase == Phase.EQUIP_TRANSFER) {
                    InterfaceASTMListener.this.getPortaCOM().clearInputString();
                    InterfaceASTMListener.this.messageToReceive = null;
                }
                if (newPhase == Phase.IDLE && InterfaceASTMListener.this.messageManager.hasMessagesToSend()) {
                    InterfaceASTMListener.this.requestHostTransfer();
                }
                if (newPhase == Phase.HOST_TRANSFER) {
                    try {
                        if (InterfaceASTMListener.this.messageManager.hasMessagesToSend()) {
                            InterfaceASTMListener.this.messageManager.nextMessage();
                            InterfaceASTMListener.this.messageManager.sendPacket(InterfaceASTMListener.this.getPortaCOM());
                        }
                    }
                    catch (IOException e) {
                        ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Falha na comunica\u00e7\u00e3o");
                    }
                }
            }
        };
        this.phaseListeners.add(this.internalPhaseListener);
        this.messageReceivedListeners.add(this.getMessageReceivedListener());
    }

    protected abstract MessageReceivedListener getMessageReceivedListener();

    private void firePhaseChanged(Phase oldPhase, Phase newPhase) {
        for (PhaseListener phaseListener : this.phaseListeners) {
            phaseListener.phaseChanged(oldPhase, newPhase);
        }
    }

    private void fireMessageReceived(Message message) {
        for (MessageReceivedListener listener : this.messageReceivedListeners) {
            listener.messageReceived(message);
        }
    }

    private void requestHostTransfer() {
        try {
            this.setPhase(Phase.HOST_ESTABLISHMENT);
            this.enviarHandShake('\u0005');
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Falha na comunica\u00e7\u00e3o");
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0002');
    }

    @Override
    public String getMsgStart() {
        return LINE;
    }

    @Override
    public final void handShakeCharReceived(char handShake) {
        try {
            switch (handShake) {
                case '\u0005': {
                    if (this.phase == Phase.IDLE) {
                        this.setPhase(Phase.EQUIP_TRANSFER);
                        this.enviarHandShake('\u0006');
                        break;
                    }
                    this.enviarHandShake('\u0015');
                    break;
                }
                case '\u0004': {
                    if (this.phase != Phase.EQUIP_TRANSFER) break;
                    if (this.messageToReceive != null) {
                        this.fireMessageReceived(this.messageToReceive);
                        this.messageToReceive = null;
                    }
                    this.setPhase(Phase.IDLE);
                    break;
                }
                case '\u0006': {
                    if (this.phase == Phase.HOST_ESTABLISHMENT) {
                        this.setPhase(Phase.HOST_TRANSFER);
                        break;
                    }
                    if (this.phase != Phase.HOST_TRANSFER) break;
                    this.messageManager.lastPacketSent();
                    if (this.messageManager.hasPacketsToSend()) {
                        this.messageManager.sendPacket(this.getPortaCOM());
                        break;
                    }
                    this.enviarHandShake('\u0004');
                    this.setPhase(Phase.IDLE);
                    break;
                }
                case '\u0015': {
                    if (this.phase != Phase.HOST_TRANSFER) break;
                    if (this.messageManager.hasPacketsToSend() && this.tentativasEnvio <= 3) {
                        this.messageManager.sendPacket(this.getPortaCOM());
                        ++this.tentativasEnvio;
                        break;
                    }
                    this.enviarHandShake('\u0004');
                    this.setPhase(Phase.IDLE);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPhase(Phase phase) {
        Phase oldPhase = this.phase;
        this.phase = phase;
        this.firePhaseChanged(oldPhase, phase);
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        this.setPhase(Phase.IDLE);
    }

    @Override
    public final void dataChanged() {
        block5: {
            try {
                String text = this.getPortaCOM().getInputString();
                if (text == null || !this.packetParser.checkFormat(text)) break block5;
                this.getPortaCOM().clearInputString();
                try {
                    PacketParser.PacketParseResult result = this.packetParser.textToData(text);
                    if (result.getParseResult() == PacketParser.ParseResult.SUCCESS) {
                        this.packetRecebido(result.getData());
                        this.enviarHandShake('\u0006');
                        break block5;
                    }
                    this.enviarHandShake('\u0015');
                }
                catch (ParseException e) {
                    this.enviarHandShake('\u0015');
                }
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Falha na comunica\u00e7\u00e3o");
            }
        }
    }

    public void dataChanged(String text) {
        block5: {
            try {
                if (text == null || !this.packetParser.checkFormat(text)) break block5;
                this.getPortaCOM().clearInputString();
                try {
                    PacketParser.PacketParseResult result = this.packetParser.textToData(text);
                    if (result.getParseResult() == PacketParser.ParseResult.SUCCESS) {
                        this.packetRecebido(result.getData());
                        this.enviarHandShake('\u0006');
                        break block5;
                    }
                    this.enviarHandShake('\u0015');
                }
                catch (ParseException e) {
                    this.enviarHandShake('\u0015');
                }
            }
            catch (IOException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Falha na comunica\u00e7\u00e3o");
            }
        }
    }

    protected void packetRecebido(String data) {
        Record record = this.recordParser.dataToRecord(data);
        if (record != null) {
            if (this.messageToReceive == null) {
                if (record.getType() == RecordType.MESSAGE_HEADER) {
                    this.messageToReceive = new Message();
                    this.messageToReceive.addRecord(record);
                }
            } else {
                this.messageToReceive.addRecord(record);
            }
        }
    }

    @Override
    public final String parse(String data) {
        return null;
    }

    protected void addMessageToSend(Message message, MessageSentCallback callback) {
        this.messageManager.addMessageToSend(message, callback);
        if (this.phase == Phase.IDLE) {
            this.requestHostTransfer();
        }
    }

    protected void addMessageToSend(Message message) {
        this.addMessageToSend(message, new MessageSentCallback(){

            @Override
            public void messageSent(Message message, MessageSentCallback.MessageSentResult result) {
            }
        });
    }

    protected void enviarHandShake(char handShake) throws IOException {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getPortaCOM().write(String.valueOf(handShake));
    }

    private class MessageManager {
        private Queue<MessageToSend> messages;
        private MessageToSend currentMessage;
        private Queue<String> packets;
        private int frameNumber;
        private PacketParser packetParser;
        private RecordParser recordParser;

        public MessageManager(PacketParser packetParser, RecordParser recordParser) {
            this.packetParser = packetParser;
            this.recordParser = recordParser;
            this.messages = new LinkedList<MessageToSend>();
            this.packets = new LinkedList<String>();
            this.frameNumber = 1;
        }

        public void addMessageToSend(Message message, MessageSentCallback callback) {
            this.messages.add(new MessageToSend(message, callback));
        }

        public void sendPacket(AbstractPort port) throws IOException {
            if (!this.packets.isEmpty()) {
                port.write(this.packets.peek());
            }
        }

        public void lastPacketSent() {
            this.packets.poll();
            if (this.packets.isEmpty() && this.currentMessage != null) {
                this.currentMessage.getCallback().messageSent(this.currentMessage.getMessage(), MessageSentCallback.MessageSentResult.SUCCESS);
                this.messages.poll();
            }
        }

        public boolean hasPacketsToSend() {
            return !this.packets.isEmpty();
        }

        public boolean hasMessagesToSend() {
            return !this.messages.isEmpty();
        }

        public void nextMessage() {
            this.packets.clear();
            this.frameNumber = 1;
            this.currentMessage = null;
            if (!this.messages.isEmpty()) {
                this.currentMessage = this.messages.peek();
                Object lastRecordType = null;
                int sequenceNumber = 1;
                for (Record record : this.currentMessage.getMessage().getRecords()) {
                    sequenceNumber = lastRecordType == record.getType() ? ++sequenceNumber : 1;
                    String data = this.recordParser.recordToData(record, sequenceNumber);
                    String[] dataParts = StringUtil.dividir(data, 200);
                    for (int i = 0; i < dataParts.length; ++i) {
                        boolean finalPacket = i == dataParts.length - 1;
                        String text = this.packetParser.dataToText(this.frameNumber, dataParts[i], finalPacket);
                        this.packets.add(text);
                        ++this.frameNumber;
                    }
                }
            }
        }
    }

    private class MessageToSend {
        private MessageSentCallback callback;
        private Message message;

        public MessageToSend(Message message, MessageSentCallback callback) {
            this.callback = callback;
            this.message = message;
        }

        public MessageSentCallback getCallback() {
            return this.callback;
        }

        public Message getMessage() {
            return this.message;
        }
    }

    public static enum Phase {
        IDLE,
        EQUIP_TRANSFER,
        HOST_TRANSFER,
        HOST_ESTABLISHMENT;

    }
}

