/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.padroes.abx;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.abx.ABXStandard;
import jalis.laboratorio.interfaceamento.padroes.abx.InterfaceABXConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.binary.Base64;

public class InterfaceABXListener
extends AbstractInterfaceamentoListener {
    protected int MAX_TEST_ID = 16;
    protected int MAX_PATIENT_NAME_CHARS = 30;
    protected int TIME_RX_ABORTADO = 3000;
    protected int TIME_TX_ABORTADO = 5000;
    protected int TIME_TX = 15000;
    protected int TIME_RX = 15000;
    protected int TIME_ENQUIRY = 30000;
    protected int TIME_ENQ_ABORTADO = 20000;
    protected int TIME_TO_REFRESH = 2000;
    protected int MAX_TENTATIVAS = 6;
    protected String req_codigo;
    protected String mco_codigo;
    protected String rec_codigo;
    protected String pac_nome;
    protected String pac_exames;
    protected String pac_sexo;
    protected String req_idade;
    protected String req_data;
    protected String req_hora;
    protected String fil_codigo;
    protected String acao;
    protected String int_codigo;
    protected String[] exames;
    protected MemoryList<String> tx_list = new MemoryList();
    protected MemoryList<String> rx_list = new MemoryList();
    private Map<String, String> flag = new HashMap<String, String>();
    protected int tx_counter = 0;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    protected char anlysisType = (char)128;
    protected String alturaGrafico = "128";
    protected String larguraGrafico = "128";

    public InterfaceABXListener() {
        this.carregaConfiguracoes();
    }

    private void carregaConfiguracoes() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        InterfaceABXConfiguracao configuracao = new InterfaceABXConfiguracao();
        configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        if (configuracao.getCustomAnlysisType() != null && !configuracao.getCustomAnlysisType().trim().isEmpty()) {
            this.anlysisType = configuracao.getCustomAnlysisType().trim().charAt(0);
        }
        if (!Funcoes.textoVazio(configuracao.getAlturaGrafico())) {
            this.alturaGrafico = configuracao.getAlturaGrafico();
        }
        if (!Funcoes.textoVazio(configuracao.getLarguraGrafico())) {
            this.larguraGrafico = configuracao.getLarguraGrafico();
        }
        this.flag.put("GRA+", "Granulocytosis");
        this.flag.put("GRA-", "Granulopenia");
        this.flag.put("LEU+", "Leukocytosis");
        this.flag.put("LEU-", "Leukopenia");
        this.flag.put("LYM+", "Lymphocytosis");
        this.flag.put("LYM-", "Lymphopenia");
        this.flag.put("NEU+", "Neutrophilia");
        this.flag.put("NEU-", "Neutropenia");
        this.flag.put("EOS+", "Eosinophilia");
        this.flag.put("MYEL", "Myelemia");
        this.flag.put("LIMC", "Large Immature Cells");
        this.flag.put("ALYM", "Atypic Lymphocytes");
        this.flag.put("LSHT", "Left shift");
        this.flag.put("NRBC", "Nucleated Red Blood Cells");
        this.flag.put("MON+", "Monocytosis");
        this.flag.put("BAS+", "Basophilia");
        this.flag.put("BLST", "Blasts");
        this.flag.put("ANEM", "Anemia");
        this.flag.put("ANI1", "Anisocytosis level 1");
        this.flag.put("ANI2", "Anisocytosis level 2");
        this.flag.put("ANI3", "Anisocytosis level 3");
        this.flag.put("MIC1", "Microcytes level 1");
        this.flag.put("MIC2", "Microcytes level 2");
        this.flag.put("MIC3", "Microcytes level 3");
        this.flag.put("MAC1", "Macrocytes level 1");
        this.flag.put("MAC2", "Macrocytes level 2");
        this.flag.put("MAC3", "Macrocytes level 3");
        this.flag.put("MICR", "Microcytosis");
        this.flag.put("MACR", "Macrocytosis");
        this.flag.put("HCR1", "Hypochromia level 1");
        this.flag.put("HCR2", "Hypochromia level 2");
        this.flag.put("HCR3", "Hypochromia level 3");
        this.flag.put("CAGG", "Cold agglutinin");
        this.flag.put("ERYT", "Erythrocytosis");
        this.flag.put("THR+", "Thrombocytosis");
        this.flag.put("THR-", "Thrombopenia");
        this.flag.put("PLAG", "Platelet aggregates");
        this.flag.put("SCEL", "Small cells");
        this.flag.put("MICC", "Microcytes");
        this.flag.put("SCHI", "Schizocytes");
        this.flag.put("MAPL", "Macro platelet");
        this.flag.put("IMMT", "Immature reticulocytes");
        this.flag.put("RET+", "Reticulocytosis");
        this.flag.put("RET", "Reticulopenia");
        this.flag.put("????", "No interpretation");
        this.flag.put("PANC", "Pancytopenia");
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.acao = acao;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            StringBuilder codigo = new StringBuilder(fil_codigo);
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            codigo.append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            this.tx_list.clear();
            this.tx_list.add(ABXStandard.getDefaultHeaderRecord());
            this.tx_list.add(ABXStandard.getDefaultOrderRecord(codigo.toString(), short_name, "", pac_idade, pac_sexo, this.exames[0], codigo.toString()));
            this.tx_list.add(ABXStandard.getDefaultFooterRecord());
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.enviarProximoFrame();
            this.tx_counter = 0;
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractABXInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractABXInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    public String getCodigoApoiado(String sampleID) {
        return sampleID;
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            int pos = message.length() - 1;
            if (pos == 0) {
                this.fireExcecaoEncontrada(String.format("Erro ao receber bloco de dados: Tamanho do bloco incorreto (%s)!", message));
                return "Erro ao receber bloco de dados: Tamanho do bloco incorreto!";
            }
            int indexCr = (message = message.substring(1, pos)).indexOf(String.valueOf('\r'));
            if (indexCr == -1) {
                return "Erro ao receber bloco de dados: Tamanho do bloco incorreto!";
            }
            String tmp = message.substring(0, indexCr);
            if (!Funcoes.isNumeric(tmp)) {
                return "Erro ao receber bloco de dados: Tamanho do bloco incorreto!";
            }
            int index = message.indexOf(String.valueOf('\u00fd'));
            checksum = message.substring(index + 1, message.length());
            if (!this.checkCRC(message, checksum)) {
                return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
            }
            if (!Funcoes.textoVazio(message)) {
                this.recordFound(message);
            }
            this.setIdle();
            return "";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), String.format("AbstractABXInterfaceamento: parse messsage=\"%s\"", message));
            this.rx_list.clear();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractABXInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
            } else {
                this.aguardarProximoFrame();
            }
            if (!message.equals("") && message.startsWith(this.getMsgStart())) {
                String retorno = this.parse(message);
                if (retorno != null && retorno.startsWith("Erro")) {
                    this.fireMensagemEnviada(retorno, 1, 5000);
                } else if (retorno != null) {
                    this.fireMensagemEnviada(retorno, 0, 10000);
                }
            } else {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractABXInterfaceamento: evento de dados recebidos");
                    InterfaceABXListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
                }
            };
            SwingUtilities.invokeLater(run);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handShakeCharReceived(final char c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    switch (c) {
                        case '\u0005': {
                            InterfaceABXListener.this.tratarEnquiry();
                            break;
                        }
                        case '\u0006': {
                            InterfaceABXListener.this.tratarAcknowledge();
                            break;
                        }
                        case '\u0015': {
                            InterfaceABXListener.this.tratarNegativeAck();
                            break;
                        }
                        case '\u0004': {
                            InterfaceABXListener.this.tratarEndOfTX();
                            break;
                        }
                        case '\u0001': {
                            InterfaceABXListener.this.tratarSOH();
                        }
                        default: {
                            InterfaceABXListener.this.caracterNaoEsperado();
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "InterfaceABXListener: evento de caracter de handshake recebido");
                    InterfaceABXListener.this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
                    InterfaceABXListener.this.setIdle();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public MemoryList<String> makeFrames(MemoryList<String> raw_list) throws Exception {
        try {
            MemoryList<String> new_list = new MemoryList<String>();
            StringBuilder temp_list = new StringBuilder();
            if (raw_list != null) {
                while (!raw_list.isEmpty()) {
                    temp_list.append(raw_list.remove(0));
                }
                int size = temp_list.toString().getBytes().length;
                temp_list.insert(0, Funcoes.preencheZero(size, 5) + '\r');
                temp_list.insert(0, this.getMsgStart());
                temp_list.append(this.getMsgEnd());
                new_list.add(temp_list.toString());
                return new_list;
            }
            return null;
        }
        catch (Exception ex) {
            throw new Exception("Erro ao recuperar lista de frames (size:" + raw_list.size() + ")");
        }
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(this.TIME_RX);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    protected void abortarParaReceber() throws Exception {
        this.setRX(this.TIME_ENQ_ABORTADO);
        this.fireMensagemEnviada("Abortando transmiss\u00e3o de dados ao equipamento.", 1, 5000);
    }

    protected void prepararParaReceber() throws Exception {
        this.rx_list.clear();
        this.getPortaCOM().clearInputString();
        this.setRX(this.TIME_ENQUIRY);
        this.fireMensagemEnviada("Aguardando envio de dados pelo equipamento", 0, 10000);
        this.getPortaCOM().write(String.valueOf('\u0006'));
    }

    protected void enviarProximoFrame() throws Exception {
        int next;
        this.rx_list.clear();
        int n = next = this.tx_list.getUltimoLido() < 0 ? 0 : this.tx_list.getUltimoLido() + 1;
        if (this.tx_list.size() > 0) {
            String frame = this.tx_list.get(next);
            this.setTX(this.TIME_TX);
            ++this.tx_counter;
            this.getPortaCOM().write(frame);
        } else {
            this.encerrarTransmissao();
        }
    }

    protected void encerrarTransmissao() throws Exception {
        if (Funcoes.textoVazio(this.fil_codigo) || Funcoes.textoVazio(this.int_codigo) || Funcoes.textoVazio(this.req_codigo) || Funcoes.textoVazio(this.mco_codigo) || Funcoes.textoVazio(this.rec_codigo) || Funcoes.textoVazio(this.acao)) {
            return;
        }
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
        this.interromperTimer();
        if (this.acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    protected void limpaDadosRequisicao() {
        this.rx_list.clear();
        this.tx_list.clear();
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    public boolean checkCRC(String message, String checksum) {
        return true;
    }

    public void recordFound(String record) throws Exception {
        StringTokenizer stks = new StringTokenizer(record, String.valueOf('\r'));
        HashMap<String, Object> lines = new HashMap<String, Object>();
        while (stks.hasMoreTokens()) {
            String token = stks.nextToken();
            String cmd = token.substring(0, 1);
            String value = "";
            if (token.length() > 2) {
                value = token.substring(2, token.length());
            }
            lines.put(cmd, value);
        }
        String type = (String)lines.get(String.valueOf(this.anlysisType));
        if (type == null || type.trim().isEmpty()) {
            String string = type = lines.get("\u20ac") != null ? lines.get("\u20ac").toString() : null;
        }
        if (type == null || type.trim().isEmpty()) {
            String string = type = lines.get("\ufffd") != null ? lines.get("\ufffd").toString() : null;
        }
        if (type == null || type.trim().isEmpty()) {
            this.fireExcecaoEncontrada("ANLYSIS_TYPE (" + this.anlysisType + ") n\u00e3o encontrado");
        } else {
            String record_type = InterfaceABXListener.getRecordTypeIdentifier(type);
            this.parseRecord(record_type, lines);
        }
    }

    protected void parseRecord(String record_type, HashMap<String, Object> lines) throws Exception {
        if (record_type != null) {
            int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String req_codigo = null;
            if (lines.containsKey(String.valueOf('v'))) {
                req_codigo = ((String)lines.get(String.valueOf('v'))).trim();
            }
            if (req_codigo == null || !Funcoes.isNumeric(req_codigo) && lines.containsKey(String.valueOf('u'))) {
                req_codigo = ((String)lines.get(String.valueOf('u'))).trim();
            }
            if (req_codigo == null || req_codigo.length() != qtde) {
                this.fireExcecaoEncontrada(req_codigo + " - N\u00e3o existe ou n\u00e3o esta interfaceada");
                return;
            }
            req_codigo = this.getCodigoApoiado(req_codigo);
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            if (!(Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo) && Funcoes.isNumeric(rec_codigo))) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da amostra fora do padr\u00e3o %s %s %s ", fil_codigo, req_codigo, rec_codigo));
                return;
            }
            String int_codigo = "";
            Map<String, Object> dados = null;
            if (record_type.equals("A")) {
                dados = this.trataResultCBC(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "A");
            } else if (record_type.equals("B")) {
                dados = this.trataResultDIF(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "B");
            } else if (record_type.equals("C")) {
                dados = this.trataResultRET(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "C");
            } else if (record_type.equals("D")) {
                dados = this.trataResultLMG(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "D");
            } else if (record_type.equals("E")) {
                dados = this.trataResultCBR(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "E");
            } else if (record_type.equals("F")) {
                dados = this.trataResultDIR(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "F");
            } else if (record_type.equals("G")) {
                dados = this.trataResultSPS(lines);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, "G");
            }
            List<String> flags = this.getFlags(lines);
            if (!flags.isEmpty()) {
                StringBuilder strFlags = new StringBuilder();
                for (String str : flags) {
                    strFlags.append(str).append(" ");
                }
                dados.put("flag", strFlags.toString());
            }
            if (dados == null) {
                this.fireExcecaoEncontrada("Tipo do resultado recebido n\u00e3o existe ou n\u00e3o interfaceado");
                return;
            }
            if (Funcoes.textoVazio(int_codigo)) {
                this.fireExcecaoEncontrada(fil_codigo + " " + req_codigo + " " + rec_codigo + " - " + "Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada!");
                return;
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, record_type);
            if (exame == null) {
                this.fireExcecaoEncontrada(fil_codigo + " " + req_codigo + " " + rec_codigo + " - " + ("Exame n\u00e3o existe ou n\u00e3o esta interfaceado (int: " + (int_codigo == null ? "-1" : int_codigo) + ", type: " + record_type + ")"));
                return;
            }
            Statement st = Conexao.getStatement();
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
            for (BDExame e : exames) {
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, e.getExame(), e.getMaterial(), int_codigo, dados, flags);
            }
            Conexao.arquivaSQL();
        }
    }

    protected List<String> getFlags(HashMap<String, Object> lines) {
        ArrayList<String> flags = new ArrayList<String>();
        if (lines.containsKey("P") && !Funcoes.textoVazio(String.valueOf(lines.get("P")))) {
            flags.add(String.valueOf(lines.get("P")));
        }
        if (lines.containsKey("Q") && !Funcoes.textoVazio(String.valueOf(lines.get("Q")))) {
            flags.add(String.valueOf(lines.get("Q")));
        }
        if (lines.containsKey("R") && !Funcoes.textoVazio(String.valueOf(lines.get("R")))) {
            flags.add(String.valueOf(lines.get("R")));
        }
        if (lines.containsKey("S") && !Funcoes.textoVazio(String.valueOf(lines.get("S")))) {
            flags.add(String.valueOf(lines.get("S")));
        }
        if (lines.containsKey("f") && !Funcoes.textoVazio(String.valueOf(lines.get("f")))) {
            flags.add(String.valueOf(lines.get("f")));
        }
        if (lines.containsKey("g") && !Funcoes.textoVazio(String.valueOf(lines.get("g")))) {
            flags.add(String.valueOf(lines.get("g")));
        }
        if (lines.containsKey("h") && !Funcoes.textoVazio(String.valueOf(lines.get("h")))) {
            flags.add(String.valueOf(lines.get("h")));
        }
        if (lines.containsKey("T") && !Funcoes.textoVazio(String.valueOf(lines.get("T")))) {
            flags.add(this.flag.get(String.valueOf(lines.get("T"))));
        }
        if (lines.containsKey("U") && !Funcoes.textoVazio(String.valueOf(lines.get("U")))) {
            flags.add(this.flag.get(String.valueOf(lines.get("U"))));
        }
        if (lines.containsKey("V") && !Funcoes.textoVazio(String.valueOf(lines.get("V")))) {
            flags.add(this.flag.get(String.valueOf(lines.get("V"))));
        }
        for (String s : lines.keySet()) {
            if (s.charAt(0) == '\u00a2' && !Funcoes.textoVazio(String.valueOf(lines.get(s)))) {
                flags.add(String.valueOf(lines.get(s)));
                continue;
            }
            if (!s.equals("\u00a2") || Funcoes.textoVazio(String.valueOf(lines.get(s)))) continue;
            flags.add(String.valueOf(lines.get(s)));
        }
        return flags;
    }

    public Map<String, Object> trataResultSPS(HashMap<String, Object> lines) throws Exception {
        HashMap<String, Object> dados = new HashMap<String, Object>();
        return this.trataPadrao(lines, dados);
    }

    public Map<String, Object> trataResultDIR(HashMap<String, Object> lines) throws Exception {
        HashMap<String, Object> dados = new HashMap<String, Object>();
        return this.trataPadrao(lines, dados);
    }

    public Map<String, Object> trataResultCBR(HashMap<String, Object> lines) throws Exception {
        HashMap<String, Object> dados = new HashMap<String, Object>();
        return this.trataPadrao(lines, dados);
    }

    public Map<String, Object> trataResultLMG(HashMap<String, Object> lines) throws Exception {
        HashMap<String, Object> dados = new HashMap<String, Object>();
        return this.trataLMG(lines, dados);
    }

    public Map<String, Object> trataResultRET(HashMap<String, Object> lines) throws Exception {
        HashMap<String, Object> dados = new HashMap<String, Object>();
        return this.trataPadrao(lines, dados);
    }

    public Map<String, Object> trataResultDIF(HashMap<String, Object> lines) throws Exception {
        Map<String, Object> dados = new HashMap<String, Object>();
        dados = this.trataPadrao(lines, dados);
        dados = this.trataPadraoHistogramas(lines, dados);
        return this.trataPadrao(lines, dados);
    }

    public Map<String, Object> trataResultCBC(HashMap<String, Object> lines) throws Exception {
        HashMap<String, Object> dados = new HashMap<String, Object>();
        return this.trataPadrao(lines, dados);
    }

    public Map<String, Object> trataPadrao(HashMap<String, Object> lines, Map<String, Object> dados) throws Exception {
        dados.put("leucocitos", this.parseValor(lines.get(String.valueOf('!'))));
        dados.put("linfocitos_tipicos_contagem", this.parseValor(lines.get(String.valueOf('\"'))));
        dados.put("linfocitos_tipicos_percentual", this.parseValor(lines.get(String.valueOf('#'))));
        dados.put("monocitos_contagem", this.parseValor(lines.get(String.valueOf('$'))));
        dados.put("monocitos_percentual", this.parseValor(lines.get(String.valueOf('%'))));
        dados.put("segmentados_contagem", this.parseValor(lines.get(String.valueOf('('))));
        dados.put("segmentados_percentual", this.parseValor(lines.get(String.valueOf(')'))));
        dados.put("basofilos_contagem", this.parseValor(lines.get(String.valueOf(','))));
        dados.put("basofilos_percentual", this.parseValor(lines.get(String.valueOf('-'))));
        dados.put("linfocitos_atipicos_contagem", this.parseValor(lines.get(String.valueOf('.'))));
        dados.put("linfocitos_atipicos_percentual", this.parseValor(lines.get(String.valueOf('/'))));
        dados.put("reticulocitos_contagem", this.parseValor(lines.get(String.valueOf('0'))));
        dados.put("reticulocitos_percentual", this.parseValor(lines.get(String.valueOf('1'))));
        dados.put("hemacias", this.parseValor(lines.get(String.valueOf('2'))));
        dados.put("hgb", this.parseValor(lines.get(String.valueOf('3'))));
        dados.put("hct", this.parseValor(lines.get(String.valueOf('4'))));
        dados.put("vcm", this.parseValor(lines.get(String.valueOf('5'))));
        dados.put("hcm", this.parseValor(lines.get(String.valueOf('6'))));
        dados.put("chcm", this.parseValor(lines.get(String.valueOf('7'))));
        dados.put("rdw", this.parseValor(lines.get(String.valueOf('8'))));
        dados.put("plaquetas", this.parseValor(lines.get(String.valueOf('@')), false));
        dados.put("vpm", this.parseValor(lines.get(String.valueOf('A'))));
        dados.put("pct", this.parseValor(lines.get(String.valueOf('B'))));
        dados.put("pdw", this.parseValor(lines.get(String.valueOf('C'))));
        dados.put("eosinofilos_percentual", this.parseValor(lines.get(String.valueOf('+'))));
        dados.put("eosinofilos_contagem", this.parseValor(lines.get(String.valueOf('*'))));
        return dados;
    }

    private Map<String, Object> trataLMG(HashMap<String, Object> lines, Map<String, Object> dados) throws Exception {
        String pct;
        dados.put("leucocitos", this.parseValor(lines.get(String.valueOf('!'))));
        dados.put("linfocitos_tipicos_contagem", this.parseValor(lines.get(String.valueOf('\"'))));
        dados.put("linfocitos_tipicos_percentual", this.parseValor(lines.get(String.valueOf('#'))));
        dados.put("monocitos_contagem", this.parseValor(lines.get(String.valueOf('$'))));
        dados.put("monocitos_percentual", this.parseValor(lines.get(String.valueOf('%'))));
        dados.put("granulocitos_contagem", this.parseValor(lines.get(String.valueOf('&'))));
        dados.put("granulocitos_percentual", this.parseValor(lines.get(String.valueOf('\''))));
        dados.put("hemacias", this.parseValor(lines.get(String.valueOf('2'))));
        dados.put("hgb", this.parseValor(lines.get(String.valueOf('3'))));
        dados.put("hct", this.parseValor(lines.get(String.valueOf('4'))));
        dados.put("vcm", this.parseValor(lines.get(String.valueOf('5'))));
        dados.put("hcm", this.parseValor(lines.get(String.valueOf('6'))));
        dados.put("chcm", this.parseValor(lines.get(String.valueOf('7'))));
        dados.put("rdw", this.parseValor(lines.get(String.valueOf('8'))));
        dados.put("plaquetas", this.parseValor(lines.get(String.valueOf('@')), false));
        dados.put("vpm", this.parseValor(lines.get(String.valueOf('A'))));
        String string = pct = lines.containsKey(String.valueOf('B')) ? lines.get(String.valueOf('B')).toString().trim() : "";
        if (pct.startsWith(".")) {
            pct = String.format("%s%s", "0", pct);
        }
        dados.put("pct", this.parseValor(pct));
        dados.put("pdw", this.parseValor(lines.get(String.valueOf('C'))));
        return dados;
    }

    private Map<String, Object> trataPadraoHistogramas(HashMap<String, Object> lines, Map<String, Object> dados) throws Exception {
        Object l = lines.get(String.valueOf('W'));
        if (l != null) {
            dados.put("pentra_histograma_wbc", this.parseImagem((String)l));
        }
        if ((l = lines.get(String.valueOf('X'))) != null) {
            dados.put("pentra_histograma_rbc", this.parseImagem((String)l));
        }
        if ((l = lines.get(String.valueOf('Y'))) != null) {
            dados.put("pentra_histograma_plt", this.parseImagem((String)l));
        }
        if ((l = lines.get(String.valueOf('Z'))) != null) {
            dados.put("pentra_histograma_bas", this.parseImagem((String)l));
        }
        return dados;
    }

    private Object parseValor(Object valor) {
        return this.parseValor(valor, true);
    }

    protected Object parseValor(Object valor, boolean removerPonto) {
        try {
            String s = valor.toString().trim();
            if (removerPonto) {
                s = s.replaceFirst("\\.", ",");
            }
            StringBuilder vlr = new StringBuilder(s);
            int pos = -1;
            pos = vlr.indexOf("l");
            if (pos > 0 || (pos = vlr.indexOf("L")) > 0) {
                vlr = vlr.deleteCharAt(pos);
            }
            pos = -1;
            pos = vlr.indexOf("H");
            if (pos > 0 || (pos = vlr.indexOf("h")) > 0) {
                vlr = vlr.deleteCharAt(pos);
            }
            pos = -1;
            pos = vlr.indexOf("S");
            if (pos > 0 || (pos = vlr.indexOf("s")) > 0) {
                vlr = vlr.deleteCharAt(pos);
            }
            pos = -1;
            pos = vlr.indexOf("A");
            if (pos > 0 || (pos = vlr.indexOf("a")) > 0) {
                vlr = vlr.deleteCharAt(pos);
            }
            pos = -1;
            pos = vlr.indexOf("B");
            if (pos > 0 || (pos = vlr.indexOf("b")) > 0) {
                vlr = vlr.deleteCharAt(pos);
            }
            pos = -1;
            pos = vlr.indexOf("R");
            if (pos > 0 || (pos = vlr.indexOf("r")) > 0) {
                vlr = vlr.deleteCharAt(pos);
            }
            return vlr.toString().trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getRecordTypeIdentifier(String record) {
        if (record != null && !record.equals("")) {
            char record_type = record.charAt(0);
            switch (record_type) {
                case 'A': {
                    return "A";
                }
                case 'a': {
                    return "A";
                }
                case 'B': {
                    return "B";
                }
                case 'b': {
                    return "B";
                }
                case 'C': {
                    return "C";
                }
                case 'c': {
                    return "C";
                }
                case 'D': {
                    return "D";
                }
                case 'd': {
                    return "D";
                }
                case 'E': {
                    return "E";
                }
                case 'e': {
                    return "E";
                }
                case 'F': {
                    return "F";
                }
                case 'f': {
                    return "F";
                }
                case 'G': {
                    return "G";
                }
                case 'g': {
                    return "G";
                }
            }
            return null;
        }
        return null;
    }

    protected void caracterNaoEsperado() throws Exception {
    }

    protected void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            this.verificarNegacao();
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    protected void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
            } else {
                this.enviarProximoFrame();
            }
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    protected void tratarEnquiry() throws Exception {
        if (this.isTX()) {
            this.abortarParaReceber();
        } else if (!this.isRX()) {
            this.prepararParaReceber();
        } else {
            this.prepararParaReceber();
        }
    }

    protected void tratarEndOfTX() throws Exception {
        if (this.isTX()) {
            if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
            } else {
                this.enviarProximoFrame();
            }
        } else {
            this.encerrarRecepcao();
        }
    }

    protected void tratarSOH() throws Exception {
        this.getPortaCOM().write(String.valueOf('\u0005'));
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        if (this.isTX()) {
            this.abortarTransmissao();
            this.setIdle();
        }
    }

    protected void verificarNegacao() throws Exception {
        if (this.isTX()) {
            if (this.tx_list.getUltimoLido() >= 0) {
                this.retransmitirRecusado();
            } else {
                this.abortarTransmissao();
            }
        } else if (this.isRX()) {
            this.caracterNaoEsperado();
        }
    }

    protected void encerrarRecepcao() {
        this.limpaDadosRequisicao();
        this.getPortaCOM().clearInputString();
        this.setIdle();
    }

    protected void retransmitirRecusado() throws Exception {
        if (this.tx_counter >= this.MAX_TENTATIVAS) {
            this.encerrarTransmissao();
            return;
        }
        int next = this.tx_list.getUltimoLido();
        if (next < this.tx_list.size()) {
            this.setTX(this.TIME_TX);
            this.getPortaCOM().write(this.tx_list.get(next));
        }
        ++this.tx_counter;
    }

    protected void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(this.TIME_TX_ABORTADO);
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    public String reenviarExames(String req_codigo, String rec_codigo, String pac_sexo, String pac_idade, String pac_nome, String hora, String data, String fil_codigo, String int_codigo, ArrayList<ExameMaterial> exames, String acao, String rackposition, String prioridade) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, exames.get(0).getCodigoMaterial(), rec_codigo, exames.get(0).getCodigo().toString(), acao);
    }

    protected String parseImagem(String message) {
        BufferedImage b = this.criarImagem(message);
        if (b == null) {
            return "";
        }
        if (!this.alturaGrafico.equals("128") || !this.larguraGrafico.equals("128")) {
            b = this.redimensionaImagem(b, Integer.parseInt(this.alturaGrafico), Integer.parseInt(this.larguraGrafico));
        }
        Image i = Toolkit.getDefaultToolkit().createImage(b.getSource());
        String foto64 = new Base64().encodeAsString(ImagemUtils.imageToByte(i));
        return foto64;
    }

    protected BufferedImage criarImagem(String channels) {
        if (!Funcoes.textoVazio(channels) && channels.length() == 128) {
            BufferedImage b = new BufferedImage(128, 128, 1);
            Graphics2D g = b.createGraphics();
            char[] c = channels.toCharArray();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, 128, 133);
            g.setColor(Color.BLACK);
            int x1 = 0;
            int y1 = 128;
            for (int x2 = 0; x2 < 128; ++x2) {
                int y2 = 128 - c[x2 / 2] + 30;
                g.drawLine(x1, y1, x2 + 1, y2);
                x1 = x2 + 1;
                y1 = y2;
            }
            return b;
        }
        return null;
    }

    private BufferedImage redimensionaImagem(Image originalImage, int scaledWidth, int scaledHeight) {
        BufferedImage scaledBI = new BufferedImage(scaledWidth, scaledHeight, 1);
        Graphics2D g = scaledBI.createGraphics();
        g.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null);
        g.dispose();
        return scaledBI;
    }

    private BufferedImage createImageMatrix(String matrix) {
        if (!Funcoes.textoVazio(matrix) && matrix.trim().length() == 4096) {
            BufferedImage b = new BufferedImage(16, 128, 1);
            Graphics2D g = b.createGraphics();
            char[] c = matrix.toCharArray();
            int x = 0;
            int y = 0;
            int j = 0;
            for (j = 0; j < 4096; j += 2) {
                char c1 = c[j];
                char c2 = c[j + 1];
                String s = "" + c1 + c2;
                int soma = Integer.parseInt(s, 16);
                Color l = new Color(soma, false);
                g.setColor(l);
                g.drawRect(x, y, 1, 1);
                ++x;
                if (j % 32 != 0) continue;
                x = 0;
                ++y;
            }
            return b;
        }
        return null;
    }

    private String decimalToBinary(int decimal) {
        String bin = "";
        while (decimal / 2 >= 1) {
            bin = decimal % 2 + bin;
            decimal /= 2;
        }
        bin = decimal + bin;
        return bin;
    }

    private int binaryToDecimal(String binary) {
        int decimal = 0;
        for (int i = 0; i < binary.length(); ++i) {
            decimal <<= 1;
            if (binary.charAt(i) != '1') continue;
            ++decimal;
        }
        return decimal;
    }

    protected void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    protected void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        this.threadRecebimento.start();
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceABXListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceABXListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

