/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame.remover;

import jalis.laboratorio.interfaceamento.liberacaoexame.remover.ExameInterfaceado;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

class TableRenderer
extends DefaultTableCellRenderer {
    protected ArrayList<ExameInterfaceado> exames = null;
    protected String[] colunas = null;
    protected JCheckBox check = new JCheckBox();
    protected ImageIcon repetindo = ImagemUtils.carregaImagemJalis("sit_repetindo.png");
    protected ImageIcon com_repeticao = ImagemUtils.carregaImagemJalis("sit_com_repeticao.png");
    protected ImageIcon com_excecao = ImagemUtils.carregaImagemJalis("sit_com_excecao.png");
    protected JLabel label_com_excecao = new JLabel(this.com_excecao, 0);
    protected JLabel label_repetindo = new JLabel(this.repetindo, 0);
    protected JLabel label_com_repeticao = new JLabel(this.com_repeticao, 0);
    protected JTable table = null;
    protected int colunaValidacao = -1;

    public int getColunaValidacao() {
        return this.colunaValidacao;
    }

    public void setColunaValidacao(int colunaValidacao) {
        this.colunaValidacao = colunaValidacao;
    }

    public TableRenderer(ArrayList<ExameInterfaceado> exames, String[] colunas, JTable table) {
        this.exames = exames;
        this.colunas = colunas;
        this.table = table;
        this.check.setHorizontalAlignment(0);
        this.label_repetindo.setOpaque(true);
        this.label_com_repeticao.setOpaque(true);
    }

    @Override
    public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
        JComponent c = this;
        int i = table.convertRowIndexToModel(row);
        ExameInterfaceado e = this.exames.get(i);
        if (this.colunaValidacao > -1 && column == this.colunaValidacao) {
            switch (Integer.parseInt(e.getIer_situacao())) {
                case 2: {
                    this.check.setSelected(false);
                    c = this.check;
                    break;
                }
                case 3: {
                    c = this.label_repetindo;
                    break;
                }
                case 5: {
                    c = this.label_repetindo;
                    break;
                }
                case 4: {
                    c = this.label_com_repeticao;
                    break;
                }
                case 7: {
                    this.check.setSelected(true);
                    c = this.check;
                    break;
                }
                case 6: {
                    c = this.label_com_excecao;
                    break;
                }
                default: {
                    c = new JLabel("a");
                }
            }
        }
        this.setValue(value);
        if (selected) {
            ((Component)c).setForeground(table.getSelectionForeground());
            ((Component)c).setBackground(table.getSelectionBackground());
        } else {
            ((Component)c).setBackground(table.getBackground());
            if (e.getReq_urgente()) {
                ((Component)c).setBackground(ScreenUtil.clarearCor(Color.RED, 200));
            }
        }
        try {
            Date dt = e.getExr_dataentregaprev();
            Date dtAtual = new Date();
            if (dt.before(dtAtual)) {
                ((Component)c).setForeground(Color.RED);
            } else if (Funcoes.hoje(Funcoes.formataData(dt))) {
                ((Component)c).setForeground(Color.BLUE);
            } else {
                ((Component)c).setForeground(table.getForeground());
            }
        }
        catch (Exception dt) {
            // empty catch block
        }
        ((Component)c).setFont(table.getFont());
        if (focused) {
            Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
            c.setBorder(border);
            if (!selected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    ((Component)c).setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    ((Component)c).setBackground(col);
                }
            }
        } else {
            c.setBorder(noFocusBorder);
        }
        return c;
    }

    public int getColIndice(String nome) {
        for (int i = 0; i < this.colunas.length; ++i) {
            if (!this.colunas[i].equalsIgnoreCase(nome)) continue;
            return i;
        }
        return -1;
    }
}

