/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame.remover;

import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.AbaPronto;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.ExameInterfaceado;
import jalis.laboratorio.interfaceamento.resultados.Exportacao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelExportacao
extends JPanel
implements ActionListener {
    protected JLabel labelContador = new JLabel(" ");
    protected JButton buttonCancelar = new BotaoNavegavel("Cancelar");
    protected ThreadExportacao threadExportacao;
    protected AbaPronto abaPronto = null;

    public PanelExportacao(AbaPronto abaPronto) {
        this.abaPronto = abaPronto;
        this.setBorder(ComponenteFactory.novoTitledEtchedBorder("Exporta\u00e7\u00e3o"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.labelContador, "West");
        this.buttonCancelar.setMargin(new Insets(2, 2, 2, 2));
        this.add((Component)this.buttonCancelar, "East");
        this.buttonCancelar.setEnabled(false);
        this.buttonCancelar.addActionListener(this);
        this.threadExportacao = new ThreadExportacao(this.labelContador, 100, Conexao.getStatement());
    }

    public void addExames(ArrayList<ExameInterfaceado> exames) {
        this.threadExportacao.addExames(exames);
    }

    public void restart() {
        if (this.threadExportacao != null && !this.threadExportacao.isInterrupted() && this.threadExportacao.isAlive()) {
            return;
        }
        this.buttonCancelar.setEnabled(true);
        if (!this.threadExportacao.isAlive()) {
            ArrayList exames = this.threadExportacao.exames;
            this.threadExportacao = new ThreadExportacao(this.labelContador, 100, Conexao.getStatement());
            this.threadExportacao.addExames(exames);
        }
        this.threadExportacao.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        }
    }

    private void cancelar() {
        try {
            this.threadExportacao.cancelar();
            Conexao.anulaSQL();
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "StatusExportacao: 88");
        }
    }

    protected void limpar() {
        this.buttonCancelar.setEnabled(false);
        this.labelContador.setText(" ");
    }

    protected class ThreadExportacao
    extends Thread {
        private JLabel labelContador;
        private int time;
        private ArrayList<ExameInterfaceado> exames = new ArrayList();
        private int col_req;
        private int col_int;
        private int col_exa;
        private int col_mco;
        private int col_rec;
        private int totalExames = 0;
        private boolean cancelar = false;
        private Statement st = null;

        public ThreadExportacao(JLabel labelContador, int time, Statement st) {
            this.labelContador = labelContador;
            this.setPriority(1);
            this.time = time;
            this.st = st;
        }

        public void addExames(ArrayList<ExameInterfaceado> exames) {
            this.exames.addAll(exames);
            this.totalExames += exames.size();
        }

        public void addExame(ExameInterfaceado exame) {
            this.exames.add(exame);
            ++this.totalExames;
        }

        public void cancelar() {
            this.cancelar = true;
        }

        @Override
        public void run() {
            try {
                while (this.exames.size() > 0 && !this.cancelar) {
                    this.labelContador.setText("Exportando " + Integer.toString(this.totalExames - this.exames.size() + 1) + " de " + Integer.toString(this.totalExames));
                    ExameInterfaceado exame = this.exames.get(0);
                    String req_codigo = exame.getReq_codigo();
                    String pac_nome = exame.getPac_nome();
                    String exa_codigo = exame.getExa_codigo();
                    String mco_codigo = exame.getMco_codigo();
                    String rec_codigo = exame.getRec_codigo();
                    String int_codigo = exame.getInt_codigo();
                    String fil_codigo = exame.getFil_codigo();
                    int situacao = BDUtil.getExmSituacao(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                    if (situacao == 8) {
                        String nomeSituacao = BDUtil.getReqSituacao(fil_codigo, req_codigo, exa_codigo, Integer.parseInt(mco_codigo));
                        String sit = Tipos.tipoSituacaoExame(nomeSituacao);
                        PanelExportacao.this.abaPronto.novaMensagem("Requisi\u00e7\u00e3o: " + req_codigo + ", Exame: " + exa_codigo + " - N\u00e3o pode ser exportado por encontrar-se como \"" + sit + "\"");
                        continue;
                    }
                    Exportacao.exportarExame(null, this.st, exame.getFil_codigo(), exame.getReq_codigo(), exame.getInt_codigo(), exame.getExa_codigo(), exame.getMco_codigo(), exame.getRec_codigo(), null, null);
                    this.exames.remove(0);
                    ThreadExportacao.sleep(this.time);
                }
                if (!this.cancelar) {
                    Conexao.arquivaSQL();
                    this.exames = new ArrayList();
                }
                PanelExportacao.this.limpar();
                PanelExportacao.this.abaPronto.reloadExames();
            }
            catch (InterruptedException ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                ex.printStackTrace();
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "StatusExportacao: 143");
                Funcoes.showErro(null, "A exporta\u00e7\u00e3o de exames ser\u00e1 encerrada.");
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                ex.printStackTrace();
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "StatusExportacao: 153");
                Funcoes.showErro(null, "A exporta\u00e7\u00e3o de exames ser\u00e1 encerrada.");
            }
        }
    }
}

