/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame.remover;

import jalis.comum.Conexao;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.AbaExcecoes;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.AbaPendente;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.AbaPronto;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.Equipamento;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.Filial;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.LiberacaoExameMensagem;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LiberacaoExame
extends FrmPadrao
implements ActionListener,
LiberacaoExameMensagem {
    public static final int SIT_PENDENTE = 1;
    public static final int SIT_PRONTO = 2;
    public static final int SIT_REPETINDO = 3;
    public static final int SIT_COM_REPETICAO = 4;
    public static final int SIT_PRONTO_VALIDADO = 7;
    private JPanel panelSouth = new JPanel(new BorderLayout());
    private JPanel panelFechar = new JPanel(new FlowLayout(2));
    private BotaoNavegavel buttonFechar = new BotaoNavegavel("Fechar", 'F');
    private JPanel panelCenter = new JPanel(new BorderLayout());
    private JTabbedPane tabCenter = new JTabbedPane();
    private AbaPendente abaPendente = new AbaPendente(this);
    private AbaPronto abaPronto = new AbaPronto(this);
    private AbaExcecoes abaExcecoes = new AbaExcecoes();
    private JPanel panelFiltro = new JPanel(new GridBagLayout());
    private JLabel labelEquipamento = new JLabel("Equipamento:");
    private JComboBox comboEquipamento = ComponenteFactory.novoJComboBox(this, true);
    private JLabel labelFilial = new JLabel("Filial:");
    private JComboBox comboFilial = ComponenteFactory.novoJComboBox(this, true);
    private JPanel panelLegenda = new JPanel(new FlowLayout(0));
    private CheckItemFiltro filtroDestino;
    private CheckItemFiltro filtroColeta;
    private JButton buttonFiltrar = new JButton("Filtrar");

    public LiberacaoExame() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Libera\u00e7\u00e3o de Exames", "Realiza a libera\u00e7\u00e3o de exames interfaceados", "interfac_conferencia.jpg");
        this.buttonFechar.addActionListener(this);
        this.panelFechar.add(this.buttonFechar);
        this.panelSouth.add((Component)this.panelFechar, "East");
        this.add((Component)this.panelSouth, "South");
        this.tabCenter.addTab("Processando", this.abaPendente);
        this.tabCenter.addTab("Prontos", this.abaPronto);
        this.tabCenter.addTab("Mensagens", this.abaExcecoes);
        this.panelCenter.add((Component)this.tabCenter, "Center");
        this.tabCenter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LiberacaoExame.this.filtrar();
            }
        });
        Dimension d = new Dimension(150, 25);
        String sql = "select a.col_codigo, a.col_descricao, a.fil_codigo, b.fil_descricao from coletas a left join filiais_postocoleta b on a.fil_codigo = b.fil_codigo";
        this.filtroColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando Locais de Coletas", "");
        this.filtroColeta.setDados(sql, new String[]{"col_codigo", "col_descricao", "fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "C\u00f3d. Filial", "Filial"}, new int[]{70, 0, 90, 0}, true);
        this.filtroColeta.setColunaHint(1);
        this.filtroColeta.setPreferredSize(d);
        sql = "select a.des_codigo, a.des_descricao, a.fil_codigo, b.fil_descricao from destino a left join filiais_postocoleta b on a.fil_codigo = b.fil_codigo";
        this.filtroDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando Locais de Destino", "");
        this.filtroDestino.setDados(sql, new String[]{"des_codigo", "des_descricao", "fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "C\u00f3d. Filia", "Filial"}, new int[]{70, 0, 90, 0}, true);
        this.filtroDestino.setColunaHint(1);
        this.filtroDestino.setPreferredSize(d);
        d = new Dimension(350, 20);
        this.comboEquipamento.setSize(d);
        this.comboEquipamento.setPreferredSize(d);
        this.comboEquipamento.setMaximumSize(d);
        this.comboEquipamento.setMinimumSize(d);
        this.comboEquipamento.setAutoscrolls(true);
        this.comboFilial.setSize(d);
        this.comboFilial.setPreferredSize(d);
        this.comboFilial.setMaximumSize(d);
        this.comboFilial.setMinimumSize(d);
        this.comboFilial.setAutoscrolls(true);
        this.comboFilial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiberacaoExame.this.atualizaFiltros();
            }
        });
        d = new Dimension(80, 20);
        this.buttonFiltrar.setSize(d);
        this.buttonFiltrar.setPreferredSize(d);
        this.buttonFiltrar.setMaximumSize(d);
        this.buttonFiltrar.setMinimumSize(d);
        this.buttonFiltrar.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 1;
        this.panelFiltro.add((Component)this.labelFilial, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.panelFiltro.add((Component)this.comboFilial, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        this.panelFiltro.add((Component)this.filtroColeta, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.panelFiltro.add((Component)this.filtroDestino, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.panelFiltro.add((Component)this.labelEquipamento, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.panelFiltro.add((Component)this.comboEquipamento, c);
        c.gridx += 3;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        this.panelFiltro.add((Component)new JPanel(), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelFiltro.add((Component)this.buttonFiltrar, c);
        this.panelCenter.add((Component)this.panelFiltro, "North");
        this.add((Component)this.panelCenter, "Center");
        FlowLayout flow = (FlowLayout)this.panelLegenda.getLayout();
        flow.setVgap(0);
        JPanel panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(10, 10));
        panelCorLegenda.setBackground(Color.RED);
        this.panelLegenda.add(panelCorLegenda);
        JLabel labelLegenda = new JLabel("Atrasado");
        Font font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        this.panelLegenda.add(labelLegenda);
        panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(10, 10));
        panelCorLegenda.setBackground(Color.BLUE);
        this.panelLegenda.add(panelCorLegenda);
        labelLegenda = new JLabel("No Prazo");
        labelLegenda.setFont(font);
        this.panelLegenda.add(labelLegenda);
        panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(10, 10));
        panelCorLegenda.setBackground(Color.BLACK);
        this.panelLegenda.add(panelCorLegenda);
        labelLegenda = new JLabel("Entrega Futura");
        labelLegenda.setFont(font);
        this.panelLegenda.add(labelLegenda);
        panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(10, 10));
        panelCorLegenda.setBackground(ScreenUtil.clarearCor(Color.RED, 200));
        this.panelLegenda.add(panelCorLegenda);
        JLabel labelUrgente = new JLabel("Urgente");
        labelUrgente.setBackground(ScreenUtil.clarearCor(Color.RED, 200));
        labelUrgente.setOpaque(true);
        labelUrgente.setFont(font);
        this.panelLegenda.add(labelUrgente);
        JLabel labelAtalhos = new JLabel("[F6] Processando     [F7] Prontos     [F8] Mensagens");
        labelAtalhos.setFont(font);
        this.panelLegenda.add(labelAtalhos);
        this.panelSouth.add((Component)this.panelLegenda, "Center");
        this.inserirAcaoDeTecla("F6", "atalhoF6", new AbstractAction("atalhoF6"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiberacaoExame.this.tabCenter.setSelectedComponent(LiberacaoExame.this.abaPendente);
            }
        });
        this.inserirAcaoDeTecla("F7", "atalhoF7", new AbstractAction("atalhoF7"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiberacaoExame.this.tabCenter.setSelectedComponent(LiberacaoExame.this.abaPronto);
            }
        });
        this.inserirAcaoDeTecla("F8", "atalhoF8", new AbstractAction("atalhoF8"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiberacaoExame.this.tabCenter.setSelectedComponent(LiberacaoExame.this.abaExcecoes);
            }
        });
        Statement st = Conexao.getStatement();
        String sqlFilial = "select fil_codigo, fil_descricao from filiais_postocoleta order by fil_codigo";
        try {
            ResultSet rs = Conexao.executeQuery(st, sqlFilial);
            while (rs.next()) {
                Filial f = new Filial(rs.getInt("fil_codigo"), rs.getString("fil_descricao"));
                this.comboFilial.addItem(f);
            }
        }
        catch (SQLException e1) {
            try {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "LiberacaoExame:264");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1010070001");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonFiltrar) {
            this.filtrar();
        }
    }

    private void atualizaFiltros() {
        this.filtroColeta.clear();
        this.filtroDestino.clear();
        if (this.comboFilial.getSelectedIndex() < 0) {
            return;
        }
        Filial f = (Filial)this.comboFilial.getSelectedItem();
        this.comboEquipamento.removeAllItems();
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct int_codigo, int_descricao from interface where fil_codigo = ");
        sql.append(f.getCodigo());
        sql.append(" order by int_descricao ");
        try {
            Statement st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, sql);
            while (rs.next()) {
                this.comboEquipamento.addItem(new Equipamento(rs.getInt("int_codigo"), rs.getString("int_descricao")));
            }
            Conexao.fecharStatement(st);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "LiberacaoExame: 232");
        }
        this.filtroColeta.setFiltro("a.fil_codigo = " + Integer.toString(f.getCodigo()));
        this.filtroDestino.setFiltro("a.fil_codigo = " + Integer.toString(f.getCodigo()));
    }

    private void filtrar() {
        if (this.comboEquipamento.getSelectedItem() == null || this.comboFilial.getSelectedItem() == null) {
            return;
        }
        Filial f = (Filial)this.comboFilial.getSelectedItem();
        String[] coletas = this.filtroColeta.getSelecionados(0);
        String[] destinos = this.filtroDestino.getSelecionados(0);
        this.abaPendente.setFiliais(new String[]{Integer.toString(f.getCodigo())});
        this.abaPendente.setColetas(coletas);
        this.abaPendente.setDestinos(destinos);
        this.abaPendente.setEquipamento(((Equipamento)this.comboEquipamento.getSelectedItem()).getCodigo());
        this.abaPendente.reloadExames();
        this.abaPronto.setFiliais(new String[]{Integer.toString(f.getCodigo())});
        this.abaPronto.setColetas(coletas);
        this.abaPronto.setDestinos(destinos);
        this.abaPronto.setEquipamento(((Equipamento)this.comboEquipamento.getSelectedItem()).getCodigo());
        this.abaPronto.reloadExames();
    }

    @Override
    public void mensagemEnviada(String mensagem) {
        this.abaExcecoes.addMensagem(mensagem);
    }

    protected void inserirAcaoDeTecla(String key_stroke, String action_name, AbstractAction action) {
        this.getInputMap(0).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getActionMap().put(action_name, action);
    }
}

