/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame.remover;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.AbaPadrao;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.ExameInterfaceado;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.LiberacaoExameMensagem;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.PanelExportacao;
import jalis.laboratorio.interfaceamento.resultados.EditarResultado;
import jalis.laboratorio.interfaceamento.resultados.Exportacao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DialogUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;

@Deprecated
public class AbaPronto
extends AbaPadrao {
    private static String[] colunas = new String[]{"C\u00f3digo", "Paciente", "Sexo", "Idade", "Mat.", "Exame", "Quanti", "Quali", "Situa\u00e7\u00e3o"};
    private static int IDX_CODIGO = 0;
    private static int IDX_NOME = 1;
    private static int IDX_SEXO = 2;
    private static int IDX_IDADE = 3;
    private static int IDX_MATERIAL = 4;
    private static int IDX_EXAME = 5;
    private static int IDX_RESQUANTI = 6;
    private static int IDX_RESQUALI = 7;
    private static int IDX_SITUACAO = 8;
    private JPanel panelNorth = new JPanel(new BorderLayout());
    private JPanel panelValidados = new JPanel(new FlowLayout(0));
    private JPanel panelLinha = new JPanel(new FlowLayout(0));
    private PanelExportacao panelExportacao = new PanelExportacao(this);
    private JButton buttonExportarValidados = new JButton("Exportar");
    private JButton buttonExportar = new JButton("Exportar");
    private JButton buttonExcluir = new JButton("Excluir");

    public AbaPronto(LiberacaoExameMensagem liberacaoExameMensagem) {
        super(colunas, liberacaoExameMensagem);
        int[] size = new int[]{90, 0, 40, 65, 50, 50, 70, 70, 55};
        this.setTamanhoColunas(size);
        this.tabela.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AbaPronto.this.tabelaMouseClicked(e);
            }
        });
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AbaPronto.this.tabelaKeyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                AbaPronto.this.tabelaKeyPressed(e);
            }
        });
        this.add((Component)this.panelNorth, "North");
        this.panelNorth.add((Component)this.panelValidados, "West");
        this.panelNorth.add((Component)this.panelLinha, "Center");
        this.panelNorth.add((Component)this.panelExportacao, "East");
        FlowLayout fl = (FlowLayout)this.panelValidados.getLayout();
        fl.setVgap(1);
        fl.setHgap(1);
        this.panelValidados.setLayout(fl);
        fl = (FlowLayout)this.panelLinha.getLayout();
        fl.setVgap(1);
        fl.setHgap(1);
        this.panelLinha.setLayout(fl);
        this.panelValidados.setBorder(BorderFactory.createTitledBorder("Validados"));
        this.panelLinha.setBorder(BorderFactory.createTitledBorder("Linha Selecionada"));
        Insets i = new Insets(1, 1, 1, 1);
        this.buttonExportarValidados.setMargin(i);
        this.buttonExcluir.setMargin(i);
        this.buttonExportar.setMargin(i);
        this.panelValidados.add(this.buttonExportarValidados);
        this.panelLinha.add(this.buttonExcluir);
        this.panelLinha.add(this.buttonExportar);
        this.buttonExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AbaPronto.this.tabela.convertRowIndexToModel(AbaPronto.this.tabela.getSelectedRow());
                if (row >= 0 && AbaPronto.this.tabela.getRowCount() > 0) {
                    AbaPronto.this.excluirExame(row);
                }
            }
        });
        this.buttonExportar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Acesso.getAcesso(1001003003L)) {
                    int resposta;
                    int row = AbaPronto.this.tabela.convertRowIndexToModel(AbaPronto.this.tabela.getSelectedRow());
                    ExameInterfaceado ei = (ExameInterfaceado)AbaPronto.this.exames.get(row);
                    int sit = Integer.parseInt(ei.getIer_situacao());
                    if (row >= 0 && row < AbaPronto.this.tabela.getRowCount() && (sit == 7 || sit == 4) && (resposta = Funcoes.showPerguntaSimNao(Laboratorio.getInstancia(), "Exportar exame \u00fanico", "Exportar o exame selecionado?")) == 0) {
                        Laboratorio.getInstancia().setCursor(Cursor.getPredefinedCursor(3));
                        AbaPronto.this.liberarUm(row);
                        AbaPronto.this.reloadExames();
                    }
                } else {
                    AbaPronto.this.novaMensagem("Voc\u00ea n\u00e3o possui acesso para liberar exames");
                }
            }
        });
        this.buttonExportarValidados.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (AbaPronto.this.exames == null || AbaPronto.this.exames.isEmpty()) {
                    return;
                }
                if (Acesso.getAcesso(1001003002L)) {
                    ArrayList<ExameInterfaceado> examesProntos = new ArrayList<ExameInterfaceado>();
                    int row = 0;
                    for (ExameInterfaceado e : AbaPronto.this.exames) {
                        if (e.getIer_situacao().equalsIgnoreCase(Integer.toString(7))) {
                            examesProntos.add(e);
                            continue;
                        }
                        ++row;
                    }
                    if (examesProntos.size() == 0) {
                        AbaPronto.this.novaMensagem("N\u00e3o h\u00e1 exames validados.");
                        return;
                    }
                    for (ExameInterfaceado e : examesProntos) {
                        AbaPronto.this.exames.remove(e);
                    }
                    AbaPronto.this.limparExames();
                    AbaPronto.this.popularExames();
                    int resposta = Funcoes.showPerguntaSimNao(Laboratorio.getInstancia(), "Exportar exames", "Exportar exames validados?");
                    if (resposta == 0) {
                        AbaPronto.this.setCursor(Cursor.getPredefinedCursor(3));
                        AbaPronto.this.exportarValidados(examesProntos);
                        AbaPronto.this.setCursor(Cursor.getDefaultCursor());
                    } else {
                        AbaPronto.this.reloadExames();
                    }
                } else {
                    AbaPronto.this.novaMensagem("Voc\u00ea n\u00e3o possui permiss\u00e3o para exportar exames.");
                }
                Laboratorio.getInstancia().setCursor(Cursor.getPredefinedCursor(3));
                System.gc();
                Laboratorio.getInstancia().setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    void tabelaMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            Point p = e.getPoint();
            int row = this.tabela.rowAtPoint(p);
            row = this.tabela.convertRowIndexToModel(row);
            ExameInterfaceado ei = (ExameInterfaceado)this.exames.get(row);
            int sit = Integer.parseInt(ei.getIer_situacao());
            int column = this.tabela.columnAtPoint(p);
            if (column == IDX_SITUACAO) {
                if (sit != 3 && sit != 4) {
                    this.setValidado(row, !e.isControlDown());
                } else {
                    this.novaMensagem(sit == 3 ? "Exames em repeti\u00e7\u00e3o n\u00e3o podem ser validados." : "Exames com resultados de repeti\u00e7\u00e3o devem ser editados antes de serem validados.");
                }
            } else if (sit == 4 || sit == 2) {
                this.editarResultado(row);
            } else {
                String msg = sit == 3 ? "O exame est\u00e1 aguardando resultados da repeti\u00e7\u00e3o e n\u00e3o pode ser editado." : "O exame est\u00e1 validado para exporta\u00e7\u00e3o e n\u00e3o pode ser editado. Desmarque-o e tente novamente.";
                this.novaMensagem(msg);
            }
        }
    }

    public void tabelaKeyTyped(KeyEvent e) {
        if (e.isAltDown()) {
            e.consume();
        } else if (e.getKeyChar() == '\u007f') {
            int row = this.tabela.convertRowIndexToModel(this.tabela.getSelectedRow());
            if (row >= 0 && this.tabela.getRowCount() > 0) {
                this.excluirExame(row);
            }
        } else if (e.getKeyChar() == ' ') {
            int row = this.tabela.convertRowIndexToModel(this.tabela.getSelectedRow());
            if (row >= 0 && this.tabela.getRowCount() > 0) {
                this.editarResultado(row);
            }
            this.tabela.grabFocus();
        } else {
            this.tabela.grabFocus();
        }
    }

    void tabelaKeyPressed(KeyEvent e) {
        block7: {
            int row;
            block6: {
                row = this.tabela.convertRowIndexToModel(this.tabela.getSelectedRow());
                if (e.getKeyCode() == 121) break block6;
                if (e.getKeyCode() != 120) break block7;
            }
            if (this.tabela.getRowCount() > 0 && row >= 0) {
                ExameInterfaceado ei = (ExameInterfaceado)this.exames.get(row);
                String sit = ei.getIer_situacao();
                if (!sit.equals("3") && !sit.equals("4")) {
                    this.setValidado(row, !e.isControlDown());
                } else {
                    this.novaMensagem(sit.equals("3") ? "Exames em repeti\u00e7\u00e3o n\u00e3o podem ser validados." : "Exames com resultados de repeti\u00e7\u00e3o devem ser editados antes de serem validados.");
                }
            }
        }
    }

    public void setValidado(int row, boolean validacao) {
        if (row >= 0 && row < this.tabela.getRowCount()) {
            try {
                ExameInterfaceado e = (ExameInterfaceado)this.exames.get(row);
                if (!this.validaSituacaoExame(e)) {
                    return;
                }
                Statement st = Conexao.getStatement();
                int situacao = validacao ? 7 : 2;
                String user_code = Variaveis.login;
                BDUtil.setExmSituacaoEAssinatura(st, e.getFil_codigo(), e.getInt_codigo(), e.getReq_codigo(), e.getExa_codigo(), e.getMco_codigo(), e.getRec_codigo(), situacao, user_code);
                if (BDUtil.isExameDesmembrado(e.getFil_codigo(), e.getInt_codigo(), e.getExa_codigo(), e.getMco_codigo())) {
                    BDUtil.setExmSituacaoTodosFilhos(st, e.getFil_codigo(), e.getInt_codigo(), e.getReq_codigo(), e.getExa_codigo(), e.getMco_codigo(), e.getRec_codigo(), situacao);
                }
                Conexao.arquivaSQL();
                this.tabela.setValueAt(String.valueOf(situacao), this.tabela.convertRowIndexToView(row), IDX_SITUACAO);
                this.stepSelection();
                st.close();
                this.reloadLinha(row);
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    this.reloadExames();
                }
                catch (SQLException ex1) {
                    ErrorLogger.mostraMensagem(this, ex1.getMessage(), ex1.getStackTrace());
                }
                this.novaMensagem("Erro ao acessar BD enquanto alterando valida\u00e7\u00e3o do exame. " + ex.getMessage());
            }
        }
    }

    public void editarResultado(int row) {
        block10: {
            if (Acesso.getAcesso(1001003005L)) {
                try {
                    if (this.tabela.getRowCount() <= 0) break block10;
                    ExameInterfaceado e = (ExameInterfaceado)this.exames.get(row);
                    String req_codigo = e.getReq_codigo();
                    String pac_nome = e.getPac_nome();
                    String pac_sexo = e.getPac_sexo();
                    String exa_codigo = e.getExa_codigo();
                    String mco_codigo = e.getMco_codigo();
                    String rec_codigo = e.getRec_codigo();
                    String int_codigo = e.getInt_codigo();
                    String metCodigo = e.getMetCodigo();
                    String fil_codigo = e.getFil_codigo();
                    String usr_codigo = Variaveis.login;
                    Statement st = Conexao.getStatement();
                    int situacao = BDUtil.getExmSituacao(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                    boolean permiteSalvar = true;
                    if (situacao == 3 || situacao == 5) {
                        permiteSalvar = false;
                    }
                    if (situacao != 7 && situacao != 4 && situacao != 8) {
                        EditarResultado dlg = new EditarResultado(Laboratorio.getInstancia(), st, fil_codigo, int_codigo, false, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, pac_sexo, usr_codigo, null, permiteSalvar, false, metCodigo, null);
                        if (!dlg.isMontada()) {
                            return;
                        }
                        DialogUtil.centerAndShow(dlg, true, false);
                        if (dlg.fechouSalvar()) {
                            this.reloadLinha(row);
                            this.stepSelection();
                        } else if (dlg.fechouSalvarEExportar()) {
                            this.reloadExames();
                        }
                        break block10;
                    }
                    String msg = "";
                    msg = situacao == 7 || situacao == 4 ? "Exame j\u00e1 validado! Somente exames n\u00e3o validados podem ser editados." : "Exame j\u00e1 exportado! Somente exames n\u00e3o exportados podem ser editados.";
                    Funcoes.mensagem(this, msg, 2);
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
            } else {
                this.novaMensagem("Voc\u00ea n\u00e3o possui permiss\u00e3o para editar resultados");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excluirExame(int row) {
        if (Acesso.getAcesso(1001003001L)) {
            try {
                ExameInterfaceado e = (ExameInterfaceado)this.exames.get(row);
                String req_codigo = e.getReq_codigo();
                String pac_nome = e.getPac_nome();
                String exa_codigo = e.getExa_codigo();
                String mco_codigo = e.getMco_codigo();
                String rec_codigo = e.getRec_codigo();
                String fil_codigo = e.getFil_codigo();
                String int_codigo = e.getInt_codigo();
                StringBuilder msg = new StringBuilder("Tem certeza que deseja excluir o exame selecionado de ");
                msg.append(pac_nome);
                msg.append("?");
                int answer = Funcoes.showPerguntaSimNao(Laboratorio.getInstancia(), "", msg.toString());
                if (answer == 0) {
                    Statement st = Conexao.getStatement();
                    this.gravaLogExclusaoRequisicao(this, st, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exa_codigo, "Pronto");
                    BDUtil.deletarExame(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                    Conexao.arquivaSQL();
                    st.close();
                    this.reloadExames();
                    this.novaMensagem("Exame exclu\u00eddos com sucesso deste interfaceamento");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                finally {
                    this.reloadExames();
                }
            }
            this.tabela.grabFocus();
        } else {
            this.novaMensagem("Voc\u00ea n\u00e3o possui acesso para excluir exames");
        }
    }

    @Override
    public void popularExames() {
        if (this.exames == null) {
            return;
        }
        for (ExameInterfaceado e : this.exames) {
            Object[] linha = new Object[colunas.length];
            String codigo = Funcoes.preencheZero(e.getFil_codigo(), ParametrosGerais.getDigitosTuboFilial());
            codigo = codigo + Funcoes.preencheZero(e.getReq_codigo(), ParametrosGerais.getDigitosTuboRequisicao());
            linha[0] = codigo;
            linha[1] = e.getPac_nome();
            linha[2] = e.getPac_sexo();
            linha[3] = e.getPac_idade();
            linha[4] = e.getMco_descricao();
            linha[5] = e.getExa_codigo();
            if (!Funcoes.textoVazio(e.getIer_xmlvalores())) {
                Map<String, Object> dados = StringUtil.getMapDeXML(e.getIer_xmlvalores());
                String text = (String)dados.get("resultado_quantitativo");
                String valor = text == null || text.equals("null") ? "" : text;
                linha[6] = valor;
                text = (String)dados.get("repeticao_quantitativo");
                valor = text == null || text.equals("null") ? "" : text;
                linha[7] = valor;
            } else {
                linha[6] = null;
                linha[7] = null;
            }
            linha[8] = e.getIer_situacao();
            this.addLinha(linha);
        }
    }

    @Override
    protected void reloadExames() {
        int i;
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlwhere = new StringBuilder();
        sql.append("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, b.req_data, ");
        sql.append("b.req_hora, b.req_anomes, b.req_idade, c.pac_nome, c.pac_sexo, d.mco_abreviatura, ");
        sql.append("e.exr_dataentregaprev, a.ier_rackpos, (b.req_urgente or (coalesce(e.exr_urgente, false))) as req_urgente, a.int_codigo, f.emi_alternativo, a.ier_situacao, a.ier_xmlvalores, f.met_codigo ");
        sql.append("from interfaceexamerequisicao a ");
        sql.append("left join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
        sql.append("left join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
        sql.append("left join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
        sql.append("left join examerequisicao e on a.fil_codigo=e.fil_codigo and a.req_codigo=e.req_codigo ");
        sql.append(" and a.exa_codigo=e.exa_codigo and a.mco_codigo=e.mco_codigo ");
        sql.append("left join examematinterface f on a.fil_codigo=f.fil_codigo and a.exa_codigo=f.exa_codigo and a.mco_codigo=f.mco_codigo and a.int_codigo=f.int_codigo ");
        sql.append(" where ");
        if (this.filiais != null && this.filiais.length > 0) {
            sqlwhere.append(" a.fil_codigo  in (");
            for (i = 0; i < this.filiais.length; ++i) {
                if (i > 0) {
                    sqlwhere.append(", ");
                }
                sqlwhere.append(this.filiais[i]);
            }
            sqlwhere.append(")");
        }
        if (this.coletas != null && this.coletas.length > 0) {
            if (sqlwhere.length() > 0) {
                sqlwhere.append(" and ");
            }
            sqlwhere.append(" b.col_codigo  in (");
            for (i = 0; i < this.coletas.length; ++i) {
                if (i > 0) {
                    sqlwhere.append(", ");
                }
                sqlwhere.append("'").append(this.coletas[i]).append("'");
            }
            sqlwhere.append(")");
        }
        if (this.destinos != null && this.destinos.length > 0) {
            if (sqlwhere.length() > 0) {
                sqlwhere.append(" and ");
            }
            sqlwhere.append(" b.des_codigo  in (");
            for (i = 0; i < this.destinos.length; ++i) {
                if (i > 0) {
                    sqlwhere.append(", ");
                }
                sqlwhere.append("'").append(this.destinos[i]).append("'");
            }
            sqlwhere.append(")");
        }
        sql.append(sqlwhere.toString());
        if (sqlwhere.length() > 0) {
            sql.append(" and ");
        }
        sql.append(" a.int_codigo = ").append(this.equipamento);
        sql.append(" and a.ier_situacao >= ").append(2);
        sql.append(" and a.ier_situacao <= ").append(7);
        sql.append(" order by a.fil_codigo, a.req_codigo, a.rec_codigo, a.exa_codigo ");
        this.setExames(this.executeSql(st, sql.toString()), IDX_SITUACAO);
        Conexao.fecharStatement(st);
    }

    public void reloadLinha(int row) {
        if (row >= 0 && row < this.tabela.getRowCount()) {
            ExameInterfaceado e = (ExameInterfaceado)this.exames.get(row);
            String req_codigo = e.getReq_codigo();
            String exa_codigo = e.getExa_codigo();
            String mco_codigo = e.getMco_codigo();
            String rec_codigo = e.getRec_codigo();
            String fil_codigo = e.getFil_codigo();
            String int_codigo = e.getInt_codigo();
            try {
                Exame exame = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                int situacao = exame.getSituacaoExame();
                e.setIer_situacao(Integer.toString(situacao));
                row = this.tabela.convertRowIndexToView(row);
                Map<String, Object> dados = exame.getDados();
                String xml = StringUtil.getXMLDeMap(dados);
                String text = (String)dados.get("resultado_quantitativo");
                String valor = text == null || text.equals("null") ? "" : text;
                this.tabela.setValueAt(valor, row, IDX_RESQUANTI);
                text = (String)dados.get("repeticao_quantitativo");
                valor = text == null || text.equals("null") ? "" : text;
                this.tabela.setValueAt(valor, row, IDX_RESQUALI);
                this.tabela.setValueAt(String.valueOf(situacao), row, IDX_SITUACAO);
                this.tabela.revalidate();
                this.tabela.repaint();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "reloadLinha");
                this.reloadExames();
            }
        }
    }

    private void liberarUm(int row) {
        try {
            ExameInterfaceado e = (ExameInterfaceado)this.exames.get(row);
            String req_codigo = e.getReq_codigo();
            String exa_codigo = e.getExa_codigo();
            String mco_codigo = e.getMco_codigo();
            String rec_codigo = e.getRec_codigo();
            String int_codigo = e.getInt_codigo();
            String fil_codigo = e.getFil_codigo();
            String usr_codigo = e.getUsr_codigo();
            Conexao.arquivaSQL();
            Exportacao.exportarExame(null, Conexao.getStatement(), fil_codigo, req_codigo, int_codigo, exa_codigo, mco_codigo, rec_codigo, usr_codigo, null, null);
            Conexao.arquivaSQL();
            this.reloadExames();
            Funcoes.mensagem(this, "O exame  " + exa_codigo + " da requisi\u00e7\u00e3o " + req_codigo + " exportado com sucesso", 2);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                this.reloadExames();
            }
            catch (SQLException ex2) {
                ErrorLogger.mostraMensagem(this, ex2.getMessage(), ex2.getStackTrace());
            }
        }
    }

    private void exportarValidados(ArrayList<ExameInterfaceado> examesProntos) {
        this.buttonExportarValidados.setEnabled(false);
        this.buttonExportar.setEnabled(false);
        try {
            this.panelExportacao.addExames(examesProntos);
            this.panelExportacao.restart();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                this.reloadExames();
            }
            catch (SQLException ex2) {
                ErrorLogger.mostraMensagem(this, ex2.getMessage(), ex2.getStackTrace());
            }
        }
        this.buttonExportar.setEnabled(true);
        this.buttonExportarValidados.setEnabled(true);
        this.reloadExames();
    }

    private boolean validaSituacaoExame(ExameInterfaceado exame) throws SQLException {
        Registro rs = BDUtil.getDadosExameRequisicaoJalis(exame.getFil_codigo(), exame.getReq_codigo(), exame.getExa_codigo(), exame.getMco_codigo());
        if (rs != null) {
            String exr_situacao = rs.getString("exr_situacao");
            if (exr_situacao.equalsIgnoreCase("L")) {
                Funcoes.mensagem(this, "O Exame j\u00e1 encontra-se lan\u00e7ado", 2);
                return false;
            }
            if (exr_situacao.equalsIgnoreCase("C")) {
                Funcoes.mensagem(this, "O Exame j\u00e1 encontra-se conferido", 2);
                return false;
            }
            if (exr_situacao.equalsIgnoreCase("I")) {
                Funcoes.mensagem(this, "O Exame j\u00e1 encontra-se impresso", 2);
                return false;
            }
            if (exr_situacao.equalsIgnoreCase("E")) {
                Funcoes.mensagem(this, "O Exame j\u00e1 encontra-se entregue", 2);
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    protected DefaultTableModel createModel() {
        return new DefaultTableModel(null, colunas){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            public Class getColumnClass(int column) {
                if (this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null) {
                    return this.getValueAt(0, column).getClass();
                }
                return Object.class;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return super.getValueAt(row, col);
            }
        };
    }
}

