/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame.remover;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.AbaPadrao;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.ExameInterfaceado;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.LiberacaoExameMensagem;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public class AbaPendente
extends AbaPadrao {
    private static String[] colunas = new String[]{"C\u00f3digo", "Paciente", "Sexo", "Idade", "Data", "Hora", "Mat.", "Exame"};
    private JPanel panelNorth = new JPanel(new BorderLayout());
    private JPanel panelLinha = new JPanel(new FlowLayout(0));
    private JButton buttonExcluir = new JButton("Excluir");

    public AbaPendente(LiberacaoExameMensagem liberacaoExameMensagem) {
        super(colunas, liberacaoExameMensagem);
        int[] size = new int[]{90, 0, 40, 65, 80, 50, 50, 55};
        this.setTamanhoColunas(size);
        this.add((Component)this.panelNorth, "North");
        this.panelNorth.add((Component)this.panelLinha, "Center");
        FlowLayout fl = (FlowLayout)this.panelLinha.getLayout();
        fl.setVgap(1);
        fl.setHgap(1);
        this.panelLinha.setLayout(fl);
        this.panelLinha.setBorder(BorderFactory.createTitledBorder("Linha Selecionada"));
        this.panelLinha.add(this.buttonExcluir);
        this.buttonExcluir.setMargin(new Insets(1, 1, 1, 1));
        this.buttonExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AbaPendente.this.tabela.convertRowIndexToModel(AbaPendente.this.tabela.getSelectedRow());
                if (row >= 0 && AbaPendente.this.tabela.getRowCount() > 0) {
                    AbaPendente.this.excluirExame(row);
                }
            }
        });
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AbaPendente.this.tabelaKeyTyped(e);
            }
        });
    }

    @Override
    public void popularExames() {
        if (this.exames == null) {
            return;
        }
        for (ExameInterfaceado e : this.exames) {
            Object[] linha = new Object[colunas.length];
            String codigo = Funcoes.preencheZero(e.getFil_codigo(), ParametrosGerais.getDigitosTuboFilial());
            codigo = codigo + Funcoes.preencheZero(e.getReq_codigo(), ParametrosGerais.getDigitosTuboRequisicao());
            linha[0] = codigo;
            linha[1] = e.getPac_nome();
            linha[2] = e.getPac_sexo();
            linha[3] = e.getPac_idade();
            linha[4] = Funcoes.formataData("dd/MM/yyyy", e.getReq_data());
            linha[5] = Funcoes.formataData("HH:mm", e.getReq_hora());
            linha[6] = e.getMco_descricao();
            linha[7] = e.getExa_codigo();
            this.addLinha(linha);
        }
    }

    @Override
    protected void reloadExames() {
        int i;
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlwhere = new StringBuilder();
        sql.append("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, b.req_data, ");
        sql.append("b.req_hora, b.req_anomes, b.req_idade, c.pac_nome, c.pac_sexo, d.mco_abreviatura, ");
        sql.append("e.exr_dataentregaprev, a.ier_rackpos, (b.req_urgente or (coalesce(e.exr_urgente, false))) as req_urgente, a.int_codigo, f.emi_alternativo, a.ier_situacao, a.ier_xmlvalores, f.met_codigo ");
        sql.append("from interfaceexamerequisicao a ");
        sql.append("left join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
        sql.append("left join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
        sql.append("left join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
        sql.append("left join examerequisicao e on a.fil_codigo=e.fil_codigo and a.req_codigo=e.req_codigo ");
        sql.append(" and a.exa_codigo=e.exa_codigo and a.mco_codigo=e.mco_codigo ");
        sql.append("left join examematinterface f on a.fil_codigo=f.fil_codigo and a.exa_codigo=f.exa_codigo and a.mco_codigo=f.mco_codigo and a.int_codigo=f.int_codigo ");
        sql.append(" where ");
        if (this.filiais != null && this.filiais.length > 0) {
            sqlwhere.append(" a.fil_codigo  in (");
            for (i = 0; i < this.filiais.length; ++i) {
                if (i > 0) {
                    sqlwhere.append(", ");
                }
                sqlwhere.append(this.filiais[i]);
            }
            sqlwhere.append(")");
        }
        if (this.coletas != null && this.coletas.length > 0) {
            if (sqlwhere.length() > 0) {
                sqlwhere.append(" and ");
            }
            sqlwhere.append(" b.col_codigo  in (");
            for (i = 0; i < this.coletas.length; ++i) {
                if (i > 0) {
                    sqlwhere.append(", ");
                }
                sqlwhere.append("'").append(this.coletas[i]).append("'");
            }
            sqlwhere.append(")");
        }
        if (this.destinos != null && this.destinos.length > 0) {
            if (sqlwhere.length() > 0) {
                sqlwhere.append(" and ");
            }
            sqlwhere.append(" b.des_codigo  in (");
            for (i = 0; i < this.destinos.length; ++i) {
                if (i > 0) {
                    sqlwhere.append(", ");
                }
                sqlwhere.append("'").append(this.destinos[i]).append("'");
            }
            sqlwhere.append(")");
        }
        sql.append(sqlwhere.toString());
        if (sqlwhere.length() > 0) {
            sql.append(" and ");
        }
        sql.append(" a.int_codigo = ").append(this.equipamento);
        sql.append(" and a.ier_situacao = ").append(1);
        sql.append(" order by a.fil_codigo, a.req_codigo, a.rec_codigo, a.exa_codigo ");
        this.setExames(this.executeSql(st, sql.toString()), -1);
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void excluirExame(int row) {
        if (Acesso.getAcesso(1001002001L)) {
            try {
                ExameInterfaceado e = (ExameInterfaceado)this.exames.get(row);
                String req_codigo = e.getReq_codigo();
                String pac_nome = e.getPac_nome();
                String exa_codigo = e.getExa_codigo();
                String mco_codigo = e.getMco_codigo();
                String rec_codigo = e.getRec_codigo();
                String fil_codigo = e.getFil_codigo();
                String int_codigo = e.getInt_codigo();
                StringBuilder msg = new StringBuilder("Tem certeza que deseja excluir o exame selecionado de ");
                msg.append(pac_nome);
                msg.append("?");
                int answer = Funcoes.showPerguntaSimNao(Laboratorio.getInstancia(), "", msg.toString());
                if (answer == 0) {
                    Statement st = Conexao.getStatement();
                    this.gravaLogExclusaoRequisicao(this, st, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exa_codigo, "Pendente");
                    BDUtil.deletarExame(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                    Conexao.arquivaSQL();
                    st.close();
                    this.reloadExames();
                    this.novaMensagem("Exame exclu\u00eddos com sucesso deste interfaceamento");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                finally {
                    this.reloadExames();
                }
            }
            this.tabela.grabFocus();
        } else {
            this.novaMensagem("Voc\u00ea n\u00e3o possui acesso para excluir exames");
        }
    }

    public void tabelaKeyTyped(KeyEvent e) {
        if (e.isAltDown()) {
            e.consume();
        } else if (e.getKeyChar() == '\u007f') {
            int row = this.tabela.convertRowIndexToModel(this.tabela.getSelectedRow());
            if (row >= 0 && this.tabela.getRowCount() > 0) {
                this.excluirExame(row);
            }
        } else {
            this.tabela.grabFocus();
        }
    }
}

