/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame.remover;

import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.ExameInterfaceado;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.LiberacaoExameMensagem;
import jalis.laboratorio.interfaceamento.liberacaoexame.remover.TableRenderer;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;

public abstract class AbaPadrao
extends JPanel {
    public static final int SIT_NAO_ENVIADO = 0;
    public static final int SIT_PENDENTE = 1;
    public static final int SIT_PRONTO = 2;
    public static final int SIT_REPETINDO = 3;
    public static final int SIT_COM_REPETICAO = 4;
    public static final int SIT_PRONTO_VALIDADO = 7;
    public static final int SIT_EXPORTADO = 8;
    public static final String COL_CODIGO = "C\u00f3digo";
    public static final String COL_NOME = "Paciente";
    public static final String COL_SEXO = "Sexo";
    public static final String COL_IDADE = "Idade";
    public static final String COL_DATA = "Data";
    public static final String COL_HORA = "Hora";
    public static final String COL_MATERIAL = "Mat.";
    public static final String COL_EXAME = "Exame";
    public static final String COL_SITUACAO = "Situa\u00e7\u00e3o";
    public static final String COL_RESQUANTI = "Quanti";
    public static final String COL_REPQUANTI = "R.Quanti";
    public static final String COL_RESQUALI = "Quali";
    public static final String COL_REPQUALI = "R.Quali";
    public static final int TIPO_NORMAL = 0;
    public static final int TIPO_ALERTA = 1;
    public static final int TEMPO_STATUS_PADRAO = 10000;
    public static final int TEMPO_ALERTA_PADRAO = 5000;
    public static final long PRONTOS_EXCLUIR = 1001003001L;
    public static final long PRONTOS_EXPORTAR = 1001003002L;
    public static final long PRONTOS_LIBERAR_UM = 1001003003L;
    public static final long PRONTOS_EDITAR = 1001003005L;
    public static final long PRONTOS_EDITAR_VALIDO = 1001003009L;
    public static final long PENDENTES_EXCLUIR = 1001002001L;
    protected ArrayList<ExameInterfaceado> exames = null;
    protected String[] colunas = null;
    protected String[] filiais;
    protected String[] coletas;
    protected String[] destinos;
    protected int equipamento;
    protected int colunaOrdenada = -1;
    protected JTable tabela;
    protected DefaultTableModel model;
    private JScrollPane scrollTabela;
    protected TableRenderer renderer;
    private LiberacaoExameMensagem liberacaoExameMensagem = null;

    public AbaPadrao(LiberacaoExameMensagem liberacaoExameMensagem) {
        this(null, liberacaoExameMensagem);
    }

    public AbaPadrao(String[] colunas, LiberacaoExameMensagem liberacaoExameMensagem) {
        this.setLayout(new BorderLayout());
        this.colunas = colunas;
        this.liberacaoExameMensagem = liberacaoExameMensagem;
        this.model = this.createModel();
        this.tabela = new JTable(this.model);
        TableRowSorter<DefaultTableModel> sorter = new TableRowSorter<DefaultTableModel>(this.model);
        this.tabela.setRowSorter(sorter);
        this.scrollTabela = new JScrollPane(this.tabela);
        this.add((Component)this.scrollTabela, "Center");
    }

    public void setTamanhoColunas(int[] tamanho) {
        for (int i = 0; i < tamanho.length; ++i) {
            if (tamanho[i] <= 0) continue;
            this.tabela.getColumnModel().getColumn(i).setMinWidth(tamanho[i]);
            this.tabela.getColumnModel().getColumn(i).setMaxWidth(tamanho[i]);
            this.tabela.getColumnModel().getColumn(i).setPreferredWidth(tamanho[i]);
            this.tabela.getColumnModel().getColumn(i).setWidth(tamanho[i]);
        }
    }

    public void setExames(ArrayList<ExameInterfaceado> exames, int colunaValidacao) {
        this.exames = exames;
        this.renderer = new TableRenderer(exames, this.colunas, this.tabela);
        this.renderer.setColunaValidacao(colunaValidacao);
        this.tabela.setDefaultRenderer(Object.class, this.renderer);
        this.limparExames();
        this.popularExames();
        this.tabela.revalidate();
        this.tabela.repaint();
    }

    protected abstract void popularExames();

    protected abstract void reloadExames();

    protected DefaultTableModel createModel() {
        return new DefaultTableModel(null, this.colunas){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            public Class getColumnClass(int column) {
                Class returno = this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null ? this.getValueAt(0, column).getClass() : Object.class;
                return returno;
            }
        };
    }

    public void limparExames() {
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(0);
        }
    }

    protected void addLinha(Object[] linha) {
        this.model.addRow(linha);
    }

    protected void novaMensagem(String texto) {
        if (this.liberacaoExameMensagem != null) {
            this.liberacaoExameMensagem.mensagemEnviada(texto);
        }
    }

    public void stepSelection() {
        int row = this.tabela.convertRowIndexToModel(this.tabela.getSelectedRow());
        if (row + 1 < this.tabela.getRowCount()) {
            this.tabela.setRowSelectionInterval(++row, row);
        }
    }

    protected ArrayList<ExameInterfaceado> executeSql(Statement st, String sql) {
        ArrayList<ExameInterfaceado> exames = new ArrayList<ExameInterfaceado>();
        try {
            ResultSet rs = Conexao.executeQuery(st, sql);
            while (rs.next()) {
                String idade = String.valueOf(rs.getInt("req_idade")) + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                ExameInterfaceado e = new ExameInterfaceado();
                e.setFil_codigo(rs.getString("fil_codigo"));
                e.setReq_codigo(rs.getString("req_codigo"));
                e.setExa_codigo(rs.getString("exa_codigo"));
                e.setMco_codigo(rs.getString("mco_codigo"));
                e.setRec_codigo(rs.getString("rec_codigo"));
                e.setReq_data(rs.getDate("req_data"));
                e.setReq_hora(rs.getDate("req_hora"));
                e.setPac_idade(idade);
                e.setPac_nome(rs.getString("pac_nome"));
                e.setPac_sexo(rs.getString("pac_sexo"));
                e.setMco_descricao(rs.getString("mco_abreviatura"));
                e.setExr_dataentregaprev(rs.getDate("exr_dataentregaprev"));
                e.setReq_urgente(rs.getBoolean("req_urgente"));
                e.setInt_codigo(rs.getString("int_codigo"));
                e.setEmi_alternativo(rs.getString("emi_alternativo"));
                e.setIer_situacao(rs.getString("ier_situacao"));
                e.setUsr_codigo(rs.getString("usr_codigo"));
                e.setIer_xmlvalores(rs.getString("ier_xmlvalores"));
                e.setMetCodigo(rs.getString("met_codigo"));
                exames.add(e);
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "LiberacaoExame: 278");
        }
        return exames;
    }

    public void setFiliais(String[] filiais) {
        this.filiais = filiais;
    }

    public void setColetas(String[] coletas) {
        this.coletas = coletas;
    }

    public void setDestinos(String[] destinos) {
        this.destinos = destinos;
    }

    public void setEquipamento(int equipamento) {
        this.equipamento = equipamento;
    }

    protected void gravaLogExclusaoRequisicao(Object pai, Statement st, String filial, String interfaceamento, String requisicao, String material, String tubo, String exame, String aba) throws Exception {
        requisicao = Integer.toString(Integer.parseInt(requisicao));
        StringBuilder buf = new StringBuilder();
        StringBuilder motivo = new StringBuilder();
        Date d = new Date();
        motivo.append("Requisi\u00e7\u00e3o excluida na tela de libera\u00e7\u00e3o do interfaceamento na ").append(aba).append(" na data ").append(Funcoes.formataData("dd/MM/yyyy", d)).append(" \u00e0s ").append(Funcoes.formataData("HH:mm", d)).append(" pelo usuario: ").append(Variaveis.login);
        motivo.append("\n\nExame(s) exclu\u00eddo(s) : ").append(exame);
        buf.append("select * from interfaceexamerequisicao where fil_codigo = ").append(filial);
        buf.append(" and req_codigo = ").append(requisicao);
        if (!Funcoes.textoVazio(interfaceamento)) {
            buf.append(" and int_codigo = ").append(interfaceamento);
        }
        if (!Funcoes.textoVazio(material)) {
            buf.append(" and mco_codigo = ").append(material);
        }
        if (!Funcoes.textoVazio(exame)) {
            String[] exas = exame.split(" ");
            if (exas.length == 1) {
                buf.append(" and exa_codigo = '").append(exame).append("'");
            } else {
                buf.append(" and exa_codigo in (");
                int i = 0;
                for (String s : exas) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    if (!Funcoes.textoVazio(s)) {
                        buf.append("'").append(s).append("'");
                    }
                    ++i;
                }
                buf.append(")");
            }
        }
        if (!Funcoes.textoVazio(tubo)) {
            buf.append(" and rec_codigo = ").append(tubo);
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        ArrayList<Registro> regs = new ArrayList<Registro>();
        ArrayList<String> tabelas = new ArrayList<String>();
        while (rs.next()) {
            tabelas.add("interfaceexamerequisicao");
            regs.add(new Registro(rs));
        }
        buf.setLength(0);
        buf.append("select * from interfaceexamerequisicaodesm where fil_codigo = ").append(filial);
        buf.append(" and req_codigo = ").append(requisicao);
        if (!Funcoes.textoVazio(interfaceamento)) {
            buf.append(" and int_codigo = ").append(interfaceamento);
        }
        if (!Funcoes.textoVazio(material)) {
            buf.append(" and mco_codigo = ").append(material);
        }
        if (!Funcoes.textoVazio(exame)) {
            String[] exas = exame.split(" ");
            if (exas.length == 1) {
                buf.append(" and exa_codigo = '").append(exame).append("'");
            } else {
                buf.append(" and exa_codigo in (");
                int i = 0;
                for (String s : exas) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    if (!Funcoes.textoVazio(s)) {
                        buf.append("'").append(s).append("'");
                    }
                    ++i;
                }
                buf.append(")");
            }
        }
        if (!Funcoes.textoVazio(tubo)) {
            buf.append(" and rec_codigo = ").append(tubo);
        }
        rs = Conexao.executeQuery(st, buf);
        while (rs.next()) {
            tabelas.add("interfaceexamerequisicaodesm");
            regs.add(new Registro(rs));
        }
        if (tabelas.size() > 0) {
            DBUtil.gravaLogXML(st, filial, regs.toArray(new Registro[regs.size()]), tabelas.toArray(new String[tabelas.size()]), "Interfaceamento", requisicao, new String[]{"fil_codigo, int_codigo, exa_codigo, mco_codigo, req_codigo, rec_codigo"}, "E", motivo.toString());
        }
    }
}

