/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame.remover;

import jalis.util.Funcoes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;

public class AbaExcecoes
extends JPanel {
    protected Color COR_ALERTA = SystemColor.inactiveCaption;
    protected Color COR_NORMAL = UIManager.getColor("TabbedPane.unselectedTabBackground");
    private AlertThread alerta = new AlertThread();
    protected JTable tabela;
    protected DefaultTableModel model;
    private JScrollPane scrollTabela;

    public AbaExcecoes() {
        this.setLayout(new BorderLayout());
        this.model = new DefaultTableModel(null, new String[]{"Data/Hora", "Mensagem"}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tabela = new JTable(this.model);
        this.scrollTabela = new JScrollPane(this.tabela);
        this.add((Component)this.scrollTabela, "Center");
        this.tabela.getColumnModel().getColumn(0).setMinWidth(110);
        this.tabela.getColumnModel().getColumn(0).setMaxWidth(110);
        this.tabela.getColumnModel().getColumn(0).setPreferredWidth(110);
        this.tabela.getColumnModel().getColumn(0).setWidth(110);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (AbaExcecoes.this.alerta != null && !AbaExcecoes.this.alerta.isInterrupted()) {
                    AbaExcecoes.this.alerta.interrupt();
                }
            }
        });
    }

    public void addMensagem(String mensagem) {
        Date dt = new Date();
        String hr = Funcoes.formataData("dd/MM/yyyy HH:mm:ss", dt);
        Object[] linha = new Object[]{hr, mensagem};
        this.model.addRow(linha);
        this.alertarUsuario();
    }

    private void alertarUsuario() {
        if (!this.isShowing()) {
            if (this.alerta != null && !this.alerta.isInterrupted()) {
                this.alerta.interrupt();
            }
            this.alerta = new AlertThread();
            this.alerta.start();
        }
    }

    class AlertThread
    extends Thread {
        public AlertThread() {
            this.setPriority(1);
        }

        @Override
        public void run() {
            JTabbedPane pai = (JTabbedPane)AbaExcecoes.this.getParent();
            try {
                while (true) {
                    pai.setBackgroundAt(pai.indexOfComponent(AbaExcecoes.this), AbaExcecoes.this.COR_ALERTA);
                    pai.revalidate();
                    pai.repaint();
                    AlertThread.sleep(500L);
                    pai.setBackgroundAt(pai.indexOfComponent(AbaExcecoes.this), AbaExcecoes.this.COR_NORMAL);
                    pai.revalidate();
                    pai.repaint();
                    AlertThread.sleep(500L);
                }
            }
            catch (InterruptedException ex) {
                pai.setBackgroundAt(pai.indexOfComponent(AbaExcecoes.this), AbaExcecoes.this.COR_NORMAL);
                return;
            }
        }
    }
}

