/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.liberacaoexame.AbaPronto;
import jalis.laboratorio.interfaceamento.resultados.EditarResultado;
import jalis.util.Funcoes;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatusExportacao
extends JPanel
implements ActionListener {
    protected JLabel labelContador = new JLabel(" ");
    protected JButton buttonCancelar = new BotaoNavegavel("Cancelar");
    protected ArrayList<String> colunasVisiveis;
    protected ArrayList<String> colunasOcultas;
    protected ThreadExportacao threadExportacao;
    protected AbaPronto aba;
    protected boolean executando = false;

    public StatusExportacao(ArrayList<String> colunasVisiveis, ArrayList<String> colunasOcultas, AbaPronto aba) {
        this.colunasVisiveis = colunasVisiveis;
        this.colunasOcultas = colunasOcultas;
        this.aba = aba;
        this.setBorder(ComponenteFactory.novoTitledEtchedBorder("Exporta\u00e7\u00e3o"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.labelContador, "West");
        this.buttonCancelar.setMargin(new Insets(2, 2, 2, 2));
        this.add((Component)this.buttonCancelar, "East");
        this.buttonCancelar.setEnabled(false);
        this.buttonCancelar.addActionListener(this);
        this.threadExportacao = new ThreadExportacao(this.labelContador, 100, Conexao.getStatement(), aba);
    }

    public void addExames(ArrayList<Object[]> exames) {
        this.threadExportacao.addExames(exames);
    }

    public void restart() {
        if (this.threadExportacao != null && !this.threadExportacao.isInterrupted() && this.threadExportacao.isAlive()) {
            return;
        }
        this.buttonCancelar.setEnabled(true);
        if (this.threadExportacao != null && !this.threadExportacao.isAlive()) {
            Map exames = this.threadExportacao.exames;
            if (this.threadExportacao != null) {
                try {
                    this.threadExportacao.cancelar();
                    this.threadExportacao.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.threadExportacao = new ThreadExportacao(this.labelContador, 100, Conexao.getStatement(), this.aba);
            this.threadExportacao.addExames(exames);
        }
        if (this.threadExportacao != null) {
            this.threadExportacao.start();
        }
    }

    public int getColIndice(String nome_coluna) {
        int c = this.colunasVisiveis.indexOf(nome_coluna);
        if (c >= 0) {
            return c;
        }
        c = this.colunasOcultas.indexOf(nome_coluna);
        if (c >= 0) {
            return this.colunasVisiveis.size() + c;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        }
    }

    private void cancelar() {
        try {
            this.threadExportacao.cancelar();
            Conexao.anulaSQL();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void limpar() {
        this.buttonCancelar.setEnabled(false);
        this.labelContador.setText(" ");
    }

    public boolean isExecutando() {
        return this.executando;
    }

    protected class ThreadExportacao
    extends Thread {
        private JLabel labelContador;
        private int time;
        private Map<String, Object[]> exames;
        private int col_req;
        private int col_int;
        private int col_exa;
        private int col_mco;
        private int col_rec;
        private int col_pac;
        private int col_sex;
        private int colMetodo;
        private boolean cancelar;
        private Statement st;
        private AbaPronto aba;
        private int total;
        private int contador;
        private int usr_codigo;
        private String usuario;

        public ThreadExportacao(JLabel labelContador, int time, Statement st, AbaPronto aba) {
            super("Thread Exportacao Libera\u00e7\u00e3o");
            this.exames = new HashMap<String, Object[]>();
            this.cancelar = false;
            this.st = null;
            this.total = 0;
            this.contador = 0;
            this.labelContador = labelContador;
            this.setPriority(1);
            this.time = time;
            this.st = st;
            this.aba = aba;
        }

        public void addExames(Map<String, Object[]> exames) {
            this.exames.putAll(exames);
        }

        public void addExames(ArrayList<Object[]> exames) {
            for (Object[] ex : exames) {
                this.addExame(ex);
            }
        }

        private void addExame(Object[] ex) {
            int col_req = StatusExportacao.this.getColIndice("C\u00f3digo");
            int col_mul = StatusExportacao.this.getColIndice("Multiguia");
            int col_int = StatusExportacao.this.getColIndice("Interface");
            int col_exa = StatusExportacao.this.getColIndice("Exame");
            int col_mco = StatusExportacao.this.getColIndice("C\u00f3d. Mat.");
            int col_rec = StatusExportacao.this.getColIndice("Tubo");
            String req1 = (String)ex[col_req];
            if (Funcoes.textoVazio(req1)) {
                req1 = (String)ex[col_mul];
            }
            String int1 = (String)ex[col_int];
            String exa1 = (String)ex[col_exa];
            String mco1 = (String)ex[col_mco];
            String rec1 = (String)ex[col_rec];
            String chave = String.format("%s_%s_%s_%s_%s", req1, int1, exa1, mco1, rec1);
            if (!this.exames.containsKey(chave)) {
                this.exames.put(chave, ex);
            }
        }

        public void cancelar() {
            this.cancelar = true;
        }

        @Override
        public void run() {
            StatusExportacao.this.executando = true;
            try {
                this.col_req = StatusExportacao.this.getColIndice("C\u00f3digo");
                this.col_int = StatusExportacao.this.getColIndice("Interface");
                this.col_exa = StatusExportacao.this.getColIndice("Exame");
                this.col_mco = StatusExportacao.this.getColIndice("C\u00f3d. Mat.");
                this.col_rec = StatusExportacao.this.getColIndice("Tubo");
                this.col_pac = StatusExportacao.this.getColIndice("Paciente");
                this.colMetodo = StatusExportacao.this.getColIndice("Cod. M\u00e9todo");
                this.usr_codigo = StatusExportacao.this.getColIndice("Usuario");
                this.contador = 1;
                this.total = this.exames.size();
                Timer timer = new Timer("Timer atualiza\u00e7\u00e3o exportados libera\u00e7\u00e3o", true);
                timer.scheduleAtFixedRate(new TimerTask(){

                    @Override
                    public void run() {
                        if (!ThreadExportacao.this.cancelar) {
                            ThreadExportacao.this.labelContador.setText("Exportando " + Integer.toString(ThreadExportacao.this.contador) + " de " + Integer.toString(ThreadExportacao.this.total));
                        }
                    }
                }, this.time, (long)this.time);
                boolean isAgruparInterface = ParametrosGerais.isAgruparGuiasInterface();
                int digitosTuboFilial = ParametrosGerais.getDigitosTuboFilial();
                while (this.exames.keySet().iterator().hasNext() && !this.cancelar) {
                    if (this.exames.size() > this.total || this.contador > this.total) {
                        this.total = this.exames.size() + this.contador - 1;
                    }
                    String key = this.exames.keySet().iterator().next();
                    Object[] exame = this.exames.get(key);
                    String requisicao = (String)exame[this.col_req];
                    this.usuario = !Funcoes.textoVazio((String)exame[this.usr_codigo]) ? (String)exame[this.usr_codigo] : Variaveis.login;
                    if (isAgruparInterface) {
                        requisicao = (String)exame[StatusExportacao.this.getColIndice("C\u00f3digo Temp.")];
                    }
                    String filial = requisicao.substring(0, digitosTuboFilial);
                    requisicao = requisicao.substring(digitosTuboFilial);
                    EditarResultado dlg = this.aba.exportaExame(true, requisicao, (String)exame[this.col_pac], null, (String)exame[this.col_exa], (String)exame[this.col_mco], (String)exame[this.col_rec], (String)exame[this.col_int], true, filial, this.usuario, this.st, (String)exame[this.colMetodo]);
                    dlg.dispose();
                    Laboratorio.getInstancia().removeDisposeListener(dlg);
                    dlg = null;
                    exame = null;
                    this.exames.remove(key);
                    ThreadExportacao.sleep(this.time);
                    ++this.contador;
                }
                Conexao.arquivaSQL();
                this.exames = new HashMap<String, Object[]>();
                StatusExportacao.this.limpar();
                timer.cancel();
                this.aba.reloadExames();
            }
            catch (InterruptedException ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                ex.printStackTrace();
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "StatusExportacao: 143");
                Funcoes.showErro(null, "A exporta\u00e7\u00e3o de exames ser\u00e1 encerrada.");
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                ex.printStackTrace();
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "StatusExportacao: 153");
                Funcoes.showErro(null, "A exporta\u00e7\u00e3o de exames ser\u00e1 encerrada.");
            }
            StatusExportacao.this.executando = false;
        }
    }
}

