/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame;

import jalis.comum.Conexao;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.liberacaoexame.AbaExcecoes;
import jalis.laboratorio.interfaceamento.liberacaoexame.AbaPendente;
import jalis.laboratorio.interfaceamento.liberacaoexame.AbaPronto;
import jalis.laboratorio.interfaceamento.liberacaoexame.AbaRecoleta;
import jalis.laboratorio.interfaceamento.liberacaoexame.Equipamento;
import jalis.laboratorio.interfaceamento.liberacaoexame.Filial;
import jalis.laboratorio.interfaceamento.liberacaoexame.LiberacaoExameMensagem;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public class LiberacaoExame
extends FrmPadrao
implements ActionListener,
LiberacaoExameMensagem {
    public static final int SIT_PENDENTE = 1;
    public static final int SIT_PRONTO = 2;
    public static final int SIT_REPETINDO = 3;
    public static final int SIT_COM_REPETICAO = 4;
    public static final int SIT_PRONTO_VALIDADO = 7;
    public static final Color COR_VALORALTERADO = new Color(255, 204, 51);
    private JPanel panelSouth = new JPanel(new BorderLayout());
    private JPanel panelFechar = new JPanel(new FlowLayout(2));
    private JPanel panelCenter = new JPanel(new BorderLayout());
    private JPanel panelFiltro = new JPanel(new GridBagLayout());
    private JPanel panelBellow = new JPanel(new BorderLayout());
    private JPanel panelLegenda = new JPanel(new BorderLayout());
    private JLabel labelEquipamento = new JLabel("Equipamento:");
    private JLabel labelFilial = new JLabel("Filial:");
    private AbaPendente abaPendente = new AbaPendente(this);
    private AbaPronto abaPronto = null;
    private AbaExcecoes abaExcecoes = new AbaExcecoes();
    private AbaRecoleta abaRecoleta = null;
    private JComboBox<Equipamento> comboEquipamento = ComponenteFactory.novoJComboBox(this, true);
    private JComboBox<Filial> comboFilial = ComponenteFactory.novoJComboBox(this, true);
    private JButton buttonFiltrar = new JButton("Filtrar");
    private BotaoNavegavel buttonFechar = new BotaoNavegavel("Fechar", 'F');
    private JCheckBox checkDestacarExames = new JCheckBox("Destacar exames fora do valor de refer\u00eancia");
    private JTabbedPane tabCenter = new JTabbedPane();
    private CheckItemFiltro filtroDestino;
    private CheckItemFiltro filtroColeta;
    private boolean botaoFiltrarPressionado = false;

    public LiberacaoExame() {
        String valor = StringUtil.getValor(ParametrosUsuarios.getValor("LiberacaoExame.CheckDestacarExamesValorReferencia"), "destacarExames");
        this.checkDestacarExames.setSelected(Boolean.valueOf(valor));
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Libera\u00e7\u00e3o de Exames", "Realiza a libera\u00e7\u00e3o de exames interfaceados", "interface/interfac_conferencia.jpg");
        this.buttonFechar.addActionListener(this);
        this.add((Component)this.panelSouth, "South");
        this.abaPronto = new AbaPronto(this, this.checkDestacarExames.isSelected());
        this.abaRecoleta = new AbaRecoleta(this, this.checkDestacarExames.isSelected());
        this.tabCenter.addTab("Processando", this.abaPendente);
        this.tabCenter.addTab("Prontos", this.abaPronto);
        this.tabCenter.addTab("Mensagens", this.abaExcecoes);
        this.tabCenter.addTab("Recoleta", this.abaRecoleta);
        this.panelCenter.add((Component)this.tabCenter, "Center");
        this.tabCenter.setSelectedComponent(this.abaPronto);
        this.tabCenter.addChangeListener(listener -> {
            if (this.botaoFiltrarPressionado) {
                this.filtrar();
            }
        });
        Dimension d = new Dimension(150, 25);
        String sql = "select a.col_codigo, a.col_descricao, a.fil_codigo, b.fil_descricao from coletas a left join filiais_postocoleta b on a.fil_codigo = b.fil_codigo";
        this.filtroColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando Locais de Coletas", "");
        this.filtroColeta.setDados(sql, new String[]{"col_codigo", "col_descricao", "fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "C\u00f3d. Filial", "Filial"}, new int[]{70, 0, 90, 0}, true);
        this.filtroColeta.setColunaHint(1);
        this.filtroColeta.setPreferredSize(d);
        sql = "select a.des_codigo, a.des_descricao, a.fil_codigo, b.fil_descricao from destino a left join filiais_postocoleta b on a.fil_codigo = b.fil_codigo";
        this.filtroDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando Locais de Destino", "");
        this.filtroDestino.setDados(sql, new String[]{"des_codigo", "des_descricao", "fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "C\u00f3d. Filia", "Filial"}, new int[]{70, 0, 90, 0}, true);
        this.filtroDestino.setColunaHint(1);
        this.filtroDestino.setPreferredSize(d);
        d = new Dimension(350, 20);
        this.comboEquipamento.setSize(d);
        this.comboEquipamento.setPreferredSize(d);
        this.comboEquipamento.setMaximumSize(d);
        this.comboEquipamento.setMinimumSize(d);
        this.comboEquipamento.setAutoscrolls(true);
        this.comboFilial.setSize(d);
        this.comboFilial.setPreferredSize(d);
        this.comboFilial.setMaximumSize(d);
        this.comboFilial.setMinimumSize(d);
        this.comboFilial.setAutoscrolls(true);
        this.comboFilial.addActionListener(event -> this.atualizaFiltros());
        d = new Dimension(80, 20);
        this.buttonFiltrar.setSize(d);
        this.buttonFiltrar.setPreferredSize(d);
        this.buttonFiltrar.setMaximumSize(d);
        this.buttonFiltrar.setMinimumSize(d);
        this.buttonFiltrar.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 2;
        c.gridwidth = 1;
        this.panelFiltro.add((Component)this.labelFilial, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.panelFiltro.add(this.comboFilial, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        this.panelFiltro.add((Component)this.filtroColeta, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.panelFiltro.add((Component)this.filtroDestino, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.panelFiltro.add((Component)this.labelEquipamento, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.panelFiltro.add(this.comboEquipamento, c);
        c.gridx += 3;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.fill = 2;
        this.panelFiltro.add((Component)new JPanel(), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelFiltro.add((Component)this.buttonFiltrar, c);
        this.panelCenter.add((Component)this.panelFiltro, "North");
        this.add((Component)this.panelCenter, "Center");
        BorderLayout bl = (BorderLayout)this.panelLegenda.getLayout();
        bl.setVgap(0);
        JPanel panelLegendaLeft = new JPanel(new FlowLayout(0, 1, 0));
        JPanel panelLegendaRight = new JPanel(new FlowLayout(2, 1, 0));
        this.panelLegenda.add((Component)panelLegendaLeft, "West");
        this.panelLegenda.add((Component)panelLegendaRight, "East");
        JPanel panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(10, 10));
        panelCorLegenda.setBackground(Color.RED);
        panelLegendaLeft.add(panelCorLegenda);
        JLabel labelLegenda = new JLabel("Atrasado   ");
        Font font = new Font(labelLegenda.getFont().getName(), 0, 10);
        labelLegenda.setFont(font);
        panelLegendaLeft.add(labelLegenda);
        panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(10, 10));
        panelCorLegenda.setBackground(Color.BLUE);
        panelLegendaLeft.add(panelCorLegenda);
        labelLegenda = new JLabel("No Prazo   ");
        labelLegenda.setFont(font);
        panelLegendaLeft.add(labelLegenda);
        panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(10, 10));
        panelCorLegenda.setBackground(Color.BLACK);
        panelLegendaLeft.add(panelCorLegenda);
        labelLegenda = new JLabel("Entrega Futura   ");
        labelLegenda.setFont(font);
        panelLegendaLeft.add(labelLegenda);
        panelCorLegenda = new JPanel();
        panelCorLegenda.setPreferredSize(new Dimension(10, 10));
        panelCorLegenda.setBackground(ScreenUtil.clarearCor(Color.RED, 200));
        panelLegendaLeft.add(panelCorLegenda);
        JLabel labelUrgente = new JLabel("Urgente   ");
        labelUrgente.setBackground(ScreenUtil.clarearCor(Color.RED, 200));
        labelUrgente.setOpaque(true);
        labelUrgente.setFont(font);
        panelLegendaLeft.add(labelUrgente);
        if (this.checkDestacarExames.isSelected()) {
            panelCorLegenda = new JPanel();
            panelCorLegenda.setPreferredSize(new Dimension(10, 10));
            panelCorLegenda.setBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, COR_VALORALTERADO));
            panelLegendaLeft.add(panelCorLegenda);
            JLabel labelValoresAlterados = new JLabel("Valores alterados");
            labelValoresAlterados.setOpaque(true);
            labelValoresAlterados.setFont(font);
            panelLegendaLeft.add(labelValoresAlterados);
        }
        JLabel labelAtalhos = new JLabel("[F6] Processando   [F7] Prontos   [F8] Mensagens   [F9] Recoleta");
        labelAtalhos.setFont(font);
        panelLegendaRight.add(labelAtalhos);
        this.panelFechar.add(this.buttonFechar);
        this.panelBellow.add(this.panelLegenda);
        this.checkDestacarExames.setToolTipText("\u00c9 necess\u00e1rio fechar e abrir a tela novamente para as valida\u00e7\u00f5es serem executadas.");
        this.panelBellow.add((Component)this.checkDestacarExames, "South");
        this.panelSouth.add((Component)this.panelBellow, "Center");
        this.panelSouth.add((Component)this.panelFechar, "East");
        this.inserirAcaoDeTecla("F6", "atalhoF6", new AbstractAction("atalhoF6"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiberacaoExame.this.tabCenter.setSelectedComponent(LiberacaoExame.this.abaPendente);
            }
        });
        this.inserirAcaoDeTecla("F7", "atalhoF7", new AbstractAction("atalhoF7"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiberacaoExame.this.tabCenter.setSelectedComponent(LiberacaoExame.this.abaPronto);
            }
        });
        this.inserirAcaoDeTecla("F8", "atalhoF8", new AbstractAction("atalhoF8"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiberacaoExame.this.tabCenter.setSelectedComponent(LiberacaoExame.this.abaExcecoes);
            }
        });
        this.inserirAcaoDeTecla("F9", "atalhoF9", new AbstractAction("atalhoF9"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiberacaoExame.this.tabCenter.setSelectedComponent(LiberacaoExame.this.abaRecoleta);
            }
        });
        Statement st = Conexao.getStatement();
        String sqlFilial = "select fil_codigo, fil_descricao from filiais_postocoleta order by fil_codigo";
        try {
            ResultSet rs = Conexao.executeQuery(st, sqlFilial);
            while (rs.next()) {
                Filial f = new Filial(rs.getInt("fil_codigo"), rs.getString("fil_descricao"));
                this.comboFilial.addItem(f);
            }
        }
        catch (SQLException e1) {
            try {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "LiberacaoExame:264");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("1010070001");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            if (this.abaPronto.getStatusExportacao() != null && this.abaPronto.getStatusExportacao().isExecutando()) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Existem exames sendo exportados! \u00c9 preciso aguardar o t\u00e9rmino antes de fechar a tela de libera\u00e7\u00e3o de exames!", 5);
            } else {
                ParametrosUsuarios.setValor("LiberacaoExame.CheckDestacarExamesValorReferencia", this.getValorParametros());
                ParametrosUsuarios.salvarParametros(true);
                this.setVisible(false);
            }
        } else if (e.getSource() == this.buttonFiltrar) {
            this.botaoFiltrarPressionado = true;
            this.filtrar();
        }
    }

    private String getValorParametros() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.escrever("filial", Variaveis.filialPadrao);
        xml.escrever("usuario", Variaveis.login);
        xml.escrever("destacarExames", String.valueOf(this.checkDestacarExames.isSelected()));
        return xml.toString();
    }

    private void atualizaFiltros() {
        this.filtroColeta.clear();
        this.filtroDestino.clear();
        if (this.comboFilial.getSelectedIndex() < 0) {
            return;
        }
        Filial filial = (Filial)this.comboFilial.getSelectedItem();
        this.comboEquipamento.removeAllItems();
        try {
            Statement st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, this.getSql(filial));
            while (rs.next()) {
                this.comboEquipamento.addItem(new Equipamento(rs.getInt("int_codigo"), rs.getString("int_descricao"), rs.getBoolean("int_contadorcelulas")));
            }
            Conexao.fecharStatement(st);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "LiberacaoExame: 232");
        }
        this.filtroColeta.setFiltro("a.fil_codigo = " + Integer.toString(filial.getCodigo()));
        this.filtroDestino.setFiltro("a.fil_codigo = " + Integer.toString(filial.getCodigo()));
    }

    private String getSql(Filial filial) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct int_codigo, int_descricao, int_contadorcelulas ");
        sql.append(" from interface where fil_codigo = ").append(filial.getCodigo());
        sql.append(" and (int_inativo is null or not int_inativo) ");
        sql.append(" order by int_descricao ");
        return sql.toString();
    }

    private void filtrar() {
        if (this.comboEquipamento.getSelectedItem() == null || this.comboFilial.getSelectedItem() == null) {
            return;
        }
        Filial filial = (Filial)this.comboFilial.getSelectedItem();
        String[] coletas = this.filtroColeta.getSelecionados(0);
        String[] destinos = this.filtroDestino.getSelecionados(0);
        Equipamento equip = (Equipamento)this.comboEquipamento.getSelectedItem();
        if (this.tabCenter.getSelectedIndex() == 0) {
            this.carregarAbaPendente(filial, coletas, destinos, equip);
        }
        if (this.tabCenter.getSelectedIndex() == 1) {
            this.carregarAbaPronto(filial, coletas, destinos, equip);
        }
        if (this.tabCenter.getSelectedIndex() == 3) {
            this.carregarAbaRecoleta(filial, coletas, destinos, equip);
        }
    }

    private void carregarAbaRecoleta(Filial filial, String[] coletas, String[] destinos, Equipamento equip) {
        SplashMensagem splash = SplashMensagem.getInstancia(this);
        splash.mostrar("Carregando Exames...");
        this.abaRecoleta.setFiliais(new String[]{Integer.toString(filial.getCodigo())});
        this.abaRecoleta.setColetas(coletas);
        this.abaRecoleta.setDestinos(destinos);
        this.abaRecoleta.setEquipamento(equip.getCodigo());
        this.abaRecoleta.setPermitirContadorCelulas(equip.isPermitirContadorCelulas());
        this.abaRecoleta.reloadExames();
        splash.apagar();
    }

    private void carregarAbaPronto(Filial filial, String[] coletas, String[] destinos, Equipamento equip) {
        SplashMensagem splash = SplashMensagem.getInstancia(this);
        splash.mostrar("Carregando Exames...");
        this.abaPronto.setFiliais(new String[]{Integer.toString(filial.getCodigo())});
        this.abaPronto.setColetas(coletas);
        this.abaPronto.setDestinos(destinos);
        this.abaPronto.setEquipamento(equip.getCodigo());
        this.abaPronto.setPermitirContadorCelulas(equip.isPermitirContadorCelulas());
        this.abaPronto.reloadExames();
        splash.apagar();
    }

    private void carregarAbaPendente(Filial filial, String[] coletas, String[] destinos, Equipamento equip) {
        SplashMensagem splash = SplashMensagem.getInstancia(this);
        splash.mostrar("Carregando Exames...");
        this.abaPendente.setFiliais(new String[]{Integer.toString(filial.getCodigo())});
        this.abaPendente.setColetas(coletas);
        this.abaPendente.setDestinos(destinos);
        this.abaPendente.setEquipamento(equip.getCodigo());
        this.abaPendente.reloadExames();
        splash.apagar();
    }

    @Override
    public void mensagemEnviada(String mensagem) {
        this.abaExcecoes.adicionarExcecao(mensagem);
    }

    protected void inserirAcaoDeTecla(String key_stroke, String action_name, AbstractAction action) {
        this.getInputMap(0).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(key_stroke), action_name);
        this.getActionMap().put(action_name, action);
    }
}

