/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame;

import jalis.apoio.util.Util;
import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.liberacaoexame.AbaPadrao;
import jalis.laboratorio.interfaceamento.liberacaoexame.LiberacaoExameMensagem;
import jalis.laboratorio.interfaceamento.liberacaoexame.LiberacaoExameService;
import jalis.laboratorio.interfaceamento.resultados.EditarResultado;
import jalis.laboratorio.recepcao.util.SolicitarJejum;
import jalis.laboratorio.recepcao.util.SolicitarTempoDiurese;
import jalis.laboratorio.recepcao.util.SolicitarVolume;
import jalis.service.interfaceamento.liberacaoexame.AbaRecoletaService;
import jalis.service.recepcao.ExameRequisicaoRecipienteService;
import jalis.util.DBUtil;
import jalis.util.DialogUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;

public class AbaRecoleta
extends AbaPadrao {
    private JButton buttonReceberMaterial = new BotaoNavegavel("Receber material");
    private ArrayList exames = null;
    private final AbaRecoletaService service = new AbaRecoletaService();
    private final LiberacaoExameService liberacaoExameService;
    private final ExameRequisicaoRecipienteService exameRequisicaoRecipienteService = new ExameRequisicaoRecipienteService();

    public AbaRecoleta(LiberacaoExameMensagem liberacaoExameMensagem) {
        super(liberacaoExameMensagem);
        this.liberacaoExameService = new LiberacaoExameService();
    }

    public AbaRecoleta(LiberacaoExameMensagem liberacaoExameMensagem, boolean destacarExames) {
        super(liberacaoExameMensagem, destacarExames);
        this.liberacaoExameService = new LiberacaoExameService();
        this.montaTela();
    }

    public void montaTela() {
        try {
            this.jPanelMain.add((Component)this.jPanelHeader, "North");
            this.button_panel.addButton(this.buttonReceberMaterial, null, 'M', "Receber Material");
            this.buttonReceberMaterial.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AbaRecoleta.this.tabelaExames.getSelectedRow();
                    if (row >= 0) {
                        Registro reg = AbaRecoleta.this.buscaExame(row);
                        AbaRecoleta.this.receberMaterial(reg, true);
                    }
                }
            });
            this.iniciarGrid();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private Registro buscaExame(int row) {
        String req_codigo = StringUtil.isEmpty((String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"))) ? (String)this.tabelaExames.getValueAt(row, this.getColIndice("Multiguia")) : (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
        String exa_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
        int mco_codigo = (Integer)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
        int int_codigo = (Integer)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
        return this.liberacaoExameService.buscaDadosExameRequisicaoLiberacao(fil_codigo, exa_codigo, mco_codigo, req_codigo, int_codigo);
    }

    private String solicitarJejum() {
        SolicitarJejum sj = SolicitarJejum.novaInstancia(this.getTopLevelAncestor());
        if (sj != null) {
            sj.setVisible(true);
            return sj.getTempoJejum().trim();
        }
        return "";
    }

    private double pedirVolume(double vol) {
        double retorno = 0.0;
        SolicitarVolume volume = SolicitarVolume.novaInstancia(this.getTopLevelAncestor());
        volume.setVolume(vol);
        volume.setVisible(true);
        retorno = volume.getVolume();
        return retorno;
    }

    private String pedirTempoDiurese(String s) {
        String retorno = "";
        SolicitarTempoDiurese tempo = SolicitarTempoDiurese.novaInstancia(this.getTopLevelAncestor());
        if (Funcoes.verificaIntervaloHora(s)) {
            tempo.setTempoDiurese(s);
        }
        tempo.setVisible(true);
        retorno = tempo.getTempoDiurese();
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receberMaterial(Registro reg, boolean perguntarJejum) {
        Statement st = Conexao.getStatement();
        if (st != null && reg != null) {
            try {
                Date entrega = !StringUtil.isEmpty(reg.getString("prz_codigo")) ? ExameUtil.calculaDataEntrega(reg.getString("fil_codigo"), reg.getString("prz_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("con_codigo"), reg.getString("codigoDestino")) : null;
                String dataEntrega = entrega != null ? Funcoes.formataData("MM/dd/yyyy HH:mm", entrega) : null;
                String tempoJejum = null;
                String tempoDiurese = null;
                double volume = 0.0;
                if (perguntarJejum && reg.getBoolean("emc_solicitarjejum")) {
                    String solicitarJejum = this.solicitarJejum();
                    tempoJejum = !Funcoes.textoVazio(solicitarJejum) ? "'" + solicitarJejum + "'" : null;
                }
                String tempo = "";
                if (reg.getBoolean("emc_obrigatempodiurese")) {
                    if (Funcoes.textoVazio(tempoDiurese)) {
                        tempoDiurese = tempo = this.pedirTempoDiurese("");
                    } else {
                        tempo = tempoDiurese;
                    }
                }
                double volumeDiurese = 0.0;
                if (reg.getBoolean("emc_obrigavolume")) {
                    if (volumeDiurese == 0.0) {
                        volume = volumeDiurese = this.pedirVolume(0.0);
                    } else {
                        volumeDiurese = volume;
                    }
                }
                DBUtil.gravaLogSituacaoExameRequisicao(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), "", false);
                this.liberacaoExameService.atualizarSituacaoReceberMaterial(reg, dataEntrega, tempoJejum, tempoDiurese, volumeDiurese);
                this.liberacaoExameService.setExmSituacaoTubo(st, reg.getString("fil_codigo"), reg.getString("int_codigo"), reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"), Integer.valueOf(SIT_NAO_ENVIADO), reg.getString("rec_codigo"));
                if (this.exportarParaWeb()) {
                    this.liberacaoExameService.alterarExameRequisicaoWeb(st, reg, "situacaoExameRequisicao", "", "dataColetaExameRequisicao", Funcoes.formataData("dd/MM/yyyy", new Date()), "horaColetaExameRequisicao", Funcoes.formataData("HH:mm", new Date()));
                }
                Util.gravaAlteracaoExameRequisicao(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                Conexao.arquivaSQL();
                this.loadExames();
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "AbaRecoleta (173)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "AbaRecoleta (201)");
        }
    }

    private boolean exportarParaWeb() {
        return !Funcoes.textoVazio(Variaveis.codigoBaseWeb);
    }

    private void iniciarGrid() {
        int index = 0;
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            this.addColVisivel("Multiguia");
            ++index;
        }
        this.addColVisivel("C\u00f3digo");
        ++index;
        this.addColVisivel("Paciente");
        ++index;
        this.addColVisivel("Sexo");
        ++index;
        this.addColVisivel("Idade");
        ++index;
        this.addColVisivel("Mat.");
        ++index;
        this.addColVisivel("Exame");
        int n = ++index;
        this.addColVisivel(n, "Res.Quanti", "resultado_quantitativo", false);
        int n2 = ++index;
        ++index;
        this.addColVisivel(n2, "Res.Quali", "resultado_qualitativo", false);
        this.addColVisivel("Usuario");
        ++index;
        this.addColVisivel("F");
        ++index;
        this.addColVisivel("Sit");
        this.addColOculta("C\u00f3d. Mat.");
        this.addColOculta("Tubo");
        this.addColOculta("Valores");
        this.addColOculta("Previs\u00e3o");
        this.addColOculta("Rack");
        this.addColOculta("Urgente");
        this.addColOculta("Interface");
        this.addColOculta("Alternativo");
        this.addColOculta("C\u00f3digo Temp.");
        this.addColOculta("Tubos Filhos");
        this.addColOculta("Cod. M\u00e9todo");
        this.addColOculta("Valor Alterado");
        this.tabelaExames.forceSize(this.getColIndice("C\u00f3digo"), 85);
        this.tabelaExames.forceSize(this.getColIndice("Sexo"), 40);
        this.tabelaExames.forceSize(this.getColIndice("Idade"), 70);
        this.tabelaExames.forceSize(this.getColIndice("Mat."), 50);
        this.tabelaExames.forceSize(this.getColIndice("Exame"), 55);
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            this.tabelaExames.forceSize(this.getColIndice("Multiguia"), 80);
        }
        index = this.getColIndice("Exame");
        this.tabelaExames.forceSize(++index, 80);
        this.tabelaExames.forceSize(++index, 80);
        this.tabelaExames.forceSize(this.getColIndice("F"), 16);
        this.tabelaExames.forceSize(this.getColIndice("Sit"), 20);
        this.tabelaExames.forceSize(this.getColIndice("Usuario"), 60);
        this.tabelaExames.setDefaultRenderer(Object.class, this.renderer);
        this.tabelaExames.sortRowsByColumn(0, false, true);
        this.renderer.addColunasCentralizadas(new Integer[]{this.getColIndice("C\u00f3digo"), this.getColIndice("Sexo"), this.getColIndice("Idade"), this.getColIndice("Mat.")});
        this.renderer.setColunaValidacao(this.getColIndice("Sit"));
        this.renderer.setColunaFlag(this.getColIndice("F"));
        this.renderer.setColunaDataPrevisao(this.getColIndice("Previs\u00e3o"));
        this.renderer.setColunaUrgente(this.getColIndice("Urgente"));
        this.renderer.setColunaValorAlterado(this.getColIndice("Valor Alterado"));
        this.tabelaExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AbaRecoleta.this.tabelaExames_keyTyped(e);
            }
        });
    }

    @Override
    protected void loadExames() {
        this.setAmpulheta(true);
        try {
            ArrayList dados_temp = this.service.pesquisarRecoletasInterface(this.filiais, this.coletas, this.destinos, this.equipamento, this.getColCount(), this.colunasVisiveis, this.colunasOcultas);
            this.tabelaExames.setData(dados_temp);
            this.tabelaExames.sortRowsByColumn(this.tabelaExames.getColunaOrdenada(), false, false);
            this.exames = dados_temp;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        this.setAmpulheta(false);
    }

    public void tabelaExames_keyTyped(KeyEvent e) {
        if (e.isAltDown()) {
            e.consume();
        } else if (e.getKeyChar() == ' ') {
            int row = this.tabelaExames.getSelectedRow();
            if (row >= 0 && this.tabelaExames.getRowCount() > 0) {
                this.editarResultado(row, false);
            }
            this.tabelaExames.grabFocus();
        } else if (Character.isLetterOrDigit(e.getKeyChar())) {
            this.showLocalizar(e.getKeyChar());
        } else {
            this.tabelaExames.grabFocus();
        }
    }

    @Override
    public void editarResultado(int row, boolean exportando) {
        block8: {
            if (Acesso.getAcesso(1001003005L)) {
                try {
                    if (this.tabelaExames.getRowCount() <= 0) break block8;
                    String req_codigo = StringUtil.isEmpty((String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"))) ? (String)this.tabelaExames.getValueAt(row, this.getColIndice("Multiguia")) : (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                    String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Paciente"));
                    String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Sexo"));
                    String exa_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                    String mco_codigo = String.valueOf(this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat.")));
                    String rec_codigo = String.valueOf(this.tabelaExames.getValueAt(row, this.getColIndice("Tubo")));
                    String situacao = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Sit"));
                    String int_codigo = String.valueOf(this.tabelaExames.getValueAt(row, this.getColIndice("Interface")));
                    String metCodigo = String.valueOf(this.tabelaExames.getValueAt(row, this.getColIndice("Cod. M\u00e9todo")));
                    String usr_codigo = "";
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo Temp."));
                    }
                    String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                    Exame exame = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                    Statement st = Conexao.getStatement();
                    usr_codigo = !Funcoes.textoVazio(exame.getUsuarioExame()) ? exame.getUsuarioExame() : Variaveis.login;
                    EditarResultado dlg = this.exportaExame(exportando, req_codigo, pac_nome, pac_sexo, exa_codigo, mco_codigo, rec_codigo, int_codigo, false, fil_codigo, usr_codigo, st, metCodigo);
                    if (dlg == null) {
                        return;
                    }
                    if (dlg.fechouSalvar()) {
                        this.reloadLinha(row);
                        this.tabelaExames.stepSelection();
                    }
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Funcoes.mensagem(null, "Voc\u00ea n\u00e3o possui permiss\u00e3o para editar resultados", 2);
            }
        }
    }

    public EditarResultado exportaExame(boolean exportando, String req_codigo, String pac_nome, String pac_sexo, String exa_codigo, String mco_codigo, String rec_codigo, String int_codigo, boolean permiteSalvar, String fil_codigo, String usr_codigo, Statement st, String metCodigo) {
        EditarResultado dlg = new EditarResultado(Laboratorio.getInstancia(), st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, pac_sexo, usr_codigo, null, this.permitirContadorCelulas, permiteSalvar, exportando, metCodigo);
        dlg.setButtonPerguntaVisible();
        dlg.getItemConferenciaAutomatica().setVisible(false);
        dlg.getButtonContador().setVisible(false);
        dlg.getDigi().getPanelArea().removeAll();
        JLabel recoletaLabel = new JLabel("", 0);
        recoletaLabel.setSize(new Dimension(300, 100));
        this.getInformacoesDigitacao(recoletaLabel, fil_codigo, req_codigo, exa_codigo, mco_codigo);
        recoletaLabel.setVisible(true);
        dlg.getDigi().add(recoletaLabel);
        dlg.revalidate();
        dlg.repaint();
        if (!dlg.isMontada()) {
            return null;
        }
        if (!exportando) {
            DialogUtil.centerAndShow(dlg, true, false);
        } else {
            if (!Funcoes.permiteConferirGerarPdf(fil_codigo)) {
                return dlg;
            }
            dlg.acaoSalvarEExportar();
        }
        return dlg;
    }

    public void getInformacoesDigitacao(JLabel label, String filial, String requisicao, String exame, String material) {
        Boolean acessoVerMotivoRecoleta = Acesso.getAcesso(400100135L);
        Registro registro = DBUtil.getSituacaoMotivoRecoleta(filial, requisicao, exame, material);
        StringBuilder buf = new StringBuilder("<html>Material do exame deve ser coletado novamente.");
        if (!Funcoes.textoVazio(registro.getString("motivoRecoleta")) && !acessoVerMotivoRecoleta.booleanValue()) {
            buf.append("<br>").append("<font size=2>Motivo: ").append(registro.getString("motivoRecoleta")).append("</font>");
        }
        if (!Funcoes.textoVazio(registro.getString("justificativaRecoleta")) && !acessoVerMotivoRecoleta.booleanValue()) {
            buf.append("<br>").append("<font size=2>Justificativa: ").append(registro.getString("justificativaRecoleta")).append("</font>");
        }
        buf.append("</html>");
        label.setText(buf.toString());
    }

    @Override
    public String getAtalhos() {
        return null;
    }

    @Override
    public void exibeUltimoExportado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
    }

    @Override
    public void showPopupMenu(MouseEvent e) {
    }
}

