/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.componentes.PanelBotoes;
import jalis.laboratorio.interfaceamento.componentes.PanelHistoricos;
import jalis.laboratorio.interfaceamento.componentes.PanelPaciente;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.liberacaoexame.AbaPadrao;
import jalis.laboratorio.interfaceamento.liberacaoexame.LiberacaoExameMensagem;
import jalis.laboratorio.interfaceamento.liberacaoexame.LiberacaoExameService;
import jalis.laboratorio.interfaceamento.liberacaoexame.StatusExportacao;
import jalis.laboratorio.interfaceamento.resultados.EditarResultado;
import jalis.laboratorio.interfaceamento.resultados.repeticao.AbstractEditarRepeticao;
import jalis.laboratorio.interfaceamento.resultados.repeticao.EditarRepeticaoGrupo;
import jalis.laboratorio.interfaceamento.resultados.repeticao.EditarRepeticaoSimples;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.recepcao.util.SolicitarMotivoRecoleta;
import jalis.util.DBUtil;
import jalis.util.DialogUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AbaPronto
extends AbaPadrao {
    public static final Long MARCAR_RECOLETA = new Long(1010070002L);
    public static final Long MARCAR_REPETICAO = new Long(1010070003L);
    protected JButton jButtonExportar = new BotaoNavegavel("Exportar");
    protected JButton jButtonLiberarUm = new BotaoNavegavel("Exportar");
    private JButton buttonRepetir = new BotaoNavegavel("Repetir");
    private JButton buttonEstornar = new BotaoNavegavel("Estornar");
    private JButton buttonRecoleta = new BotaoNavegavel("Recoleta");
    protected PanelBotoes checked_panel = new PanelBotoes("Validados");
    protected PanelHistoricos his_panel = new PanelHistoricos(false, false);
    protected JPanel panelPaciente = new JPanel(new BorderLayout());
    protected PanelPaciente panelPacienteExportado = new PanelPaciente("\u00daltimo Paciente Exportado");
    protected StatusExportacao panelExportacao;
    protected ArrayList exames = null;
    private boolean mostraColunaFlags = true;
    private String usrCodigo = null;
    private boolean validado = false;

    public AbaPronto(LiberacaoExameMensagem liberacaoExameMensagem) {
        super(liberacaoExameMensagem);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public AbaPronto(LiberacaoExameMensagem liberacaoExameMensagem, boolean destacarExames) {
        super(liberacaoExameMensagem, destacarExames);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.panelPaciente.add((Component)this.panelPacienteExportado, "South");
        this.jPanelFoot.add((Component)this.his_panel, "Center");
        this.jPanelFoot.add((Component)this.panelPaciente, "South");
        this.jPanelHeader.add((Component)this.checked_panel, "West");
        this.jPanelMain.add((Component)this.jPanelHeader, "North");
        this.checked_panel.addButton(this.jButtonExportar, null, 'E', "Exportar para os exames validados");
        this.button_panel.addButton(this.jButtonLiberarUm, null, 'U', "Exportar somente o exame cuja linha est\u00e1 selecionada");
        if (Acesso.getAcesso(MARCAR_REPETICAO)) {
            this.button_panel.addButton(this.buttonRepetir, null, 'R', "Repetir");
            this.button_panel.addButton(this.buttonEstornar, null, 'N', "Estornar");
        }
        if (Acesso.getAcesso(MARCAR_RECOLETA)) {
            this.button_panel.addButton(this.buttonRecoleta, null, 'C', "Recoleta");
        }
        this.his_panel.setBorder(new TitledBorder(BorderFactory.createBevelBorder(1), "Observa\u00e7\u00f5es"));
        this.initTable();
        this.jButtonExportar.addActionListener(e -> {
            this.jButtonExportar_actionPerformed(e);
            this.tabelaExames.grabFocus();
        });
        this.jButtonLiberarUm.addActionListener(e -> {
            this.jButtonLiberarUm_actionPerformed(e);
            this.tabelaExames.grabFocus();
        });
        this.buttonRepetir.addActionListener(e -> {
            int row = this.tabelaExames.getSelectedRow();
            if (row >= 0) {
                this.tabelaExames.setValueAt(SIT_A_REPETIR, row, this.getColIndice("Sit"));
                this.atualizaSituacaoInterfaceExame(row, Integer.valueOf(SIT_A_REPETIR));
            }
        });
        this.buttonEstornar.addActionListener(e -> {
            int row = this.tabelaExames.getSelectedRow();
            if (row >= 0) {
                String situacao = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Sit"));
                if (!situacao.equals(SIT_A_REPETIR)) {
                    Funcoes.mensagem(null, "A\u00e7\u00e3o n\u00e3o realizada. Exame j\u00e1 est\u00e1 em repeti\u00e7\u00e3o no equipamento.", 2);
                } else {
                    this.tabelaExames.setValueAt(SIT_PRONTO, row, this.getColIndice("Sit"));
                    this.atualizaSituacaoInterfaceExame(row, Integer.valueOf(SIT_PRONTO));
                }
            }
        });
        this.buttonRecoleta.addActionListener(e -> {
            int row = this.tabelaExames.getSelectedRow();
            if (row >= 0) {
                String codigoExame = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                SolicitarMotivoRecoleta recoleta = SolicitarMotivoRecoleta.novaInstancia(Laboratorio.getInstancia(), codigoExame, false, Variaveis.filialPadrao);
                recoleta.setVisible(true);
                if (recoleta.getOK()) {
                    int qtDigitosTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                    Registro registro = new Registro();
                    String material = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
                    this.tabelaExames.getRow(row);
                    String codigoReq = StringUtil.isEmpty((String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"))) ? (String)this.tabelaExames.getValueAt(row, this.getColIndice("Multiguia")) : (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                    String requisicao = this.getCodigoRequisicao(qtDigitosTubo, codigoReq);
                    registro.setValor("req_codigo", requisicao);
                    registro.setValor("exa_codigo", codigoExame);
                    registro.setValor("mco_codigo", material);
                    Statement statement = Conexao.getStatement();
                    try {
                        LiberacaoExameService servicelib = new LiberacaoExameService();
                        servicelib.updateRequisicaoRecoleta(registro, statement, recoleta.getMotivoRecoleta(), recoleta.getCodigoMotivo());
                        String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                        StringBuilder bui = DBUtil.geraInsertExameRequisicaoSituacao(Variaveis.filialPadrao, requisicao, codigoExame, material, StringUtil.textoDB(Variaveis.login), "R", String.valueOf(recoleta.getCodigoMotivo()), recoleta.getDescricaoMotivo());
                        Conexao.execute(Variaveis.filialPadrao, Conexao.getStatement(), bui.toString());
                        DBUtil.setExameSituacaoInterfaceamento(statement, Variaveis.filialPadrao, requisicao, codigoExame, material, 12);
                        this.tabelaExames.setValueAt(SIT_A_REPETIR, row, this.getColIndice("Sit"));
                        Conexao.arquivaSQL();
                        this.reloadExames();
                    }
                    catch (Exception ex) {
                        try {
                            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace());
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(statement);
                            throw throwable;
                        }
                        Conexao.fecharStatement(statement);
                    }
                    Conexao.fecharStatement(statement);
                }
            }
        });
        this.panelExportacao = new StatusExportacao(this.colunasVisiveis, this.colunasOcultas, this);
        JPanel pnlAux = new JPanel(new BorderLayout());
        pnlAux.add((Component)this.panelExportacao, "Center");
        this.jPanelHeader.add((Component)pnlAux, "East");
    }

    private void atualizaSituacaoInterfaceExame(int row, Integer situacao) {
        LiberacaoExameService service = new LiberacaoExameService();
        String reqCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
        String exaCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
        String mcoCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
        String recCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
        String intCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            reqCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo Temp."));
        }
        String filCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        reqCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboFilial());
        try {
            service.setExmSituacaoTubo(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, mcoCodigo, exaCodigo, situacao, recCodigo);
            Conexao.arquivaSQL();
            this.reloadExames();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace());
        }
    }

    private String getCodigoRequisicao(int qtDigitosTubo, String identificacao) {
        String requisicao = identificacao.length() == qtDigitosTubo ? StringUtil.removeZerosEsquerda(identificacao.substring(ParametrosGerais.getDigitosTuboFilial(), identificacao.length() - ParametrosGerais.getDigitosTuboTubo())) : StringUtil.removeZerosEsquerda(identificacao.substring(ParametrosGerais.getDigitosTuboFilial(), identificacao.length()));
        return requisicao;
    }

    public StatusExportacao getStatusExportacao() {
        return this.panelExportacao;
    }

    protected void initTable() {
        int index = 0;
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            this.addColVisivel("Multiguia");
            ++index;
        }
        this.addColVisivel("C\u00f3digo");
        ++index;
        this.addColVisivel("Paciente");
        ++index;
        this.addColVisivel("Sexo");
        ++index;
        this.addColVisivel("Idade");
        ++index;
        this.addColVisivel("Mat.");
        ++index;
        this.addColVisivel("Exame");
        int n = ++index;
        this.addColVisivel(n, "Res.Quanti", "resultado_quantitativo", false);
        int n2 = ++index;
        ++index;
        this.addColVisivel(n2, "Res.Quali", "resultado_qualitativo", false);
        this.addColVisivel("Usuario");
        if (this.mostraColunaFlags) {
            this.addColVisivel("F");
            ++index;
        }
        this.addColVisivel("Sit");
        this.addColOculta("C\u00f3d. Mat.");
        this.addColOculta("Tubo");
        this.addColOculta("Valores");
        this.addColOculta("Previs\u00e3o");
        this.addColOculta("Rack");
        this.addColOculta("Urgente");
        this.addColOculta("Interface");
        this.addColOculta("Alternativo");
        this.addColOculta("C\u00f3digo Temp.");
        this.addColOculta("Tubos Filhos");
        this.addColOculta("Cod. M\u00e9todo");
        this.addColOculta("Valor Alterado");
        this.addColOculta("Cod. Apoiado");
        this.addColOculta("Cod. M\u00e9todo");
        this.addColOculta("Exame da Rotina");
        this.addColOculta("Cod. Paciente");
        this.tabelaExames.forceSize(this.getColIndice("C\u00f3digo"), 85);
        this.tabelaExames.forceSize(this.getColIndice("Sexo"), 40);
        this.tabelaExames.forceSize(this.getColIndice("Idade"), 70);
        this.tabelaExames.forceSize(this.getColIndice("Mat."), 50);
        this.tabelaExames.forceSize(this.getColIndice("Exame"), 55);
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            this.tabelaExames.forceSize(this.getColIndice("Multiguia"), 80);
        }
        index = this.getColIndice("Exame");
        this.tabelaExames.forceSize(++index, 80);
        this.tabelaExames.forceSize(++index, 80);
        if (this.mostraColunaFlags) {
            this.tabelaExames.forceSize(this.getColIndice("F"), 16);
        }
        this.tabelaExames.forceSize(this.getColIndice("Sit"), 20);
        this.tabelaExames.forceSize(this.getColIndice("Usuario"), 60);
        this.tabelaExames.setDefaultRenderer(Object.class, this.renderer);
        this.tabelaExames.sortRowsByColumn(0, false, true);
        this.renderer.addColunasCentralizadas(new Integer[]{this.getColIndice("C\u00f3digo"), this.getColIndice("Sexo"), this.getColIndice("Idade"), this.getColIndice("Mat.")});
        this.renderer.setColunaValidacao(this.getColIndice("Sit"));
        if (this.mostraColunaFlags) {
            this.renderer.setColunaFlag(this.getColIndice("F"));
        }
        this.renderer.setColunaDataPrevisao(this.getColIndice("Previs\u00e3o"));
        this.renderer.setColunaUrgente(this.getColIndice("Urgente"));
        this.renderer.setColunaValorAlterado(this.getColIndice("Valor Alterado"));
        this.tabelaExames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = AbaPronto.this.tabelaExames.getSelectedRow();
                if (row >= 0 && !e.getValueIsAdjusting()) {
                    AbaPronto.this.his_panel.loadHistoricos((String)AbaPronto.this.tabelaExames.getValueAt(row, AbaPronto.this.getColIndice("Valores")));
                    AbaPronto.this.validaBotoes(row);
                }
            }
        });
        this.tabelaExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AbaPronto.this.tabelaExames_mouseClicked(e);
            }
        });
        this.tabelaExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AbaPronto.this.tabelaExames_keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                AbaPronto.this.tabelaExames_keyPressed(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadExames() {
        this.setAmpulheta(true);
        try {
            ArrayList<Object[]> dadosTemp = new ArrayList<Object[]>();
            StringBuilder query = new StringBuilder();
            query.append("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, ");
            query.append("a.ier_situacao, a.ier_xmlvalores,a.usr_codigo, b.req_anomes, b.req_idade, ");
            query.append("c.pac_nome, c.pac_sexo, d.mco_abreviatura, a.ier_rackpos, ");
            query.append("a.int_codigo,  f.met_codigo, ");
            query.append("(b.req_urgente or (coalesce(pegaUrgenteExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo), false))) as req_urgente, ");
            query.append(" pegaDataEntregaExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo) as exr_dataentregaprev, ");
            query.append(" pegaAlternativoExameInterface(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo) as emi_alternativo, a.ier_resultadoalterado, ");
            query.append(" examedesmembrado(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo) as exameDesm, ");
            query.append(" pegatubodesmembrado(a.fil_codigo, a.req_codigo, a.rec_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo) as tubos ");
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                query.append(", pegaCodigoMultiguiaMae(a.fil_codigo, a.req_codigo) as multiguia ");
            }
            query.append("from interfaceexamerequisicao a ");
            query.append("join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
            query.append("join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
            query.append("left join examematinterface f on a.fil_codigo=f.fil_codigo and a.exa_codigo=f.exa_codigo and a.mco_codigo=f.mco_codigo and a.int_codigo=f.int_codigo ");
            query.append("join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
            query.append("join examerequisicao e on a.fil_codigo=e.fil_codigo and a.req_codigo=e.req_codigo and a.exa_codigo=e.exa_codigo and a.mco_codigo=e.mco_codigo ");
            query.append("where ");
            query.append(" a.int_codigo = ").append(this.equipamento);
            query.append(" and a.ier_situacao >= ").append(SIT_PRONTO);
            query.append(" and a.ier_situacao <= ").append(SIT_PRONTO_VALIDADO);
            query.append(" and e.exr_situacao not in ( ");
            query.append("'").append("T").append("', ");
            query.append("'").append("A").append("', ");
            query.append("'").append("F").append("', ");
            query.append("'").append("R").append("', ");
            query.append("'").append("N").append("', ");
            query.append("'").append("C").append("', ");
            query.append("'").append("L").append("', ");
            query.append("'").append("E").append("', ");
            query.append("'").append("I").append("' ");
            query.append(") ");
            query.append(" and e.exr_excluido = false and b.req_excluida = false ");
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                query.append(" order by a.fil_codigo, multiguia, a.rec_codigo, a.exa_codigo");
            } else {
                query.append(" order by a.fil_codigo, a.req_codigo, a.rec_codigo, a.exa_codigo");
            }
            PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
            try (ResultSet rs = null;){
                rs = ps.executeQuery();
                query.delete(0, query.length());
                query.append("select b.ier_xmlvalores from interfaceexamerequisicaodesm a");
                query.append(" left join interfaceexamerequisicao b on a.fil_codigo = b.fil_codigo and a.int_codigo = b.int_codigo");
                query.append("   and a.exa_kodigo = b.exa_codigo and a.mco_kodigo = a.mco_codigo and a.req_codigo = b.req_codigo");
                query.append("   and a.rec_codigo = b.rec_codigo");
                query.append(" where b.fil_codigo = ? and b.int_codigo = ? and b.exa_codigo = ? and b.mco_codigo = ?");
                query.append("   and b.req_codigo = ? and b.rec_codigo = ?");
                PreparedStatement psFilhos = Conexao.getPreparedStatement(query.toString());
                ResultSet rsFilhos = null;
                while (rs != null && rs.next()) {
                    Object[] linha = new Object[this.getColCount()];
                    String reqCodigo = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                    reqCodigo = reqCodigo + Funcoes.preencheZero(rs.getInt("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
                    String idade = String.valueOf(rs.getInt("req_idade")) + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                    String nome = rs.getString("pac_nome");
                    if (Funcoes.textoVazio(nome.trim())) {
                        nome = reqCodigo + " Nome nao compativel com interfaceamento";
                    }
                    linha[this.getColIndice((String)"C\u00f3digo")] = reqCodigo;
                    linha[this.getColIndice((String)"Paciente")] = nome;
                    linha[this.getColIndice((String)"Sexo")] = rs.getString("pac_sexo");
                    linha[this.getColIndice((String)"Idade")] = idade;
                    linha[this.getColIndice((String)"Exame")] = rs.getString("exa_codigo");
                    linha[this.getColIndice((String)"Usuario")] = rs.getString("usr_codigo");
                    linha[this.getColIndice((String)"Sit")] = rs.getString("ier_situacao");
                    linha[this.getColIndice((String)"Mat.")] = rs.getString("mco_abreviatura");
                    linha[this.getColIndice((String)"C\u00f3d. Mat.")] = rs.getString("mco_codigo");
                    linha[this.getColIndice((String)"Tubo")] = rs.getString("rec_codigo");
                    linha[this.getColIndice((String)"Valor Alterado")] = rs.getInt("ier_resultadoalterado");
                    String xml = rs.getString("ier_xmlvalores");
                    linha[this.getColIndice((String)"Valores")] = xml;
                    linha[this.getColIndice((String)"Previs\u00e3o")] = rs.getTimestamp("exr_dataentregaprev");
                    if (this.getColIndice("Contador") > -1) {
                        linha[this.getColIndice((String)"Contador")] = rs.getString("ier_rackpos");
                    }
                    if (this.getColIndice("Rack") > -1) {
                        linha[this.getColIndice((String)"Rack")] = rs.getString("ier_rackpos");
                    }
                    if (this.getColIndice("Urgente") > -1) {
                        linha[this.getColIndice((String)"Urgente")] = rs.getBoolean("req_urgente");
                    }
                    linha[this.getColIndice((String)"Interface")] = rs.getString("int_codigo");
                    linha[this.getColIndice((String)"Alternativo")] = rs.getString("emi_alternativo");
                    linha[this.getColIndice((String)"Cod. M\u00e9todo")] = rs.getString("met_codigo");
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        String multiguia = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                        multiguia = multiguia + Funcoes.preencheZero(rs.getInt("multiguia"), ParametrosGerais.getDigitosTuboRequisicao());
                        linha[this.getColIndice((String)"Multiguia")] = multiguia;
                        linha[this.getColIndice((String)"C\u00f3digo Temp.")] = reqCodigo;
                        if (reqCodigo.equalsIgnoreCase(multiguia)) {
                            linha[this.getColIndice((String)"C\u00f3digo")] = "";
                        }
                    }
                    if (rs.getBoolean("exameDesm")) {
                        String tubos = rs.getString("tubos");
                        List<Object> tubosFilho = new ArrayList();
                        if (!Funcoes.textoVazio(tubos)) {
                            tubosFilho = Arrays.asList(tubos.split(","));
                        }
                        linha[this.getColIndice((String)"Tubos Filhos")] = tubosFilho;
                    }
                    if (xml != null) {
                        Map<String, Object> dados = StringUtil.getMapDeXML(xml);
                        if (this.mostraColunaFlags) {
                            List<String> flags = StringUtil.getListDeXML(StringUtil.converteHtmlParaAcentos((String)dados.get("flag")));
                            if (flags != null && !flags.isEmpty()) {
                                linha[this.getColIndice((String)"F")] = true;
                            } else if (rs.getBoolean("exameDesm")) {
                                psFilhos.setInt(1, rs.getInt("fil_codigo"));
                                psFilhos.setInt(2, rs.getInt("int_codigo"));
                                psFilhos.setString(3, rs.getString("exa_codigo"));
                                psFilhos.setInt(4, rs.getInt("mco_codigo"));
                                psFilhos.setLong(5, rs.getLong("req_codigo"));
                                psFilhos.setLong(6, rs.getLong("rec_codigo"));
                                try {
                                    rsFilhos = psFilhos.executeQuery();
                                    while (rsFilhos.next()) {
                                        Map<String, Object> dadosFilho = StringUtil.getMapDeXML(rsFilhos.getString("ier_xmlvalores"));
                                        List<String> flagsFilho = StringUtil.getListDeXML(StringUtil.converteHtmlParaAcentos((String)dadosFilho.get("flag")));
                                        if (flagsFilho == null || flagsFilho.isEmpty()) continue;
                                        linha[this.getColIndice((String)"F")] = true;
                                        break;
                                    }
                                }
                                finally {
                                    if (rsFilhos != null) {
                                        rsFilhos.close();
                                    }
                                }
                            }
                        }
                        for (AbaPadrao.Coluna c : this.colunas) {
                            int index = this.getColIndice(c.getNomeColuna());
                            String campo = c.getNomeCampo();
                            String valor = this.notNull((String)dados.get(campo));
                            linha[index] = valor;
                        }
                    }
                    dadosTemp.add(linha);
                }
                this.tabelaExames.setData(dadosTemp);
                this.tabelaExames.sortRowsByColumn(this.tabelaExames.getColunaOrdenada(), false, false);
                this.exames = dadosTemp;
            }
            ps.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setAmpulheta(false);
    }

    public void validaBotoes(int row) {
        SwingUtilities.invokeLater(() -> {
            if (row < this.tabelaExames.getRowCount()) {
                int sit = Integer.parseInt((String)this.tabelaExames.getValueAt(row, this.getColIndice("Sit")));
                this.jButtonLiberarUm.setEnabled(sit == 7);
            }
        });
    }

    void tabelaExames_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            Point p = e.getPoint();
            int row = this.tabelaExames.rowAtPoint(p);
            int column = this.tabelaExames.columnAtPoint(p);
            int col_situacao = this.getColIndice("Sit");
            String sit = (String)this.tabelaExames.getValueAt(row, col_situacao);
            if (column == col_situacao) {
                if (!sit.equals(SIT_REPETINDO) && !sit.equals(SIT_COM_REPETICAO)) {
                    this.setValidado(row, !e.isControlDown());
                } else {
                    Funcoes.mensagem(null, sit.equals(SIT_REPETINDO) ? "Exames em repeti\u00e7\u00e3o n\u00e3o podem ser validados." : "Exames com resultados de repeti\u00e7\u00e3o devem ser editados antes de serem validados.", 2);
                }
            } else if (sit.equals(SIT_COM_REPETICAO) || sit.equals(SIT_PRONTO)) {
                this.editarResultado(row, false);
            } else {
                String msg = sit.equals(SIT_REPETINDO) ? "O exame est\u00e1 aguardando resultados da repeti\u00e7\u00e3o e n\u00e3o pode ser editado." : "O exame est\u00e1 validado para exporta\u00e7\u00e3o e n\u00e3o pode ser editado. Desmarque-o e tente novamente.";
                Funcoes.mensagem(null, msg, 2);
            }
        }
    }

    public void tabelaExames_keyTyped(KeyEvent e) {
        if (e.isAltDown()) {
            e.consume();
        } else if (e.getKeyChar() == ' ') {
            int row = this.tabelaExames.getSelectedRow();
            if (row >= 0 && this.tabelaExames.getRowCount() > 0) {
                this.editarResultado(row, false);
            }
            this.tabelaExames.grabFocus();
        } else if (Character.isLetterOrDigit(e.getKeyChar())) {
            this.showLocalizar(e.getKeyChar());
        } else {
            this.tabelaExames.grabFocus();
        }
    }

    void tabelaExames_keyPressed(KeyEvent e) {
        block7: {
            int row;
            block6: {
                row = this.tabelaExames.getSelectedRow();
                if (e.getKeyCode() == 121) break block6;
                if (e.getKeyCode() != 120) break block7;
            }
            if (this.tabelaExames.getRowCount() > 0 && row >= 0) {
                String sit = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Sit"));
                if (!sit.equals(SIT_REPETINDO) && !sit.equals(SIT_COM_REPETICAO)) {
                    this.setValidado(row, !e.isControlDown());
                } else {
                    Funcoes.mensagem(null, sit.equals(SIT_REPETINDO) ? "Exames em repeti\u00e7\u00e3o n\u00e3o podem ser validados." : "Exames com resultados de repeti\u00e7\u00e3o devem ser editados antes de serem validados.", 2);
                }
            }
        }
    }

    void jButtonExportar_actionPerformed(ActionEvent e) {
        if (Acesso.getAcesso(1001003002L)) {
            int col_situacao = this.getColIndice("Sit");
            ArrayList<Object[]> examesProntos = new ArrayList<Object[]>();
            int row = 0;
            int resposta = Funcoes.showPerguntaSimNao(Laboratorio.getInstancia(), "Exportar exames", "Exportar exames validados?");
            if (resposta != 0) {
                return;
            }
            while (row < this.tabelaExames.getRowCount()) {
                if (((String)this.tabelaExames.getValueAt(row, col_situacao)).equals(SIT_PRONTO_VALIDADO)) {
                    examesProntos.add(this.tabelaExames.getRow(row));
                    this.tabelaExames.deleteRow(row);
                    continue;
                }
                ++row;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.exportarValidados(examesProntos);
            this.setCursor(Cursor.getDefaultCursor());
            this.reloadExames();
        } else {
            Funcoes.mensagem(null, "Voc\u00ea n\u00e3o possu\u00ed acesso para liberar exames!", 2);
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        System.gc();
        this.setCursor(Cursor.getDefaultCursor());
    }

    void jButtonLiberarUm_actionPerformed(ActionEvent e) {
        if (Acesso.getAcesso(1001003003L)) {
            int resposta;
            int row = this.tabelaExames.getSelectedRow();
            if (row >= 0 && row < this.tabelaExames.getRowCount() && (resposta = Funcoes.showPerguntaSimNao(Laboratorio.getInstancia(), "Exportar exame \u00fanico", "Exportar o exame selecionado?")) == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.liberarUm(row);
                this.reloadExames();
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            Funcoes.mensagem(null, "Voc\u00ea n\u00e3o possu\u00ed acesso para liberar exames!", 2);
        }
    }

    public void setValidado(int row, boolean validacao) {
        this.setAmpulheta(true);
        if (row >= 0 && row < this.tabelaExames.getRowCount()) {
            try {
                Statement st = Conexao.getStatement();
                int situacao = validacao ? 7 : 2;
                String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                String exa_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
                String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                String user_code = Variaveis.login;
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo Temp."));
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                BDUtil.setExmSituacaoEAssinatura(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, situacao, user_code);
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo)) {
                    BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, situacao);
                }
                Conexao.arquivaSQL();
                this.tabelaExames.setValueAt(String.valueOf(situacao), row, this.getColIndice("Sit"));
                this.tabelaExames.setValueAt(String.valueOf(user_code), row, this.getColIndice("Usuario"));
                this.tabelaExames.stepSelection();
                st.close();
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    this.reloadExames();
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
            }
        }
        this.setAmpulheta(false);
    }

    @Override
    public void editarResultado(int row, boolean exportando) {
        block15: {
            if (Acesso.getAcesso(1001003005L)) {
                try {
                    String fil_codigo;
                    Exame exame;
                    if (this.tabelaExames.getRowCount() <= 0) break block15;
                    String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
                    String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Paciente"));
                    String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Sexo"));
                    String exa_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame"));
                    String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
                    String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
                    String situacao = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Sit"));
                    String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                    String metCodigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Cod. M\u00e9todo"));
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo Temp."));
                    }
                    boolean permiteSalvar = true;
                    if (situacao.equals(SIT_REPETINDO) || situacao.equals(SIT_A_REPETIR)) {
                        permiteSalvar = false;
                    }
                    this.usrCodigo = !Funcoes.textoVazio((exame = new Exame(fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial()), int_codigo, req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial()), exa_codigo, mco_codigo, rec_codigo)).getUsuarioExame()) && this.validado ? exame.getUsuarioExame() : Variaveis.login;
                    Statement st = Conexao.getStatement();
                    if (Acesso.getAcesso(1001003009L) || !situacao.equals(SIT_PRONTO_VALIDADO) && !situacao.equals(SIT_REPETINDO)) {
                        JDialog dlg;
                        if (situacao.equals(SIT_COM_REPETICAO)) {
                            boolean is_grupo = BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo);
                            dlg = is_grupo ? new EditarRepeticaoGrupo(Laboratorio.getInstancia(), fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, this.usrCodigo) : new EditarRepeticaoSimples(Laboratorio.getInstancia(), fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, this.usrCodigo);
                            DialogUtil.centerAndShow(dlg, true, false);
                            this.reloadLinha(row);
                            this.validaBotoes(row);
                            if (!((AbstractEditarRepeticao)dlg).fechouOK()) {
                                return;
                            }
                        }
                        if ((dlg = this.exportaExame(exportando, req_codigo, pac_nome, pac_sexo, exa_codigo, mco_codigo, rec_codigo, int_codigo, permiteSalvar, fil_codigo, this.usrCodigo, st, metCodigo)) == null) {
                            return;
                        }
                        if (((EditarResultado)dlg).fechouSalvar()) {
                            this.reloadLinha(row);
                            this.validaBotoes(row);
                            if (this.getColIndice("Valores") < this.tabelaExames.getColumnCount() && null != this.tabelaExames.getValueAt(row, this.getColIndice("Valores"))) {
                                this.his_panel.loadHistoricos((String)this.tabelaExames.getValueAt(row, this.getColIndice("Valores")));
                            }
                            this.tabelaExames.stepSelection();
                        } else if (((EditarResultado)dlg).fechouSalvarEExportar()) {
                            this.reloadExames();
                        }
                        break block15;
                    }
                    Funcoes.mensagem(null, situacao.equals(SIT_PRONTO_VALIDADO) ? "Exame j\u00e1 validado! Somente exames n\u00e3o validados podem ser editados." : "O sistema est\u00e1 aguardando o resultado da repeti\u00e7\u00e3o pelo equipamento.", 2);
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                Funcoes.mensagem(null, "Voc\u00ea n\u00e3o possui permiss\u00e3o para editar resultados", 2);
            }
        }
    }

    public EditarResultado exportaExame(boolean exportando, String req_codigo, String pac_nome, String pac_sexo, String exa_codigo, String mco_codigo, String rec_codigo, String int_codigo, boolean permiteSalvar, String fil_codigo, String usr_codigo, Statement st, String metCodigo) {
        EditarResultado dlg = new EditarResultado(Laboratorio.getInstancia(), st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, pac_sexo, usr_codigo, null, this.permitirContadorCelulas, permiteSalvar, exportando, metCodigo);
        if (!dlg.isMontada()) {
            return null;
        }
        if (!exportando) {
            DialogUtil.centerAndShow(dlg, true, false);
        } else {
            if (!Funcoes.permiteConferirGerarPdf(fil_codigo)) {
                return dlg;
            }
            dlg.acaoSalvarEExportar();
        }
        return dlg;
    }

    private String exportarValidados(ArrayList<Object[]> examesProntos) {
        this.jButtonExportar.setEnabled(false);
        this.jButtonLiberarUm.setEnabled(false);
        String retorno = "Exames exportados com sucesso";
        try {
            this.panelExportacao.addExames(examesProntos);
            this.panelExportacao.restart();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                retorno = "Erro: Os exames n\u00e3o puderam ser exportados. " + ex.getMessage();
            }
            catch (SQLException ex2) {
                ErrorLogger.mostraMensagem(this, ex2.getMessage(), ex2.getStackTrace());
            }
        }
        this.jButtonExportar.setEnabled(true);
        this.jButtonLiberarUm.setEnabled(true);
        return retorno;
    }

    private String liberarUm(int row) {
        String retorno = "";
        this.setAmpulheta(true);
        try {
            this.setValidado(true);
            this.editarResultado(row, true);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            try {
                retorno = "Erro: O exame n\u00e3o p\u00f4de ser exportado. " + ex.getLocalizedMessage();
                Conexao.anulaSQL();
                this.reloadExames();
            }
            catch (SQLException ex2) {
                ErrorLogger.mostraMensagem(this, ex2.getMessage(), ex2.getStackTrace());
            }
        }
        this.setAmpulheta(false);
        return retorno;
    }

    @Override
    public String getAtalhos() {
        return "[ESP]-Resultado";
    }

    public ArrayList getExames() {
        return this.exames;
    }

    @Override
    public void exibeUltimoExportado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
        this.panelPacienteExportado.showPacInfo(req_codigo, pac_nome);
    }

    @Override
    public void showPopupMenu(MouseEvent e) {
        this.popupPronto.show(e.getComponent(), e.getX(), e.getY());
    }

    public void setValidado(boolean validado) {
        this.validado = validado;
    }

    public boolean getValidado() {
        return this.validado;
    }
}

