/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.laboratorio.interfaceamento.liberacaoexame.AbaPadrao;
import jalis.laboratorio.interfaceamento.liberacaoexame.LiberacaoExameMensagem;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AbaPendente
extends AbaPadrao {
    protected ArrayList exames = null;

    public AbaPendente(LiberacaoExameMensagem liberacaoExameMensagem) {
        super(liberacaoExameMensagem);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.initTable();
    }

    protected void initTable() {
        this.addColVisivel("C\u00f3digo");
        this.addColVisivel("Paciente");
        this.addColVisivel("Sexo");
        this.addColVisivel("Idade");
        this.addColVisivel("Data");
        this.addColVisivel("Hora");
        this.addColVisivel("Mat.");
        this.addColVisivel("Exame");
        this.addColOculta("C\u00f3d. Mat.");
        this.addColOculta("Tubo");
        this.addColOculta("Previs\u00e3o");
        this.addColOculta("Rack");
        this.addColOculta("Urgente");
        this.addColOculta("Interface");
        this.addColOculta("Alternativo");
        this.addColOculta("Sit");
        this.addColOculta("Multiguia");
        this.addColOculta("C\u00f3digo Temp.");
        this.addColOculta("Tubos Filhos");
        this.tabelaExames.forceSize(this.getColIndice("C\u00f3digo"), 90);
        this.tabelaExames.forceSize(this.getColIndice("Sexo"), 40);
        this.tabelaExames.forceSize(this.getColIndice("Idade"), 65);
        this.tabelaExames.forceSize(this.getColIndice("Data"), 80);
        this.tabelaExames.forceSize(this.getColIndice("Hora"), 50);
        this.tabelaExames.forceSize(this.getColIndice("Mat."), 50);
        this.tabelaExames.forceSize(this.getColIndice("Exame"), 55);
        this.tabelaExames.setDefaultRenderer(Object.class, this.renderer);
        this.renderer.addColunasCentralizadas(new Integer[]{this.getColIndice("C\u00f3digo"), this.getColIndice("Sexo"), this.getColIndice("Idade"), this.getColIndice("Data"), this.getColIndice("Hora"), this.getColIndice("Mat.")});
        this.renderer.setColunaDataPrevisao(this.getColIndice("Previs\u00e3o"));
        this.renderer.setColunaUrgente(this.getColIndice("Urgente"));
        this.tabelaExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                AbaPendente.this.tabelaExames_keyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    e.consume();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadExames() {
        this.setAmpulheta(true);
        try {
            int i;
            ArrayList<Object[]> dadosTemp = new ArrayList<Object[]>();
            StringBuilder sqlwhere = new StringBuilder();
            StringBuilder query = new StringBuilder();
            query.append("select a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, b.req_data, ");
            query.append("b.req_hora, b.req_anomes, b.req_idade, c.pac_nome, c.pac_sexo, d.mco_abreviatura, ");
            query.append("e.exr_dataentregaprev, a.ier_rackpos, (b.req_urgente or (coalesce(e.exr_urgente, false))) as req_urgente, a.int_codigo, f.emi_alternativo, a.ier_situacao, ");
            query.append("examedesmembrado(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo) as exameDesm, ");
            query.append("pegatubodesmembrado(a.fil_codigo, a.req_codigo, a.rec_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo) as tubos ");
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                query.append(", pegaCodigoMultiguiaMae(a.fil_codigo, a.req_codigo) as multiguia ");
            }
            query.append("from interfaceexamerequisicao a ");
            query.append("left join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
            query.append("left join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
            query.append("left join examerequisicao e on a.fil_codigo=e.fil_codigo and a.req_codigo=e.req_codigo ");
            query.append(" and a.exa_codigo=e.exa_codigo and a.mco_codigo=e.mco_codigo ");
            query.append("left join examematinterface f on a.fil_codigo=f.fil_codigo and a.exa_codigo=f.exa_codigo and a.mco_codigo=f.mco_codigo and a.int_codigo=f.int_codigo ");
            query.append("left join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
            query.append("where ");
            if (this.filiais != null && this.filiais.length > 0) {
                sqlwhere.append(" a.fil_codigo  in (");
                for (i = 0; i < this.filiais.length; ++i) {
                    if (i > 0) {
                        sqlwhere.append(", ");
                    }
                    sqlwhere.append(this.filiais[i]);
                }
                sqlwhere.append(")");
            }
            if (this.coletas != null && this.coletas.length > 0) {
                if (sqlwhere.length() > 0) {
                    sqlwhere.append(" and ");
                }
                sqlwhere.append(" b.col_codigo  in (");
                for (i = 0; i < this.coletas.length; ++i) {
                    if (i > 0) {
                        sqlwhere.append(", ");
                    }
                    sqlwhere.append("'").append(this.coletas[i]).append("'");
                }
                sqlwhere.append(")");
            }
            if (this.destinos != null && this.destinos.length > 0) {
                if (sqlwhere.length() > 0) {
                    sqlwhere.append(" and ");
                }
                sqlwhere.append(" b.des_codigo  in (");
                for (i = 0; i < this.destinos.length; ++i) {
                    if (i > 0) {
                        sqlwhere.append(", ");
                    }
                    sqlwhere.append("'").append(this.destinos[i]).append("'");
                }
                sqlwhere.append(")");
            }
            query.append(sqlwhere.toString());
            if (sqlwhere.length() > 0) {
                query.append(" and ");
            }
            query.append(" a.int_codigo = ").append(this.equipamento);
            query.append(" and a.ier_situacao = ").append(SIT_PENDENTE);
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                query.append(" order by a.fil_codigo, multiguia, a.rec_codigo, a.exa_codigo");
            } else {
                query.append(" order by a.fil_codigo, a.req_codigo, a.rec_codigo, a.exa_codigo");
            }
            PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
            try (ResultSet rs = null;){
                rs = ps.executeQuery();
                while (rs != null && rs.next()) {
                    Object[] linha = new Object[this.getColCount()];
                    String reqCodigo = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                    reqCodigo = reqCodigo + Funcoes.preencheZero(rs.getInt("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
                    String idade = String.valueOf(rs.getInt("req_idade")) + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                    Date ddata = rs.getDate("req_data");
                    Time hhora = rs.getTime("req_hora");
                    String data = ddata == null ? "" : new SimpleDateFormat("dd/MM/yyyy").format(ddata);
                    String hora = hhora == null ? "" : new SimpleDateFormat("HH:mm").format(hhora);
                    String nome = rs.getString("pac_nome");
                    if (Funcoes.textoVazio(nome.trim())) {
                        nome = reqCodigo + " Nome nao compativel com interfaceamento";
                    }
                    linha[this.getColIndice((String)"C\u00f3digo")] = reqCodigo;
                    linha[this.getColIndice((String)"Exame")] = rs.getString("exa_codigo");
                    linha[this.getColIndice((String)"Paciente")] = nome;
                    linha[this.getColIndice((String)"Sexo")] = rs.getString("pac_sexo");
                    linha[this.getColIndice((String)"Data")] = data;
                    linha[this.getColIndice((String)"Hora")] = hora;
                    linha[this.getColIndice((String)"Idade")] = idade;
                    linha[this.getColIndice((String)"Mat.")] = rs.getString("mco_abreviatura");
                    linha[this.getColIndice((String)"C\u00f3d. Mat.")] = rs.getString("mco_codigo");
                    linha[this.getColIndice((String)"Tubo")] = rs.getString("rec_codigo");
                    linha[this.getColIndice((String)"Previs\u00e3o")] = rs.getTimestamp("exr_dataentregaprev");
                    linha[this.getColIndice((String)"Rack")] = rs.getString("ier_rackpos");
                    linha[this.getColIndice((String)"Urgente")] = rs.getBoolean("req_urgente");
                    linha[this.getColIndice((String)"Interface")] = rs.getString("int_codigo");
                    linha[this.getColIndice((String)"Alternativo")] = rs.getString("emi_alternativo");
                    linha[this.getColIndice((String)"Sit")] = rs.getString("ier_situacao");
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        String multiguia = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                        multiguia = multiguia + Funcoes.preencheZero(rs.getInt("multiguia"), ParametrosGerais.getDigitosTuboRequisicao());
                        linha[this.getColIndice((String)"Multiguia")] = multiguia;
                        linha[this.getColIndice((String)"C\u00f3digo Temp.")] = reqCodigo;
                    }
                    if (rs.getBoolean("exameDesm")) {
                        linha[this.getColIndice((String)"Tubos Filhos")] = this.getTubosExameDesm(rs);
                    }
                    dadosTemp.add(linha);
                }
                this.exames = ParametrosGerais.isAgruparGuiasInterface() ? this.ordenaExamesMultiGuia(dadosTemp) : dadosTemp;
                this.tabelaExames.setSortedData(this.exames, this.getColIndice("C\u00f3digo"), true);
                this.tabelaExames.grabFocus();
            }
            ps.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setAmpulheta(false);
    }

    private List<String> getTubosExameDesm(ResultSet rs) throws SQLException {
        String tubos = rs.getString("tubos");
        List<String> tubosFilho = new ArrayList<String>();
        if (!Funcoes.textoVazio(tubos)) {
            tubosFilho = Arrays.asList(tubos.split(","));
        }
        return tubosFilho;
    }

    void tabelaExames_keyTyped(KeyEvent e) {
        if (e.isAltDown()) {
            e.consume();
        } else if (Character.isLetterOrDigit(e.getKeyChar())) {
            this.showLocalizar(e.getKeyChar());
        }
    }

    public ArrayList getExames() {
        return this.exames;
    }

    @Override
    public String getAtalhos() {
        return "";
    }

    @Override
    public void exibeUltimoExportado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
    }

    @Override
    public void showPopupMenu(MouseEvent e) {
        this.popupPendente.show(e.getComponent(), e.getX(), e.getY());
    }

    protected ArrayList ordenaExamesMultiGuia(ArrayList lista) throws SQLException {
        ArrayList<Object> nova = new ArrayList<Object>();
        int exameRotina = this.getColIndice("Exame da Rotina");
        int tubo = this.getColIndice("Tubo");
        int exames = this.getColIndice("Exame");
        int material = this.getColIndice("C\u00f3d. Mat.");
        int equip = this.getColIndice("Interface");
        int codigo = this.getColIndice("Multiguia");
        if (lista.size() > 0) {
            Object[] temp = (Object[])lista.remove(0);
            while (!lista.isEmpty()) {
                Object[] prox = (Object[])lista.remove(0);
                String reqa = (String)temp[codigo];
                String fila = reqa.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reca = (String)temp[tubo];
                String inta = (String)temp[equip];
                String reqb = (String)prox[codigo];
                String filb = reqb.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String recb = (String)prox[tubo];
                String intb = (String)prox[equip];
                String exaa = (String)temp[exames];
                String exab = (String)prox[exames];
                if (reqa.equalsIgnoreCase(reqb) && reca.equalsIgnoreCase(recb)) {
                    if (inta.equalsIgnoreCase(intb) && exaa.equalsIgnoreCase(exab)) continue;
                    if (temp != null) {
                        temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                        nova.add(temp.clone());
                    }
                    temp = prox;
                    continue;
                }
                if (temp != null) {
                    temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                    nova.add(temp.clone());
                }
                temp = prox;
            }
            if (temp != null) {
                temp[this.getColIndice((String)"C\u00f3digo")] = temp[codigo];
                nova.add(temp.clone());
            }
            return nova;
        }
        return nova;
    }
}

