/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.informacao.InfoRequisicao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.abas.renderer.TabelaExamesRenderer;
import jalis.laboratorio.interfaceamento.componentes.PanelBotoes;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.liberacaoexame.LiberacaoExameMensagem;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DialogUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TableUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.TabelaModelada;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class AbaPadrao
extends JPanel {
    public static final long PENDENTES_EXCLUIR = 1001002001L;
    public static final long PRONTOS_EXCLUIR = 1001003001L;
    public static final long PRONTOS_EXPORTAR = 1001003002L;
    public static final long PRONTOS_LIBERAR_UM = 1001003003L;
    public static final long PRONTOS_EDITAR = 1001003005L;
    public static final long PRONTOS_EDITAR_VALIDO = 1001003009L;
    public static final String COL_CODIGO = "C\u00f3digo";
    public static final String COL_NOME = "Paciente";
    public static final String COL_SEXO = "Sexo";
    public static final String COL_IDADE = "Idade";
    public static final String COL_DATA = "Data";
    public static final String COL_HORA = "Hora";
    public static final String COL_MATERIAL = "Mat.";
    public static final String COL_EXAME = "Exame";
    public static final String COL_USUARIO = "Usuario";
    public static final String COL_SITUACAO = "Sit";
    public static final String COL_CONTADOR = "Contador";
    public static final String COL_FLAG = "F";
    public static final String COL_VALORALTERADO = "Valor Alterado";
    public static final String COL_MATCOD = "C\u00f3d. Mat.";
    public static final String COL_TUBO = "Tubo";
    public static final String COL_VALORES = "Valores";
    public static final String COL_DATAPREVISAO = "Previs\u00e3o";
    public static final String COL_RACKPOS = "Rack";
    public static final String COL_URGENTE = "Urgente";
    public static final String COL_INTERFACE = "Interface";
    public static final String COL_ALTERNATIVO = "Alternativo";
    public static final String COL_EXAMEROTINA = "Exame da Rotina";
    public static final String COL_MULTIGUIA = "Multiguia";
    public static final String COL_CODIGOTEMP = "C\u00f3digo Temp.";
    public static final String COL_TUBOSFILHO = "Tubos Filhos";
    public static final String SIT_NAO_ENVIADO = String.valueOf(0);
    public static final String SIT_PENDENTE = String.valueOf(1);
    public static final String SIT_PRONTO = String.valueOf(2);
    public static final String SIT_REPETINDO = String.valueOf(3);
    public static final String SIT_A_REPETIR = String.valueOf(5);
    public static final String SIT_COM_REPETICAO = String.valueOf(4);
    public static final String SIT_PRONTO_VALIDADO = String.valueOf(7);
    public static final String SIT_EXPORTADO = String.valueOf(8);
    public static final int SIT_RECOLETA = 12;
    protected static final Cursor CURSOR_ESPERA = new Cursor(3);
    protected static final Cursor CURSOR_SETA = new Cursor(0);
    protected Color COR_ALERTA = SystemColor.inactiveCaption;
    protected Color COR_NORMAL = UIManager.getColor("TabbedPane.unselectedTabBackground");
    protected Color TEXTO = UIManager.getColor("TabbedPane.font");
    protected static final boolean ON = true;
    protected static final boolean OFF = false;
    protected JPanel jPanelMain = new JPanel(new BorderLayout());
    protected JPanel jPanelEquip = new JPanel(new BorderLayout());
    protected JPanel jPanelHeader = new JPanel(new BorderLayout());
    protected JPanel jPanelFoot = new JPanel(new BorderLayout());
    protected PanelBotoes button_panel = new PanelBotoes("Linha selecionada");
    protected JSplitPane splitPane = new JSplitPane(0);
    protected JScrollPane scrollExames = new JScrollPane();
    protected ArrayList<Coluna> colunas = new ArrayList();
    protected TabelaExamesRenderer renderer = new TabelaExamesRenderer();
    protected TabelaModelada tabelaExames = new TabelaModelada(new ArrayList<String>());
    protected ArrayList<String> colunasVisiveis = new ArrayList();
    protected ArrayList<String> colunasOcultas = new ArrayList();
    private JPanel jPanelInfo = new JPanel(new BorderLayout());
    private JPanel jPanelFind = new JPanel(new BorderLayout());
    private JPanel jPanelFindLeft = new JPanel(null);
    private JTextField jTextFieldLocalizar = new JTextField();
    private JLabel jLabelLocalizar = new JLabel("Localizar:");
    private JLabel jLabelAlerta = new JLabel("Conte\u00fado n\u00e3o localizado!");
    AlertThread alerta = new AlertThread();
    protected JPopupMenu popupNaoEnviado = new JPopupMenu("N\u00e3o Enviado");
    protected JPopupMenu popupPendente = new JPopupMenu("Pendete");
    protected JPopupMenu popupPronto = new JPopupMenu("Pronto");
    protected JMenuItem menuItemNaoEnviado = new JMenuItem("Enviar para aba de n\u00e3o enviados");
    protected JMenuItem menuItemPendente = new JMenuItem("Enviar para aba de exames em processamento");
    protected JMenuItem menuItemNaoEnviadoPronto = new JMenuItem("Enviar para aba de n\u00e3o enviados");
    protected JMenuItem menuItemPendentePronto = new JMenuItem("Enviar para aba de exames em processamento");
    protected String[] filiais;
    protected String[] coletas;
    protected String[] destinos;
    protected int equipamento;
    protected boolean permitirContadorCelulas = false;
    protected boolean realizaBusca_flag = false;

    public AbaPadrao(LiberacaoExameMensagem liberacaoExameMensagem) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "AbaPadrao:166");
        }
    }

    public AbaPadrao(LiberacaoExameMensagem liberacaoExameMensagem, boolean destacarExames) {
        try {
            this.renderer.setDestacarValoresAlterados(destacarExames);
            this.jbInit();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "AbaPadrao:166");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.jLabelLocalizar.setDisplayedMnemonic('F');
        this.jLabelLocalizar.setLabelFor(this.jTextFieldLocalizar);
        this.jLabelAlerta.setFont(new Font("Dialog", 1, 11));
        this.jLabelAlerta.setForeground(Color.red);
        this.jLabelAlerta.setBounds(new Rectangle(188, 6, 151, 15));
        this.jLabelAlerta.setVisible(false);
        this.scrollExames.setHorizontalScrollBarPolicy(30);
        this.add((Component)this.jPanelMain, "Center");
        this.add((Component)this.jPanelInfo, "South");
        this.jPanelEquip.add((Component)this.jPanelHeader, "Center");
        this.jPanelHeader.add((Component)this.button_panel, "Center");
        this.jPanelEquip.setFocusable(false);
        this.jLabelLocalizar.setBounds(new Rectangle(5, 6, 58, 15));
        this.jTextFieldLocalizar.setBounds(new Rectangle(62, 3, 121, 21));
        this.jPanelFind.setBorder(BorderFactory.createRaisedBevelBorder());
        this.jPanelFind.setPreferredSize(new Dimension(10, 30));
        this.jPanelInfo.setPreferredSize(new Dimension(10, 0));
        this.jPanelMain.add((Component)this.splitPane, "Center");
        this.splitPane.setBottomComponent(this.jPanelFoot);
        this.splitPane.setTopComponent(this.scrollExames);
        this.jPanelHeader.setPreferredSize(new Dimension(204, 50));
        this.jPanelFind.add((Component)this.jPanelFindLeft, "Center");
        this.jPanelFindLeft.add((Component)this.jTextFieldLocalizar, null);
        this.jPanelFindLeft.add((Component)this.jLabelLocalizar, null);
        this.jPanelFindLeft.add((Component)this.jLabelAlerta, null);
        this.scrollExames.setPreferredSize(new Dimension(700, 4));
        this.splitPane.getInputMap(2).put(KeyStroke.getKeyStroke("F6"), "none");
        this.splitPane.getInputMap(1).put(KeyStroke.getKeyStroke("F6"), "none");
        this.splitPane.getInputMap(0).put(KeyStroke.getKeyStroke("F6"), "none");
        this.splitPane.getInputMap(2).put(KeyStroke.getKeyStroke("F8"), "none");
        this.splitPane.getInputMap(1).put(KeyStroke.getKeyStroke("F8"), "none");
        this.splitPane.getInputMap(0).put(KeyStroke.getKeyStroke("F8"), "none");
        this.splitPane.setFocusable(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AbaPadrao.this.scrollExames.setViewportView(AbaPadrao.this.tabelaExames);
                if ((JTabbedPane)AbaPadrao.this.getParent() != null) {
                    int aba_sel = ((JTabbedPane)AbaPadrao.this.getParent()).getSelectedIndex();
                    String loc = ParametrosLocais.getParametro("aba" + aba_sel);
                    if (loc != null && !loc.equals("")) {
                        AbaPadrao.this.splitPane.setDividerLocation(Integer.parseInt(loc));
                    }
                    AbaPadrao.this.removeComponentListener(AbaPadrao.this.getComponentListeners()[0]);
                }
            }
        });
        this.splitPane.getTopComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int loc = AbaPadrao.this.splitPane.getDividerLocation();
                if (loc >= 0) {
                    int aba_sel = ((JTabbedPane)AbaPadrao.this.getParent()).getSelectedIndex();
                    ParametrosLocais.setParametro("aba" + aba_sel, String.valueOf(loc));
                    ParametrosLocais.salvaParametros();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AbaPadrao.this.this_componentShown(e);
            }
        });
        this.jTextFieldLocalizar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbaPadrao.this.realizaBusca();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbaPadrao.this.realizaBusca();
            }
        });
        this.jTextFieldLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 && !AbaPadrao.this.realizaBusca_flag) {
                    e.consume();
                    AbaPadrao.this.tabelaExames.requestFocusInWindow();
                } else {
                    AbaPadrao.this.showLocalizar();
                }
            }
        });
        this.tabelaExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AbaPadrao.this.jTextFieldLocalizar_keyPressed(e);
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke("control L"), "exibe");
        this.getInputMap(1).put(KeyStroke.getKeyStroke("control L"), "exibe");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("control L"), "exibe");
        this.getActionMap().put("exibe", new AbstractAction("exibe"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaPadrao.this.showLocalizar();
            }
        });
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaPadrao.this.showReqInfo();
            }
        });
        this.popupNaoEnviado.add(this.menuItemPendente);
        this.popupPendente.add(this.menuItemNaoEnviado);
        this.popupPronto.add(this.menuItemNaoEnviadoPronto);
        this.popupPronto.add(this.menuItemPendentePronto);
        this.tabelaExames.setSelectionMode(2);
        this.tabelaExames.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AbaPadrao.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    AbaPadrao.this.showPopupMenu(e);
                }
            }
        });
        this.menuItemPendente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaPadrao.this.enviarExameParaPendente();
            }
        });
        this.menuItemNaoEnviado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaPadrao.this.enviarExameParaNaoEnviado();
            }
        });
        this.menuItemPendentePronto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaPadrao.this.enviarExameParaPendente();
            }
        });
        this.menuItemNaoEnviadoPronto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaPadrao.this.enviarExameParaNaoEnviado();
            }
        });
    }

    protected abstract void loadExames();

    public abstract String getAtalhos();

    public void setAmpulheta(boolean ampulheta_on) {
        Laboratorio.getInstancia().setCursor(ampulheta_on ? CURSOR_ESPERA : CURSOR_SETA);
    }

    public int getRowCount() {
        return this.tabelaExames.getRowCount();
    }

    public int getSelectedRow() {
        return this.tabelaExames.getSelectedRow();
    }

    protected int getColIndice(String nome_coluna) {
        int c = this.colunasVisiveis.indexOf(nome_coluna);
        if (c >= 0) {
            return c;
        }
        c = this.colunasOcultas.indexOf(nome_coluna);
        if (c >= 0) {
            return this.colunasVisiveis.size() + c;
        }
        return -1;
    }

    protected int getColCount() {
        return this.colunasVisiveis.size() + this.colunasOcultas.size();
    }

    protected void addColVisivel(String nome_coluna) {
        this.colunasVisiveis.add(nome_coluna);
        this.tabelaExames.addColumn(nome_coluna);
    }

    protected void addColOculta(String nome_coluna) {
        this.colunasOcultas.add(nome_coluna);
    }

    public void addColVisivel(int index, String nome_coluna, String nome_campo, boolean centralizada) {
        this.colunasVisiveis.add(index, nome_coluna);
        this.colunas.add(new Coluna(nome_coluna, nome_campo));
        this.tabelaExames.addColumn(index, nome_coluna, false);
        this.renderer.corrigeIndices(index);
        if (centralizada) {
            this.renderer.addColunaCentralizada(index);
        }
    }

    public void forceColSize(int index, int size) {
        this.tabelaExames.forceSize(index, size);
    }

    public void alertarUsuario() {
        if (!this.isShowing()) {
            if (this.alerta != null && !this.alerta.isInterrupted()) {
                this.alerta.interrupt();
            }
            this.alerta = new AlertThread();
            this.alerta.start();
        }
    }

    public void reloadExames() {
        block6: {
            int selected = -1;
            String reqSel = "";
            String exaSel = "";
            int colCodigo = this.getColIndice(COL_CODIGO);
            int colExame = this.getColIndice(COL_EXAME);
            if (this.tabelaExames != null && this.tabelaExames.getRowCount() > 0 && colCodigo >= 0 && colExame >= 0 && (selected = this.tabelaExames.getSelectedRow()) >= 0 && selected < this.tabelaExames.getRowCount()) {
                reqSel = (String)this.tabelaExames.getValueAt(selected, colCodigo);
                exaSel = (String)this.tabelaExames.getValueAt(selected, colExame);
            }
            int coluna_ordenada = 0;
            if (this.tabelaExames != null) {
                coluna_ordenada = this.tabelaExames.getColunaOrdenada();
            }
            this.loadExames();
            this.tabelaExames.sortRowsByColumn(coluna_ordenada, true);
            try {
                if (selected < 0 || selected >= this.tabelaExames.getRowCount()) break block6;
                int rowcount = this.tabelaExames.getRowCount();
                String req = (String)this.tabelaExames.getValueAt(selected, this.getColIndice(COL_CODIGO));
                String exa = (String)this.tabelaExames.getValueAt(selected, this.getColIndice(COL_EXAME));
                if (reqSel.equalsIgnoreCase(req) && exaSel.equalsIgnoreCase(exa)) {
                    this.tabelaExames.selectRow(selected);
                    break block6;
                }
                for (int i = 0; i < rowcount && i <= this.tabelaExames.getRowCount(); ++i) {
                    req = (String)this.tabelaExames.getValueAt(i, this.getColIndice(COL_CODIGO));
                    exa = (String)this.tabelaExames.getValueAt(i, this.getColIndice(COL_EXAME));
                    if (!reqSel.equalsIgnoreCase(req) || !exaSel.equalsIgnoreCase(exa)) continue;
                    this.tabelaExames.selectRow(i);
                    break;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "AbaPadrao: 552");
            }
        }
        this.tabelaExames.revalidate();
        this.tabelaExames.grabFocus();
    }

    void this_componentShown(ComponentEvent e) {
        this.setCursor(CURSOR_ESPERA);
        this.setCursor(CURSOR_SETA);
        if (this.alerta != null && !this.alerta.isInterrupted()) {
            this.alerta.interrupt();
        }
    }

    public void realizaBusca() {
        Thread pesquisa = new Thread("Thread - Pesquisa (Abas)"){

            @Override
            public void run() {
                Object cell;
                String prefix = AbaPadrao.this.jTextFieldLocalizar.getText().toLowerCase();
                if (prefix.equals("")) {
                    return;
                }
                int column = AbaPadrao.this.tabelaExames.getColunaOrdenada();
                int rows = AbaPadrao.this.tabelaExames.getRowCount();
                for (int i = 0; i < rows && (cell = AbaPadrao.this.tabelaExames.getValueAt(i, column)) instanceof String; ++i) {
                    String value = ((String)cell).toLowerCase();
                    if (!value.startsWith(prefix)) continue;
                    AbaPadrao.this.tabelaExames.selectRow(i);
                    TableUtil.scrollToCenter(AbaPadrao.this.tabelaExames, i);
                    AbaPadrao.this.tabelaExames.repaint();
                    AbaPadrao.this.jTextFieldLocalizar.setBackground(Color.white);
                    AbaPadrao.this.jTextFieldLocalizar.setForeground(Color.black);
                    AbaPadrao.this.jLabelAlerta.setVisible(false);
                    AbaPadrao.this.realizaBusca_flag = false;
                    return;
                }
                AbaPadrao.this.jTextFieldLocalizar.setBackground(Color.red);
                AbaPadrao.this.jTextFieldLocalizar.setForeground(Color.white);
                AbaPadrao.this.getToolkit().beep();
                AbaPadrao.this.jLabelAlerta.setVisible(true);
                AbaPadrao.this.realizaBusca_flag = true;
            }
        };
        pesquisa.run();
    }

    public void showLocalizar() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AbaPadrao.this.setCursor(Cursor.getPredefinedCursor(3));
                AbaPadrao.this.jPanelInfo.add((Component)AbaPadrao.this.jPanelFind, "North");
                AbaPadrao.this.jPanelInfo.setPreferredSize(new Dimension(10, 30));
                AbaPadrao.this.revalidate();
                AbaPadrao.this.repaint();
                AbaPadrao.this.jTextFieldLocalizar.grabFocus();
                AbaPadrao.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void showLocalizar(char c) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.jPanelInfo.add((Component)this.jPanelFind, "North");
        this.jPanelInfo.setPreferredSize(new Dimension(10, 30));
        this.revalidate();
        this.repaint();
        this.jTextFieldLocalizar.setText(String.valueOf(c));
        this.jTextFieldLocalizar.grabFocus();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void hideLocalizar() {
        this.jPanelInfo.remove(this.jPanelFind);
        this.jPanelInfo.setPreferredSize(new Dimension(10, 0));
        this.jPanelInfo.revalidate();
        this.jPanelInfo.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbaPadrao.this.tabelaExames.grabFocus();
            }
        });
    }

    public String notNull(String text) {
        return text == null || text.equals("null") ? "" : text;
    }

    void showReqInfo() {
        int row = this.tabelaExames.getSelectedRow();
        GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)Laboratorio.getInstancia().getRootPane().getGlassPane();
        InfoRequisicao info = new InfoRequisicao((Frame)Laboratorio.getInstancia(), glassPaneMensagem);
        if (row >= 0 && row < this.tabelaExames.getRowCount()) {
            String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGO));
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGOTEMP));
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            if (!Funcoes.textoVazio(req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial()))) {
                info.setRequisicao(fil_codigo, Integer.parseInt(req_codigo));
            }
        }
        DialogUtil.centerAndShow(info, true, false);
        this.requestFocus();
        this.tabelaExames.grabFocus();
        Laboratorio.getInstancia().getRootPane().setGlassPane(glassPaneMensagem);
    }

    public void jTextFieldLocalizar_keyPressed(KeyEvent e) {
        block5: {
            int row;
            block7: {
                int key;
                block6: {
                    block4: {
                        key = e.getKeyCode();
                        row = this.tabelaExames.getSelectedRow();
                        if (key != 38 || row < 0 || row - 1 < 0) break block4;
                        this.tabelaExames.selectRow(row);
                        this.hideLocalizar();
                        break block5;
                    }
                    if (key != 40 || row < 0 || row + 1 >= this.tabelaExames.getRowCount()) break block6;
                    this.tabelaExames.selectRow(row);
                    this.hideLocalizar();
                    break block5;
                }
                if (key == 40) break block7;
                if (key != 38) break block5;
            }
            if (row < 0 && this.tabelaExames.getRowCount() > 0) {
                this.tabelaExames.selectRow(0);
                this.hideLocalizar();
            }
        }
    }

    public void reloadLinha(int row) {
        this.setAmpulheta(true);
        if (row >= 0 && row < this.tabelaExames.getRowCount()) {
            String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGO));
            String exa_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_EXAME));
            String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_MATCOD));
            String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_TUBO));
            String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_INTERFACE));
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGOTEMP));
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            try {
                Exame exame = new Exame(fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                int situacao = exame.getSituacaoExame();
                int valorAlterado = exame.getValorAlterado();
                String user = !Funcoes.textoVazio(exame.getUsuarioExame()) ? exame.getUsuarioExame() : "";
                Map<String, Object> dados = exame.getDados();
                String xml = StringUtil.getXMLDeMap(dados);
                for (Coluna c : this.colunas) {
                    this.tabelaExames.setValueAt(this.notNull((String)dados.get(c.getNomeCampo())), row, this.getColIndice(c.getNomeColuna()));
                }
                this.tabelaExames.setValueAt(String.valueOf(situacao), row, this.getColIndice(COL_SITUACAO));
                this.tabelaExames.setValueAt(valorAlterado, row, this.getColIndice(COL_VALORALTERADO));
                this.tabelaExames.setValueAt(String.valueOf(user), row, this.getColIndice(COL_USUARIO));
                this.tabelaExames.setValueAt(xml, row, this.getColIndice(COL_VALORES));
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "reloadLinha");
                this.reloadExames();
            }
        }
        this.setAmpulheta(false);
    }

    protected ArrayList getRequisicaoExames(int row, ArrayList exames) {
        ArrayList<Object> requisicaoExames = new ArrayList<Object>();
        String aux = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGO));
        int fil_codigo = Integer.parseInt(aux.substring(0, ParametrosGerais.getDigitosTuboFilial()));
        int req_codigo = Integer.parseInt(aux.substring(ParametrosGerais.getDigitosTuboFilial()));
        int rec_codigo = Integer.parseInt((String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_TUBO)));
        for (int i = 0; i < exames.size(); ++i) {
            Object[] exame = (Object[])exames.get(i);
            aux = (String)exame[this.getColIndice(COL_CODIGO)];
            int filial = Integer.parseInt(aux.substring(0, ParametrosGerais.getDigitosTuboFilial()));
            int requisicao = Integer.parseInt(aux.substring(ParametrosGerais.getDigitosTuboFilial()));
            int tubo = Integer.parseInt((String)exame[this.getColIndice(COL_TUBO)]);
            if (fil_codigo != filial || req_codigo != requisicao || rec_codigo != tubo) continue;
            requisicaoExames.add(exame.clone());
        }
        return requisicaoExames;
    }

    public TabelaModelada getTabela() {
        return this.tabelaExames;
    }

    public abstract void exibeUltimoExportado(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public abstract void showPopupMenu(MouseEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enviarExameParaPendente() {
        if (this.tabelaExames.getSelectedRowCount() == 0) {
            return;
        }
        Statement st = null;
        try {
            st = Conexao.getStatement();
            for (int row : this.tabelaExames.getSelectedRows()) {
                ExameMaterial[] exa_lista;
                String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGO));
                String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_TUBO));
                String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_MATCOD));
                String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_SEXO));
                String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_IDADE));
                String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_NOME));
                String pac_exames = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_EXAME));
                String rack = null;
                if (this.getColIndice(COL_RACKPOS) >= 0) {
                    rack = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_RACKPOS));
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_INTERFACE));
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                for (ExameMaterial e : exa_lista = ExamesUtil.anexarCodigoMaterial(pac_exames.split(" ", 0), mco_codigo)) {
                    if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, e.getNomeExame(), e.getCodigoMaterial())) {
                        BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo, 1);
                    }
                    BDUtil.setExmXmlValores(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), mco_codigo, rec_codigo, "");
                    if (Funcoes.textoVazio(rack)) {
                        BDUtil.setExmSituacao(st, fil_codigo, req_codigo, e.getNomeExame(), mco_codigo, 1, int_codigo, rec_codigo);
                        continue;
                    }
                    BDUtil.setExmSituacao(st, fil_codigo, req_codigo, e.getNomeExame(), mco_codigo, 1, rack, int_codigo, rec_codigo);
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "AbaPadrao (1014)");
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "AbaPadrao (1020)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enviarExameParaNaoEnviado() {
        if (this.tabelaExames.getSelectedRowCount() == 0) {
            return;
        }
        Statement st = null;
        try {
            st = Conexao.getStatement();
            for (int row : this.tabelaExames.getSelectedRows()) {
                ExameMaterial[] exa_lista;
                String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_CODIGO));
                String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_TUBO));
                String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_MATCOD));
                String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_SEXO));
                String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_IDADE));
                String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_NOME));
                String pac_exames = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_EXAME));
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice(COL_INTERFACE));
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                for (ExameMaterial e : exa_lista = ExamesUtil.anexarCodigoMaterial(pac_exames.split(" ", 0), mco_codigo)) {
                    if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, e.getNomeExame(), e.getCodigoMaterial())) {
                        BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo, 0);
                    }
                    BDUtil.setExmXmlValores(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), mco_codigo, rec_codigo, "");
                    BDUtil.setExmSituacao(st, fil_codigo, req_codigo, e.getNomeExame(), mco_codigo, 0, int_codigo, rec_codigo);
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "AbaPadrao (1062)");
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), ex.getMessage(), ex.getStackTrace(), "AbaPadrao (1068)");
            }
        }
    }

    public void setFiliais(String[] filiais) {
        this.filiais = filiais;
    }

    public void setColetas(String[] coletas) {
        this.coletas = coletas;
    }

    public void setDestinos(String[] destinos) {
        this.destinos = destinos;
    }

    public void setEquipamento(int equipamento) {
        this.equipamento = equipamento;
    }

    public void setPermitirContadorCelulas(boolean p) {
        this.permitirContadorCelulas = p;
    }

    public boolean isPermitirContadorCelulas() {
        return this.permitirContadorCelulas;
    }

    public void editarResultado(int row, boolean exportando) {
    }

    public class Coluna {
        private String nome_coluna;
        private String nome_campo;

        public Coluna(String nome_coluna, String nome_campo) {
            this.nome_coluna = nome_coluna;
            this.nome_campo = nome_campo;
        }

        public String getNomeColuna() {
            return this.nome_coluna;
        }

        public String getNomeCampo() {
            return this.nome_campo;
        }
    }

    class AlertThread
    extends Thread {
        public AlertThread() {
            this.setPriority(1);
        }

        @Override
        public void run() {
            JTabbedPane pai = (JTabbedPane)AbaPadrao.this.getParent();
            try {
                while (true) {
                    pai.setBackgroundAt(pai.indexOfComponent(AbaPadrao.this), AbaPadrao.this.COR_ALERTA);
                    pai.revalidate();
                    pai.repaint();
                    AlertThread.sleep(500L);
                    pai.setBackgroundAt(pai.indexOfComponent(AbaPadrao.this), AbaPadrao.this.COR_NORMAL);
                    pai.revalidate();
                    pai.repaint();
                    AlertThread.sleep(500L);
                }
            }
            catch (InterruptedException ex) {
                pai.setBackgroundAt(pai.indexOfComponent(AbaPadrao.this), AbaPadrao.this.COR_NORMAL);
                return;
            }
        }
    }
}

