/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.liberacaoexame;

import jalis.laboratorio.interfaceamento.componentes.PanelBotoes;
import jalis.laboratorio.interfaceamento.liberacaoexame.AbaPadrao;
import jalis.laboratorio.interfaceamento.liberacaoexame.LiberacaoExameMensagem;
import jalis.util.Funcoes;
import jalis.util.TempoUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;

public class AbaExcecoes
extends AbaPadrao {
    public static final String ERRO_FALTA_MATERIAL_ALTERNATIVO = "Material alternativo n\u00e3o definido para o exame";
    protected static final String COL_MOMENTO = "Data - Hora";
    protected static final String COL_EXCECAO = "Exce\u00e7\u00e3o";
    protected PanelBotoes button_panel = new PanelBotoes("Linha selecionada");
    protected JButton jButtonExcluir = new BotaoNavegavel("Excluir", 'c');
    protected JButton jButtonExcluirTodos = new BotaoNavegavel("Excluir Todas", 'T');
    JFrame parent;

    public AbaExcecoes() {
        super((LiberacaoExameMensagem)null);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AbaExcecoes");
        }
    }

    @Override
    protected void loadExames() {
    }

    public void jbInit() {
        this.jPanelHeader.add((Component)this.button_panel, "Center");
        this.button_panel.addButton(this.jButtonExcluir, null, 'c', "Excluir a exce\u00e7\u00e3o selecionada");
        this.button_panel.addButton(this.jButtonExcluirTodos, new Insets(2, 0, 2, 0), 'T', "Excluir todas as exce\u00e7\u00f5es");
        this.addColVisivel(COL_MOMENTO);
        this.addColVisivel(COL_EXCECAO);
        this.tabelaExames.forceSize(this.getColIndice(COL_MOMENTO), 120);
        this.tabelaExames.setDefaultRenderer(Object.class, this.renderer);
        this.tabelaExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                int row;
                if (e.getKeyChar() == '\u007f' && (row = AbaExcecoes.this.tabelaExames.getSelectedRow()) >= 0) {
                    AbaExcecoes.this.excluirExcecao(row);
                }
            }
        });
        this.jButtonExcluir.addActionListener(e -> {
            int row = this.tabelaExames.getSelectedRow();
            if (row >= 0) {
                this.excluirExcecao(row);
            }
            this.tabelaExames.grabFocus();
        });
        this.jButtonExcluirTodos.addActionListener(e -> {
            this.excluirTodas();
            this.tabelaExames.grabFocus();
        });
    }

    public void adicionarExcecao(String exception) {
        StringBuilder momento = new StringBuilder(TempoUtil.getCurrentDateBr()).append(" ").append(TempoUtil.getCurrentTime());
        Object[] linha = new String[]{momento.toString(), exception};
        this.tabelaExames.addRow(linha);
        this.alertarUsuario();
    }

    public void excluirExcecao(int row) {
        this.tabelaExames.deleteRow(row);
    }

    public void excluirTodas() {
        int resposta = Funcoes.showPerguntaSimNao(this.parent, "", "Tem certeza que deseja excluir todas as exce\u00e7\u00f5es?");
        if (resposta == 0) {
            this.tabelaExames.setData(new ArrayList());
        }
    }

    public void transmiteExames(int row, String exames) {
    }

    @Override
    public String getAtalhos() {
        return "[DEL]-Excluir";
    }

    @Override
    public void showPopupMenu(MouseEvent e) {
    }

    @Override
    public void exibeUltimoExportado(String req_codigo, String pac_nome, String pac_sexo, String req_idade, String req_data, String req_hora, String pac_exames) {
    }
}

