/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.zybioexc200;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageDsrQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrmO01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQckQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQryQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentDsp;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsh;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentQak;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class InterfaceListener
extends InterfaceHl7Listener {
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private static final String MSG_ACEITA = "Mensagem aceita";

    public InterfaceListener() {
        super("Zybio EXC 200");
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setSendingApplication("Zybio");
            mensagem.getMsh().setSendingFacility("EXC200");
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setApplicationAckType(MessageSegmentMsh.ApplicationAckType.SAMPLE_RESULT);
            mensagem.getMsh().setVersionId("2.5");
            mensagem.getMsh().setCharacterSet("UNICODE");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            this.getPortaCOM().write(this.messageParser.messageToText(mensagem, this.fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00c3\u00a7\u00c3\u00a3o com o equipamento.", e.getStackTrace());
        }
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        this.processaMensagem(oruR01);
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage(MSG_ACEITA);
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    private String getCodigoInterface(String filCodigo, String reqCodigo, String recCodigo, String emiAlternativo) throws SQLException {
        String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
        if (Funcoes.textoVazio(intCodigo)) {
            intCodigo = this.verificarRepeticao(filCodigo, reqCodigo, recCodigo);
        }
        return intCodigo;
    }

    private String verificarRepeticao(String filCodigo, String reqCodigo, String recCodigo) throws SQLException {
        String intCodigo = "";
        for (ConfiguracaoSerial c : Variaveis.equipamentos) {
            for (EquipamentoFilial f : c.getEquipamentos()) {
                StringBuilder sql = new StringBuilder();
                sql.append("select int_codigo from interfaceexamerequisicao ");
                sql.append("where fil_codigo = ").append(filCodigo);
                sql.append("  and int_codigo = ").append(f.getEquipamento());
                sql.append("  and req_codigo = ").append(reqCodigo);
                sql.append("  and rec_codigo = ").append(recCodigo);
                sql.append("  and ier_situacao = ").append(3);
                Statement st = Conexao.getStatement();
                ResultSet rs = Conexao.executeQuery(st, sql.toString());
                intCodigo = rs.next() ? rs.getString("int_codigo") : "";
                Conexao.fecharStatement(st);
            }
        }
        return intCodigo;
    }

    private void processaMensagem(MessageOruR01 oruR01) {
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getObr().getPlacerOrderNumber();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                if (etiqueta != null) {
                    filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                    reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                    recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                }
                for (MessageSegmentObx obx : oruR01.getObxList()) {
                    String emiAlternativo = String.valueOf(obx.getObservationId());
                    String intCodigo = this.getCodigoInterface(filCodigo, reqCodigo, recCodigo, emiAlternativo);
                    if (Funcoes.textoVazio(intCodigo)) {
                        this.fireExcecaoEncontrada(String.format("Amostra n\u00c3\u00a3o localizada na interface id %s %s %s alternativo %s", filCodigo, reqCodigo, recCodigo, emiAlternativo));
                        continue;
                    }
                    ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                    if (exame != null) {
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        ArrayList<String> flags = new ArrayList<String>();
                        if (obx.getAbnormalFlag() != null) {
                            flags.add(obx.getAbnormalFlag().toString());
                        }
                        int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                        String campo = "resultado_quantitativo";
                        String resultado = "";
                        if (Funcoes.textoVazio(obx.getUnits())) continue;
                        switch (obx.getValueType()) {
                            case NUMERIC: {
                                campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                                resultado = obx.getObservationValue();
                                resultado = this.arrendondaValor(resultado, filCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo);
                                resultado = resultado.replace('.', ',');
                                break;
                            }
                            case STRING: {
                                campo = sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo";
                                resultado = obx.getObservationValue();
                            }
                        }
                        if (sit != 3 && sit != 5 && sit != 1 && sit != 0) continue;
                        dados.put(campo, resultado);
                        this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados);
                        continue;
                    }
                    this.fireExcecaoEncontrada(String.format("Exame n\u00c3\u00a3o localizado ou j\u00c3\u00a1 exportado na interface id %s %s %s alternativo %s", filCodigo, reqCodigo, recCodigo, emiAlternativo));
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            } else {
                this.fireExcecaoEncontrada(String.format("Amostra fora do padr\u00c3\u00a3o utilizado ou amostra passada manualmente %s", tuboId));
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public void messageQryQ02Recebida(MessageQryQ02 qryQ02) {
        block22: {
            String messageId = qryQ02.getMsh().getMessageControlId();
            MessageQckQ02 qckQ02 = new MessageQckQ02();
            qckQ02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
            qckQ02.getMsa().setTextMessage(MSG_ACEITA);
            qckQ02.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
            qckQ02.getErr().setErrorCode(0);
            qckQ02.getQak().setQueryTag("SR");
            try {
                String tuboId = qryQ02.getQrd().getWhoSubjectFilter();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && !tuboId.equals("null") && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                    if (etiqueta != null) {
                        filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                        reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                        recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    }
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    String exames = "";
                    StringBuilder examesFilho = new StringBuilder();
                    if (req != null) {
                        exames = (String)req[aba.getColIndice("Exame")];
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1), aba = this.equipamento.getTab(1), exames, 1)) && req != null && !Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                        exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 1);
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2), aba = this.equipamento.getTab(2), exames, 2)) && req != null && !Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                        exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 2);
                    }
                    if (req == null) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        return;
                    }
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String recTuboPai = (String)req[aba.getColIndice("Tubo")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.trim().split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        boolean curva = BDUtil.isExameCurva(filCodigo, intCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            int sitFilho;
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (!(n != 0 && n != 1 || curva)) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            if (curva) {
                                for (ExameMaterial exameFilho : examesFilhos) {
                                    sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recTuboPai, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    String tuboFilho = BDUtil.getExameDesmembradoTubo(filCodigo, reqCodigo, recTuboPai, intCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    if (sitFilho != 0 && sitFilho != 1 && sitFilho != 3 || !Funcoes.preencheZero(tuboFilho, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo)) continue;
                                    examesFilho.append(exameFilho.getNomeExame()).append(" ");
                                    examesParaEnviar.add(exameFilho);
                                }
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test == null || test.trim().isEmpty()) continue;
                        tests.add(test);
                    }
                    if (tests.isEmpty()) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        infoExameRequisicao.setInterface(intCodigo);
                        if (!Funcoes.preencheZero(recTuboPai, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo) && !Funcoes.textoVazio(examesFilho.toString().trim())) {
                            infoExameRequisicao.setTuboPai(recTuboPai);
                            infoExameRequisicao.setExamesFilho(examesFilho.toString().trim());
                            infoExameRequisicao.setCurva(true);
                        }
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        String string = BDUtil.getExmEquipamentoMaterial(filCodigo, ((ExameMaterial)examesParaEnviar.get(0)).getNomeExame(), mcoCodigo, intCodigo);
                        String pacNasc = this.getPacienteDataNascimento(filCodigo, reqCodigo);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        MessageDsrQ03 dsrQ03 = new MessageDsrQ03();
                        dsrQ03.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        dsrQ03.getMsa().setTextMessage(MSG_ACEITA);
                        dsrQ03.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
                        dsrQ03.getErr().setErrorCode(0);
                        dsrQ03.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        dsrQ03.getQak().setQueryTag("SR");
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp(pacNome));
                        dsrQ03.addDsp(new MessageSegmentDsp(pacNasc));
                        dsrQ03.addDsp(new MessageSegmentDsp(pacSexo));
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp(tuboId));
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp(!Funcoes.textoVazio(string) ? string : ""));
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        dsrQ03.addDsp(new MessageSegmentDsp());
                        for (String test : tests) {
                            dsrQ03.addDsp(new MessageSegmentDsp(test));
                        }
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.enviaMensagem(messageId, dsrQ03);
                    }
                    break block22;
                }
                qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.APPLICATION_REJECT);
                this.enviaMensagem(messageId, qckQ02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    @Override
    protected String getPacienteDataNascimento(String filial, String requisicao) {
        Date nasc = BDUtil.getDataNacimentoPaciente(filial, requisicao);
        if (null == nasc) {
            return "";
        }
        return Funcoes.formataData("yyyyMMdd", nasc);
    }

    public void addListaRecebimento(MessageOruR01 message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento == null || this.threadRecebimento.isInterrupted() || !this.threadRecebimento.isAlive()) {
            if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
                List<MessageOruR01> lista = this.threadRecebimento.getListaRecebimento();
                this.threadRecebimento = new ThreadRecebimento();
                this.threadRecebimento.addListaRecebimentos(lista);
            }
            if (this.threadRecebimento != null) {
                this.threadRecebimento.start();
            }
        }
    }

    @Override
    public String parse(String text) {
        text = this.replaceUnicode(text);
        try {
            Message message = this.messageParser.textToMessage(text);
            this.mensagemRecebida(message);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    protected void mensagemRecebida(Message message) {
        switch (message.getType()) {
            case ORU_R01: {
                this.messageOruR01Recebida((MessageOruR01)message);
                break;
            }
            case QRY_Q02: {
                this.messageQryQ02Recebida((MessageQryQ02)message);
                break;
            }
            case ACK_Q03: {
                this.messageAckQ03Recebida((MessageAckQ03)message);
                break;
            }
            case ORM_O01: {
                this.messageOrmO01Recebida((MessageOrmO01)message);
                break;
            }
            default: {
                this.fireExcecaoEncontrada("Mensagem de tipo desconhecido recebida");
            }
        }
    }

    private String replaceUnicode(String mensagem) {
        for (int i = 0; i < mensagem.length(); ++i) {
            if (mensagem.charAt(i) <= '\u1000') continue;
            mensagem = mensagem.replace(mensagem.charAt(i), ' ');
        }
        return mensagem;
    }

    @Override
    public void teste() {
        StringBuilder buf = new StringBuilder();
        String tubo = Funcoes.showDigitacao(null, "Aten\u00e7\u00e3o", "Informe o tubo.", "");
        if (!tubo.trim().isEmpty() && Funcoes.isNumeric(tubo) && tubo != null) {
            if (Funcoes.showPerguntaOpcoes(null, "Informe o tipo de Opera\u00e7\u00e3o", new String[]{"Query", "Resultado"}) == 0) {
                buf.append("[SB]");
                buf.append("MSH|^~\\&|ZYBIO|EXC200|||20231222142039||QRY^Q02|1|P|2.5||||||UTF-8|||[CR]");
                buf.append("QRD|20231222142039|R|D|1|||RD|").append(tubo).append("||||T[CR]");
                buf.append("QRF|EXC200|||||RCT|COR|ALL||[CR]");
                buf.append("[EB][CR]");
            } else {
                String requisicao = "010007676904";
                buf.append("[SB]MSH|^~\\&|Zybio|EXC200|||20210916114200||ORU^R01|202109151142005678|P|2.5||||0||UNICODE|||[CR]");
                buf.append("PID|1||||||||||||||||||||||||||||||||||||||[CR]");
                buf.append("OBR|1|" + requisicao + "|202011300001|Zybio^EXC200||20210916114200|20201130090608|||||||20210916114200|SERUM|||||||||||||||||||||||||||||||||||[CR]");
                buf.append("OBX|1|NM|76^COL||176.6|mg/dL|||LRL||||||||||20210916114200[CR]");
                buf.append("OBX|2|NM|87^TRI||203.8|mg/dL|||\u00e6\u0085\u00af||||||||||20210916114200[CR]");
                buf.append("OBX|3|NM|45^HDL||70.2|mg/dL||||\u00e6\u0085\u00af|||||||||20210916114200[CR]");
                buf.append("OBX|1|NM|12^ALB||3.1|mg/dL|||||\u00e6\u0085\u00af||||||||20210916114200[CR]");
                buf.append("[EB][CR]");
            }
        } else {
            return;
        }
        this.parse(this.equipamento.arruma(buf.toString()));
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<MessageOruR01> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public List<MessageOruR01> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(MessageOruR01 message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(List<MessageOruR01> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    MessageOruR01 message = this.listaRecebimento.remove(0);
                    InterfaceListener.this.processaMensagem(message);
                    ThreadRecebimento.sleep(450L);
                }
                if (!InterfaceListener.this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
                    InterfaceListener.this.fireAtualizarTabela();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

