/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.zybio5;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrmO01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrrO02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends InterfaceHl7Listener {
    private static final String IMAGE_BMP_BASE64 = "^Image^BMP^Base64^";
    private static final String IMAGE_BINARY_BASE64 = "^Application^Octet-stream^Base64^";
    private HashMap<String, String> parametros = new HashMap();
    private Map<String, String> warning = new HashMap<String, String>();

    public InterfaceListener() {
        super("Zybio5");
        this.parametros.put("6790-2^WBC^LN", "leucocitos");
        this.parametros.put("704-7^BAS#^LN", "basofilos_contagem");
        this.parametros.put("706-2^BAS%^LN", "basofilos_percentual");
        this.parametros.put("751-8^NEU#^LN", "neutrofilo_contagem");
        this.parametros.put("770-8^NEU%^LN", "neutrofilo_percentual");
        this.parametros.put("711-2^EOS#^LN", "eosinofilos_contagem");
        this.parametros.put("713-8^EOS%^LN", "eosinofilos_percentual");
        this.parametros.put("731-0^LYM#^LN", "linfocitos_tipicos_contagem");
        this.parametros.put("736-9^LYM%^LN", "linfocitos_tipicos_percentual");
        this.parametros.put("742-7^MON#^LN", "monocitos_contagem");
        this.parametros.put("5905-5^MON%^LN", "monocitos_percentual");
        this.parametros.put("26477-0^*ALY#^LN", "linfocitos_atipicos_contagem");
        this.parametros.put("13046-8^*ALY%^LN", "linfocitos_atipicos_percentual");
        this.parametros.put("789-8^RBC^LN", "hemacias");
        this.parametros.put("718-7^HGB^LN", "hgb");
        this.parametros.put("787-2^MCV^LN", "vcm");
        this.parametros.put("785-6^MCH^LN", "hcm");
        this.parametros.put("786-4^MCHC^LN", "mchc");
        this.parametros.put("788-0^RDW-CV^LN", "rdw_cv");
        this.parametros.put("22000-5^RDW-SD^LN", "rdw_sd");
        this.parametros.put("4544-3^HCT^LN", "hct");
        this.parametros.put("777-3^PLT^LN", "plaquetas");
        this.parametros.put("33623-1^MPV^LN", "vpm");
        this.parametros.put("33207-3^PDW^LN", "pdw");
        this.parametros.put("12003^PCT^99MRC", "pct");
        this.parametros.put("11001^*LIC#^99MRC", "bastonados_percentual");
        this.parametros.put("11002^*LIC%^99MRC", "bastonados_contagem");
        this.parametros.put("49386-7^P-LCR^LN", "plaquetas_lcr");
        this.parametros.put("35167-7^P-LCC^LN", "plaquetas_lcc");
        this.parametros.put("13054^ RBC Histogram.Binary^99MRC", "celldyn_histograma_rbc");
        this.parametros.put("13104^ PLT Histogram.Binary^99MRC", "celldyn_histograma_plt");
    }

    @Override
    protected String getPacienteDataNascimento(String filial, String requisicao) {
        Date nasc = BDUtil.getDataNacimentoPaciente(filial, requisicao);
        if (nasc == null) {
            return "";
        }
        return Funcoes.formataData("yyyyMMdd", nasc) + "000000";
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setSendingApplication("Zybio5");
            mensagem.getMsh().setSendingFacility(this.modelo);
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setCharacterSet("UNICODE");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            this.getPortaCOM().write(this.messageParser.messageToText(mensagem, this.fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getObr().getFilterOrderNumber();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                MessageSegmentObx obx;
                String emiAlternativo;
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, emiAlternativo = (obx = this.buscaObxPeloObservationID(oruR01.getObxList(), "03003^Test Mode^99MRC")).getObservationValue());
                if (Funcoes.textoVazio(intCodigo)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("Nenhum exame foi encontrado para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>();
                ArrayList<String> listaWarning = new ArrayList<String>();
                int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                for (String p : this.parametros.keySet()) {
                    obx = this.buscaObxPeloObservationID(oruR01.getObxList(), p);
                    if (obx == null) continue;
                    if (obx.getAbnormalFlag() != null && !obx.getAbnormalFlag().equals((Object)MessageSegmentObx.AbnormalFlag.NORMAL)) {
                        flags.add(this.tratarDescricao(p) + " - " + obx.getAbnormalFlag().toString());
                    }
                    String campo = this.parametros.get(p);
                    String resultado = obx.getObservationValue();
                    this.retornaAlerta(campo, resultado, listaWarning);
                    if (resultado.length() > IMAGE_BINARY_BASE64.length() && resultado.substring(0, IMAGE_BINARY_BASE64.length()).equalsIgnoreCase(IMAGE_BINARY_BASE64)) {
                        resultado = resultado.substring(IMAGE_BINARY_BASE64.length());
                        resultado = this.convertImg(reqCodigo, resultado, p);
                    } else if (resultado.length() > IMAGE_BMP_BASE64.length() && resultado.substring(0, IMAGE_BMP_BASE64.length()).equalsIgnoreCase(IMAGE_BMP_BASE64)) {
                        resultado = resultado.substring(IMAGE_BMP_BASE64.length());
                        resultado = this.convertImg(reqCodigo, resultado, p);
                    } else {
                        resultado = resultado.replace('.', ',');
                    }
                    dados.put(campo, resultado);
                }
                flags.addAll(listaWarning);
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exa : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exa.getExame(), exa.getMaterial(), intCodigo, dados, flags);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
            ackR01.getMsa().setTextMessage("Erro ao receber a mensagem");
            ackR01.getMsa().setErrorCondition(ErrorCondition.APPLICATION_INTERNAL_ERROR);
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    private void retornaAlerta(String campo, String resultado, List<String> listaWarning) {
        if (this.warning.containsValue(campo)) {
            listaWarning.add(campo);
        }
    }

    private String tratarDescricao(String p) {
        String[] campo = p.split("\\^");
        return campo != null && campo.length > 1 ? campo[1] : p;
    }

    private String convertImg(String reqCodigo, String resultado, String p) throws IOException {
        Base64 b64 = new Base64();
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(b64.decode(resultado)));
        if (null != image) {
            ImageIO.getCacheDirectory();
            File img = File.createTempFile("zybio5_" + reqCodigo, ".png");
            ImageIO.write((RenderedImage)image, "png", img);
            BufferedImage imgNew = ImageIO.read(img);
            resultado = b64.encodeAsString(ImagemUtils.imageToByte(imgNew));
            img.delete();
        }
        return resultado;
    }

    private MessageSegmentObx buscaObxPeloObservationID(List<MessageSegmentObx> listObx, String observationID) {
        for (MessageSegmentObx obx : listObx) {
            if (!obx.getObservationId().equals(observationID)) continue;
            return obx;
        }
        return null;
    }

    @Override
    protected void messageOrmO01Recebida(MessageOrmO01 ormO01) {
        block17: {
            String messageId = ormO01.getMsh().getMessageControlId();
            MessageOrrO02 orrO02 = new MessageOrrO02();
            try {
                String tuboId = ormO01.getOrc().getFilterOrderNumber();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                        aba = this.equipamento.getTab(1);
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                        aba = this.equipamento.getTab(2);
                    }
                    if (req == null) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        return;
                    }
                    String exames = (String)req[aba.getColIndice("Exame")];
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    String pacNasc = this.getPacienteDataNascimento(filCodigo, reqCodigo);
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (n == 0 || n == 1) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test == null || test.trim().isEmpty()) continue;
                        tests.add(test);
                    }
                    if (tests.isEmpty()) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(filCodigo).append(reqCodigo).append("^^^^");
                        Date dataHoraRequisicao = new Date();
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        orrO02.getPid().setId(1);
                        orrO02.getPid().setPatientName("^" + pacNome);
                        orrO02.getPid().setSex(pacSexo);
                        orrO02.getPid().setDataOfBirth(pacNasc);
                        orrO02.getPid().setPatientIdentifierList(stringBuilder.toString());
                        orrO02.getOrc().setOrderControl("AF");
                        orrO02.getOrc().setPlaceOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setPlacerOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setRequestDateTime(dataHoraRequisicao);
                        orrO02.getObr().setCollectorIdentifier("MA");
                        orrO02.getObr().setSpecimenReceiveDateTime(dataHoraRequisicao);
                        orrO02.getObr().setDiagnosticServSect("HM");
                        MessageSegmentObx obx = new MessageSegmentObx();
                        obx.setId(1);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("08001^Take Mode^99MRC");
                        obx.setObservationValue("A");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        obx = new MessageSegmentObx();
                        obx.setId(2);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("08002^Blood Mode^99MRC");
                        obx.setObservationValue("W");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        for (String alternativo : tests) {
                            obx = new MessageSegmentObx();
                            obx.setId(3);
                            obx.setValueType(MessageSegmentObx.ValueType.IS);
                            obx.setObservationId("08003^Test Mode^99MRC");
                            obx.setObservationValue(alternativo);
                            obx.setObserveResultStatus("F");
                            orrO02.addObx(obx);
                        }
                        obx = new MessageSegmentObx();
                        obx.setId(4);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("01002^Ref Group^99MRC");
                        obx.setObservationValue("Geral");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        this.enviaMensagem(messageId, orrO02);
                        this.alteraSituacaoParaPendentes((InfoExameRequisicao)this.examesEnviadosPorSid.get(tuboId));
                        this.examesEnviadosPorSid.remove(tuboId);
                    }
                    break block17;
                }
                orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                this.enviaMensagem(messageId, orrO02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    @Override
    public void teste() {
        StringBuilder buf = new StringBuilder();
        String requisicao = "010007661701";
        buf.append("[SB]MSH|^~&|Z5|Zybio|||20210426152233||ORU^R01|202104261522335644|P|2.3.1||||||UNICODE[CR]");
        buf.append("PID|1||^^^^MR||^|||0[CR]");
        buf.append("PV1|1||^^|||||||||||||||||0[CR]");
        buf.append("OBR|1||" + requisicao + "|01001^Automated[SP]Count^99MRC|||20210426111836|||||||||||||||||HM||||||||admin[CR]");
        buf.append("OBX|1|IS|03001^Take[SP]Mode^99MRC||O||||||F[CR]");
        buf.append("OBX|2|IS|03002^Blood[SP]Mode^99MRC||W||||||F[CR]");
        buf.append("OBX|3|IS|03003^Test[SP]Mode^99MRC||CBC+DIFF||||||F[CR]");
        buf.append("OBX|4|NM|31525-0^Age^LN||-1|yr|||||F[CR]");
        buf.append("OBX|5|IS|04001^Ref[SP]Group^99MRC||1||||||F[CR]");
        buf.append("OBX|6|NM|6790-2^WBC^LN||2.98|10^9/L|3.5000-9.5000|L~A|||F[CR]");
        buf.append("OBX|7|NM|751-8^NEU#^LN||1.79|10^9/L|1.8000-6.3000|L~A|||F[CR]");
        buf.append("OBX|8|NM|731-0^LYM#^LN||0.93|10^9/L|1.1000-3.2000|L~A|||F[CR]");
        buf.append("OBX|9|NM|742-7^MON#^LN||0.22|10^9/L|0.1000-0.6000|N|||F[CR]");
        buf.append("OBX|10|NM|711-2^EOS#^LN||0.03|10^9/L|0.0200-0.5200|N|||F[CR]");
        buf.append("OBX|11|NM|704-7^BAS#^LN||0.01|10^9/L|0.0000-0.0600|N|||F[CR]");
        buf.append("OBX|12|NM|770-8^NEU%^LN||60.3|%|40.0000-75.0000|N|||F[CR]");
        buf.append("OBX|13|NM|736-9^LYM%^LN||31.1|%|20.0000-50.0000|N|||F[CR]");
        buf.append("OBX|14|NM|5905-5^MON%^LN||7.5|%|3.0000-10.0000|N|||F[CR]");
        buf.append("OBX|15|NM|713-8^EOS%^LN||0.9|%|0.4000-8.0000|N|||F[CR]");
        buf.append("OBX|16|NM|706-2^BAS%^LN||0.2|%|0.0000-1.0000|N|||F[CR]");
        buf.append("OBX|17|NM|26477-0^*ALY#^LN||0.03|10^9/L||N|||F[CR]");
        buf.append("OBX|18|NM|13046-8^*ALY%^LN||0.9|%||N|||F[CR]");
        buf.append("OBX|19|NM|11001^*LIC#^99MRC||0.01|10^9/L||N|||F[CR]");
        buf.append("OBX|20|NM|11002^*LIC%^99MRC||0.2|%||N|||F[CR]");
        buf.append("OBX|21|NM|789-8^RBC^LN||4.30|10^12/L|3.8000-5.8000|N|||F[CR]");
        buf.append("OBX|22|NM|718-7^HGB^LN||13.2|g/dL|11.5000-17.5000|N|||F[CR]");
        buf.append("OBX|23|NM|4544-3^HCT^LN||38.7|%|35.0000-50.0000|N|||F[CR]");
        buf.append("OBX|24|NM|787-2^MCV^LN||90.1|fL|82.0000-100.0000|N|||F[CR]");
        buf.append("OBX|25|NM|785-6^MCH^LN||30.7|pg|27.0000-34.0000|N|||F[CR]");
        buf.append("OBX|26|NM|786-4^MCHC^LN||34.1|g/dL|31.6000-35.4000|N|||F[CR]");
        buf.append("OBX|27|NM|788-0^RDW-CV^LN||11.9|%|11.5000-16.0000|N|||F[CR]");
        buf.append("OBX|28|NM|22000-5^RDW-SD^LN||39.5|fL|35.0000-56.0000|N|||F[CR]");
        buf.append("OBX|29|NM|777-3^PLT^LN||155|10^9/L|125.0000-350.0000|N|||F[CR]");
        buf.append("OBX|30|NM|33623-1^MPV^LN||10.1|fL|6.5000-12.0000|N|||F[CR]");
        buf.append("OBX|31|NM|33207-3^PDW^LN||16.3|fL|9.0000-17.0000|N|||F[CR]");
        buf.append("OBX|32|NM|12003^PCT^99MRC||0.156|%|0.1080-0.2820|N|||F[CR]");
        buf.append("OBX|33|NM|35167-7^P-LCC^LN||41|10^9/L|30.0000-90.0000|N|||F[CR]");
        buf.append("OBX|34|NM|49386-7^P-LCR^LN||26.3|%|11.0000-45.0000|N|||F[CR]");
        buf.append("OBX|35|NM|13051^RBC[SP]Histogram.[SP]Left[SP]Line^99MRC||28||||||F[CR]");
        buf.append("OBX|36|NM|13052^RBC[SP]Histogram.[SP]Right[SP]Line^99MRC||230||||||F[CR]");
        buf.append("OBX|37|ED|13054^[SP]RBC[SP]Histogram.Binary^99MRC||^Application^Octet-stream^Base64^AAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgAEAAcACwALAAoACgAIAAYABQAEAAMAAwADAAIAAQABAAEAAgADAAMABAAEAAQABQAGAAkADQASABgAHwApADYASwBnAIgAtADmABoBYAGxARECegLeAkEDqAMRBIkE8AREBYIFlwWkBZ8FjAVnBTEF7gScBEYE6QOIAy4D0QJ8AjMC6gGuAXEBPAEIAeEAvwCjAJEAgQB0AGsAYgBbAFUATQBFAEEAPwA+AD4APQA5ADUAMgAwAC8ALgAtAC0AMAAvAC0AKgAmACQAIgAgACAAIQAiACEAIAAdAB0AHQAcAB0AHAAbABsAGgAXABYAFgAVABUAFAAUABUAFgAWABQAEQAPAA4ADQALAAsACgAJAAkACAAIAAgACAAHAAYABQAEAAMABAAEAAQABAADAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAIAAQABAAEAAQABAAEAAQABAAAAAAAAAAAAAAABAAEAAQAAAAAAAAAAAAAAAAABAAEAAQABAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA||||||F[CR]");
        buf.append("OBX|38|NM|13101^PLT[SP]Histogram.[SP]Left[SP]Line^99MRC||2||||||F[CR]");
        buf.append("OBX|39|NM|13102^PLT[SP]Histogram.[SP]Right[SP]Line^99MRC||56||||||F[CR]");
        buf.append("OBX|40|ED|13104^[SP]PLT[SP]Histogram.Binary^99MRC||^Application^Octet-stream^Base64^gAAAAAAAAgAGAA4AGQAmADMAPgBHAE0AUABRAFEAUABOAEsASABEAEAAPAA5ADUAMQAtACgAJAAfABwAGQAXABUAEwASABEAEAAQAA8ADgANAAwACwAJAAgABwAGAAYABQAFAAUABQAEAAQABAAEAAQABAAEAAMAAwADAAMAAwADAAMAAwADAAMAAwADAAMABAAEAAQABAAEAAQABAAEAAUABgAHAAgACAAKAAsADQAPABEAEwAVABkAHQAjACgALwA2AD8ASgBWAGIAbgB6AIcAlQCmALkAzgDnAAEBHwE+AV4BgAGiAccB9AEvAo0COQPeBFsIiQ3IE4UY+RhyFsERog0=||||||FOBX|41|IS|14102^Leucopenia^99MRC||||||||F[CR]");
        buf.append("OBX|42|IS|09001^Remark^99MRC||||||||F[CR]");
        buf.append("[EB][CR]");
        this.parse(this.equipamento.arruma(buf.toString()));
    }
}

