/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.yumizenh550;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    private HashMap<String, String> parametros = new HashMap();
    private HashMap<String, String> flagsResultado = new HashMap();
    private final String PEDIDO_NAO_REALIZADO = "X";

    public RecordParser() {
        this.parametros.put("WBC", "leucocitos");
        this.parametros.put("RBC", "hemacias");
        this.parametros.put("HGB", "hgb");
        this.parametros.put("HCT", "hct");
        this.parametros.put("PLT", "plaquetas");
        this.parametros.put("LYM#", "linfocitos_tipicos_contagem");
        this.parametros.put("MON#", "monocitos_contagem");
        this.parametros.put("NEU#", "neutrofilo_contagem");
        this.parametros.put("LYM", "linfocitos_tipicos_contagem");
        this.parametros.put("MON", "monocitos_contagem");
        this.parametros.put("NEU", "neutrofilo_contagem");
        this.parametros.put("LYM%", "linfocitos_tipicos_percentual");
        this.parametros.put("MON%", "monocitos_percentual");
        this.parametros.put("NEU%", "neutrofilo_percentual");
        this.parametros.put("MCV", "celulas_media_contagem");
        this.parametros.put("MCH", "hcm");
        this.parametros.put("MCHC", "mchc");
        this.parametros.put("RDW-CV", "rdw_cv");
        this.parametros.put("RDW-SD", "rdw_sd");
        this.parametros.put("MPV", "vpm");
        this.parametros.put("PCT", "pct");
        this.parametros.put("PDW", "pdw");
        this.parametros.put("EOS#", "eosinofilos_contagem");
        this.parametros.put("BAS#", "basofilos_contagem");
        this.parametros.put("EOS", "eosinofilos_contagem");
        this.parametros.put("BAS", "basofilos_contagem");
        this.parametros.put("EOS%", "eosinofilos_percentual");
        this.parametros.put("BAS%", "basofilos_percentual");
        this.parametros.put("LIC%", "lic_percentual");
        this.parametros.put("LIC#", "lic_contagem");
        this.parametros.put("LIC", "lic_contagem");
        this.parametros.put("LCC", "plaquetas_lcc");
        this.parametros.put("LCR", "plaquetas_lcr");
        this.flagsResultado.put("A", "Anormal");
        this.flagsResultado.put("H", "Acima do normal");
        this.flagsResultado.put("L", "Abaixo do normal");
        this.flagsResultado.put("LL", "Muito abaixo do normal");
        this.flagsResultado.put("HH", "Muito acima do normal");
        this.flagsResultado.put("<", "Abaixo do valor absoluto");
        this.flagsResultado.put(">", "Acima do valor absoluto");
    }

    @Override
    public void recordFound(String record) throws Exception {
        String record_type = ASTMStandard.getRecordTypeIdentifier(record = record.substring(1, record.length() - 1));
        if (record_type != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String orderFieldReportType = (String)order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE);
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        if (req_codigo.contains("^")) {
            req_codigo = req_codigo.substring(0, req_codigo.indexOf("^"));
        }
        if (!Funcoes.textoVazio(orderFieldReportType) && orderFieldReportType.equalsIgnoreCase("X")) {
            this.exame_atual = null;
            this.equip.fireExcecaoEncontrada("Resultados inv\u00e1lidos recebidos para a requisi\u00e7\u00e3o:  " + req_codigo);
            return;
        }
        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigo);
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        String emi_alternativo = components.get(this.equip.TEST_ITEM_NUMBER);
        Statement st = Conexao.getStatement();
        if (etiqueta != null) {
            fil_codigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            rec_codigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
        }
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String fieldInstrument = (String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID);
        String campoHemog = this.parseCampoHemograma(fieldInstrument);
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.endsWith(",")) {
            resultado = resultado + "0";
        }
        if (campoHemog != null && !campoHemog.trim().isEmpty()) {
            this.exame_atual.put(campoHemog, resultado);
            if (flags != null && !flags.trim().isEmpty() && !flags.trim().equalsIgnoreCase("N")) {
                if (!this.exame_atual.containsKey("flag")) {
                    this.exame_atual.put("flag", new ArrayList());
                }
                String flg = this.parseCampoHemograma(fieldInstrument);
                if (this.flagsResultado.containsKey(flags.trim())) {
                    String flag = String.format("%s - %s", flg, this.flagsResultado.get(flags.trim()));
                    if (!((ArrayList)this.exame_atual.get("flag")).contains(flag)) {
                        ((ArrayList)this.exame_atual.get("flag")).add(flag);
                    }
                }
            }
        }
    }

    private String parseCampoHemograma(String campo) {
        String[] fields = campo.split("\\^");
        String parametro = "";
        if (fields != null && fields.length > 3) {
            parametro = fields[3];
        }
        return this.parametros.get(parametro);
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        ArrayList flags = null;
        if (this.exame_atual.containsKey("flag")) {
            flags = (ArrayList)this.exame_atual.get("flag");
        }
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        if (dados.size() > 0) {
            this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados, flags);
        }
    }

    @Override
    protected void trataTerminationRecord() throws Exception {
        if (this.exame_atual == null) {
            return;
        }
        this.salvaExame(this.exame_atual);
        this.exame_atual = null;
    }
}

