/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.yumizenh550;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.yumizenh550.RecordParser;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.yumizenh500.InterfaceListener {
    private List<String> request = new ArrayList<String>();
    protected boolean hostQuery = false;
    private boolean query = false;
    boolean exr_codigoapoiado = false;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.INSTRUMENT_NAME = "H500^708YOXH01014^2.1.0.1c";
        this.MAX_PATIENT_NAME_CHARS = 50;
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size() && this.rx_list.size() > 0) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                this.rx_list.add(message);
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String s = (String)this.rx_list.remove(0);
                    this.recordParser.recordFound(s);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            String sobrenome = null;
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            if (short_name.indexOf(" ") > 0) {
                String[] names = short_name.split(" ");
                String firstName = names[0];
                if (firstName.length() > this.MAX_PATIENT_NAME_CHARS) {
                    firstName = firstName.substring(0, this.MAX_PATIENT_NAME_CHARS);
                }
                if (names.length > 2 && !Funcoes.textoVazio(names[1])) {
                    short_name = "" + names[1].charAt(0);
                }
                if ((sobrenome = names[names.length - 1]).length() > 20) {
                    sobrenome = sobrenome.substring(0, 20);
                }
                short_name = firstName;
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            if (mapaParametros != null && !Funcoes.textoVazio(mapaParametros.get("codigoApoiado"))) {
                codigo.setLength(0);
                codigo.append(mapaParametros.get("codigoApoiado"));
            }
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = "";
            if (exa_lista.length > 0) {
                tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            }
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            String patient_id = BDUtil.getCodigoPaciente(fil_codigo, req_codigo);
            Object laboratory_pid = null;
            Date dataNascimento = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String pac_nascimento = "";
            if (dataNascimento != null) {
                pac_nascimento = Funcoes.formataData("yyyyMMdd", dataNascimento);
            }
            String med_nome = this.buscaMedicoRequisicao(fil_codigo, req_codigo);
            this.tx_list.add(this.getHeaderRecord(this.DELIMITERS, this.PASSWORD, this.INSTRUMENT_NAME, null, null, this.HOST_NAME, this.INSTRUMENT_SYSTEM_VERSION, "E 1394-97"));
            if (this.tx_list.size() < 0) {
                this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            this.tx_list.add(this.getPatientRecord(1, patient_id, codigo.toString(), null, short_name, sobrenome, pac_sexo, pac_nascimento, med_nome, null, null));
            if (this.tx_list.size() < 0) {
                this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            for (ExameMaterial exameMaterial : alternativos) {
                this.tx_list.add(this.getOrderRecord(1, codigo.toString(), exameMaterial, "R", "", acao, tipo_amostra, rackposition, "O"));
            }
            if (this.tx_list.size() < 0) {
                this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(this.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    protected void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
            } else {
                this.enviarProximoFrame();
            }
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public String buscaMedicoRequisicao(String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select a.med_crm, a.med_uf, b.med_nome from requisicao a ");
        sql.append(" left join medico b on a.fil_codigo = b.fil_codigo and a.med_conselho = b.med_conselho and a.med_crm = b.med_crm and a.med_uf = b.med_uf ");
        sql.append(" where a.fil_codigo = ").append(fil_codigo);
        sql.append(" and a.req_codigo = ").append(req_codigo);
        Statement st = Conexao.getStatement();
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            sql.setLength(0);
            sql.append(rs.getString("med_crm"));
            sql.append("^");
            String nomeMedico = rs.getString("med_nome");
            if (!Funcoes.textoVazio(nomeMedico)) {
                String[] names = nomeMedico.split(" ");
                String primeiroNome = names[0];
                if (!Funcoes.textoVazio(primeiroNome) && primeiroNome.length() > 10) {
                    nomeMedico = primeiroNome.substring(0, 11);
                }
                nomeMedico = StringUtil.removerAcentos(primeiroNome);
                sql.append(nomeMedico);
            }
            return sql.toString();
        }
        return "";
    }

    @Override
    public String getHeaderRecord(String delimiters, String password, String sender_id_name, String sender_id_system, String control, String receiver_id_name, String receiver_id_system, String version_number) {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("||");
        record.append("|");
        record.append(this.HOST_NAME);
        record.append("|||||||P|");
        record.append("LIS2-A2");
        record.append("|");
        record.append(this.getCurrentMoment());
        record.append('\r');
        return record.toString();
    }

    @Override
    public String getCurrentMoment() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis()));
    }

    private String getOrderRecord(int sequence, String sampleId, ExameMaterial alternativo, String priorty, String horaColeta, String acao, String tipo_amostra, String rackPos, String reportType) {
        StringBuilder record = new StringBuilder("O");
        record.append("|").append(sequence);
        record.append("|").append(sampleId);
        record.append("|");
        record.append("|^^^").append(alternativo.getNomeExame());
        record.append("|").append(priorty);
        record.append("|").append(Funcoes.formataData("yyyyMMddHHmmss", new Date()));
        record.append("|").append(horaColeta);
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|").append("N");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|").append("Q");
        record.append("|||||");
        record.append('\r');
        return record.toString();
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String patient_id3, String pac_nome, String pac_sobrenome, String pac_sexo, String pac_nascimento, String med_nome, String comment, String location) {
        StringBuilder record = new StringBuilder("P");
        record.append("|").append(patient_sequence);
        record.append("|");
        record.append("|").append(patient_id == null ? "" : patient_id);
        record.append("|");
        record.append("|");
        record.append(pac_sobrenome == null ? "" : pac_sobrenome);
        record.append(pac_nome == null ? "" : "^" + pac_nome);
        record.append("|");
        record.append("|").append(pac_nascimento == null ? "" : pac_nascimento);
        record.append("|").append(pac_sexo == null ? "U" : pac_sexo);
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append('\r');
        return record.toString();
    }

    @Override
    public String getDefaultTerminationRecord(String termination_code) {
        StringBuilder record = new StringBuilder("L|1|");
        record.append('\r');
        return record.toString();
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            String sampleId = starting_range.substring(1).trim();
            this.hostQuery = true;
            if (!Funcoes.textoVazio(sampleId)) {
                ArrayList<Object> amostras = new ArrayList<String>();
                if (sampleId.contains("\\")) {
                    amostras = StringUtil.explode(sampleId, "\\");
                } else {
                    amostras.add(sampleId);
                }
                for (String string : amostras) {
                    if (Funcoes.textoVazio(string)) {
                        this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                        continue;
                    }
                    if (string.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                        this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                        continue;
                    }
                    if (this.request.contains(string)) continue;
                    this.request.add(string);
                }
                if (!this.request.isEmpty()) {
                    this.hostQuery = true;
                } else {
                    this.fireExcecaoEncontrada(String.format("Pedido de amostra do aparelho sem nenhum Sample ID: %s", starting_range));
                }
            } else {
                this.fireExcecaoEncontrada("Pedido de amostra do aparelho sem nenhum Sample ID");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public void responseHostQuery() {
        try {
            String sampleId;
            if (this.request.isEmpty()) {
                return;
            }
            String codigoEtiqueta = sampleId = this.request.remove(0);
            String fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            String rec_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            StringBuilder pac_exames = new StringBuilder("");
            String acao = "N";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames.append((String)req[aba.getColIndice("Exame")]);
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames.toString()) && req != null && aba != null) {
                    pac_exames.append((String)req[aba.getColIndice("Exame")]).append(" ");
                }
                if (req != null) {
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                    }
                }
            }
            String situacao = null;
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    String tuboPai = Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboTubo());
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        situacao = (String)r[aba.getColIndice("Sit")];
                        String exame = (String)r[aba.getColIndice("Exame")];
                        mco_codigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                        int_codigo = (String)req[aba.getColIndice("Interface")];
                        if (BDUtil.isGrupoInteiroRepetido(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai)) {
                            pac_exames.append(exame).append(" ");
                            acao = "A";
                            continue;
                        }
                        BDExame[] filhos = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai);
                        if (filhos == null) continue;
                        for (BDExame bdExame : filhos) {
                            if (!Funcoes.preencheZero(bdExame.getRecipienteFilho(), ParametrosGerais.getDigitosTuboTubo()).equals(rec_codigo) || bdExame.getSituacao() <= 2 || bdExame.getSituacao() >= 7) continue;
                            pac_exames.append(bdExame.getExame()).append(" ");
                            acao = "A";
                        }
                    }
                }
            }
            if (req != null && !Funcoes.textoVazio(pac_exames.toString())) {
                String req_codigoapoio = null;
                if (this.exr_codigoapoiado) {
                    if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                        if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
                            if (ParametrosGerais.isAgruparGuiasInterface()) {
                                requisicao = (String)req[aba.getColIndice("Multiguia")];
                            }
                            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
                            String tubo = (String)req[aba.getColIndice("Tubo")];
                            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                            if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                                if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                                    req_codigoapoio = (String)req[aba.getColIndice("Cod. Apoiado")];
                                }
                            }
                            fil_codigo = filial;
                            req_codigo = requisicao;
                            rec_codigo = tubo;
                        }
                    }
                }
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                HashMap<String, String> map = new HashMap<String, String>();
                if (!Funcoes.textoVazio(req_codigoapoio)) {
                    map.put("codigoApoiado", req_codigoapoio);
                    map.put("codigoEtiqueta", codigoEtiqueta);
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao, map);
                } else {
                    map.put("codigoEtiqueta", codigoEtiqueta);
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao, map);
                }
            } else {
                this.fireExcecaoEncontrada(String.format("Nenhuma requisi\u00e7\u00e3o encontrada para a amostra %s %s %s", fil_codigo, req_codigo, rec_codigo));
                if (!this.request.isEmpty()) {
                    this.responseHostQuery();
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.equipamento.configuracao.getModoHostQuery() && !this.request.isEmpty()) {
            this.responseHostQuery();
        }
    }

    @Override
    public void teste() {
        String requisicao = "010007679701";
        this.testeResultado(requisicao);
        this.testeResultadoInvalido(requisicao);
    }

    private void testeQuery(String requisicao) {
        this.parse(this.equipamento.arruma("[STX]1H|1^&|||H500^001YOXH00031^1.0.0.6|||||||P|LIS2-A2|20150323160052[CR][ETX]34[CR][LF]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|^" + requisicao + "||ALL||||||||O[CR][ETX]F7[CR][LF]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR][ETX]06[CR][LF]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR][ETX]06[CR][LF]"));
        this.parse(this.equipamento.arruma("[STX]1H|1^&|||HCM|||||||P|LIS2-A2|20150323160111[CR][ETX]51[CR][LF]"));
        this.parse(this.equipamento.arruma("[STX]2P|1||2||BOND^JAMES||19770526|M|||||[CR][ETX]24[CR][LF]"));
        this.parse(this.equipamento.arruma("[STX]4L|1|N[CR][ETX]B9[LINE]"));
        this.handShakeCharReceived('\u0004');
        for (int i = 0; i < 10; ++i) {
            this.handShakeCharReceived('\u0006');
        }
    }

    private void testeResultado(String requisicao) {
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||H550^911YAXH02790^1.0.5.1a|||||||P|LIS2-A2|20200213114655[CR][ETX]A6[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2P|1|||||||||||||||||||||||||||||||||||[CR][ETX]33[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3O|1|" + requisicao + "||^^^DIF|R|20200213114443|||||||||BLOOD||||||||||F|||||[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|1|^^^PCT^51637-7|0.17|%|0.15[SP]-[SP]0.40^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]33[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|2|^^^NEU#^751-8|4.66|10E3/uL|1.60[SP]-[SP]7.00^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]A1[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|3|^^^MCV^787-2|85.3|um3|76.0[SP]-[SP]100.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]FD[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|4|^^^P-LCR^48386-7|45.5|%|18.0[SP]-[SP]50.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]B9[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|5|^^^NEU%^770-8|68.6|%|40.0[SP]-[SP]73.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]02[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|6|^^^RDW-CV^788-0|13.9|%|11.0[SP]-[SP]15.8^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]A6[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|7|^^^MPV^32623-1|11.0|um3|8.0[SP]-[SP]11.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]F1[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|8|^^^RBC^789-8|4.79|10E6/uL|4.20[SP]-[SP]6.00^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]81[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|9|^^^P-LCC|70|10E3/uL|44[SP]-[SP]140^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]97[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|10|^^^MON#^742-7|0.61|10E3/uL|0.20[SP]-[SP]0.80^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]C4[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|11|^^^WBC^6690-2|6.82|10E3/uL|3.50[SP]-[SP]10.00^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]00[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|12|^^^PLT^777-3|154|10E3/uL|150[SP]-[SP]400^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]20[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|13|^^^LIC%^55433-7|0.4|%|0.0[SP]-[SP]1.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]D9[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|14|^^^MON%^5905-5|9.0|%|4.0[SP]-[SP]12.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]F5[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|15|^^^LIC#^55432-9|0.02|10E3/uL|0.00[SP]-[SP]0.10^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]0E[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|16|^^^LYM#^731-0|1.46|10E3/uL|1.00[SP]-[SP]3.00^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]C5[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|17|^^^PDW^51631-0|21.3|um3|11.0[SP]-[SP]22.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]4B[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|18|^^^HGB^718-7|14.0|g/dL|13.0[SP]-[SP]17.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]10[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|19|^^^LYM%^736-9|21.4|%|15.0[SP]-[SP]45.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]3E[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|20|^^^RDW-SD^21000-5|41.6|um3|37.0[SP]-[SP]49.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]14[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|21|^^^BAS%^706-2|0.9|%|0.0[SP]-[SP]2.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]70[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|22|^^^BAS#^704-7|0.06|10E3/uL|0.00[SP]-[SP]0.15^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]A8[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|23|^^^MCH^785-6|29.2|pg|25.6[SP]-[SP]34.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]B4[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|24|^^^MCHC^786-4|34.3|g/dL|32.0[SP]-[SP]35.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]5D[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|25|^^^HCT^4544-3|40.8|%|39.0[SP]-[SP]52.0^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]35[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|26|^^^EOS#^711-2|0.01|10E3/uL|0.00[SP]-[SP]0.50^REFERENCE_RANGE|N||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]B4[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|27|^^^EOS%^713-8|0.1|%|0.5[SP]-[SP]7.0^REFERENCE_RANGE|L||F||ABX^^LABMANAGER|20210805165642||[CR][ETX]91[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4L|1|N[CR][ETX]07[LINE]"));
        this.parse(this.equipamento.arruma("[EOT]"));
    }

    private void testeResultadoInvalido(String requisicao) {
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||H550^911YAXH02792^1.0.4.2|||||||P|LIS2-A2|20210930094434[CR][ETX]50[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2P|1||13690||Jalis^Teste||19891229|M||||||||||||||||||||||||||||[CR][ETX]82[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3O|1|" + requisicao + "||^^^DIF|R|20210930095744|||||||||||||||||||X|||||[CR][ETX]0D[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4L|1|N[CR][ETX]07[LINE]"));
    }
}

