/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.xi921;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.interfaces.xi921.DadosXi921DTO;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final Integer DIGITOS_CODIGO_TUBO = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
    private static final String NOME_EXAME = "";

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            Statement st = Conexao.getStatement();
            String[] stringArray = exames.split(" ");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String exame;
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame = stringArray[i], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!Funcoes.textoVazio(message)) {
                this.parse(message);
                if (this.getPortaCOM().getInputString().length() > 0) {
                    this.dataChanged();
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Falha na comunica\u00e7\u00e3o com o aparelho", e.getStackTrace());
        }
    }

    @Override
    public String parse(String message) {
        DadosXi921DTO dto = new DadosXi921DTO(message);
        String tuboId = dto.getId();
        if (tuboId.length() < DIGITOS_CODIGO_TUBO) {
            this.fireExcecaoEncontrada("Mensagem fora do padr\u00e3o.");
            return NOME_EXAME;
        }
        if ((tuboId = tuboId.substring(tuboId.length() - DIGITOS_CODIGO_TUBO)) != null && Funcoes.isNumeric(tuboId)) {
            try {
                String intCodigo;
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(reqCodigo.length() - ParametrosGerais.getDigitosTuboRequisicao());
                DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                if (etiqueta != null) {
                    filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                    reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                    recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                }
                if ((intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, NOME_EXAME)) == null) {
                    this.fireExcecaoEncontrada("Interfaceamento do exame n\u00e3o encontrado para requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + recCodigo);
                    return NOME_EXAME;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>(dto.getFlags().values());
                Statement st = Conexao.getStatement();
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exa : exames) {
                    if (exa.getSituacao() == 3) {
                        dados.put("repeticao_K", dto.getResultPotassio().replace(".", ","));
                        dados.put("repeticao_Na", dto.getResultSodio().replace(".", ","));
                        dados.put("repeticao_CL", dto.getResultCloreto().replace(".", ","));
                        dados.put("repeticao_CA", dto.getResultCalcio().replace(".", ","));
                        dados.put("repeticao_pH", dto.getResultPh().replace(".", ","));
                    } else {
                        dados.put("K", dto.getResultPotassio().replace(".", ","));
                        dados.put("Na", dto.getResultSodio().replace(".", ","));
                        dados.put("CL", dto.getResultCloreto().replace(".", ","));
                        dados.put("CA", dto.getResultCalcio().replace(".", ","));
                        dados.put("pH", dto.getResultPh().replace(".", ","));
                    }
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exa.getExame(), exa.getMaterial(), intCodigo, dados, flags);
                    if (exa.getSituacao() != 3) continue;
                    Exame exame = new Exame(filCodigo, intCodigo, reqCodigo, exa.getExame(), exa.getMaterial(), recCodigo);
                    exame.getFlags().clear();
                    exame.getFlags().addAll(flags);
                    exame.getDados().put("flag", StringUtil.tratarEntidadesHTML(StringUtil.getXMLDeList(flags)));
                    String ier_xmlvalores = StringUtil.getXMLDeMap(exame.getDados());
                    BDUtil.setExmXmlValores(st, filCodigo, intCodigo, reqCodigo, exa.getExame(), exa.getMaterial(), recCodigo, ier_xmlvalores);
                }
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Erro ao efetuar o parse da mensagem";
            }
        }
        return null;
    }

    @Override
    public void teste() {
        String requisicao = JOptionPane.showInputDialog(null, (Object)"Informe a requisi\u00e7\u00e3o");
        if (!Funcoes.textoVazio(requisicao)) {
            StringBuilder sb = new StringBuilder();
            sb.append("001[SP][SP]000000010" + requisicao + "[SP][SP]000[SP]4.96[SP]138.4[SP]113.1[SP]1.40[SP]7.75[SP][SP][SP]0.0[LINE]");
            this.parse(TestesInterface.arruma(sb.toString()));
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf(LINE);
    }

    @Override
    public String getMsgStart() {
        return null;
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        return null;
    }
}

