/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.xi921;

import java.util.HashMap;
import java.util.Map;

public class FlagsXi921 {
    private Map<String, String> flags = new HashMap<String, String>();
    private Map<Integer, String> flagsAbnormal = new HashMap<Integer, String>();
    private Map<Integer, String> flagsNormal = new HashMap<Integer, String>();

    public FlagsXi921(String byteFlags) {
        this.setAbnormalFlags();
        this.setNormalFlags();
        int i = 0;
        for (String binaryFlags : this.byteParaBinario(byteFlags).split("")) {
            if (!this.flagsAbnormal.containsKey(i) && !this.flagsNormal.containsKey(i)) continue;
            if (binaryFlags.equals("0")) {
                this.flags.put(String.valueOf(i), this.flagsNormal.get(i));
            } else {
                this.flags.put(String.valueOf(i), this.flagsAbnormal.get(i));
            }
            ++i;
        }
    }

    private String byteParaBinario(String flagByte) {
        String binaryString = Integer.toBinaryString(Integer.parseInt(flagByte) & 0xFF);
        return String.format("%8s", binaryString).replace(' ', '0');
    }

    private void setNormalFlags() {
        this.flagsNormal.put(6, "Aspiration normal");
        this.flagsNormal.put(5, "Li+ result");
        this.flagsNormal.put(4, "pH STD Pass");
        this.flagsNormal.put(3, "Ca2+ STD Pass");
        this.flagsNormal.put(2, "CI- STD Pass");
        this.flagsNormal.put(1, "Na+ STD Pass");
        this.flagsNormal.put(0, "K+ STD Pass");
    }

    private void setAbnormalFlags() {
        this.flagsAbnormal.put(6, "Aspiration abnormal");
        this.flagsAbnormal.put(5, "Li+ result");
        this.flagsAbnormal.put(4, "pH STD Not Pass");
        this.flagsAbnormal.put(3, "Ca2+ STD Not Pass");
        this.flagsAbnormal.put(2, "CI- STD Not Pass");
        this.flagsAbnormal.put(1, "Na+ STD Not Pass");
        this.flagsAbnormal.put(0, "K+ STD Not Pass");
    }

    public Map<String, String> getFlags() {
        return this.flags;
    }
}

