/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.vitroseci;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.kermit.InterfaceKermitListener;
import jalis.laboratorio.interfaceamento.padroes.kermit.KermitRecordParser;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class RecordParser
extends KermitRecordParser {
    public RecordParser(InterfaceKermitListener equip) {
        super(equip);
    }

    @Override
    protected void trataPacketData(String message) throws SQLException {
        try {
            String[] msgExames;
            message = message.substring(2);
            String req_codigo = message.substring(25, 40).trim();
            Statement st = Conexao.getStatement();
            if (Funcoes.textoVazio(req_codigo) || req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.equip.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + req_codigo);
                return;
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            req_codigo = req_codigo.substring(0, req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            String resultados = "";
            String mode = message.substring(43, 44);
            resultados = mode.equalsIgnoreCase("0") || mode.equalsIgnoreCase("1") || mode.equalsIgnoreCase("4") || mode.equalsIgnoreCase("5") ? message.substring(49, message.indexOf("|")) : message.substring(50, message.indexOf("|"));
            for (String s : msgExames = resultados.split("}")) {
                if (Funcoes.textoVazio(s)) continue;
                String emi_alternativo = s.substring(0, 3);
                s = s.substring(3);
                if (emi_alternativo.equalsIgnoreCase("#") && s.startsWith("#")) {
                    s = s.substring(3);
                }
                String resultado = "";
                resultado = s.toLowerCase().indexOf("NO RESULT".toLowerCase()) >= 0 ? "NO RESULT" : (!s.startsWith(" ") ? s.substring(s.indexOf(" ")) : s.substring(0, 9));
                String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (int_codigo == null) {
                    this.equip.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                int sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
                String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                dados.put(campo, this.arrumaValor(resultado, fil_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo));
                this.equip.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, null, sit);
                this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
            }
            if (this.equip.getAbaSelecionada() != 2) {
                this.equip.fireAtualizarTabela();
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.equip.fireExcecaoEncontrada("Erro ao realizar parse de dados recebidos do equipamento");
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.equip.fireExcecaoEncontrada("Erro ao realizar parse de dados recebidos do equipamento");
        }
    }
}

