/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.vitroseci;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.vitroseci.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.vitroseci.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.kermit.InterfaceKermitListener;
import jalis.laboratorio.interfaceamento.padroes.kermit.KermitRecordParser;
import jalis.laboratorio.interfaceamento.padroes.kermit.KermitStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class InterfaceListener
extends InterfaceKermitListener {
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        RecordParser record = new RecordParser(this);
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    public InterfaceListener(KermitRecordParser recordParser) {
        recordParser.setInterfaceASTMListener(this);
        super.setASTMRecordParser(recordParser);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            StackTraceElement[] stack = new Exception().getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                System.out.println(String.format("%s(%s)", stack[i].getClassName(), String.valueOf(stack[i].getLineNumber())));
            }
            String listaExames = this.obtemExameJaEnviados(fil_codigo, req_codigo, rec_codigo, pac_exames);
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = listaExames;
            this.exames = listaExames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String nome = StringUtil.removerAcentos(pac_nome);
            nome = nome.length() > this.MAX_PATIENT_NAME_CHARS ? nome.substring(0, this.MAX_PATIENT_NAME_CHARS) : Funcoes.preencheVazio(nome, this.MAX_PATIENT_NAME_CHARS, 2);
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo).append(rec_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            ArrayList<ExameMaterial> temporario = new ArrayList<ExameMaterial>();
            for (ExameMaterial e : alternativos) {
                if (temporario.contains(e)) continue;
                temporario.add(e);
            }
            alternativos = new ExameMaterial[temporario.size()];
            for (int i = 0; i < temporario.size(); ++i) {
                alternativos[i] = (ExameMaterial)temporario.get(i);
            }
            String material = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getNomeExame(), mco_codigo, int_codigo);
            int sequencia = 32;
            this.tx_list.add(KermitStandard.getDefaultConfigPacket(sequencia++));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o packet de configura\u00e7\u00e3o de envio");
            }
            this.tx_list.add(KermitStandard.getDefaultFilePacket(sequencia++));
            if (this.tx_list.size() < 1) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o packet do arquivo");
            }
            this.tx_list.add(this.getDefaultDataPacket((char)sequencia++, codigo.toString(), nome, material, alternativos));
            if (this.tx_list.size() < 2) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o packet dos exames");
            }
            this.tx_list.add(KermitStandard.getDefaultEndFilePacket(sequencia++));
            if (this.tx_list.size() < 3) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o packet de final de envio");
            }
            this.tx_list.add(KermitStandard.getDefaultBreakPacket(sequencia++));
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.enviarProximoFrame();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractKermitInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractKermitInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private String getDefaultDataPacket(char sequence, String sampleId, String pac_nome, String material, ExameMaterial[] alternativos) {
        StringBuilder msg = new StringBuilder();
        msg.append(sequence);
        msg.append('D');
        msg.append(Funcoes.preencheVazio(sampleId.toString(), 15, 2));
        msg.append(material);
        msg.append("0");
        msg.append(" ");
        String diluicao = this.configuracao.getModoDeDiluicao();
        msg.append(diluicao);
        for (ExameMaterial exa : alternativos) {
            msg.append(exa.getNomeExame());
        }
        msg.append("|");
        msg.append(pac_nome);
        msg.append("]");
        StringBuilder temp = new StringBuilder();
        temp.append(msg.toString());
        temp.insert(0, (char)(temp.length() + 33));
        temp.append(KermitStandard.getCheckSum(temp.toString()));
        temp.append(String.valueOf('\r'));
        temp.insert(0, String.valueOf('\u0001'));
        return temp.toString();
    }
}

