/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.vitros3600;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.vitros3600.RecordParser;
import jalis.laboratorio.interfaceamento.interfaces.vitros3600.ThreadRecebimento;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.util.parsers.Exame;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    protected int MAX_PATIENT_NAME_CHARS = 15;
    protected int MAX_EXAMES = 10;
    private List<String> listSamples = new ArrayList<String>();
    protected boolean hostQuery = false;
    protected boolean hostQueryVazio = false;
    private List<InfoExameRequisicao> examesEnviados = new ArrayList<InfoExameRequisicao>();
    private List<String> mensagens = new ArrayList<String>();
    private boolean query = false;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private Map<String, String> alternativos = new HashMap<String, String>();
    private List<Exame> curvas = new ArrayList<Exame>();
    private Map<String, List<Exame>> desmembrados = new HashMap<String, List<Exame>>();
    private String errorLog;
    private RecordParser recordResult = new RecordParser();

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        this.recordResult.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.INSTRUMENT_NAME = "";
        this.INSTRUMENT_SYSTEM_VERSION = "LIS2-A";
        this.MAX_TENTATIVAS_RX = 3;
        String dia = Funcoes.formataData("dd", Calendar.getInstance().getTime());
        this.limpaLogArquivos(dia);
        this.errorLog = String.format("%s%sVITROS5600-%s.log", System.getProperty("user.home"), System.getProperty("file.separator"), dia);
        this.alternativos = this.getAlternativos();
        this.desmembrados = this.getDesmembrados();
    }

    private Map<String, String> getAlternativos() {
        String int_codigo = "0";
        for (ConfiguracaoSerial c : Variaveis.equipamentos) {
            for (EquipamentoFilial e : c.getEquipamentos()) {
                int_codigo = e.getEquipamento().toString();
            }
        }
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo, mco_codigo, emi_alternativo, emi_curva, emi_material from examematinterface where fil_codigo = ");
        query.append(Variaveis.filialPadrao);
        query.append(" and int_codigo = ");
        query.append(int_codigo);
        Statement st = Conexao.getStatement();
        HashMap<String, String> alternativos = new HashMap<String, String>();
        try {
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                if (rs.getBoolean("emi_curva")) {
                    this.curvas.add(new Exame(rs.getString("exa_codigo"), rs.getInt("mco_codigo")));
                }
                if (Funcoes.textoVazio(rs.getString("emi_alternativo"))) continue;
                alternativos.put(rs.getString("exa_codigo") + "|" + rs.getString("mco_codigo"), rs.getString("emi_alternativo") + "|" + rs.getString("emi_material"));
            }
            st.close();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return alternativos;
    }

    private Map<String, List<Exame>> getDesmembrados() {
        String int_codigo = "0";
        for (ConfiguracaoSerial c : Variaveis.equipamentos) {
            for (EquipamentoFilial e : c.getEquipamentos()) {
                int_codigo = e.getEquipamento().toString();
            }
        }
        HashMap<String, List<Exame>> ret = new HashMap<String, List<Exame>>();
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo, mco_codigo, exa_kodigo, mco_kodigo from examematintdesmembrar where fil_codigo = ? ");
        query.append(" and int_codigo = ? order by exa_codigo, mco_codigo ");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        try {
            ps.setInt(1, Integer.parseInt(Variaveis.filialPadrao));
            ps.setInt(2, Integer.parseInt(int_codigo));
            ResultSet rs = ps.executeQuery();
            while (rs != null && rs.next()) {
                String key = String.format("%s|%s", rs.getString("exa_codigo"), rs.getString("mco_codigo"));
                if (!ret.containsKey(key)) {
                    ret.put(key, new ArrayList());
                }
                ((List)ret.get(key)).add(new Exame(rs.getString("exa_kodigo"), rs.getInt("mco_kodigo")));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public String parse(String message) {
        return super.parse(message);
    }

    public String parseResult(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                this.rx_list.add(message);
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String s = (String)this.rx_list.remove(0);
                    this.recordResult.recordFound(s);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    private void limpaLogArquivos(final String dia) {
        File file = new File(System.getProperty("user.home"));
        File[] afile = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.startsWith("VITROS5600") && name.endsWith(".log")) {
                    int d = Integer.parseInt(dia);
                    for (int i = 0; i < 5; ++i) {
                        if (d == 0) {
                            d = 31;
                        }
                        if (name.endsWith(String.format("%s.log", Funcoes.preencheZero(d, 2)))) {
                            return false;
                        }
                        --d;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        if (acao.equals("A")) {
            Statement st = Conexao.getStatement();
            try {
                String[] stringArray = exames.split(" ");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String exame;
                    int sitAtual = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame = stringArray[i], mcoCodigo, recCodigo);
                    this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, sitAtual < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                if (message.charAt(0) == '\u0005' && message.length() > 1 && message.charAt(message.length() - 1) == '\u0005') {
                    this.getPortaCOM().clearInputString();
                    this.handShakeCharReceived('\u0005');
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    if (this.isRX()) {
                        this.aguardarProximoFrame();
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("H")) {
                        this.query = false;
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("Q")) {
                        this.query = true;
                    }
                    this.mensagens.add(message);
                    if (this.query) {
                        while (this.mensagens.size() > 0) {
                            String resultado = this.parse(this.mensagens.remove(0));
                            if (resultado == null || !resultado.startsWith("Erro")) continue;
                            this.fireExcecaoEncontrada(resultado);
                        }
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("L")) {
                        this.query = false;
                        while (this.mensagens.size() > 0) {
                            this.addListaRecebimento(this.mensagens.remove(0));
                        }
                        this.restartThreadRecebimento();
                    }
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            this.fireExcecaoEncontrada("Erro ao receber dados do equipamento: " + ex.getMessage());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void encerrar() {
        SplashMensagem splash = new SplashMensagem();
        boolean x = false;
        while (this.threadRecebimento.listaDeExamesProcessando()) {
            try {
                splash = new SplashMensagem();
                splash.mostrar("Aguarde finalizando comunica\u00e7\u00e3o e processando \u00faltimos resultados");
                Thread.sleep(5000L);
                this.restartThreadRecebimento();
                splash.apagar();
            }
            catch (InterruptedException e) {
                splash.apagar();
                e.printStackTrace();
            }
        }
        super.encerrar();
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            starting_range = starting_range.substring(1);
            if (starting_range.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                return;
            }
            if (!this.listSamples.contains(starting_range)) {
                this.listSamples.add(starting_range);
            }
            this.hostQuery = true;
            this.hostQueryVazio = false;
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Erro ao responder o equipamento: " + e.getMessage());
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    if (this.isTX() || this.tx_list.size() > 0 && this.rx_counter < this.MAX_TENTATIVAS_RX) {
                        this.getPortaCOM().write(String.valueOf('\u0015'));
                        ++this.rx_counter;
                        break;
                    }
                    this.rx_counter = 0;
                    this.tratarEnquiry();
                    break;
                }
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    this.tratarEndOfTX();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.fireExcecaoEncontrada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage());
            if (this.tx_list.size() > 0) {
                this.limpaDadosRequisicao();
            }
            this.setIdle();
        }
    }

    protected String getErro(StackTraceElement[] erro) {
        StringBuilder erroText = new StringBuilder("");
        if (erro != null) {
            for (StackTraceElement e : erro) {
                erroText.append(e.getClassName()).append("(").append(e.getLineNumber()).append(")\n");
            }
        }
        return erroText.toString();
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    public void responseHostQuery() {
        try {
            while (!this.listSamples.isEmpty()) {
                String sample = this.listSamples.remove(0);
                String fil_codigo = sample.substring(0, ParametrosGerais.getDigitosTuboFilial());
                sample = sample.substring(ParametrosGerais.getDigitosTuboFilial());
                String req_codigo = sample.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                String rec_codigo = sample.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String pac_nome = null;
                String pac_sexo = null;
                String pac_idade = null;
                String data = null;
                String hora = null;
                String rack = null;
                String prioridade = null;
                String int_codigo = null;
                String mco_codigo = null;
                StringBuilder pac_exames = new StringBuilder("");
                String acao = "A";
                Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
                PanelAbaAbstrata aba = this.equipamento.getTab(0);
                if (req != null) {
                    pac_exames.append((String)req[aba.getColIndice("Exame")]);
                }
                if (req == null) {
                    req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    aba = this.equipamento.getTab(1);
                    if (req != null) {
                        List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                        for (Object[] r : reqs) {
                            pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                        }
                    }
                }
                String situacao = null;
                if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                    aba = this.equipamento.getTab(2);
                    if (req != null) {
                        List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                        for (Object[] r : reqs) {
                            if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                            situacao = (String)r[aba.getColIndice("Sit")];
                            pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                        }
                    }
                }
                if (req != null) {
                    pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                    pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                    data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                    hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                    rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                    int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                    String string = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : (mco_codigo = null);
                    if (situacao == null) {
                        situacao = aba.getColIndice("Sit") >= 0 ? (String)req[aba.getColIndice("Sit")] : null;
                    }
                    this.hostQueryVazio = false;
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao, situacao);
                    continue;
                }
                this.hostQueryVazio = true;
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo);
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + e.getMessage());
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.getPortaCOM().clearInputString();
        if (!(this.hostQueryVazio || Funcoes.textoVazio(this.fil_codigo) || Funcoes.textoVazio(this.req_codigo) || Funcoes.textoVazio(this.mco_codigo) || Funcoes.textoVazio(this.rec_codigo))) {
            while (!this.examesEnviados.isEmpty()) {
                this.encerrarTransmissao(this.examesEnviados.remove(0));
            }
        }
        this.limpaDadosRequisicao();
        this.setIdle();
        if (this.hostQuery) {
            this.hostQuery = false;
        }
        this.hostQueryVazio = false;
    }

    private void encerrarTransmissao(InfoExameRequisicao infoExame) throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            Statement st = Conexao.getStatement();
            if (infoExame != null) {
                String[] exames = infoExame.getExames().split(" ");
                String fil_codigo = infoExame.getFilial();
                String int_codigo = infoExame.getInterface();
                String req_codigo = infoExame.getCodigo();
                String mco_codigo = infoExame.getMaterial();
                String rec_tuboPai = infoExame.getTuboPai();
                String rec_codigo = infoExame.getRecipiente();
                boolean curva = infoExame.isCurva();
                for (int i = 0; i < exames.length; ++i) {
                    int situacao;
                    String[] examesFilho = infoExame.getExamesFilho().split(" ");
                    if (!Funcoes.textoVazio(rec_tuboPai) && curva && examesFilho != null && examesFilho.length > 0) {
                        for (String exame : examesFilho) {
                            int situacao2 = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_tuboPai, exame, mco_codigo);
                            BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, exame, mco_codigo, rec_tuboPai, situacao2 < 2 ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                        if (!BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_tuboPai)) continue;
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_tuboPai, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    if (examesFilho != null && examesFilho.length > 0) {
                        situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                        BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
            }
        }
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(infoExame.getCodigo(), infoExame.getNome(), infoExame.getSexo(), infoExame.getIdade(), infoExame.getData(), infoExame.getHora(), infoExame.getExames());
        }
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            if (!this.hostQuery) {
                this.tx_list.clear();
                this.rx_list.clear();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            if (!this.hostQuery) {
                this.tx_list = this.makeFrames(this.tx_list);
                this.tx_list.resetUltimoLido();
                this.setTX(this.TIME_TX);
                this.tx_counter = 0;
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada(String.format(" enviarRequisicaoSemExame: %s", this.getErro(e.getStackTrace())));
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                this.fireExcecaoEncontrada(String.format(" enviarRequisicaoSemExame Conexao.anulaSQL(): %s", this.getErro(e.getStackTrace())));
            }
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        StringBuilder msg = new StringBuilder();
        if (!Funcoes.textoVazio(erro)) {
            String[] erros;
            for (String e : erros = erro.split(";")) {
                if (e.equalsIgnoreCase("CEX")) {
                    msg.append("Curve expired.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("CRH")) {
                    msg.append("Result higher than critical (panic) reference range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("CRL")) {
                    msg.append("Result lower than critical (panic) reference range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("EDT")) {
                    msg.append("Result edit (currently unused).\t");
                    continue;
                }
                if (e.equalsIgnoreCase("GRY")) {
                    msg.append("Qualitative result in gray zone.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("IND")) {
                    msg.append("Result is indeterminant.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("LEX")) {
                    msg.append("Lot expired.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("LOW")) {
                    msg.append("Result lower than the minimum reportable result.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("NCR")) {
                    msg.append("No curve.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("NRV")) {
                    msg.append("Insufficient reagent, reaction vessels, wash, substrate, waste, or reaction vessel waste.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("OLD")) {
                    msg.append("Sample old.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("ORH")) {
                    msg.append("Result higher than normal reference range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("ORL")) {
                    msg.append("Result lower than normal reference range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("OVR")) {
                    msg.append("Result out of range of curve.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("PEX")) {
                    msg.append("Pack expired.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("QCF")) {
                    msg.append(" Control is outside QC limits.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("QEX")) {
                    msg.append(" Control lot expired.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("QNS")) {
                    msg.append(" Quantity not sufficient.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("RLU")) {
                    msg.append(" Relative light unit (RLU) value is outside of the acceptable luminometer measuring range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("SYS")) {
                    msg.append(" Instrument error.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("TMP")) {
                    msg.append(" One or more of the following is outside the temperature specification: Incubator, wash/read carousel, substrate, reagent.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("UNR")) {
                    msg.append(" The measured sample signal (RLU) is less than an RLU threshold limit for the least concentrated calibrator or calibration control for a positive slope assay, or is greater than the least concentrated calibrator for a negative slope assay, as defined in the assay protocol file.\t");
                    continue;
                }
                if (!e.equalsIgnoreCase("WVL")) continue;
                msg.append(" Quality control sample result was generated using a different reagent vial lot number than the vial lot number used to calibrate the assay.\t");
            }
        }
        return msg.toString();
    }

    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, String situacao) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            if (!this.hostQuery) {
                this.tx_list.clear();
                this.rx_list.clear();
            }
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.trim().split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            Object listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            String sobrenome = null;
            if (short_name.indexOf(" ") > 0) {
                String[] names = short_name.split(" ");
                String firstName = names[0];
                if (firstName.length() > this.MAX_PATIENT_NAME_CHARS) {
                    firstName = firstName.substring(0, this.MAX_PATIENT_NAME_CHARS);
                }
                if (names.length > 2 && !Funcoes.textoVazio(names[1])) {
                    short_name = firstName + "^" + names[1].charAt(0);
                }
                if ((sobrenome = names[names.length - 1]).length() > 20) {
                    sobrenome = sobrenome.substring(0, 20);
                }
            }
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = this.getCodigoMaterial(exa_lista);
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            if (this.isExameCurva(exa_lista)) {
                exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            }
            if (exa_lista != null) {
                exa_lista = this.desmembrarExame(exa_lista);
            } else {
                exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
                if (this.hostQuery) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_lista[0].getNomeExame(), mco_codigo);
                }
                exa_lista = this.desmembrarExame(exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
            }
            alternativos = this.pegaAlternativos(exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            if (!exa_listaCurva.isEmpty()) {
                if (alternativos != null && alternativos.length == 1) {
                    alternativos = null;
                }
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, st, exa_listaCurva, this.rec_tuboPai, this.hostQuery, this.examesFilho);
            }
            String nome = short_name;
            this.tx_list.add(this.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, null, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = req_codigo;
            String laboratory_pid = null;
            this.tx_list.add(this.getDefaultPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                for (int i = 0; i < alternativos.length; ++i) {
                    if (alternativos[i] == null || alternativos[0] == null) continue;
                    this.tx_list.add(this.getDefaultOrderRecord(++seq, codigo.toString(), alternativos[i], null, null, "R", acao, tipo_amostra, "O"));
                }
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    List<ExameMaterial> examesCurva = alternativosCurva.get(key);
                    for (ExameMaterial exameMaterial : examesCurva) {
                        this.tx_list.add(this.getDefaultOrderRecord(++seq, sample_id.append(tubo).toString(), exameMaterial, null, null, "R", acao, tipo_amostra, "O"));
                    }
                }
            }
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            InfoExameRequisicao exame = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames);
            exame.setExamesFilho(StringUtil.implode(this.examesFilho, " "));
            exame.setTuboPai(this.rec_tuboPai);
            exame.setInterface(int_codigo);
            exame.setCurva(this.curva);
            this.examesEnviados.add(exame);
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            if (!this.hostQuery) {
                this.tx_list = this.makeFrames(this.tx_list);
                this.tx_list.resetUltimoLido();
                this.setTX(this.TIME_TX);
                this.tx_counter = 0;
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada(String.format(" AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o %s", this.getErro(e.getStackTrace())));
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                this.fireExcecaoEncontrada(String.format(" AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o %s", this.getErro(e.getStackTrace())));
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private String getCodigoMaterial(ExameMaterial[] exa_lista) {
        for (ExameMaterial exameMaterial : exa_lista) {
            String exame = exameMaterial.getString();
            String material = exameMaterial.getCodigo().toString();
            String chave = String.format("%s|%s", exame, material);
            for (String key : this.alternativos.keySet()) {
                String[] alt;
                if (!key.equals(chave) || (alt = this.alternativos.get(key).split("[|]")) == null || alt.length < 2 || Funcoes.textoVazio(alt[1])) continue;
                return alt[1];
            }
        }
        return "5";
    }

    private boolean isExameCurva(ExameMaterial[] exames) {
        for (ExameMaterial exm : exames) {
            String exa_codigo = exm.getString();
            String mco_codigo = exm.getCodigo().toString();
            String key = String.format("%s|%s", exa_codigo, mco_codigo);
            for (Exame curva : this.curvas) {
                String key2 = String.format("%s|%s", curva.getCodigoExame(), String.valueOf(curva.getCodigomaterial()));
                if (!key.equals(key2)) continue;
                return true;
            }
        }
        return false;
    }

    private ExameMaterial[] desmembrarExame(ExameMaterial[] exames) {
        ArrayList<ExameMaterial> nova_lista = new ArrayList<ExameMaterial>();
        for (ExameMaterial exm : exames) {
            String exa_codigo = exm.getString();
            String mco_codigo = exm.getCodigo().toString();
            String key = String.format("%s|%s", exa_codigo, mco_codigo);
            if (this.desmembrados.containsKey(key)) {
                for (Exame exame : this.desmembrados.get(key)) {
                    nova_lista.add(new ExameMaterial(exame.getCodigoExame(), exame.getCodigomaterial()));
                }
                continue;
            }
            nova_lista.add(exm);
        }
        ExameMaterial[] retorno = nova_lista.toArray(new ExameMaterial[nova_lista.size()]);
        return retorno;
    }

    private ExameMaterial[] pegaAlternativos(ExameMaterial[] exa_lista) {
        ExameMaterial[] alternativos = new ExameMaterial[exa_lista.length];
        ExameMaterial[] alternativosBild = new ExameMaterial[exa_lista.length];
        boolean bild = false;
        String bildExame = "";
        int i = -1;
        for (ExameMaterial exm : exa_lista) {
            String exa_codigo = exm.getString();
            String mco_codigo = exm.getCodigo().toString();
            String key = exa_codigo + "|" + mco_codigo;
            if (this.alternativos.containsKey(key)) {
                String[] alt = this.alternativos.get(key).split("[|]");
                if (alt == null || alt.length <= 0) continue;
                if (alt[0].equalsIgnoreCase("1.0000+905+1.0")) {
                    alternativosBild[0] = new ExameMaterial(alt[0], new Integer(exm.getCodigoMaterial()));
                    bildExame = exa_codigo;
                    bild = true;
                }
                alternativos[++i] = new ExameMaterial(alt[0], new Integer(exm.getCodigoMaterial()));
                continue;
            }
            this.fireExcecaoEncontrada(String.format("Exame %s com material %s sem a configura\u00e7\u00e3o de alternativo configurada", exa_codigo, mco_codigo));
        }
        if (bild) {
            int x = 1;
            for (ExameMaterial exameMaterial : alternativos) {
                if (exameMaterial.getNomeExame().equalsIgnoreCase("1.0000+905+1.0")) continue;
                alternativosBild[x++] = exameMaterial;
            }
            return alternativosBild;
        }
        return alternativos;
    }

    private ExameMaterial[] getDesmRepetir(String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String situacao, ExameMaterial[] exa_lista) throws SQLException {
        ArrayList<ExameMaterial> nova_lista = new ArrayList<ExameMaterial>();
        if (situacao != null && (situacao.equals(String.valueOf(3)) || situacao.equals(String.valueOf(4)) || situacao.equals(String.valueOf(5)))) {
            for (ExameMaterial exameMaterial : exa_lista) {
                String situacaoFilho = String.valueOf(BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, this.pac_exames, mco_codigo, rec_codigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial()));
                if (!situacaoFilho.equals(String.valueOf(3)) && !situacaoFilho.equals(String.valueOf(4)) && !situacaoFilho.equals(String.valueOf(5))) continue;
                nova_lista.add(exameMaterial);
            }
            return nova_lista.toArray(new ExameMaterial[nova_lista.size()]);
        }
        return exa_lista;
    }

    private String getDefaultHeaderRecord(String delimiters, String password, String sender_id_name, String sender_id_system, String control, String receiver_id_name, String receiver_id_system, String version_number) {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("||");
        record.append(password == null ? "" : password);
        record.append("|");
        record.append(sender_id_name == null ? "" : sender_id_name);
        record.append(sender_id_system == null ? "" : "^" + sender_id_system);
        record.append("||||");
        record.append(control == null ? "" : control);
        record.append("|");
        record.append(receiver_id_name == null ? "" : receiver_id_name);
        record.append(receiver_id_system == null ? "" : "^" + receiver_id_system);
        record.append("|||");
        record.append(version_number);
        record.append("|");
        record.append(ASTMStandard.getCurrentMoment());
        record.append("|");
        record.append('\r');
        return record.toString();
    }

    private String getDefaultPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String pac_nome, String pac_sobrenome, String pac_sexo) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence).append("|");
        record.append(patient_id == null ? "" : patient_id).append("|");
        record.append(laboratory_pid == null ? "" : laboratory_pid).append("");
        record.append("||");
        record.append(pac_sobrenome == null ? "" : pac_sobrenome);
        record.append(pac_nome == null ? "" : "^" + pac_nome).append("|");
        record.append("||");
        record.append(pac_sexo == null ? "" : pac_sexo).append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|").append('\r');
        return record.toString();
    }

    private String getDefaultOrderRecord(int order_sequence, String sample_id, ExameMaterial test_item_number, ExameMaterial test_item_name, String dilution, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence).append("|");
        record.append(sample_id == null ? "" : sample_id).append("|");
        record.append("|");
        record.append("^^^");
        record.append(test_item_number.getNomeExame());
        record.append(test_item_name == null ? "" : "^" + test_item_name.getNomeExame());
        record.append(dilution == null ? "" : "^" + dilution);
        record.append("|");
        record.append(priority == null ? "" : priority).append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append(action_code == null ? "" : action_code).append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append(sample_type == null ? "" : sample_type);
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append("|");
        record.append(report_type == null ? "" : report_type);
        record.append('\r');
        return record.toString();
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    private void query() {
        String idAmosta = JOptionPane.showInputDialog("Informe o Id da amostra?");
        this.testeQuery(idAmosta);
        this.testeResultado(idAmosta);
        this.handShakeCharReceived('\u0004');
        for (int i = 0; i < 10; ++i) {
            this.handShakeCharReceived('\u0006');
        }
    }

    private void testeQuery(String idAmosta) {
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||0437||||||||LIS2-A|20160811133524[CR][ETX]D0[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|^" + idAmosta + "||ALL||||||||O[CR][ETX]1B[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR]ETX]06[LINE]"));
    }

    private void testeResultado(String idAmosta) {
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||0437||||||||LIS2-A|20160811133524[CR][ETX]D0[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2P|1|U000919|||SEAN^BOYD^M||19951227|M||123 MAIN STREET^ROCHESTER,NY|||SMITH^JOHN^H|1|||||||||||SWVV[CR][ETX]1B[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2O|1|^" + idAmosta + "||^^^1.0000+301+1.0|S||20060731085403||||N||||5||||||||||F[CR][ETX]1B[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|1|^TSH|4.1|g/dL||^2^EP\\^0^\\^0^\\^0^||V||BREDICK|20060731090236|20060731090820|43000224[CR][ETX]1B[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|2|^^^1.0000+950+1.0|15|||^5^||V||BREDICK|20060731090236|20060731090258|43000224[CR][ETX]1B[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR]ETX]06[LINE]"));
    }

    @Override
    public void teste() {
        this.query();
    }
}

