/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.vitek2;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    private String starting_range = null;
    private String ending_range = null;
    private String test_id = null;
    private boolean modoHostQuery = false;
    private boolean exr_codigoapoiado = false;
    public static final String PATIENT_ID = "pd";
    public static final String SIMPLE_ID = "ci";
    public static final String TEST_TYPE_CODE = "rt";
    private static final String ANTIBIOTIC_CODE = "a1";
    private static final String ANTIBIOTIC_EXAME = "a2";
    private static final String RESULTL_MIC = "a3";
    private static final String FINAL_INTERPRETATION = "a4";
    private static final String RESULT_SEPARATOR = "ra";
    public final String QUALITATIVE_RESULT = "ql";
    public final String QUANTITATIVE_RESULT = "qn";
    private HashMap<String, String> parametros = new HashMap();

    public RecordParser() {
        this.parametros.put("esbl", "BLSE_Mic");
        this.parametros.put("an", "Amicacina_Mic");
        this.parametros.put("am", "Ampicilina_Mic");
        this.parametros.put("ams", "AmpicilinaSulBactam_Mic");
        this.parametros.put("tzp", "PiperacilinaTazobactamMic_Mic");
        this.parametros.put("rox", "Cefuroxima_Mic");
        this.parametros.put("fox", "Cefoxitina_Mic");
        this.parametros.put("taz", "Ceftazidima_Mic");
        this.parametros.put("ctr", "Ceftriaxona_Mic");
        this.parametros.put("fep", "Cefepima_Mic");
        this.parametros.put("etp", "Ertapenem_Mic");
        this.parametros.put("imi", "Imipenem_Mic");
        this.parametros.put("mem", "Meropenem_Mic");
        this.parametros.put("gm", "Gentamicina_Mic");
        this.parametros.put("cip", "Ciprofloxacina_Mic");
        this.parametros.put("tgc", "Tigeciclina_Mic");
        this.parametros.put("cs", "Colistina_Mic");
        this.parametros.put("peng", "Benzilpenicilina_Mic");
        this.parametros.put("cc", "Clindamicina_Mic");
        this.parametros.put("dap", "Daptomicina_Mic");
        this.parametros.put("e", "Eritromicina_Mic");
        this.parametros.put("lev", "Levofloxacina_Mic");
        this.parametros.put("lnz", "Linezolid_Mic");
        this.parametros.put("ftn", "Nitrofurantoina_Mic");
        this.parametros.put("ox", "Oxacilina_Mic");
        this.parametros.put("icr", "Resis_Clindamicina_Mic");
        this.parametros.put("rif", "Rifampicina_Mic");
        this.parametros.put("tpn", "Teicoplanina_Mic");
        this.parametros.put("oxsf", "Screening_Cefoxitina_Teicoplanina_Mic");
        this.parametros.put("stx", "TrimetoprimSulfametoxazol_Mic");
        this.parametros.put("va", "Vancomicina_Mic");
        this.parametros.put("ab", "AnfotericinaB_Mic");
        this.parametros.put("cas", "Caspofungina_Mic");
        this.parametros.put("flu", "Fluconazol_Mic");
        this.parametros.put("mcf", "Micafungina_Mic");
        this.parametros.put("vrc", "Voriconazol_Mic");
        this.parametros.put("esbl_diam", "BLSE_Diam");
        this.parametros.put("an_diam", "Amicacina_Diam");
        this.parametros.put("am_diam", "Ampicilina_Diam");
        this.parametros.put("ams_diam", "AmpicilinaSulBactam_Diam");
        this.parametros.put("tzp_diam", "PiperacilinaTazobactam_Diam");
        this.parametros.put("rox_diam", "Cefuroxima_Diam");
        this.parametros.put("fox_diam", "Cefoxitina_Diam");
        this.parametros.put("taz_diam", "Ceftazidima_Diam");
        this.parametros.put("ctr_diam", "Ceftriaxona_Diam");
        this.parametros.put("fep_diam", "Cefepima_Diam");
        this.parametros.put("etp_diam", "Ertapenem_Diam");
        this.parametros.put("imi_diam", "Imipenem_Diam");
        this.parametros.put("mem_diam", "Meropenem_Diam");
        this.parametros.put("gm_diam", "Gentamicina_Diam");
        this.parametros.put("cip_diam", "Ciprofloxacina_Diam");
        this.parametros.put("tgc_diam", "Tigeciclina_Diam");
        this.parametros.put("cs_diam", "Colistina_Diam");
        this.parametros.put("peng_diam", "Benzilpenicilina_Diam");
        this.parametros.put("cc_diam", "Clindamicina_Diam");
        this.parametros.put("dap_diam", "Daptomicina_Diam");
        this.parametros.put("e_diam", "Eritromicina_Diam");
        this.parametros.put("lev_diam", "Levofloxacina_Diam");
        this.parametros.put("lnz_diam", "Linezolid_Diam");
        this.parametros.put("ftn_diam", "Nitrofurantoina_Diam");
        this.parametros.put("ox_diam", "Oxacilina_Diam");
        this.parametros.put("icr_diam", "Resis_Clindamicina_Diam");
        this.parametros.put("rif_diam", "Rifampicina_Diam");
        this.parametros.put("tpn_diam", "Teicoplanina_Diam");
        this.parametros.put("oxsf_diam", "Screening_Cefoxitina_Teicoplanina_Diam");
        this.parametros.put("stx_diam", "TrimetoprimSulfametoxazol_Diam");
        this.parametros.put("va_diam", "Vancomicina_Diam");
        this.parametros.put("ab_diam", "AnfotericinaB_Diam");
        this.parametros.put("cas_diam", "Caspofungina_Diam");
        this.parametros.put("flu_diam", "Fluconazol_Diam");
        this.parametros.put("mcf_diam", "Micafungina_Diam");
        this.parametros.put("vrc_diam", "Voriconazol_Diam");
        this.parametros.put("esbl_cat", "BLSE_Cat");
        this.parametros.put("an_cat", "Amicacina_Cat");
        this.parametros.put("am_cat", "Ampicilina_Cat");
        this.parametros.put("ams_cat", "AmpicilinaSulBactam_Cat");
        this.parametros.put("tzp_cat", "PiperacilinaTazobactam_Cat");
        this.parametros.put("rox_cat", "Cefuroxima_Cat");
        this.parametros.put("fox_cat", "Cefoxitina_Cat");
        this.parametros.put("taz_cat", "Ceftazidima_Cat");
        this.parametros.put("ctr_cat", "Ceftriaxona_Cat");
        this.parametros.put("fep_cat", "Cefepima_Cat");
        this.parametros.put("etp_cat", "Ertapenem_Cat");
        this.parametros.put("imi_cat", "Imipenem_Cat");
        this.parametros.put("mem_cat", "Meropenem_Cat");
        this.parametros.put("gm_cat", "Gentamicina_Cat");
        this.parametros.put("cip_cat", "Ciprofloxacina_Cat");
        this.parametros.put("tgc_cat", "Tigeciclina_Cat");
        this.parametros.put("cs_cat", "Colistina_Cat");
        this.parametros.put("peng_cat", "Benzilpenicilina_Cat");
        this.parametros.put("cc_cat", "Clindamicina_Cat");
        this.parametros.put("dap_cat", "Daptomicina_Cat");
        this.parametros.put("e_cat", "Eritromicina_Cat");
        this.parametros.put("lev_cat", "Levofloxacina_Cat");
        this.parametros.put("lnz_cat", "Linezolid_Cat");
        this.parametros.put("ftn_cat", "Nitrofurantoina_Cat");
        this.parametros.put("ox_cat", "Oxacilina_Cat");
        this.parametros.put("icr_cat", "Resis_Clindamicina_Cat");
        this.parametros.put("rif_cat", "Rifampicina_Cat");
        this.parametros.put("tpn_cat", "Teicoplanina_Cat");
        this.parametros.put("oxsf_cat", "Screening_Cefoxitina_Teicoplanina_Cat");
        this.parametros.put("stx_cat", "TrimetoprimSulfametoxazol_Cat");
        this.parametros.put("va_cat", "Vancomicina_Cat");
        this.parametros.put("ab_cat", "AnfotericinaB_Cat");
        this.parametros.put("cas_cat", "Caspofungina_Cat");
        this.parametros.put("flu_cat", "Fluconazol_Cat");
        this.parametros.put("mcf_cat", "Micafungina_Cat");
        this.parametros.put("vrc_cat", "Voriconazol_Cat");
    }

    @Override
    public void recordFound(String record) throws Exception {
        HashMap<String, Object> dados = new HashMap<String, Object>();
        String[] message = record.replace("\r\n", "").split("\\|");
        String codigoRequisicao = "";
        String resultQualitativo = "";
        String resultQuantitativo = "";
        String emi_alternativo = "";
        for (String m : message) {
            if (m.length() <= 2) continue;
            String value = m.substring(0, 2);
            if (value.trim().contains(SIMPLE_ID)) {
                codigoRequisicao = m.substring(SIMPLE_ID.length());
                continue;
            }
            if (!value.trim().contains(TEST_TYPE_CODE)) continue;
            emi_alternativo = m.substring(TEST_TYPE_CODE.length());
        }
        String novaMensagem = record.substring(record.indexOf("ra|"));
        String[] messageRA = novaMensagem.split("ra\\|");
        dados.putAll(this.getDados(messageRA));
        this.trataResultRecord(codigoRequisicao, dados, emi_alternativo);
    }

    private Map<String, Object> getDados(String[] messageRA) {
        HashMap<String, Object> dados = new HashMap<String, Object>();
        for (String m : messageRA) {
            if (m.length() <= 2) continue;
            String[] result = m.trim().replace("\r\n", "").split("\\|");
            String campo = "";
            String resultado = "";
            String value = result[0].substring(0, 2);
            campo = this.parametros.get(result[0].substring(ANTIBIOTIC_CODE.length()));
            resultado = result[2].substring(RESULTL_MIC.length());
            resultado = resultado.replaceAll("\\.", ",").replace("[", "").replace("]", "");
            dados.put(campo, resultado);
            campo = this.parametros.get(result[0].substring(ANTIBIOTIC_CODE.length()) + "_diam");
            resultado = result[3].substring(FINAL_INTERPRETATION.length());
            resultado = resultado.replaceAll("\\.", ",").replace("[", "").replace("]", "");
            dados.put(campo, resultado);
            campo = this.parametros.get(result[0].substring(ANTIBIOTIC_CODE.length()) + "_cat");
            resultado = result[4].trim().substring(FINAL_INTERPRETATION.length());
            resultado = resultado.replaceAll("\\.", ",").replace("[", "").replace("]", "");
            dados.put(campo, resultado);
        }
        return dados;
    }

    protected void trataResultRecord(String codigoTubo, Map<String, Object> dados, String emi_alternativo) throws SQLException {
        if (this.exame_atual == null) {
            this.exame_atual = new HashMap();
        }
        String fil_codigo = codigoTubo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = codigoTubo.substring(ParametrosGerais.getDigitosTuboFilial(), codigoTubo.length() - ParametrosGerais.getDigitosTuboTubo());
        String rec_codigo = codigoTubo.substring(codigoTubo.length() - ParametrosGerais.getDigitosTuboTubo());
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(INT_CODIGO, int_codigo);
        System.out.println("emi_alternativo: " + emi_alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        String exa_codigo = exame.getNomeExame();
        String mco_codigo = exame.getCodigoMaterial();
        dados.put(EXA_CODIGO, exa_codigo);
        dados.put(MCO_CODIGO, mco_codigo);
        dados.put(REQ_CODIGO, req_codigo);
        dados.put(FIL_CODIGO, fil_codigo);
        dados.put(REC_CODIGO, rec_codigo);
        Statement st = Conexao.getStatement();
        int sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
        try {
            this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados);
            this.salvaExame(this.exame_atual);
            this.exame_atual = null;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Access: RecordParser:210");
        }
    }

    @Override
    protected void trataRequestRecord(String record) throws Exception {
        Hashtable comps = ASTMStandard.parseDefaultRequestRecord(record);
        this.starting_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_STARTING_RANGE_ID);
        this.ending_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_ENDING_RANGE_ID);
        this.test_id = (String)comps.get(ASTMStandard.REQUEST_FIELD_TEST_ID);
        this.modoHostQuery = true;
    }

    @Override
    protected void trataTerminationRecord() throws Exception {
        if (this.modoHostQuery) {
            this.equip.responderRequest(this.starting_range, this.ending_range, this.test_id);
            this.modoHostQuery = false;
            return;
        }
        if (this.exame_atual == null) {
            return;
        }
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.get(FIL_CODIGO);
        String int_codigo = (String)dados.get(INT_CODIGO);
        String req_codigo = (String)dados.get(REQ_CODIGO);
        String exa_codigo = (String)dados.get(EXA_CODIGO);
        String mco_codigo = (String)dados.get(MCO_CODIGO);
        String rec_codigo = (String)dados.get(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados);
    }

    public void setPossuiCodigoApoiado(boolean exr_codigoapoiado) {
        this.exr_codigoapoiado = exr_codigoapoiado;
    }
}

