/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.vitek2;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.vitek2.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class InterfaceListener
extends InterfaceASTMListener {
    public final String PATIENT_ID = "pd";
    public final String PATIENT_NAME = "pn";
    public final String PATIENT_BIRTHDATE = "pb";
    public final String PATIENT_SEX = "ps";
    public final String SIMPLE_ID = "ci";
    public final String MESSAGE_TYPE = "mt";
    public final String RESULT = "rsl";
    public final String REQUEST = "rsl";
    public final String SHORT_ASSAY_NAME = "rt";
    public final String TEST_COMPLETION_TIME = "tt";
    public final String TEST_COMPLETION_DATE = "td";
    public final String QUALITATIVE_RESULT = "ql";
    public final String QUANTITATIVE_RESULT = "qn";
    public final String SAMPLE_ORIGIN = "so";
    public final String SPECIMEN_SEPARATOR = "si";
    public final String MESSAGE_TERMINATOR = "zz";
    public String alternativoExame = "";
    public RecordParser record;
    boolean exr_codigoapoiado = false;

    public InterfaceListener() {
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        this.record = new RecordParser();
        this.record.setInterfaceASTMListener(this);
        this.record.setPossuiCodigoApoiado(this.exr_codigoapoiado);
        super.setASTMRecordParser(this.record);
        this.INSTRUMENT_NAME = "Access";
    }

    public String getAlternativoExame() {
        return this.alternativoExame;
    }

    public void setAlternativoExame(String alternativoExame) {
        this.alternativoExame = alternativoExame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        Statement st = Conexao.getStatement();
        String retorno = "";
        try {
            for (String exame : pac_exames.split(" ")) {
                retorno = this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exame, acao, "");
                this.handShakeCharReceived('\u0006');
                this.handShakeCharReceived('\u0006');
                this.handShakeCharReceived('\u0006');
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            this.equipamento.atualizarTabela();
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
    }

    private String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, String codigoApoiado) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo.substring(ParametrosGerais.getDigitosTuboFilial()), ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            if (!Funcoes.textoVazio(codigoApoiado)) {
                codigo.setLength(0);
                codigo.append(codigoApoiado);
            } else {
                rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
                codigo.append(rec_codigo);
            }
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            String nome = short_name;
            Object sobrenome = null;
            this.tx_list.add(this.getHeaderRecord("rsl", "", short_name, data, pac_sexo, codigo.toString(), alternativos[0].getString()));
            this.setAlternativoExame(alternativos[0].getString());
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return "";
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String checksumCalculation = "";
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            checksumCalculation = this.calculaCheckSum(message);
            message = message.substring(1, message.length());
            checksum = message.substring(message.length() - 4);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                this.rx_list.add(message);
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String s = (String)this.rx_list.remove(0);
                    this.record.recordFound(s);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                this.equipamento.atualizarTabela();
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat?vel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    private String calculaCheckSum(String message) {
        message = message.substring(1, message.length() - 4);
        char[] sentenceArr = message.toCharArray();
        boolean asciiValue = false;
        String resultadoSomaBinario = "";
        for (int i = 2; i < sentenceArr.length; ++i) {
            if (sentenceArr[i] == '|') continue;
            String b1 = Integer.toBinaryString(sentenceArr[i]);
            resultadoSomaBinario = this.addBinary(resultadoSomaBinario, b1);
        }
        int decimal = Integer.parseInt(resultadoSomaBinario.substring(1), 2);
        String hexStr = Integer.toString(decimal, 16);
        return hexStr;
    }

    private String addBinary(String b1, String b2) {
        String result = "";
        int s = 0;
        int i = b1.length() - 1;
        for (int j = b2.length() - 1; i >= 0 || j >= 0 || s == 1; s /= 2, --i, --j) {
            s += i >= 0 ? b1.charAt(i) - 48 : 0;
            result = (char)((s += j >= 0 ? b2.charAt(j) - 48 : 0) % 2 + 48) + result;
        }
        return result;
    }

    private String getHeaderRecord(String request, String pacienteID, String pacienteNome, String pacienteData, String pacienteSexo, String codigo, String alternativo) throws Exception {
        StringBuilder record = new StringBuilder();
        record.append('\u0002').append('\r').append('\n');
        record.append("mt").append(request);
        record.append("|");
        record.append("pd").append(pacienteID);
        record.append("|");
        record.append("pn").append(pacienteNome);
        record.append("|");
        record.append("pb").append(pacienteData);
        record.append("|");
        record.append("ps").append(pacienteSexo);
        record.append("|");
        record.append("so");
        record.append("|");
        record.append("si");
        record.append("|");
        record.append("ci").append(codigo);
        record.append("|");
        record.append("rt").append(alternativo);
        record.append("|");
        record.append("zz").append('\r').append('\n');
        record.append(AbstractInterfaceamento.sGS);
        record.append(this.calculaCheckSum(record.toString())).append('\r').append('\n');
        return record.toString();
    }

    @Override
    public MemoryList<String> makeFrames(MemoryList<String> raw_list) throws Exception {
        try {
            MemoryList<String> new_list = new MemoryList<String>();
            this.frame_num = 0;
            if (raw_list != null) {
                while (!raw_list.isEmpty() && raw_list.size() > 0) {
                    String[] slices = StringUtil.dividir(raw_list.remove(0), 80);
                    for (int j = 0; j < slices.length; ++j) {
                        StringBuilder temp = new StringBuilder();
                        temp.append(slices[j]);
                        temp.append(String.valueOf('\u001d'));
                        temp.append(Checksum.getChecksumMod256(temp.toString()));
                        temp = new StringBuilder(this.getMsgStart()).append((CharSequence)temp);
                        temp.append(this.getMsgEnd());
                        new_list.add(temp.toString());
                    }
                }
                return new_list;
            }
            return null;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Erro ao recuperar lista de frames (size:" + raw_list.size() + ")");
            return null;
        }
    }

    private int binaryToInt(String binary) {
        int result = 0;
        for (int exp = binary.length(); exp > 0; --exp) {
            if (binary.charAt(binary.length() - exp) == '0') continue;
            result = (int)((double)result + Math.pow(2.0, exp - 1));
        }
        return result;
    }

    public String arruma(String message) {
        String command = message;
        String newCommand = "";
        String c = "";
        if (command != null && !command.trim().isEmpty()) {
            char[] a = command.toCharArray();
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == '[' && a[i + 1] != '[') {
                    c = c + a[i];
                    ++i;
                    while (a[i] != ']') {
                        c = c + a[i];
                        ++i;
                    }
                    c = c + a[i];
                    newCommand = newCommand + this.parseStringToConstant(c);
                    c = "";
                    continue;
                }
                newCommand = newCommand + a[i];
            }
        }
        return newCommand;
    }

    public String parseStringToConstant(String command) {
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sNUL)) {
            return String.valueOf('\u0000');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sSOH)) {
            return String.valueOf('\u0001');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sSTX)) {
            return String.valueOf('\u0002');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sETX)) {
            return String.valueOf('\u0003');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sEOT)) {
            return String.valueOf('\u0004');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sENQ)) {
            return String.valueOf('\u0005');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sACK)) {
            return String.valueOf('\u0006');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sLF)) {
            return String.valueOf('\n');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sSB)) {
            return String.valueOf('\u000b');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sCR)) {
            return String.valueOf('\r');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sDLE)) {
            return String.valueOf('\u0010');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sDC1)) {
            return String.valueOf('\u0011');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sNAK)) {
            return String.valueOf('\u0015');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sSYN)) {
            return String.valueOf('\u0016');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sETB)) {
            return String.valueOf('\u0017');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sCAN)) {
            return String.valueOf('\u0018');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sEB)) {
            return String.valueOf('\u001c');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sSP)) {
            return String.valueOf(' ');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sDEL)) {
            return String.valueOf('\u007f');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sLINE)) {
            return String.valueOf(LINE);
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sFD)) {
            return String.valueOf('\u00fd');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sGS)) {
            return String.valueOf('\u001d');
        }
        if (command.equalsIgnoreCase(AbstractInterfaceamento.sRS)) {
            return String.valueOf('\u001e');
        }
        return command;
    }

    @Override
    public void teste() {
        this.recebeResultado();
    }

    private void recebeResultado() {
        StringBuilder buf = new StringBuilder();
        String req = "010007533109";
        buf.append("[STX][CR][LF]");
        buf.append("[RS]mtrsl|iiV2|is0000128270AC|itSU|pi16227|pv16227|pnANTHONY GABRIEL FREITAG|pp57974[CR][LF]");
        buf.append("[RS]6.0|p5579746.0|w116227|si|ci").append(req).append("|c014945|ctCultura Automatizada|cnCultura Autom[CR][LF]");
        buf.append("[RS]atizada|ta|rtAST-N239|rr3148169|t11|o1esccol|o2Escherichia coli|afBETA-LACT\u00c2MICO[CR][LF]");
        buf.append("[RS]S|apSELVAGEM|afAMINOGLICOS\u00cdDEOS|apSELVAGEM|afTETRACICLINAS|apRESISTENTE|apSELVAG[CR][LF]");
        buf.append("[RS]EM|afQUINOLONAS|apPARCIALMENTE RESISTENTE|apSELVAGEM|afPOLIPEPT\u00cdDEOS|apSELVAGEM|[CR][LF]");
        buf.append("[RS]ra|a1esbl|a2BLSE|a3Neg|a4-|an-|ra|a1am|a2Ampicilina|a3[=2]|a4S|anS|ra|a1ams|a2Ampicilina/sulbactam|a3[=2]|a4S|anS|[CR][LF]");
        buf.append("[RS]ra|a1tzp|a2Piperacilina/Tazobactam|a3[=4]|a4S|anS|[CR][LF]");
        buf.append("[RS]ra|a1rox|a2Cefuroxima|a34|a4S|anS|ra|a1fox|a2Cefoxitina|a3[=4]|a4S|anS|ra|a1taz|a2Ceftazidima|a3[=1]|a4S|anS|[CR][LF]");
        buf.append("[RS]ra|a1ctr|a2Ceftriaxona|a3[=1]|a4S|anS|ra|a1fep|a2Cefepima|a3[=1]|a4S|anS|[CR][LF]");
        buf.append("[RS]ra|a1etp|a2Ertapenem|a3[=0,5]|a4S|anS|ra|a1imi|a2Imipenem|a3[=0,25]|a4S|anS|[CR][LF]");
        buf.append("[RS]ra|a1mem|a2Meropenem|a3[=0,25]|a4S|anS|ra|a1an|a2Amicacina|a3[=2]|a4S|anS|ra|a1gm|a2Gentamicina|a3[=1]|a4S|anS|[CR][LF]");
        buf.append("[RS]ra|a1cip|a2Ciprofloxacina|a3[=0,25]|a4S|[CR][LF]");
        buf.append("[RS]anS|ra|a1tgc|a2Tigeciclina|a3[=0,5]|a4S|anS|ra|a1cs|a2Colistina|a3[=0,5|a4S|anS|z[CR][LF]");
        buf.append("[RS]z|[CR][LF]");
        buf.append("[GS]f8[CR][LF]");
        this.parse(this.arruma(buf.toString()));
    }

    private void recebeQuery() {
        String req = "010007531504";
        StringBuilder buf = new StringBuilder();
        buf.append("[STX][CR][LF]");
        buf.append("[RS]mtrsl|iiV2|is0000128270AC|itID|pi16342|pv16342|pnRN DE MARCIA CRISTINA CROSS|pp5[CR][LF]");
        buf.append("[RS]79839.0|p5579839.0|w116342|si|ci").append(req).append("|c014969|ctCultura Automatizada|cnCultura A[CR][LF]");
        buf.append("[RS]utomatizada|ta|rtGN|rr3154186|t11|o1kleoxy|o2Klebsiella oxytoca|o367057346771640[CR][LF]");
        buf.append("[RS]10|o999|zz|[CR][LF]");
        buf.append("[GS]fa[CR][LF]");
        this.parse(this.arruma(buf.toString()));
    }
}

