/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.vidas;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;

public class InterfaceListener
extends InterfaceArquivoListener {
    private String DIRETORIO_IMPORTACAO = "";

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.DIRETORIO_IMPORTACAO = c.getDiretorioImportacao();
    }

    @Override
    public void buscarResultados(Date inicio, Date termino) {
        File file = new File(this.DIRETORIO_IMPORTACAO);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".txt".toUpperCase());
            }
        };
        File[] files = file.listFiles(filter);
        if (files != null) {
            for (File f : files) {
                int cont;
                long tam = f.length();
                for (cont = 1; cont < 3; ++cont) {
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    File fTemp = new File(f.getAbsolutePath());
                    if (tam != fTemp.length()) {
                        fTemp = null;
                        continue;
                    }
                    fTemp = null;
                    break;
                }
                if (cont == 3) continue;
                try {
                    String texto = StringUtil.lerArquivoTexto(f);
                    this.parse(texto);
                    String dir = this.DIRETORIO_IMPORTACAO;
                    dir = !dir.endsWith("/") ? dir + "/importados/" : dir + "importados/";
                    File pasta = new File(dir);
                    if (!pasta.exists()) {
                        pasta.mkdir();
                    }
                    File novoArquivo = new File(dir + Funcoes.formataData("yyyyMMdd_HHmmss", new Date()) + "_" + f.getName());
                    StringUtil.escreverArquivoTexto(dir + Funcoes.formataData("yyyyMMdd_HHmmss", new Date()) + "_copia_" + f.getName(), texto);
                    if (f.renameTo(novoArquivo)) continue;
                    f.delete();
                }
                catch (Exception e) {
                    this.fireMensagemEnviada("N\u00e3o foi poss\u00edvel importar o resultado do arquivo " + (null != f ? f.getName() : ""), 0, 10000);
                }
            }
        }
    }

    @Override
    public String parse(String message) {
        int x;
        message = message.replace("\u0000", "");
        message = message.replace("^", "");
        String[] linhas = (message = message.replace("\r", "")).split("\n");
        if (linhas.length < 18) {
            this.fireExcecaoEncontrada("Arquivo de resultado recebido em padr\u00e3o incorreto.");
            return "Arquivo de resultado recebido em padr\u00e3o incorreto.";
        }
        String emi_alternativo = linhas[6].trim();
        if (!emi_alternativo.contains(" - DSVID")) {
            this.fireExcecaoEncontrada("Arquivo de resultado recebido em padr\u00e3o incorreto.");
            return "Arquivo de resultado recebido em padr\u00e3o incorreto.";
        }
        emi_alternativo = emi_alternativo.substring(0, emi_alternativo.indexOf(" - DSVID"));
        int linhaAmostras = 0;
        for (x = 0; x < linhas.length; ++x) {
            if (linhas[x].contains("------")) {
                linhaAmostras = x;
            }
            if (linhas.length - 1 != x) continue;
            ++linhaAmostras;
        }
        if (linhaAmostras == 0) {
            this.fireExcecaoEncontrada("Arquivo de resultado recebido em padr\u00e3o incorreto.");
            return "Arquivo de resultado recebido em padr\u00e3o incorreto.";
        }
        if (linhas[linhaAmostras].split(":").length > 1) {
            ++linhaAmostras;
        }
        for (x = linhaAmostras; x < linhas.length; ++x) {
            while (linhas[x].contains("  ")) {
                linhas[x] = linhas[x].replace("  ", " ");
            }
            if (linhas[x].isEmpty()) continue;
            String[] amostra = linhas[x].split(" ");
            if (linhas[x].contains("a` espera da confirma")) break;
            String req_codigo = amostra[1];
            if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                req_codigo = StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            }
            try {
                Long.parseLong(req_codigo);
            }
            catch (Exception ex) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.fireExcecaoEncontrada(msg.toString());
                continue;
            }
            try {
                String rec_codigo;
                DescritorCodigoEtiqueta descritorCodigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigo);
                if (descritorCodigoEtiqueta == null) {
                    this.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para etiqueta: " + req_codigo);
                    continue;
                }
                String fil_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo = Funcoes.preencheZero(descritorCodigoEtiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo()), emi_alternativo);
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    continue;
                }
                String resultado = amostra[4];
                resultado = resultado.replaceAll(",", "\\.");
                resultado = this.arrendondaValor(resultado, fil_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo);
                resultado = resultado.replaceAll("\\.", ",");
                HashMap<String, Object> resultadosMap = new HashMap<String, Object>();
                resultadosMap.put("resultado_quantitativo", resultado);
                resultadosMap.put("resultado_qualitativo", amostra[5]);
                this.atualizarDadosExame(Conexao.getStatement(), fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, resultadosMap);
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
                continue;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "Erro ao realizar parse de dados recebidos do equipamento";
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                return "Erro ao realizar parse de dados recebidos do equipamento";
            }
        }
        return "Resultados recebidos com sucesso";
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            for (String s : exms = exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, 1);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }
}

